// spconvDlg.h : wb_[ t@C
//
#include "CsvEntry.h"

/////////////////////////////////////////////////////////////////////////////
// CSpconvDlg dialog

#define SPIMAGE_X 12		// SP摜
#define SPIMAGE_Y 12
#define PALIMAGE_X 280		// pbg摜
#define PALIMAGE_Y 140
#define TXIMAGE_X 420		// eNX`摜
#define TXIMAGE_Y 12

class Cfbmp;

class CSpconvDlg : public CDialog
{
// \z
public:
	CSpconvDlg(CWnd* pParent = NULL);	// W̃RXgN^

// Dialog Data
	//{{AFX_DATA(CSpconvDlg)
	enum { IDD = IDD_SPCONV_DIALOG };
	CString	m_BmpFile;
	CString	m_DirName;
	CString	m_MainName;
	CString	m_PalFile;
	CString	m_SpFile;
	//}}AFX_DATA

	// ClassWizard ͉z֐𐶐I[o[Ch܂B
	//{{AFX_VIRTUAL(CSpconvDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	HICON m_hIcon;

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CSpconvDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	afx_msg void OnAutosw();
	afx_msg void OnSpref();
	afx_msg void OnPalref();
	afx_msg void OnBmpref();
	afx_msg void OnClear();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	// <<<<<  >>>>>
	//
	// Ԓl
	int SelectedPalBlock;				// I𒆂̃pbgubN

	// IuWFNg
	Cfbmp* palimage;				// o`k̃C[Wێrbg}bvIuWFNg
	Cfbmp* spimage;				//  ro ̃C[Wێrbg}bvIuWFNg
	Cfbmp* tximage;					// eNX`rbg}bvIuWFNg

	// 摜Epbgf[^
	RGBQUAD rgb_data[16][16];				// pal_dataϊRGBl̔zێ
	char sp_data[16][16][128];				// XvCg̃x^Z[uf[^ێ
	WORD pal_data[16][16];					// pbg̃x^Z[uf[^ێ
	CArray<CsvEntry> m_operationCsv;		// L^CSV
	//
	// <<<<< \bh >>>>>
	//
	// 
	void Initialize();
	void Release();

	// \bh
	CString MakeFullPathName(CString& dirname, CString& fname);
	void MakeRGBTable();

	// 摜č\z
	void MakePalImage();
	void MakeSpImage();
	void InitializeTextureImage();
	void MakeTexturePalet();
	void MakeCsvList();
	void MakeAllImages();
	void SpToBmp(int spDefIndex, int palIndex);
	void DrawScreenAll();

	// SPp^[]
	void TranslateBmpToSp(int idxFrom, int idxTo);
	void TranslateSpToBmp(int idxFrom, int idxTo, int spAssumedPal);

	// t@C
	BOOL doSave(LPCTSTR filename, Cfbmp* pBmp);
	BOOL doSaveStencil(LPCTSTR filename, Cfbmp* pBmp);
	BOOL doSave256(LPCTSTR filename, Cfbmp* pBmp);
	void SaveBmp(CString fname, BOOL indexedColor);

	// XNvg
	CRes ExecOperationCsv(CArray<CsvEntry> &operationCsv, CString basePath);
	CRes ExecOperationEntry(CsvEntry& entry, CString basePath);
public:
	//
	// <<<<< Cxgnh >>>>>
	//
	// ́FSP
	afx_msg void OnBnClickedButtonReadPal();		// pbgǂݍ݃{^
	afx_msg void OnBnClickedButtonReadSp();			// SPǂݍ݃{^
	//
	// óFSP
	afx_msg void OnBnClickedDirref();				// BMPo͐fBNgQ
	afx_msg void OnBnClickedButtonConvToSp();
	//
	// ́FBMP
	afx_msg void OnBnClickedButtonBmpFilenameRef();	// BMP摜Qƃ{^
	afx_msg void OnBnClickedButtonBmpSpRead();		// SPǂݍ݃{^
	afx_msg void OnBnClickedButtonLoadbmp();		// PALǂݍ݃{^
	//
	// óFBMP
	afx_msg void OnBnClickedButtonSpToBmp();
	//
	// Script
	afx_msg void OnBnClickedButtonRefBasepath();	// x[XpXQ
	//
	// S
	afx_msg void OnClose();							// 
	afx_msg void OnBnClickedCancel();				// I{^
	//
	// <<<<< DDXϐ >>>>>
	//
	// ́FSP
	CString m_spReadTo;
	int m_spAssumedPal;
	int m_spReadCount;
	//
	// ́FPAL
	int m_palReadTo;
	int m_palReadCount;
	//
	// ́FBMP
	int m_spReadOffset;
	int m_palReadOffset;
	CString m_bmpBmpFilename;
	int m_bmpSpSizeX;
	int m_bmpSpSizeY;
	int m_bmpSpFrameCount;
	CString m_bmpSpReadTo;
	int m_bmpSpReadOffset;
	int m_bmpPalReadTo;
	int m_bmpPalReadOffset;
	int m_bmpPalReadCount;
	BOOL m_bmpPalShift;
	//
	// Scripts
	CString m_csvList;
	CString m_scriptBasePath;
	//
	// Rg[
	CButton m_loadBmpButton;
	CButton m_convToSpButton;
	//
	// 
	afx_msg void OnBnClickedButtonSpSaveSpRef();
	CString m_spSaveSpFilename;
	CString m_spSaveSpFrom;
	int m_spSaveSpCount;
	CString m_spSavePalFilename;
	int m_spSavePalFrom;
	int m_spSavePalCount;
	afx_msg void OnBnClickedButtonSpSavePalRef();
	BOOL m_bmpSaveAutoSw;
	afx_msg void OnBnClickedButtonBmpSaveFullcolorBmp();
	afx_msg void OnBnClickedButtonScriptFilenameRef();
	CString m_scriptFilename;
	afx_msg void OnBnClickedButtonSaveCsv();
	afx_msg void OnBnClickedButtonReadCsv();

public:
	//
	// ReadPalets
	CRes ExecReadPalet(CString palFile, int palReadTo, int palReadOffset, int palReadCount, CString basePath);

	// ReadSp
	CRes ExecReadSp(CString spFile, int spReadToDec, int spReadOffset, int spReadCount, int spAssumedPal, CString basePath);

	// ReadBmpPal
	CRes ExecReadBmpPal(CString bmpBmpFilename, int bmpPalReadTo, int bmpPalReadOffset, int bmpPalReadCount, CString basePath);

	// ReadBmpSp
	CRes ExecReadBmpSp(
		CString bmpBmpFilename, int bmpSpSizeX, int bmpSpSizeY, int bmpSpFrameCount,
		int bmpSpReadTo, int bmpSpReadOffset, int bmpPalReadTo, int bmpPalReadOffset, int bmpPalReadCount,
		BOOL bmpPalShift, CString basePath
	);

	// SaveSpPal
	CRes ExecSaveSpPal(CString spSaveSpFilename, int spSaveSpFrom, int spSaveSpCount
		, CString spSavePalFilename, int spSavePalFrom, int spSavePalCount, CString basePath);

	// SaveBmpCnv
	CRes ExecSaveBmpCnv(CString bmpFile, CString dirName, CString mainName, BOOL bmpSaveAutoSw, CString basePath, BOOL indexedColor, int selectedPalBlock);

	// SaveBmpFul
	CRes ExecSaveBmpFul(CString bmpFile, CString basePath);

	//
	CString JoinBasePath(CString filename, CString basePath);
	afx_msg void OnBnClickedButtonExecCsv();
	afx_msg void OnEnKillfocusEditCsvlist();
	afx_msg void OnBnClickedButtonSave256();
};
