//
// CSVEntry
//
#ifndef __CSVENTRY_H__
#define __CSVENTRY_H__

#include "CRes.h"

// R}hꗗ
#define CSVCMD_NOP				"Nop"			// Ȃ
#define CSVCMD_ERROR			"Error"			// G[
#define CSVCMD_COMMENT			"Comment"		// Rg
#define CSVCMD_READ_PALET		"ReadPalet"		// pbgǂݍ
#define CSVCMD_READ_SP			"ReadSp"		// SPǂݍ
#define CSVCMD_READ_BMP_PAL		"ReadBmpPal"	// PALǂݍ
#define CSVCMD_READ_BMP_SP		"ReadBmpSp"		// SPǂݍ
#define CSVCMD_SAVE_SP_PAL		"SaveSpPal"		// SP, PALۑ
#define CSVCMD_SAVE_BMP_CNV		"SaveBmpCnv"	// BMPϊۑ
#define CSVCMD_SAVE_BMP_CNV256	"SaveBmpCnv256"	// BMPϊۑ256F
#define CSVCMD_SAVE_BMP_FUL		"SaveBmpFul"	// tJ[BMPۑ
#define CSVCMD_SET_BASEPATH		"SetBasePath"	// x[XpXݒ

#define RESERVED_EMPTY			"(null)"	// \F󕶎

/// <summary>
/// CSVf[^̓e
/// </summary>
class CsvEntry {
public:
	CsvEntry();				// RXgN^
	CsvEntry(const char* command);	// RXgN^
	CsvEntry(const CsvEntry& entry);	// Rs[RXgN^
	virtual ~CsvEntry();	// fXgN^
	CsvEntry& operator=(const CsvEntry& entry);

public:
	// R}h
	CString command;

	// 
	CStringArray params;
	CStringArray paramsOrig;

public:
	// CSV̍s𕶎ƂĎ擾
	CString GetCsvLine();
	void AddParam(CString param, bool trim);
	void AddParam(const char* param, bool trim);
	void AddParam(int param);
	void AddParamBool(BOOL param);
	// x[XpX
	void AdjustBasePath(const char* basePath);
	CString AdjustBasePathCore(const char* basePath, const char* value);

	// p[^e^Ŏ荞
	int GetParamInt(int index);
	int GetParamHex(int index);
	CString GetParamStr(int index);
	BOOL GetParamBool(int index);

	// wp[
	static CsvEntry FromString(CString line);
	static CRes FromFile(CString filename, CArray<CsvEntry>& target);
	static CRes FromCsvText(CString csvText, CArray<CsvEntry>& target);
	static CString BuildCsvText(CArray<CsvEntry>& target);
	static CString AdjustAboutBasePath(CArray<CsvEntry>& target);
};

#endif
