//====================================================================
// X68000̃}bvƓ^̍\`
//====================================================================
#ifndef __MEMORY_MAP_BUFFER__
#define __MEMORY_MAP_BUFFER__

//--------------------------------------------------------------------
// Rg[͂̃jbg
//--------------------------------------------------------------------
typedef union
{
    char mixed;
    struct
    {
        unsigned dummy1 : 1;
        unsigned trg_b : 1;
        unsigned trg_a : 1;
        unsigned dummy2 : 1;
        unsigned right : 1;
        unsigned left : 1;
        unsigned down : 1;
        unsigned up : 1;
    } bit;
    struct
    {
        unsigned dummy1 : 1;
        unsigned trg : 2;
        unsigned dummy2 : 1;
        unsigned stc : 4;
    } data;
} GAMEPAD_UNIT;

//--------------------------------------------------------------------
// rõjbg
//--------------------------------------------------------------------
typedef struct SP_UNIT
{
    short x;
    short y;
    union
    {
        short mixed;
        struct
        {
            unsigned v_rev : 1;
            unsigned h_rev : 1;
            unsigned dummy : 2;
            unsigned color : 4;
            unsigned code : 8;
        } bit;
    } code;
    short prw;
} SP_UNIT;

//--------------------------------------------------------------------
// BG̃jbg
//--------------------------------------------------------------------
typedef struct BG_DEF_UNIT
{
    union
    {
        unsigned short mixed;
        struct
        {
            unsigned v_rev : 1;
            unsigned h_rev : 1;
            unsigned dummy : 2;
            unsigned color : 4;
            unsigned code : 8;
        } bit;
    } code;
} BG_DEF_UNIT;

//--------------------------------------------------------------------
// OtBbN XN[WX^
//--------------------------------------------------------------------
typedef struct
{
    unsigned short sc0_x;
    unsigned short sc0_y;
    unsigned short sc1_x;
    unsigned short sc1_y;
    unsigned short sc2_x;
    unsigned short sc2_y;
    unsigned short sc3_x;
    unsigned short sc3_y;
} GRP_SCRL_UNIT;

//--------------------------------------------------------------------
// eLXg XN[WX^
//--------------------------------------------------------------------
typedef struct
{
    unsigned short tx_x;
    unsigned short tx_y;
} TXT_SCRL_UNIT;

//--------------------------------------------------------------------
// BG XN[WX^
//--------------------------------------------------------------------
typedef struct
{ /*  XN[WX^  */
	unsigned short bg0x;
	unsigned short bg0y;
	unsigned short bg1x;
	unsigned short bg1y;
	union
	{
		unsigned short mixed;
		struct
		{
			unsigned dummy : 6;
			unsigned disp_cpu : 1;
			unsigned dummy2 : 3;
			unsigned textsel1 : 2;
			unsigned bg1onoff : 1;
			unsigned textsel0 : 2;
			unsigned bg0onoff : 1;
		} bit;
	} ctrl;
} BG_SCRL_UNIT;

//--------------------------------------------------------------------
// PCG]
//--------------------------------------------------------------------
typedef struct
{                           
    int set;                /*  f[^̃Zbgio[  */
    int offset;             /* ItZbg */
    int cnt;                /*  f[^̃p^[̌  */
    int target;             /*  ]̃R[hԍ  */
} TRANSSP_UNIT;

/*  pbgւf[^  */
typedef struct
{                      
    int set;                /*  f[^̃Zbgio[  */
    int offset;             /* ItZbg */
    int cnt;                /*  f[^̃ubŇ  */
    int target;             /*  ]̃R[hԍ  */
} TRANSPAL_UNIT;

//--------------------------------------------------------------------
// }bvobt@
//--------------------------------------------------------------------
typedef struct MEMORY_MAP_BUFFER {
    // <<< ͏ >>>
    GAMEPAD_UNIT input_unit;

    // <<< XN[ >>>
    // XvCgXN[WX^
    SP_UNIT sp_unit[128];

    // BGXN[WX^
    BG_SCRL_UNIT bg_scroll_unit;

    // GRPXN[WX^
    GRP_SCRL_UNIT grp_scroll_unit;

    // TXTXN[WX^
    TXT_SCRL_UNIT txt_scroll_unit;

    // <<< ` >>>
    // BG`
    BG_DEF_UNIT bg_def[2][64 * 64];

    // PCG]
    int transsp_count;
    int transpal_count;
    TRANSSP_UNIT* transsp;
    TRANSPAL_UNIT* transpal;
} MEMORY_MAP_BUFFER;
#endif
