//--------------
//   Oo
//--------------
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "LogFile.h"


//--------------------------------------------------------------------
//	[  ]
//		CLogFile()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CLogFile::CLogFile()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CLogFile( const char* pFileName , int iMode )
//
//	[  ]
//		const char* pFileName		Ot@C
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		t@Cw̃RXgN^
//--------------------------------------------------------------------
CLogFile::CLogFile( const char* pFileName , int iMode )
{
	SetDefault();

	BOOL bRes;
	bRes = SetFileName( pFileName );
	SetMode( iMode );
}


//--------------------------------------------------------------------
//	[  ]
//		CLogFile( CLogFile& rLogFile )
//
//	[  ]
//		CLogFile& rLogFile			Rs[ƃRXgN^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CLogFile::CLogFile( CLogFile& rLogFile )
{
	SetDefault();

	BOOL bRes;
	bRes = CopyMembers( rLogFile );
}


//--------------------------------------------------------------------
//	[  ]
//		~CLogFile()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CLogFile::~CLogFile()
{
	Close();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^ł̏lݒ
//--------------------------------------------------------------------
void CLogFile::SetDefault()
{
	m_pFileName	= NULL;
	m_pStream	= NULL;
	m_iMode		= LOGFILE_NOTOUT;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CLogFile& rLogFile )
//
//	[  ]
//		CLogFile& rLogFile			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐
//--------------------------------------------------------------------
BOOL CLogFile::CopyMembers( CLogFile& rLogFile )
{
	BOOL bRes;

	// ܂͕
	Close();
	m_pFileName	= NULL;
	m_pStream	= NULL;
	m_iMode		= LOGFILE_NOTOUT;

	// t@C
	if( rLogFile.m_pFileName!=NULL ){
		int iLength;
		iLength = strlen( rLogFile.m_pFileName );

		m_pFileName = (char*)malloc( iLength +1 );
		if( m_pFileName==NULL ){
			return FALSE;
		}
	}

	// t@CXg[
	if( rLogFile.m_pStream ){
		// t@CJĂꍇ́AI[v
		bRes = Open( rLogFile.m_pFileName );
		if( bRes==FALSE ){
			free( m_pFileName );
			m_pFileName = NULL;
			return FALSE;
		}
	}

	// o̓x
	m_iMode = rLogFile.m_iMode;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetFileName( const char* pFileName )
//
//	[  ]
//		const char* pFileName		t@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Ot@Cݒ肵܂B
//		łɐݒ肳Ăꍇ́Axď㏑܂B
//--------------------------------------------------------------------
BOOL CLogFile::SetFileName( const char* pFileName )
{
	if( m_pFileName ){
		free( m_pFileName );
	}

	int iLength;
	iLength = strlen( pFileName );
	m_pFileName = (char*)malloc( iLength + 1 );
	if( m_pFileName==NULL ){
		return FALSE;
	}

	strcpy( m_pFileName , pFileName );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void SetMode( int iMode )
//
//	[  ]
//		int iMode					Oo̓x
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Ȍo̓xݒ肵܂B
//--------------------------------------------------------------------
void CLogFile::SetMode( int iMode )
{
	m_iMode = iMode;
}


//--------------------------------------------------------------------
//	[  ]
//		int GetMode()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		݂̃Oo̓x
//
//	[  ]
//		ݐݒ肳Ă郍Oo̓x擾܂B
//--------------------------------------------------------------------
int CLogFile::GetMode()
{
	return m_iMode;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Open( const char* pFileName , int iMode )
//
//	[  ]
//		const char* pFileName		Ot@C̃t@C
//		int iMode					Ȍo̓x
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pFileName ̃t@CŁAVKɃOt@CI[v܂B
//		̃t@Cꍇ͏㏑܂B
//--------------------------------------------------------------------
BOOL CLogFile::Open( const char* pFileName , int iMode )
{
	BOOL bRes;

	// [hݒ
	SetMode( iMode );

	// J
	bRes = Open( pFileName );
	if( bRes==FALSE ){
		Close();
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Open( const char* pFileName )
//
//	[  ]
//		const char* pFileName		Ot@C̃t@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pFileName ̃t@CŁAVKɃOt@CI[v܂B
//		̃t@Cꍇ͏㏑܂B
//--------------------------------------------------------------------
BOOL CLogFile::Open( const char* pFileName )
{
	BOOL bRes;

	bRes = SetFileName( pFileName );
	if( bRes==FALSE ){
		Close();
		return FALSE;
	}

	bRes = Open();
	if( bRes==FALSE ){
		Close();
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Open()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pFileName ̃t@CŁAVKɃOt@CI[v܂B
//		̃t@Cꍇ͏㏑܂B
//--------------------------------------------------------------------
BOOL CLogFile::Open()
{
	if( m_pFileName==NULL )return FALSE;

	if( m_pStream!=NULL ){
		fclose( m_pStream );
	}

	m_pStream = fopen( m_pFileName , "wt" );
	if( m_pStream==NULL ){
		Close();
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Log( char* pMes , ... )
//
//	[  ]
//		char*	pMes		tH[}bg
//		[argument]...		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		t@CɃOo͂܂B
//		LOGFILE_NOTOUT ݒȊȌꍇ͕Ko͂܂B
//--------------------------------------------------------------------
void CLogFile::Log(const char* pMes , ... )
{
	va_list marker;
	va_start( marker , pMes );
	Log( pMes , marker );
	va_end( marker );
}


//--------------------------------------------------------------------
//	[  ]
//		void DebugLog( char* pMes , ... )
//
//	[  ]
//		char*	pMes		tH[}bg
//		[argument]...		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_DEBUG ȏ̏ꍇɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::DebugLog(const char* pMes , ... )
{
#ifndef __DISABLE_LOGFILE__
	va_list marker;
	va_start( marker , pMes );
	DebugLog( pMes , marker );
	va_end( marker );
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void CheckLog( char* pMes , ... )
//
//	[  ]
//		char*	pMes		tH[}bg
//		[argument]...		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_CHECK ȏ̂ƂɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::CheckLog(const  char* pMes,... )
{
#ifndef __DISABLE_LOGFILE__
	va_list marker;
	va_start( marker , pMes );
	CheckLog( pMes , marker );
	va_end( marker );
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void TrackLog( char* pMes , ... )
//
//	[  ]
//		char*	pMes		tH[}bg
//		[argument]...		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_TRACE ȏ̏ꍇɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::TraceLog(const char* pMes , ... )
{
#ifndef __DISABLE_LOGFILE__
	va_list marker;
	va_start( marker , pMes );
	TraceLog( pMes , marker );
	va_end( marker );
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void ErrorLog( char* pMes , ... )
//
//	[  ]
//		char*	pMes		tH[}bg
//		[argument]...		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LOGFILE_NOTOUT ȊȌꍇɃOo͂܂B
//		o͂郁bZ[W̐擪Ɂu[error]vƂ
//		vtBbNXt܂B
//--------------------------------------------------------------------
void CLogFile::ErrorLog( const char* pMes , ... )
{
	va_list marker;
	va_start( marker , pMes );
	ErrorLog( pMes , marker );
	va_end( marker );
}


//--------------------------------------------------------------------
//	[  ]
//		void Log( char* pMes , va_list marker )
//
//	[  ]
//			char*	pMes		tH[}bg
//			va_list marker		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		t@CɃOo͂܂B
//		LOGFILE_NOTOUT ݒȊȌꍇ͕Ko͂܂B
//--------------------------------------------------------------------
void CLogFile::Log(const char* pMes , va_list marker )
{
	switch( m_iMode ){
		case LOGFILE_NOTOUT:
			return;
			break;

		default:
			OutputLog( pMes , marker );		// bZ[W̏o
			fflush( m_pStream );
			return;
			break;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void DebugLog( char* pMes , va_list marker )
//
//	[  ]
//		char*	pMes		tH[}bg
//		va_list marker		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_DEBUG ȏ̏ꍇɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::DebugLog(const char* pMes , va_list marker )
{
#ifndef __DISABLE_LOGFILE__
	switch( m_iMode ){
		case LOGFILE_DEBUG:
		case LOGFILE_CHECK:
		case LOGFILE_TRACE:
			OutputLog( pMes,marker );	// G[bZ[W̏o
			fflush( m_pStream );
			return;
			break;

		default:
			return;
			break;
	}
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void CheckLog( char* pMes , va_list marker )
//
//	[  ]
//		char*	pMes		tH[}bg
//		va_list marker		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_CHECK ȏ̂ƂɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::CheckLog(const char* pMes,va_list marker )
{
#ifndef __DISABLE_LOGFILE__
	switch( m_iMode ){
		case LOGFILE_CHECK:
		case LOGFILE_TRACE:
			OutputLog( pMes,marker );	// G[bZ[W̏o
			fflush( m_pStream );
			return;
			break;

		default:
			return;
			break;
	}
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void TrackLog( char* pMes , va_list marker )
//
//	[  ]
//		char*	pMes		tH[}bg
//		va_list marker		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		o̓x LOGFILE_TRACE ȏ̏ꍇɃOo͂܂B
//--------------------------------------------------------------------
void CLogFile::TraceLog(const char* pMes , va_list marker )
{
#ifndef __DISABLE_LOGFILE__
	switch( m_iMode ){
		case LOGFILE_TRACE:
			OutputLog( pMes,marker );			// G[bZ[W̏o
			fflush( m_pStream );
			return;
			break;

		default:
			return;
			break;
	}
#endif
}


//--------------------------------------------------------------------
//	[  ]
//		void ErrorLog( char* pMes , va_list marker )
//
//	[  ]
//		char*	pMes		tH[}bg
//		va_list marker		IvV̈
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LOGFILE_NOTOUT ȊȌꍇɃOo͂܂B
//		o͂郁bZ[W̐擪Ɂu[error]vƂ
//		vtBbNXt܂B
//--------------------------------------------------------------------
void CLogFile::ErrorLog( const char* pMes , va_list marker )
{
	if( m_iMode==LOGFILE_NOTOUT )return;

	if( m_pStream==NULL ){
		BOOL bRes;
		bRes = Open();
		if( bRes==FALSE ){
			return;
		}
	}
	fprintf( m_pStream , "[error] " );
	fflush( m_pStream );

	OutputLog( pMes,marker );			// G[bZ[W̏o
	fflush( m_pStream );
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void Close()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Ot@C܂B
//		łɃOĂԂŌĂ΂Ă肠܂B
//--------------------------------------------------------------------
void CLogFile::Close()
{
	if( m_pStream!=NULL ){
		fclose( m_pStream );
	}

	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}

	m_pFileName		= NULL;
	m_pStream		= NULL;
	m_iMode			= LOGFILE_NOTOUT;
}


//--------------------------------------------------------------------
//	[  ]
//		void OutputLog( char* pMes , va_list marker )
//
//	[  ]
//		FILE*	pDStream		o͐̃t@C|C^
//		char*	pMes			o̓tH[}bg
//		va_list	marker			p[^Xg
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Oo͂܂B
//--------------------------------------------------------------------
void CLogFile::OutputLog( const char* pMes,va_list marker )
{
	if( m_pStream==NULL ){
		BOOL bRes;
		bRes = Open();
		if( bRes==FALSE )return;
	}

	vfprintf( m_pStream , pMes , marker );					// G[bZ[W̏o
}
