//=============================================================================
// ChipMaker
// rbg}bv摜BG̊ef[^o
//=============================================================================
#include "pch.h"
#include "framework.h"
#include "afxdialogex.h"

#include "ChipMaker.h"
#include "CRes.h"
#include "memory_map_buffer.h"
#include "LogFile.h"

int numberPattern[16][8][8] = {
	{
		{0,0,1,1,1,0,0,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,0,1,2,1,0},
		{1,2,1,0,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{0,1,2,2,2,1,1,0},
		{0,0,1,1,1,1,0,0},
	}, {
		{0,0,0,1,0,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,1,2,1,0,0,0},
		{0,0,0,1,0,0,0,0},
	}, {
		{0,0,1,1,1,0,0,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{0,1,0,0,1,2,1,0},
		{0,0,1,2,2,1,0,0},
		{0,1,2,1,1,1,0,0},
		{1,2,2,2,2,2,1,0},
		{0,1,1,1,1,1,0,0},
	}, {
		{0,1,1,1,1,0,0,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,2,1,0},
		{0,1,2,2,2,1,0,0},
		{0,0,1,1,1,2,0,0},
		{0,1,1,1,1,2,1,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,0,0,0},
	}, {
		{0,1,0,0,1,0,0,0},
		{1,2,1,1,2,1,0,0},
		{1,2,1,1,2,1,0,0},
		{1,2,1,1,2,1,1,0},
		{1,2,2,2,2,2,2,1},
		{1,1,1,1,2,1,1,0},
		{0,0,0,0,2,1,0,0},
		{0,0,0,0,1,0,0,0},
	}, {
		{1,1,1,1,1,1,0,0},
		{1,2,2,2,2,2,1,0},
		{1,2,1,1,1,1,0,0},
		{1,2,2,2,2,1,1,0},
		{0,1,1,1,1,2,1,0},
		{0,1,1,1,1,2,1,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,0,0,0},
	}, {
		{0,0,1,1,1,1,0,0},
		{0,1,2,2,2,2,1,0},
		{1,2,1,1,1,1,1,0},
		{1,2,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{0,1,2,2,2,1,0,0},
		{0,0,1,1,1,0,0,0},
	}, {
		{0,1,1,1,1,1,0,0},
		{1,2,2,2,2,2,1,0},
		{0,1,1,1,1,2,1,0},
		{0,0,0,0,1,2,1,0},
		{0,0,0,1,2,1,0,0},
		{0,0,1,2,1,0,0,0},
		{0,1,2,1,0,0,0,0},
		{0,0,1,0,0,0,0,0},
	}, {
		{0,0,1,1,1,0,0,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{0,1,2,2,2,1,0,0},
		{0,0,1,1,1,0,0,0},
	}, {
		{0,0,1,1,1,0,0,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{0,1,2,2,2,2,1,0},
		{0,1,1,1,1,2,1,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,1,0,0},
	}, {	// A
		{0,0,1,1,1,0,0,0},
		{0,1,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{1,2,2,2,2,2,1,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,0,0,2,1,0},
		{0,1,0,0,0,1,0,0},
	}, {	// B
		{1,1,1,1,1,0,0,0},
		{1,2,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,2,2,2,1,1,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,1,0,0},
	}, {	// C
		{0,0,1,1,1,1,0,0},
		{0,1,2,2,2,2,1,0},
		{1,2,1,1,1,1,0,0},
		{1,2,1,0,0,0,0,0},
		{1,2,1,0,0,0,0,0},
		{1,2,1,1,1,1,0,0},
		{0,1,2,2,2,2,1,0},
		{0,0,1,1,1,1,0,0},
	}, {	// D
		{0,1,1,1,1,0,0,0},
		{1,2,2,2,2,1,0,0},
		{1,2,1,1,1,2,1,0},
		{1,2,1,0,1,2,1,0},
		{1,2,1,0,1,2,1,0},
		{1,2,1,1,1,2,1,0},
		{1,2,2,2,2,1,0,0},
		{0,1,1,1,1,0,0,0},
	}, {	// E
		{0,1,1,1,1,1,0,0},
		{1,2,2,2,2,2,1,0},
		{1,2,1,1,1,1,1,0},
		{1,2,2,2,2,1,0,0},
		{1,2,1,1,1,0,0,0},
		{1,2,1,1,1,1,1,0},
		{1,2,2,2,2,2,1,0},
		{0,1,1,1,1,1,0,0},
	}, {	// F
		{0,1,1,1,1,1,0,0},
		{1,2,2,2,2,2,1,0},
		{1,2,1,1,1,1,1,0},
		{1,2,2,2,2,1,0,0},
		{1,2,1,1,1,0,0,0},
		{1,2,1,0,0,0,0,0},
		{1,2,1,0,0,0,0,0},
		{0,1,0,0,0,0,0,0},
	}
};

//--------------------------------------------------------------------
//	[  ]
//		ChipMaker()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
ChipMaker::ChipMaker()
{
	pDCSource = NULL;
	pDCConverted = NULL;
	pDCPalet = NULL;
	srcPictureRect = CRect();
	cnvPictureRect = CRect();
	srcBitmap.Free();
	cnvBitmap.Free();
	convertedChipCount = 0;
	bg_map = NULL;
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~ChipMaker()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
ChipMaker::~ChipMaker()
{
	// 
	Release();
}

//--------------------------------------------------------------------
//	[  ]
//		CRes Initialize()
//
//	[  ]
//		CDC* pDCSource	\[XƂȂrbg}bv̕\pDC
//		CRect& rSrcPictureRect
//		CRect& rCnvPicbureRect
//
//	[ ߂l ]
//		ʂi[CResIuWFNg
//
//	[  ]
//		ȅs܂B
//		ɓǂݍ܂Ă郊\[Xꍇ́Aׂĉ܂B
//--------------------------------------------------------------------
CRes ChipMaker::Initialize(CDC* pDCSource, CRect& rSrcPictureRect, CDC* pDCConverted, CRect& rCnvPictureRect, CDC* pDCPalet, CRect& rPalPictureRect)
{
	// ̃\[Xꍇ͉
	CRes res = Release();

	// DCݒ
	this->pDCSource = pDCSource;
	this->pDCConverted = pDCConverted;
	this->pDCPalet = pDCPalet;

	// \[X摜̕`͈͂ۑ
	this->srcPictureRect = rSrcPictureRect;
	this->cnvPictureRect = rCnvPictureRect;
	this->palPictureRect = rPalPictureRect;

	// 摜
	srcBitmap.Free();
	cnvBitmap.Free();
	palBitmap.Free();
	convertedChipCount = 0;
	return res;
}


//--------------------------------------------------------------------
//	[  ]
//		CRes Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ftrue
//		sFfalse
//
//	[  ]
//		ǂݍ܂Ă郊\[X܂
//--------------------------------------------------------------------
CRes ChipMaker::Release()
{
	pDCSource = NULL;
	srcBitmap.Free();
	cnvBitmap.Free();

	return CRes::CreateOk();
}


//--------------------------------------------------------------------
//	[  ]
//		CRes LoadSrcBitmap(const char* filename)
//
//	[  ]
//		const char* filename	t@C
//
//	[ ߂l ]
//		Ftrue
//		sFfalse
//
//	[  ]
//		rbg}bvt@Cǂݍ݂܂B
//--------------------------------------------------------------------
CRes ChipMaker::LoadSrcBitmap(const char* filename)
{
	bool bRes;
	CRes cRes;

	// 摜U
	RECT clientRect;
	memset(&clientRect, 0, sizeof(RECT));
	//COLORREF bkColor = this->pDCSource->GetBkColor();
	this->pDCSource->GetWindow()->GetClientRect(&clientRect);
	this->pDCSource->FillSolidRect(&clientRect, 0);

	// ǂݍ
	bRes = srcBitmap.Load(filename, this->pDCSource);
	if (!bRes) {
		return CRes::CreateError("rbg}bv̓ǂݍ݂Ɏs܂B");
	}

	// f[^mF
	if (srcBitmap.GetColorDepth() > 8) {
		srcBitmap.Free();
		return CRes::CreateError("256Fȉ̃rbg}bvw肵ĂB");
	}

	// ϊrbg}bv
	cRes = InitializeConverted();
	if (!cRes.GetResult()) {
		return cRes;
	}

	// ǂ񂾂`
	this->DoDraw();

	// I
	return CRes::CreateOk();
}


//--------------------------------------------------------------------
//	[  ]
//		CRes LoadPresetBitmap(const char* filename)
//
//	[  ]
//		const char* filename	t@C
//
//	[ ߂l ]
//		Ftrue
//		sFfalse
//
//	[  ]
//		Presetp^[̃rbg}bvt@Cǂݍ݂܂B
//--------------------------------------------------------------------
CRes ChipMaker::LoadPresetBitmap(const char* filename)
{
	bool bRes;
	CRes cRes;

	// 摜U
	RECT clientRect;
	memset(&clientRect, 0, sizeof(RECT));
	//COLORREF bkColor = this->pDCSource->GetBkColor();
	this->pDCConverted->GetWindow()->GetClientRect(&clientRect);
	this->pDCConverted->FillSolidRect(&clientRect, 0);

	// ǂݍ
	bRes = cnvBitmap.Load(filename, this->pDCConverted);
	if (!bRes) {
		return CRes::CreateError("rbg}bv̓ǂݍ݂Ɏs܂B");
	}

	// f[^mF
	if (cnvBitmap.GetColorDepth() > 8) {
		cnvBitmap.Free();
		return CRes::CreateError("256Fȉ̃rbg}bvw肵ĂB");
	}

	if ((cnvBitmap.GetWidth() > 256) || (cnvBitmap.GetHeight() > 256)) {
		cnvBitmap.Free();
		return CRes::CreateError("256x256ȉ̃TCỸrbg}bvw肵ĂB");
	}

	// ǂ񂾂`
	this->DoDraw();

	// I
	return CRes::CreateOk();
}


//--------------------------------------------------------------------
//	[  ]
//		CRes ReadStepCSV(const char* filename, CLogFile* pLogFile)
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::ReadStepCSV(const char* filename, CLogFile* pLogFile)
{
	// z
	stepCodesMap.RemoveAll();
	for (int i = 0; i < 256; i++) {
		stepCodesArrays[i].RemoveAll();
	}

	// t@CJ
	if (strlen(filename) == 0) {
		return CRes::CreateOk();
	}
	FILE* fn = fopen(filename, "rt");
	if (fn == NULL) {
		return CRes::CreateError("R[hwCSVt@CJ܂łB");
	}

	// O
	pLogFile->Log("R[hF");

	// ǂݍŃp[X
	char* pRes;
	char buffer[256];
	int count = 0;
	while ((pRes = fgets(buffer, 255, fn)) != NULL) {
		// 擪 # ̓Rg
		if (*buffer == '#') {
			continue;
		}

		// 1s荞
		CString line(buffer);
		int curPos = 0;
		CString elem = line.Tokenize(",", curPos);
		// 1s̃J}؂̒l荞
		while (elem != "") {
			// g
			elem.Trim();
			elem.Replace("0x", "");

			// l荞
			int pal, code;
			int val;
			int type;
			int resCount;
			resCount = sscanf((LPCTSTR)elem, "%x:%x:%d", &pal, &code, &type);
			if (resCount <= 0) {
				CString message;
				message.Format("R[hl荞߂܂łB[%s]\n", (LPCTSTR)elem);
				fclose(fn);
				return CRes::CreateError(message);
			}

			// zɒǉ
			val = ((pal & 0xF) << 8) + (code & 0xFF);
			stepCodesMap.SetAt(val, type);	// }bvɒǉ
			stepCodesArrays[type].Add(val);	// Xgɒǉ
			if (count > 0) {
				pLogFile->Log(", ");
			}
			pLogFile->Log("0x%03X:%d", val, type);

			// ̒l𓾂
			elem = line.Tokenize(",", curPos);
			count++;
		}
	}

	// t@C
	fclose(fn);

	// I
	pLogFile->Log("\n");
	for (int i = 0; i < 256; i++) {
		if (stepCodesArrays[i].GetSize() == 0) {
			continue;
		}
		pLogFile->Log("[%d]", i);
		for (int c = 0; c < stepCodesArrays[i].GetSize(); c++) {
			if (c > 0) {
				pLogFile->Log(", ");
			}
			pLogFile->Log("0x%02X", stepCodesArrays[i].GetAt(c));
		}
		pLogFile->Log("\n");
	}
	return CRes::CreateOk();
}


//--------------------------------------------------------------------
//	[  ]
//		CRes InitializeConverted()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		CResIuWFNg
//
//	[  ]
//		ϊrbg}bvt@C܂
//--------------------------------------------------------------------
CRes ChipMaker::InitializeConverted()
{
	// ϊrbg}bv
	cnvBitmap.Initialize(256, 256, 8, pDCConverted);
	RGBQUAD q;
	memset(&q, 0, sizeof(RGBQUAD));
	for (int i = 0; i < 256; i++) {
		cnvBitmap.SetPalet(i, q);
	}
	for (int y = 0; y < 256; y++) {
		for (int x = 0; x < 256; x++) {
			cnvBitmap.SetPixelIndex(x, y, 0);
		}
	}
	convertedChipCount = 0;

	// pbg̃rbg}bv
	palBitmap.Free();
	palBitmap.Initialize(this->palPictureRect.right - this->palPictureRect.left, palPictureRect.bottom - palPictureRect.top, 24, pDCPalet);

	// I
	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		CRes Load(const char* filename)
//
//	[  ]
//		const char* filename	t@C
//
//	[ ߂l ]
//		Ftrue
//		sFfalse
//
//	[  ]
//		rbg}bvt@Cǂݍ݂܂B
//--------------------------------------------------------------------
CRes ChipMaker::DoDraw()
{
	// \[X摜`悷
	if (this->srcBitmap.isReady()) {
		// `挳̋`𓾂
		CRect source(0, 0, srcBitmap.GetWidth(), srcBitmap.GetHeight());

		// `̋`𓱏o
		double ratio = 1.0;
		if (srcBitmap.GetWidth() > srcBitmap.GetHeight()) {
			ratio = (double)srcPictureRect.Height() / (double)srcBitmap.GetWidth();
		}
		else {
			ratio = (double)srcPictureRect.Height() / (double)srcBitmap.GetHeight();
		}
		CRect dest(0, 0, (int)(srcBitmap.GetWidth() * ratio), (int)(srcBitmap.GetHeight()*ratio));
		//CRect dest(0, 0,100, 100);

		this->srcBitmap.StretchDraw(source, dest, pDCSource);
	}

	// ϊ摜`悷
	if (this->cnvBitmap.isReady()) {
		this->cnvBitmap.NormalDraw(CPoint(0, 0), pDCConverted);
	}

	// pbg`悷
	if (this->cnvBitmap.isReady()) {
		this->palBitmap.PrepareBitOperation();

		int cols = (int)( pow(2.0, (double)srcBitmap.GetColorDepth()) );
		for (int y = 0; y < cols; y++) {
			for (int x = 0; x < 16; x++) {
				RGBQUAD quad = cnvBitmap.GetPalet(y * 16 + x);

				for (int fx = x * 8; fx < x * 8 + 8; fx++) {
					for (int fy = y * 8; fy < y * 8 + 8; fy++) {
						palBitmap.SetPixelColor(fx, fy, quad);
					}
				}
			}
		}

		this->palBitmap.EndBitOperation(pDCPalet);
	}
	if (this->palBitmap.isReady()) {
		this->palBitmap.NormalDraw(CPoint(0, 0), pDCPalet);
	}

	// I
	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		CRes Convert(int offset, bool presetExists, CMap<int, int, int, int>* pPalErrorMap, CLogFile* pLogFile)
//
//	[  ]
//		int offset	p^[`̃ItZbgl
//		bool presetExists	vZbgp^[w肳ꂽƂtrue
//		CMap<int, int, int, int>* pPalErrorMap	pbgubNG[̃}bv
//		CLogFile* pLogFile
//
//	[ ߂l ]
//		CResIuWFNg
//
//	[  ]
//		ϊs܂
//--------------------------------------------------------------------
CRes ChipMaker::Convert(int offset, bool presetExists, CMap<int, int, int, int>* pPalErrorMap, BOOL ckeckPaletBlock, CLogFile* pLogFile)
{
	CRes cRes;

	// ϊrbg}bv
	if (presetExists == false) {
		cRes = InitializeConverted();
		if (!cRes.GetResult()) {
			return cRes;
		}
	}

	// DIBҏWJn
	cnvBitmap.PrepareBitOperation();

	// pbg]
	for (int i = 0; i < 256; i++) {
		RGBQUAD col = srcBitmap.GetPalet(i);
		cnvBitmap.SetPalet(i, col);
	}

	// Pڂ͕K0߂̃p^[Ƃ
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			cnvBitmap.SetPixelIndex(x, y, 0);
		}
	}
	convertedChipCount = 1;
	if (offset >= 1) {
		convertedChipCount = offset;
	}

	// ϊĂ
	BG_DEF_UNIT bg_def;
	int srcChipWidth = srcBitmap.GetWidth() / 8;
	int srcChipHeight = srcBitmap.GetHeight() / 8;
	if (pLogFile != NULL) {
		pLogFile->Log("摜TCY@@F(%d, %d)\n", srcBitmap.GetWidth(), srcBitmap.GetHeight());
		pLogFile->Log("BG}bvTCYF(%d, %d)\n", srcChipWidth, srcChipHeight);
	}

	bg_map = (BG_DEF_UNIT*)malloc(srcChipWidth * srcChipHeight * sizeof(BG_DEF_UNIT));
	int bg_map_index = 0;
	CString error = "";
	for (int y = 0; y < srcChipHeight; y+=2) {
		for (int x = 0; x < srcChipWidth; x+=2) {
			// n=0
			bg_def = ConvertChip(x, y, pPalErrorMap, ckeckPaletBlock, pLogFile);
			if (bg_def.code.bit.dummy != 0) {
				cnvBitmap.EndBitOperation(this->pDCConverted);
				error = "BG`̃p^[1024𒴂܂B";
				break;
			}
			bg_map[(y * srcChipWidth) + x] = bg_def;

			// n=1
			if ((y + 1) < srcChipHeight) {
				bg_def = ConvertChip(x, y + 1, pPalErrorMap, ckeckPaletBlock, pLogFile);
				if (bg_def.code.bit.dummy != 0) {
					cnvBitmap.EndBitOperation(this->pDCConverted);
					error = "BG`̃p^[1024𒴂܂B";
					break;
				}
				bg_map[((y+1) * srcChipWidth) + x] = bg_def;
			}

			// n=2
			if ((x + 1) < srcChipWidth) {
				bg_def = ConvertChip(x + 1, y, pPalErrorMap, ckeckPaletBlock, pLogFile);
				if (bg_def.code.bit.dummy != 0) {
					cnvBitmap.EndBitOperation(this->pDCConverted);
					error = "BG`̃p^[1024𒴂܂B";
					break;
				}
				bg_map[(y * srcChipWidth) + (x+1)] = bg_def;
			}

			// n=3
			if (((x + 1) < srcChipWidth) && ((y + 1) < srcChipHeight)) {
				bg_def = ConvertChip(x + 1, y + 1, pPalErrorMap, ckeckPaletBlock, pLogFile);
				if (bg_def.code.bit.dummy != 0) {
					cnvBitmap.EndBitOperation(this->pDCConverted);
					error = "BG`̃p^[1024𒴂܂B";
					break;
				}
				bg_map[((y+1) * srcChipWidth) + (x+1)] = bg_def;
			}
		}
		if (error.GetLength() > 0) {
			break;
		}
	}
	if (error.GetLength() > 0) {
		return CRes::CreateError(error);
	}
	
	// DIBҏWI
	cnvBitmap.EndBitOperation(this->pDCConverted);

	// ϊʃO
	if (pLogFile != NULL) {
		pLogFile->Log("`p^[F%d\n", this->convertedChipCount);
		if (this->convertedChipCount >= 256) {
			pLogFile->Log("őBG` 256 𒴂Ă܂B\n");
		}
	}

	// I
	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		CRes ConvertChip(int mx, int my, CArray<int>* pPalErrorList, CLogFile* pLog)
//
//	[  ]
//		int mx	摜8x8hbg̃bVƂƂ́AbVXW
//		int my	摜8x8hbg̃bVƂƂ́AbVYW
//		CMap<int, int, int, int>* pPalErrorMap	pbgubNG[̃R[h̃}bv
//		BOOL checkPaletBlock	pbgubN̈vƂ
//		CLogFile* pLog	OIuWFNgւ̃|C^
//
//	[ ߂l ]
//		CResIuWFNg
//
//	[  ]
//		w肳ꂽbVʒũp^[ɂāAϊs܂
//--------------------------------------------------------------------
BG_DEF_UNIT ChipMaker::ConvertChip(int mx, int my, CMap<int, int, int, int>* pPalErrorMap, BOOL checkPaletBlock, CLogFile* pLog)
{
	// ϊσp^[ꂼƔr
	BG_DEF_UNIT bg_def;
	memset(&bg_def, 0, sizeof(BG_DEF_UNIT));
	bg_def.code.bit.dummy = 1;
	for (int i = 0; i < this->convertedChipCount; i++) {
		bg_def = CompareChip(mx * 8, my * 8, i, checkPaletBlock, pLog);
		if (bg_def.code.bit.dummy == 0) {
			// v̂ꍇ͔
			break;
		}
	}

	// ɑ݂ꍇ͐VɒǉɏI
	if (bg_def.code.bit.dummy == 0) {
		return bg_def;
	}

//	if (convertedChipCount == 0x43) {
//		int a = 0;
//	}

	// p^[݂Ȃ̂Ńp^[]L
	if (this->convertedChipCount >= 1023) {
		if (pLog != NULL) {
			pLog->Log("BG`̃p^[1024𒴂܂B摜bVʒuF(%d, %d)\n", mx, my);
		}
		bg_def.code.bit.dummy = 1;
		return bg_def;
	}

	// ϊrbg}bv̍W𓾂
	int n = this->convertedChipCount & 3;
	int blockIndex = this->convertedChipCount / 4;
	int tx = (blockIndex & 15) * 2;
	int ty = (blockIndex / 16) * 2;
	if (n == 1) { ty += 1; }
	if (n == 2) { tx += 1; }
	if (n == 3) { tx += 1; ty += 1; }
	tx *= 8;
	ty *= 8;

	// p^[]BFR[h16̗]ƂB
	int sx = mx * 8;
	int sy = my * 8;
	int rx, ry, rblock, rdecided;
	rx = ry = rblock = rdecided = 0;
	// QƂ̃pbgubN𓾂
	for (int x = 0; x < 8; x++) {
		for (int y = 0; y < 8; y++) {
			int code = srcBitmap.GetPixelIndex(sx+x, sy+y);
			if ((code&15) != 0) {
				rx = x;
				ry = y;
				rblock = code / 16;
				rdecided = 1;
				break;
			}
		}
		if (rdecided == 1) {
			break;
		}
	}

	// pbgubN̕s`FbN
	bool palError = false;
	int ex, ey, eblock;
	ex = ey = eblock = 0;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			//int colorIndex = srcBitmap.GetPixelIndex(sx + x, sy + y) & 15;
			int colorIndex = srcBitmap.GetPixelIndex(sx + x, sy + y);
			cnvBitmap.SetPixelIndex(tx + x, ty + y, colorIndex);

			// pbgubÑ`FbN
			if(!palError) {
				int pixelPaletBlock = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
				if ((pixelPaletBlock != rblock) && (colorIndex != 0)) {
					palError = true;
					ex = x;
					ey = y;
					eblock = pixelPaletBlock;
				}
			}
		}
	}
	if (palError) {
		if (pLog != NULL) {
			pLog->Log("pbgubNɕs܂BcodeF%02X, sNZʒuF(%d, %d), BGʒuF(%d, %d), QƃpbgubNF%d (%d, %d), spbgubNF%d (%d, %d)\n"	//
				, convertedChipCount	//
				, ex, ey	//
				, mx, my	//
				, rblock, rx, ry	//
				, eblock, ex, ey	//
			);
			if (pPalErrorMap != NULL) {
				pPalErrorMap->SetAt(this->convertedChipCount, 1);	// pbgubNs}[N
			}
		}
	}

	// ʂpӂ
	bg_def.code.bit.code = this->convertedChipCount;
	bg_def.code.bit.color = rblock;
	bg_def.code.bit.dummy = 0;
	bg_def.code.bit.h_rev = 0;
	bg_def.code.bit.v_rev = 0;
	
	// I
	this->convertedChipCount += 1;
	return bg_def;
}

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::CreateBGMapImage(CDC* pDC, const char* filename, CMap<int, int, int, int>* pPalErrorMap, CLogFile* pLogFile)
{
	// Ɖ摜̃TCY𓾂
	int width = srcBitmap.GetWidth();
	int height = srcBitmap.GetHeight();
	int meshSizeY = height / 8;
	int meshSizeX = width / 8;

	// o͗pBMPpӂ
	Cfbmp bmp;
	bmp.Initialize(width * 2, height * 2, 24, pDC);

	// rbg}bv̑Jn
	bmp.PrepareBitOperation();

	// rbg}bv̉摜𔖂Ȃ畡i2x2gj
	for (int y = 0; y < srcBitmap.GetHeight(); y++) {
		for (int x = 0; x < srcBitmap.GetWidth(); x++) {
			RGBQUAD quad = srcBitmap.GetPixelColor(x, y);
			/*
			int r = quad.rgbRed;
			int g = quad.rgbGreen;
			int b = quad.rgbBlue;
			r = ((256 * 30000) + (r * 70000)) / 100000;
			g = ((256 * 30000) + (g * 70000)) / 100000;
			b = ((256 * 30000) + (b * 70000)) / 100000;
			quad.rgbRed = r;
			quad.rgbGreen = g;
			quad.rgbBlue = b;
			*/
			//
			bmp.SetPixelColor((x * 2) + 0, (y * 2) + 0, quad);
			bmp.SetPixelColor((x * 2) + 1, (y * 2) + 0, quad);
			bmp.SetPixelColor((x * 2) + 0, (y * 2) + 1, quad);
			bmp.SetPixelColor((x * 2) + 1, (y * 2) + 1, quad);
		}
	}

	// `
	RGBQUAD quad0;
	memset(&quad0, 0, sizeof(RGBQUAD));
	for (int y = 0; y < height * 2; y += 16) {
		for (int x = 0; x < width * 2; x++) {
			bmp.SetPixelColor(x, y, quad0);
		}
	}
	for (int x = 0; x < width * 2; x += 16) {
		for (int y = 0; y < height * 2; y++) {
			bmp.SetPixelColor(x, y, quad0);
		}
	}

	// pbgubNG[̈ʒu
	for (int my = 0; my < meshSizeY; my++) {
		for (int mx = 0; mx < meshSizeX; mx++) {
			int index = (meshSizeX * my) + mx;
			int code = bg_map[index].code.bit.code;
			if (pPalErrorMap == NULL) { continue; }

			int errorType = 0;
			BOOL isError;
			isError = pPalErrorMap->Lookup(code, errorType);
			if (!isError) { continue; }

			// h
			for (int y = 0; y <= 16; y+=2) {
				for (int x = 0; x <= 16; x+=2) {
					int px = (mx * 8 * 2) + x;
					int py = (my * 8 * 2) + y;

					RGBQUAD quad;
					quad = bmp.GetPixelColor(px, py);
					quad.rgbRed = 0xFF;
					quad.rgbGreen = 0x00;
					quad.rgbBlue = 0x00;
					bmp.SetPixelColor(px, py, quad);
				}
			}
		}
	}

	// `
	RGBQUAD colRed, colBlue;
	colRed.rgbRed = 0xFF;
	colRed.rgbGreen = 0x00;
	colRed.rgbBlue = 0x00;
	//
	colBlue.rgbRed = 0x00;
	colBlue.rgbGreen = 0x00;
	colBlue.rgbBlue = 0xFF;
	//
	CMap<int, int, int, int> codeMap;
	codeMap.RemoveAll();
	//
	for (int y = 0; y < meshSizeY / 2; y++) {
		for (int x = 0; x < meshSizeX / 2; x++) {
			int px, py;

			// n = 0
			px = (x << 1);
			py = (y << 1);
			DrawChipCodeNumber(px, py, meshSizeX, meshSizeY, &bmp, colBlue, colRed, &codeMap);

			// n = 1
			px = (x << 1);
			py = (y << 1)+1;
			DrawChipCodeNumber(px, py, meshSizeX, meshSizeY, &bmp, colBlue, colRed, &codeMap);

			// n = 2
			px = (x << 1)+1;
			py = (y << 1);
			DrawChipCodeNumber(px, py, meshSizeX, meshSizeY, &bmp, colBlue, colRed, &codeMap);

			// n = 3
			px = (x << 1)+1;
			py = (y << 1)+1;
			DrawChipCodeNumber(px, py, meshSizeX, meshSizeY, &bmp, colBlue, colRed, &codeMap);
		}
	}

	// rbgI
	bmp.EndBitOperation(pDC);

	bmp.Save(filename);
	bmp.Free();

	// OɌʂo
	pLogFile->Log("R[ho񐔁F\n");
	for (int i = 1; i < 255; i++) {
		int count;
		if (!codeMap.Lookup(i, count)) {
			continue;
		}
		pLogFile->Log("[%02X] %d\n", i, count);
	}

	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::DrawChipCodeNumber(int px, int py, int meshSizeX, int meshSizeY, Cfbmp* pBmp, RGBQUAD colNormal, RGBQUAD colFirst, CMap<int, int, int, int>* pMap) {
	// F`
	RGBQUAD boxQuad[8];
	boxQuad[0].rgbRed = 0x00; boxQuad[0].rgbGreen = 0x00; boxQuad[0].rgbBlue = 0xFF;
	boxQuad[1].rgbRed = 0x00; boxQuad[1].rgbGreen = 0xFF; boxQuad[1].rgbBlue = 0x00;
	boxQuad[2].rgbRed = 0x00; boxQuad[2].rgbGreen = 0xFF; boxQuad[2].rgbBlue = 0xFF;
	boxQuad[3].rgbRed = 0xFF; boxQuad[3].rgbGreen = 0x00; boxQuad[3].rgbBlue = 0x00;
	boxQuad[4].rgbRed = 0xFF; boxQuad[4].rgbGreen = 0x00; boxQuad[4].rgbBlue = 0xFF;
	boxQuad[5].rgbRed = 0xFF; boxQuad[5].rgbGreen = 0xFF; boxQuad[5].rgbBlue = 0x00;
	boxQuad[6].rgbRed = 0xFF; boxQuad[6].rgbGreen = 0xFF; boxQuad[6].rgbBlue = 0xFF;
	boxQuad[7].rgbRed = 0xFF; boxQuad[7].rgbGreen = 0x80; boxQuad[7].rgbBlue = 0x80;

	//
	int index, code, pal, val;
	if ((px < meshSizeX) && (py < meshSizeY)) {
		// R[hԍ擾
		index = (meshSizeX * py) + px;
		code = bg_map[index].code.bit.code;
		pal = bg_map[index].code.bit.color;
		val = ((pal & 0xF) << 8) + (code & 0xFF);

		// ͈
		int r_code;	// R[h
		if (this->stepCodesMap.Lookup(val, r_code)) {
			// ꂾ
			for (int i = 0; i < 16; i++) {
				pBmp->SetPixelColor((px * 16) + i, (py * 16), boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16), (py * 16) + i, boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16) + i, (py * 16) + 15, boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16) + 15, (py * 16) + i, boxQuad[r_code & 7]);

				pBmp->SetPixelColor((px * 16) + i, (py * 16) + 1, boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16) + 1, (py * 16) + i, boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16) + i, (py * 16) + 14, boxQuad[r_code & 7]);
				pBmp->SetPixelColor((px * 16) + 14, (py * 16) + i, boxQuad[r_code & 7]);
			}
		}

		// R[hۂɂFI
		RGBQUAD col;
		int code_count;
		if (pMap->Lookup(code, code_count)) {
			// l͊iʏj
			col = colNormal;
			code_count += 1;
			pMap->SetAt(code, code_count);	// lJEgčXV
		}
		else {
			// l͏߂Č
			col = colFirst;
			pMap->SetAt(code, 1); // ŏ̒l
		}

		// `悷
		if (code != 0) {
			// pbgubN
			DrawNumber(pBmp, (px * 16) + 1 + 6, (py * 16) + 0, (pal % 16) & 0xF, col);

			// R[hԍ
			DrawNumber(pBmp, (px * 16) + 1 + 0, (py * 16) + 8, (code / 16) & 0xF, col);
			DrawNumber(pBmp, (px * 16) + 1 + 6, (py * 16) + 8, (code % 16) & 0xF, col);
		}
	}

	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::DrawNumber(Cfbmp* pBmp, int px, int py, int number, RGBQUAD& quad)
{
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			if (numberPattern[number][y][x] == 0) {
				continue;
			}

			RGBQUAD col;
			memset(&col, 0, sizeof(RGBQUAD));
			switch (numberPattern[number][y][x]) {
			case 1:
				col.rgbRed = 0xFF;
				col.rgbGreen = 0xFF;
				col.rgbBlue = 0xFF;
				break;
			case 2:
				col = quad;
				break;
			default:
				col.rgbRed = 0xFF;
				break;
			}
			pBmp->SetPixelColor(px + x, py + y, col);
		}
	}

	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::CreateSPDefImage(CDC* pDC, const char* filename, CLogFile* pLogFile)
{
	// Ɖ摜̃TCY𓾂
	int width = cnvBitmap.GetWidth();
	int height = cnvBitmap.GetHeight();

	// o͗pBMPpӂ
	Cfbmp bmp;
	bmp.Initialize(width * 2, height * 2, 24, pDC);

	// rbg}bv̑Jn
	bmp.PrepareBitOperation();

	// rbg}bv̉摜𔖂Ȃ畡i2x2gj
	for (int y = 0; y < cnvBitmap.GetHeight(); y++) {
		for (int x = 0; x < cnvBitmap.GetWidth(); x++) {
			RGBQUAD quad = cnvBitmap.GetPixelColor(x, y);
			/*
			int r = quad.rgbRed;
			int g = quad.rgbGreen;
			int b = quad.rgbBlue;
			r = ((256 * 30000) + (r * 70000)) / 100000;
			g = ((256 * 30000) + (g * 70000)) / 100000;
			b = ((256 * 30000) + (b * 70000)) / 100000;
			quad.rgbRed = r;
			quad.rgbGreen = g;
			quad.rgbBlue = b;
			*/
			//
			bmp.SetPixelColor((x * 2) + 0, (y * 2) + 0, quad);
			bmp.SetPixelColor((x * 2) + 1, (y * 2) + 0, quad);
			bmp.SetPixelColor((x * 2) + 0, (y * 2) + 1, quad);
			bmp.SetPixelColor((x * 2) + 1, (y * 2) + 1, quad);
		}
	}

	// `
	RGBQUAD quad0;
	memset(&quad0, 0, sizeof(RGBQUAD));
	for (int y = 0; y < height * 2; y += 16) {
		for (int x = 0; x < width * 2; x++) {
			bmp.SetPixelColor(x, y, quad0);
		}
	}
	for (int x = 0; x < width * 2; x += 16) {
		for (int y = 0; y < height * 2; y++) {
			bmp.SetPixelColor(x, y, quad0);
		}
	}

	// `
	RGBQUAD colBlue, colRed;
	colBlue.rgbRed = 0x00;
	colBlue.rgbGreen = 0x00;
	colBlue.rgbBlue = 0xFF;
	//
	colRed.rgbRed = 0xFF;
	colRed.rgbGreen = 0x00;
	colRed.rgbBlue = 0x00;
	//
	int meshSizeY = height / 8;
	int meshSizeX = width / 8;
	//
	int code = 0;
	for (int y = 0; y < meshSizeY / 2; y++) {
		for (int x = 0; x < meshSizeX / 2; x++) {
			int px, py;
			RGBQUAD col;
			col = colBlue;
			if (y >= 4) {
				col = colRed;
			}

			// n = 0
			px = (x << 1);
			py = (y << 1);
			DrawDefCodeNumber(code++, px, py, meshSizeX, meshSizeY, &bmp, col);

			// n = 1
			px = (x << 1);
			py = (y << 1) + 1;
			DrawDefCodeNumber(code++, px, py, meshSizeX, meshSizeY, &bmp, col);

			// n = 2
			px = (x << 1) + 1;
			py = (y << 1);
			DrawDefCodeNumber(code++, px, py, meshSizeX, meshSizeY, &bmp, col);

			// n = 3
			px = (x << 1) + 1;
			py = (y << 1) + 1;
			DrawDefCodeNumber(code++, px, py, meshSizeX, meshSizeY, &bmp, col);
		}
	}

	// rbgI
	bmp.EndBitOperation(pDC);

	bmp.Save(filename);
	bmp.Free();

	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
CRes ChipMaker::DrawDefCodeNumber(int code, int px, int py, int meshSizeX, int meshSizeY, Cfbmp* pBmp, RGBQUAD col) {
	int index;
	index = (meshSizeX * py) + px;
	if (code != 0) {
		DrawNumber(pBmp, (px * 16) + 1 + 0, (py * 16) + 3, (code / 16) & 0xF, col);
		DrawNumber(pBmp, (px * 16) + 1 + 6, (py * 16) + 3, (code % 16) & 0xF, col);
	}

	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		BG_DEF_UNIT CompareChip(int sx, int sy, int targetBGCode, CLogFile* pLog)
//
//	[  ]
//		int sx	r摜̍sNZʒuX
//		int sy	r摜̍sNZʒuY
//		int targetBGCode	r摜łBGR[hԍ
//		BOOL comparePaletBlock	pbgubN̈vɊ܂߂
//		CLogFile* pLog	OIuWFNgւ̃|C^
//
//	[ ߂l ]
//		BG_DEF_UNIT BGp^[`̍\
//		vԍꍇdummy1
//
//	[  ]
//		r摜sx, syʒũubNAtargetBGCodeŎw肳
//		BGR[h̃p^[ƈv邩ۂ`FbN܂B
//		vp^[ꍇ́ABG_DEF_UNITɈv
//		BG̏ݒ肵ĕԂ܂B
//		v̂Ȃꍇdummy1i[ĕԂ܂B
//--------------------------------------------------------------------
BG_DEF_UNIT ChipMaker::CompareChip(int sx, int sy, int targetBGCode, BOOL comparePaletBlock, CLogFile* pLog)
{
	// ʊi[pӂ
	BG_DEF_UNIT result;
	memset(&result, 0, sizeof(BG_DEF_UNIT));

	// <<<<< ϊ摜̔rubN̍W𓱏o >>>>>
	int n = targetBGCode & 3;	// PCGR[hItZbg
	int blockIndex = targetBGCode / 4;	// 16x16SPR[hɑCfbNXԍ
	int tx = (blockIndex & 15) * 2;	// r^[QbgxW
	int ty = (blockIndex / 16) * 2;	// r^[QbgyW
	if (n == 1) { ty += 1; }
	if (n == 2) { tx += 1; }
	if (n == 3) { tx += 1; ty += 1; }
	tx *= 8;
	ty *= 8;
	//TRACE("tx = %d, ty = %d, targetBGCode = %d\n", tx, ty, targetBGCode);

	// <<<<< pbgubN擾Ă >>>>>
	int ltColorIndex = srcBitmap.GetPixelIndex(sx, sy);
	int palBlock = ltColorIndex / 16;
	int dec = 0;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			int code = srcBitmap.GetPixelIndex(sx + x, sy + y);
			if ((code & 15) != 0) {
				// 0ȊÕsNZ̐FŁAn߂ēoꂵubN̔ԍ̗p
				palBlock = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
				dec = 1;
				break;
			}
		}
		if (dec == 1) { break; }
	}

	// <<<<< ʏp^[ >>>>>
	bool same = true;
	same = true;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			int targetCode = cnvBitmap.GetPixelIndex(tx + x, ty + y) & 15;
			int srcCode = srcBitmap.GetPixelIndex(sx + x, sy + y) & 15;
			int targetPalet = cnvBitmap.GetPixelIndex(tx + x, ty + y) / 16;
			int srcPalet = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
			if ((targetCode != srcCode) || (comparePaletBlock && (targetPalet!=srcPalet))) {
				// FR[hႤ
				same = false;
				break;
			}
		}
		if (!same) {
			break;
		}
	}
	// rʂmF
	if (same) {
		// v
		result.code.bit.code = targetBGCode;
		result.code.bit.color = palBlock;
		result.code.bit.h_rev = 0;
		result.code.bit.v_rev = 0;
		return result;
	}

	// <<<<< E] >>>>>
	same = true;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			int targetCode = cnvBitmap.GetPixelIndex(tx + (7 - x), ty + y) & 15;
			int srcCode = srcBitmap.GetPixelIndex(sx + x, sy + y) & 15;
			int targetPalet = cnvBitmap.GetPixelIndex(tx + (7 - x), ty + y) / 16;
			int srcPalet = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
			if ((targetCode != srcCode) || (comparePaletBlock && (targetPalet != srcPalet))) {
				// FR[hႤ
				same = false;
				break;
			}
		}
		if (!same) {
			break;
		}
	}
	// rʂmF
	if (same) {
		// v
		result.code.bit.code = targetBGCode;
		result.code.bit.color = palBlock;
		result.code.bit.h_rev = 1;
		result.code.bit.v_rev = 0;
		return result;
	}

	// <<<<< ㉺] >>>>>
	same = true;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			int targetCode = cnvBitmap.GetPixelIndex(tx + x, ty + (7 - y)) & 15;
			int srcCode = srcBitmap.GetPixelIndex(sx + x, sy + y) & 15;
			int targetPalet = cnvBitmap.GetPixelIndex(tx + x, ty + (7 - y)) / 16;
			int srcPalet = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
			if ((targetCode != srcCode) || (comparePaletBlock && (targetPalet != srcPalet))) {
				// FR[hႤ
				same = false;
				break;
			}
		}
		if (!same) {
			break;
		}
	}
	// rʂmF
	if (same) {
		// v
		result.code.bit.code = targetBGCode;
		result.code.bit.color = palBlock;
		result.code.bit.h_rev = 0;
		result.code.bit.v_rev = 1;
		return result;
	}

	// <<<<< ㉺E] >>>>>
	same = true;
	for (int y = 0; y < 8; y++) {
		for (int x = 0; x < 8; x++) {
			int targetCode = cnvBitmap.GetPixelIndex(tx + (7 - x), ty + (7 - y)) & 15;
			int srcCode = srcBitmap.GetPixelIndex(sx + x, sy + y) & 15;
			int targetPalet = cnvBitmap.GetPixelIndex(tx + (7 - x), ty + (7 - y)) / 16;
			int srcPalet = srcBitmap.GetPixelIndex(sx + x, sy + y) / 16;
			if ((targetCode != srcCode) || (comparePaletBlock && (targetPalet != srcPalet))) {
				// FR[hႤ
				same = false;
				break;
			}
		}
		if (!same) {
			break;
		}
	}
	// rʂmF
	if (same) {
		// v
		result.code.bit.code = targetBGCode;
		result.code.bit.color = palBlock;
		result.code.bit.h_rev = 1;
		result.code.bit.v_rev = 1;
		return result;
	}

	// vȂ
	result.code.bit.dummy = 1;
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		CRes SaveFiles(CString bmpFilePath, CString mdtFilePath)
//
//	[  ]
//		CString bmpFilePath		ϊrbg}bv摜̕ۑt@CpX
//		CString mdtFilePath		BGMAP̃}bvf[^̕ۑt@CpX
//		CString pworldFilePath	p[h}bṽf[^ۑt@CpX
//		CString csvFilePath		p[h}bvCSVf[^ۑt@CpX
//
//	[ ߂l ]
//		CResIuWFNg
//
//	[  ]
//		ϊ̃f[^t@Cɕۑ܂B
//--------------------------------------------------------------------
CRes ChipMaker::SaveFiles(CString bmpFilePath, CString mdtFilePath, CString pworldFilePath, CString csvFilePath, CLogFile* pLog)
{
	BOOL bRes;

	// TCY𓱏o
	int srcChipWidth = srcBitmap.GetWidth() / 8;
	int srcChipHeight = srcBitmap.GetHeight() / 8;

	// <<<<< rbg}bvۑ >>>>>
	bRes = cnvBitmap.Save(bmpFilePath);
	if (!bRes) {
		return CRes::CreateError("ϊrbg}bvt@C̕ۑɎs܂B");
	}

	// _at
	CString mainFilePath = bmpFilePath.Left(bmpFilePath.GetLength() - 4);
	CString stencilPath = mainFilePath + "_a.bmp";
	bRes = cnvBitmap.SaveStencil(stencilPath);
	if (!bRes) {
		return CRes::CreateError("ϊrbg}bvt@C̕ۑɎs܂B");
	}

	// <<<<< MDT, p[h}bvۑ >>>>>
	// t@CJ
	FILE* fn = fopen((LPCTSTR)mdtFilePath, "wb");
	if (fn == NULL) {
		return CRes::CreateError("MDTt@CJ܂łB");
	}
	FILE* fnP = fopen((LPCTSTR)pworldFilePath, "wb");
	if (fnP == NULL) {
		fclose(fn);
		return CRes::CreateError("datt@CJ܂łB");
	}
	FILE* fnC = fopen((LPCTSTR)csvFilePath, "wt");
	if (fnC == NULL) {
		fclose(fn);
		fclose(fnP);
		return CRes::CreateError("csvt@CJ܂łB");
	}

	// f[^ϊȂ珑
	int bgDefIndex = 0;
	for (int y = 0; y < srcChipHeight; y++) {
		for (int x = 0; x < srcChipWidth; x++) {
			// f[^
			BG_DEF_UNIT bgDef = this->bg_map[bgDefIndex];
			int bgCode = (bgDef.code.bit.color<<8) + (bgDef.code.bit.code);	// pbgubN*256 + R[h
			int stepCode, stepCodeExists;
			stepCodeExists = this->stepCodesMap.Lookup(bgCode, stepCode);
			if (!stepCodeExists) { stepCode = 0; }

			// <<< MDT֏o >>>
			// 1oCg
			BYTE one = 0;
			one |= (bgDef.code.bit.h_rev) << 6;
			one |= (bgDef.code.bit.v_rev) << 7;
			one |= (bgDef.code.bit.color + 1);		// pbgubN͏ݎ+1
			fwrite(&one, sizeof(BYTE), 1, fn);
			if ((bgDef.code.bit.h_rev != 0) || (bgDef.code.bit.v_rev != 0)) {
				TRACE("h:%d, v:%d, one=%d\n", bgDef.code.bit.h_rev, bgDef.code.bit.v_rev, one);
			}

			// 2oCg
			BYTE two = 0;
			two = bgDef.code.bit.code;
			fwrite(&two, sizeof(BYTE), 1, fn);

			// <<< dat֏o >>>
			fputc(stepCode, fnP);
			 
			// <<< CSV֏o >>>
			CString csvElem;
			if (x > 0) { fputs(", ", fnC); }
			csvElem.Format("%02d", stepCode);
			fputs((LPCTSTR)csvElem, fnC);

			// 
			bgDefIndex++;
		}
		fputs("\n", fnC);
	}
	fclose(fn);
	fclose(fnP);
	fclose(fnC);

	// <<<<< I >>>>>
	return CRes::CreateOk();
}

//--------------------------------------------------------------------
//	[  ]
//		CString GetSrcBitmapInfo()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		rbg}bvɊւ\eLXg
//
//	[  ]
//		ǂݍ񂾃rbg}bvɊւ𕶎ɂĕԂ܂B
//--------------------------------------------------------------------
CString ChipMaker::GetSrcBitmapInfo()
{
	// ǂݍ݂Ȃ炻̎|Ԃ
	if (!srcBitmap.isReady()) {
		return CString("Ǎ");
	}

	// ǂݍݍςȂĕԂ
	CString result;
	int bmpWidth = srcBitmap.GetWidth();
	int bmpHeight = srcBitmap.GetHeight();
	int colors = srcBitmap.GetColorNum();
	int bgWidth = bmpWidth / 8;
	int bgHeight = bmpHeight / 8;
	result.Format("TCYF(%d, %d) FF%d, BGTCYF(%d, %d)\n", bmpWidth, bmpHeight, colors, bgWidth, bgHeight);

	// ʂԂ
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		bool IsSrcBitmapReady()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ϊ摜Readyۂ
//
//	[  ]
//		ϊ摜ReadyۂԂ܂B
//--------------------------------------------------------------------
bool ChipMaker::IsSrcBitmapReady() {
	return this->srcBitmap.isReady();
}


//--------------------------------------------------------------------
//	[  ]
//		CString GetCnvBitmapInfo()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ϊʂ̃rbg}bvɊւ\eLXg
//
//	[  ]
//		ϊʂ̃rbg}bvɊւ𕶎ɂĕԂ܂B
//--------------------------------------------------------------------
CString ChipMaker::GetCnvBitmapInfo()
{
	// ϊȂ炻̎|Ԃ
	if (!cnvBitmap.isReady()) {
		return CString("ϊ");
	}

	// ǂݍݍςȂĕԂ
	CString result;
	int count = this->convertedChipCount;
	result.Format("BGp^[F%d", count);
	if (count > 256) {
		result.Append(" BGő`𒴉");
	}

	return result;
}
