﻿
// BMPtoBGMAPDlg.cpp : 実装ファイル
//

#include "pch.h"
#include "framework.h"
#include "BMPtoBGMAP.h"
#include "BMPtoBGMAPDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "ChipMaker.h"

// アプリケーションのバージョン情報に使われる CAboutDlg ダイアログ

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ダイアログ データ
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV サポート

// 実装
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CBMPtoBGMAPDlg ダイアログ



CBMPtoBGMAPDlg::CBMPtoBGMAPDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_BMPTOBGMAP_DIALOG, pParent)
	, m_srcBmpPath(_T(""))
	, m_outDir(_T(""))
	, m_strSrcBmpInfo(_T(""))
	, m_strOutName(_T(""))
	, m_strCnvInfo(_T(""))
	, m_strStepCSV(_T(""))
	, m_bCheckDefPath(FALSE)
	, m_presetBmpPath(_T(""))
	, m_patternOffset(_T(""))
	, m_comparePaletBlock(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBMPtoBGMAPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PICTUREBOX, bmpSource);
	DDX_Text(pDX, IDC_EDIT_SRCBMP, m_srcBmpPath);
	DDX_Control(pDX, IDC_PICTURE_CNV, bmpConverted);
	DDX_Control(pDX, IDC_PICTURE_PAL, bmpPalet);
	DDX_Text(pDX, IDC_EDIT_OUTDIR, m_outDir);
	DDX_Text(pDX, IDC_SRC_INFO, m_strSrcBmpInfo);
	DDX_Text(pDX, IDC_EDIT_OUTNAME, m_strOutName);
	DDX_Text(pDX, IDC_PTNC, m_strCnvInfo);
	DDX_Text(pDX, IDC_EDIT_STEPCSV, m_strStepCSV);
	DDX_Text(pDX, IDC_EDIT_PRESETBMP, m_presetBmpPath);
	DDX_Text(pDX, IDC_EDIT_PATTERNOFFSET, m_patternOffset);
	DDX_Check(pDX, IDC_CHECK_COMPARE_PALET_BLOCK, m_comparePaletBlock);
}

BEGIN_MESSAGE_MAP(CBMPtoBGMAPDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_REFSRC, &CBMPtoBGMAPDlg::OnBnClickedButtonRefsrc)
	ON_BN_CLICKED(IDC_BUTTON_LOADSRC, &CBMPtoBGMAPDlg::OnBnClickedButtonLoadsrc)
	ON_BN_CLICKED(IDC_BUTTON_CONVERT, &CBMPtoBGMAPDlg::OnBnClickedButtonConvert)
	ON_BN_CLICKED(IDC_BUTTON_REFOUT, &CBMPtoBGMAPDlg::OnBnClickedButtonRefout)
	ON_BN_CLICKED(IDC_BUTTON_REFSTEPCSV, &CBMPtoBGMAPDlg::OnBnClickedButtonRefstepcsv)
	ON_BN_CLICKED(IDC_BUTTON_REFBMP, &CBMPtoBGMAPDlg::OnBnClickedButtonRefbmp)
	ON_BN_CLICKED(IDC_BUTTON_AUTOSET, &CBMPtoBGMAPDlg::OnBnClickedButtonAutoset)
	ON_BN_CLICKED(IDC_BUTTON_EXPLORER, &CBMPtoBGMAPDlg::OnBnClickedButtonExplorer)
	ON_BN_CLICKED(IDC_BUTTON_REFLOG, &CBMPtoBGMAPDlg::OnBnClickedButtonReflog)
	ON_BN_CLICKED(IDC_BUTTON_REFPRESETBMP, &CBMPtoBGMAPDlg::OnBnClickedButtonRefpresetbmp)
END_MESSAGE_MAP()


// CBMPtoBGMAPDlg メッセージ ハンドラー

BOOL CBMPtoBGMAPDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// "バージョン情報..." メニューをシステム メニューに追加します。

	// IDM_ABOUTBOX は、システム コマンドの範囲内になければなりません。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//  Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	//=============
	// 初期化処理
	//=============
	bool bRes = this->InitializeApp();
	if (!bRes) {
		MessageBox("アプリケーションの初期化中にエラーが発生しました。", "Error", MB_OK);
	}
	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

/// <summary>
/// 初期化処理
/// </summary>
/// <returns></returns>
bool CBMPtoBGMAPDlg::InitializeApp()
{
	// 初期値設定
	m_patternOffset = "000";

	// 元画像の表示領域を調整
	RECT pictureRect;
	pictureRect.top = 10;
	pictureRect.left = 10;
	pictureRect.right = pictureRect.left + 400;
	pictureRect.bottom = pictureRect.top + 400;
	this->bmpSource.MoveWindow(&pictureRect, true);
	this->m_strSrcBmpInfo = objChipMaker.GetSrcBitmapInfo();

	// 変換後画像の表示領域を調整
	pictureRect.top = 10;
	pictureRect.left = 420;
	pictureRect.bottom = pictureRect.top + 256;
	pictureRect.right = pictureRect.left + 256;
	this->bmpConverted.MoveWindow(&pictureRect, true);

	// パレット画像の表示領域を調整
	pictureRect.top = 10 + 256 + 10;
	pictureRect.left = 420;
	pictureRect.right = pictureRect.left + (8 * 16);
	pictureRect.bottom = pictureRect.top + (8 * 15);
	this->bmpPalet.MoveWindow(&pictureRect, true);

	// 画像表示部のDCを得る
	pDCSource = this->bmpSource.GetDC();
	if (pDCSource == NULL) {
		MessageBox("ソース画像のDCの取得に失敗しました。", "Error", MB_OK);
		return false;
	}

	// 変換後の画像の表示用DCを得る
	pDCConverted = this->bmpConverted.GetDC();
	if (pDCConverted == NULL) {
		MessageBox("変換後画像のDCの取得に失敗しました。", "Error", MB_OK);
		return false;
	}

	// パレット表示用DCを得る
	pDCPalet = this->bmpPalet.GetDC();
	if (pDCPalet == NULL) {
		MessageBox("パレット画像のDCの取得に失敗しました。", "Error", MB_OK);
		return false;
	}

	// ChipMaker本体を初期化する
	RECT srcRect, cnvRect, palRect;
	bmpSource.GetClientRect(&srcRect);
	bmpConverted.GetClientRect(&cnvRect);
	bmpPalet.GetClientRect(&palRect);
	CRect bmpSrcRect(srcRect);
	CRect bmpCnvRect(cnvRect);
	CRect bmpPalRect(palRect);

	CRes res = objChipMaker.Initialize(pDCSource, bmpSrcRect, pDCConverted, bmpCnvRect, pDCPalet, bmpPalRect);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg(), "Error", MB_OK);
		return false;
	}

	// 情報更新
	m_strSrcBmpInfo = objChipMaker.GetSrcBitmapInfo();
	m_strCnvInfo = objChipMaker.GetCnvBitmapInfo();

	// 表示更新
	UpdateData(false);
	return true;
}

void CBMPtoBGMAPDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//  下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//  これは、Framework によって自動的に設定されます。

void CBMPtoBGMAPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();

		// ChipMakerに描画指示
		this->objChipMaker.DoDraw();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//  システムがこの関数を呼び出します。
HCURSOR CBMPtoBGMAPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


/// <summary>
/// ダイアログが閉じるときのイベントハンドラ
/// </summary>
void CBMPtoBGMAPDlg::OnClose()
{
	// ChipMakerを解放
	this->objChipMaker.Release();

	// DCを解放
	ReleaseDC(this->pDCSource);
	ReleaseDC(this->pDCConverted);
	ReleaseDC(this->pDCPalet);

	// 標準の終了処理
	CDialogEx::OnClose();
}

/// <summary>
/// ソースBMPのファイルパス参照
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonRefsrc()
{
	CFileDialog fileDialog(TRUE, "*.bmp", NULL, OFN_FILEMUSTEXIST | OFN_READONLY, NULL, this);
	INT_PTR result = fileDialog.DoModal();
	if (result != IDOK) {
		return;
	}
	
	// 値を取得して更新
	m_srcBmpPath = fileDialog.GetPathName();
	UpdateData(false);
}

/// <summary>
/// PresetBMPのファイルパス参照
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonRefpresetbmp()
{
	CFileDialog fileDialog(TRUE, "*.bmp", NULL, OFN_FILEMUSTEXIST | OFN_READONLY, NULL, this);
	INT_PTR result = fileDialog.DoModal();
	if (result != IDOK) {
		return;
	}

	// 値を取得して更新
	m_presetBmpPath = fileDialog.GetPathName();
	UpdateData(false);
}

/// <summary>
/// 読み込む
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonLoadsrc()
{
	// データ更新
	UpdateData(true);

	// <<<<< ソース画像 >>>>>
	//
	// 確認
	if (m_srcBmpPath.GetLength() == 0) {
		MessageBox("変換元ビットマップ画像のファイルを指定してください。", "Error", MB_OK);
		return;
	}

	CFileFind find;
	bool exists = find.FindFile(m_srcBmpPath);
	if (!exists) {
		MessageBox("指定されたファイルを開けませんでした。", "Error", MB_OK);
		return;
	}

	// 開く
	CRes result = this->objChipMaker.LoadSrcBitmap(m_srcBmpPath);
	if (!result.GetResult()) {
		MessageBox(result.GetMsg(), "Error", MB_OK);
		return;
	}

	// <<<<< 変換後画像 >>>>>
	//
	// 確認
	bool presetExists = false;
	if (m_presetBmpPath.GetLength() > 0) {
		CFileFind find;
		bool exists = find.FindFile(m_presetBmpPath);
		if (!exists) {
			MessageBox("指定されたプリセット画像のファイルを開けませんでした。", "Error", MB_OK);
			return;
		}

		// 開く
		CRes result = this->objChipMaker.LoadPresetBitmap(m_presetBmpPath);
		if (!result.GetResult()) {
			MessageBox(result.GetMsg(), "Error", MB_OK);
			return;
		}

		// プリセットパターンあり
		presetExists = true;
	}

	// <<<<< オフセット値を得る >>>>>
	//
	unsigned int offset = GetOffsetValue();
	if (offset < 0) {
		return;
	}

	// <<<<< 変換処理を実行する >>>>>
	result = objChipMaker.Convert(offset, presetExists , NULL, m_comparePaletBlock, NULL);
	if (!result.GetResult()) {
		MessageBox(result.GetMsg(), "Error", MB_OK);
		objChipMaker.DoDraw();
		return;
	}

	// 描画しなおす
	objChipMaker.DoDraw();

	// 読み込んだ結果をラベルに表示
	m_strSrcBmpInfo = objChipMaker.GetSrcBitmapInfo();
	m_strCnvInfo = objChipMaker.GetCnvBitmapInfo();
	UpdateData(false);
}

/// <summary>
/// オフセットの入力値を整数にして返す
/// </summary>
/// <returns></returns>
int CBMPtoBGMAPDlg::GetOffsetValue() {
	unsigned int offset = 0;
	if (!m_patternOffset.IsEmpty()) {
		m_patternOffset.MakeUpper();
		int count = sscanf((LPCTSTR)m_patternOffset, "%03X", &offset);
		if (count <= 0) {
			MessageBox("読込先は16進数で指定してください。");
			return -1;
		}
		if ((offset < 0) || (offset >= 0x400)) {
			MessageBox("読込先は0～3FFの範囲で指定してください。");
			return -1;
		}
	}
	return offset;
}

/// <summary>
/// 変換処理
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonConvert()
{
	CRes cRes;

	// 画面上の入力フィールドからファイル名・ディレクトリ名を取り込む
	UpdateData(true);

	// 入力の状態を確認する
	if (!objChipMaker.IsSrcBitmapReady()) {
		MessageBox("変換元画像が読み込まれていません。", "Error", MB_OK);
		return;
	}
	if (m_strOutName.GetLength() == 0) {
		MessageBox("出力先の主ファイル名を指定してください。", "Error", MB_OK);
		return;
	}
	if (m_outDir.GetLength() == 0) {
		MessageBox("出力先のディレクトリを指定してください。", "Error", MB_OK);
		return;
	}

	// 出力先ディレクトリの存在を確認する
	CFileFind find;
	bool dirExists = find.FindFile(m_outDir);
	if (!dirExists) {
		MessageBox("指定された出力先ディレクトリが存在しません。", "Error", MB_OK);
		return;
	}
	
	// 既存ファイルがあるかを確認する
	CString path = m_outDir;
	CString bmpFilePath = m_outDir + CString("\\") + m_strOutName + ".bmp";
	CString mdtFilePath = m_outDir + CString("\\") + m_strOutName + ".mdt";
	CString logFilePath = m_outDir + CString("\\") + m_strOutName + ".log";
	CString codeBmpFilePath = m_outDir + CString("\\") + m_strOutName + "_code.bmp";
	CString defBmpFilePath = m_outDir + CString("\\") + m_strOutName + "_def.bmp";
	CString datFilePath = m_outDir + CString("\\") + m_strOutName + ".pwm";	// パラレルワールドマップ
	CString csvFilePath = m_outDir + CString("\\") + m_strOutName + "_pworld.csv";
	bmpFilePath.Replace("\\\\", "\\");
	mdtFilePath.Replace("\\\\", "\\");
	logFilePath.Replace("\\\\", "\\");
	codeBmpFilePath.Replace("\\\\", "\\");
	defBmpFilePath.Replace("\\\\", "\\");
	datFilePath.Replace("\\\\", "\\");
	csvFilePath.Replace("\\\\", "\\");
	CString message = "";
	if (find.FindFile(bmpFilePath)) {
		message += bmpFilePath + "\n";
	}
	if (find.FindFile(mdtFilePath)) {
		message += mdtFilePath + "\n";
	}
	if (find.FindFile(logFilePath)) {
		message += logFilePath + "\n";
	}
	if (find.FindFile(codeBmpFilePath)) {
		message += codeBmpFilePath + "\n";
	}
	if (find.FindFile(defBmpFilePath)) {
		message += defBmpFilePath + "\n";
	}
	if (find.FindFile(datFilePath)) {
		message += datFilePath + "\n";
	}
	if (find.FindFile(csvFilePath)) {
		message += csvFilePath + "\n";
	}
	if (message.GetLength() > 0) {
		message += CString("は既存です。上書きしますか？");
		int yesno = MessageBox(message, "確認", MB_YESNO);
		if (yesno != IDYES) {
			// キャンセル
			return;
		}
	}

	// ログを開く
	CLogFile logFile;
	logFile.Open(logFilePath);
	logFile.SetMode(LOGFILE_TRACE);

	// 足場CSVを読み込む
	if (m_strStepCSV != "") {
		objChipMaker.ReadStepCSV((LPCTSTR)m_strStepCSV, &logFile);
	}

	// オフセット値を得る
	unsigned int offset = GetOffsetValue();
	if (offset < 0) {
		return;
	}

	// プリセットパターン有無を判定
	bool presetExists = false;
	if (m_presetBmpPath.GetLength() > 0) {
		presetExists = true;
	}

	// 変換処理を実行する
	CMap<int, int, int, int> palErrorMap;
	cRes = objChipMaker.Convert(offset, presetExists, &palErrorMap, m_comparePaletBlock, &logFile);
	if (!cRes.GetResult()) {
		MessageBox(cRes.GetMsg(), "Error", MB_OK);
		objChipMaker.DoDraw();
		logFile.Close();
		return;
	}

	// 変換結果を保存する
	cRes = objChipMaker.SaveFiles(bmpFilePath, mdtFilePath, datFilePath, csvFilePath, &logFile);
	if (!cRes.GetResult()) {
		MessageBox(cRes.GetMsg(), "Error", MB_OK);
		objChipMaker.DoDraw();
		logFile.Close();
		return;
	}

	// コード番号の画像を作って保存する
	CDC* pDC = GetDC();
	objChipMaker.CreateBGMapImage(pDC, codeBmpFilePath, &palErrorMap ,&logFile);
	ReleaseDC(pDC);

	// 定義のコード番号の画像を作って保存する
	pDC = GetDC();
	objChipMaker.CreateSPDefImage(pDC, defBmpFilePath, &logFile);
	ReleaseDC(pDC);

	// 描画しなおす
	objChipMaker.DoDraw();

	// 変換した結果をラベルに表示
	m_strSrcBmpInfo = objChipMaker.GetSrcBitmapInfo();
	m_strCnvInfo = objChipMaker.GetCnvBitmapInfo();
	UpdateData(false);

	// 結果を表示する
	logFile.Close();
	MessageBox("チップ画像とBGパターンを保存しました。");
}

/// <summary>
/// 出力先ディレクトリ参照
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonRefout()
{
	UpdateData();
	CFolderPickerDialog folderDialog(m_outDir);

	// ダイアログ表示
	if (folderDialog.DoModal() == IDOK)
	{
		CString fullPathName = folderDialog.GetPathName();
		m_outDir = fullPathName;
		UpdateData(FALSE);
	}
}

/// <summary>
/// 足場CSVの参照ボタン
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonRefstepcsv()
{
	CFileDialog fileDialog(TRUE, "*.csv", NULL, OFN_FILEMUSTEXIST | OFN_READONLY, NULL, this);
	INT_PTR result = fileDialog.DoModal();
	if (result != IDOK) {
		return;
	}

	// 値を取得して更新
	m_strStepCSV = fileDialog.GetPathName();
	UpdateData(false);
}


void CBMPtoBGMAPDlg::OnBnClickedButtonRefbmp()
{
	CRes cRes;

	// 画面上の入力フィールドからファイル名・ディレクトリ名を取り込む
	UpdateData(true);

	// 入力の状態を確認する
	if (m_strOutName.GetLength() == 0) {
		MessageBox("出力先の主ファイル名が指定されていません。", "Error", MB_OK);
		return;
	}
	if (m_outDir.GetLength() == 0) {
		MessageBox("出力先のディレクトリが指定されていません。", "Error", MB_OK);
		return;
	}

	// 出力先ディレクトリの存在を確認する
	CFileFind find;
	bool dirExists = find.FindFile(m_outDir);
	if (!dirExists) {
		MessageBox("指定された出力先ディレクトリが存在しません。", "Error", MB_OK);
		return;
	}

	// 既存ファイルがあるかを確認する
	CString path = m_outDir;
	CString codeBmpFilePath = m_outDir + CString("\\") + m_strOutName + "_code.bmp";
	codeBmpFilePath.Replace("\\\\", "\\");
	bool bmpExists = find.FindFile(codeBmpFilePath);
	if (!bmpExists) {
		MessageBox("BGマップコード画像が存在しません。", "Error", MB_OK);
		return;
	}

	// 開く
	ShellExecute(
		m_hWnd,				//親ウィンドウのハンドル
		"open",				//ファイルの操作
		codeBmpFilePath,	//ファイル又はアプリケーションのパス
		NULL,				//アプリケーションに渡す引数
		NULL,				// デフォルトのディレクトリ
		SW_SHOWMINIMIZED	// アプリケーションが実行されたときのウィンドウの状態
	);
}

/// <summary>
/// ソースBMPに指定されたパスを参考に関連のパスを自動設定する
/// </summary>
void CBMPtoBGMAPDlg::OnBnClickedButtonAutoset()
{
	UpdateData();
	
	// ソースBMPのパスをチェック
	CString pathChecker = m_srcBmpPath;
	pathChecker.MakeUpper();
	if (pathChecker.Find(".BMP") < 0) {
		// BMPのパスが設定されていないならここまで
		MessageBox("ソースBMPが指定されていません。", MB_OK);
		return;
	}

	// ベースパスを抽出
	char basePath[MAX_PATH];
	char* pFilename;
	strcpy(basePath, (LPCTSTR)m_srcBmpPath);
	PathRemoveFileSpec(basePath);
	pFilename = PathFindFileName((LPCTSTR)m_srcBmpPath);

	// ステージ番号を抽出
	int length = strlen(pFilename);
	char stageNo = '0';
	for (int i = 0; i < length; i++) {
		char val = pFilename[i];
		if ((val >= '0') && (val <= '9')) {
			stageNo = val;
			break;
		}
	}
	CString strStageNo = CString(stageNo);

	// パスを設定
	m_outDir = basePath;
	m_strStepCSV = m_outDir + "\\background.csv";
	m_strOutName = CString("BG_ST") + strStageNo;

	// ダイアログの表示を更新
	UpdateData(FALSE);
	// 描画しなおす
	objChipMaker.DoDraw();
}


void CBMPtoBGMAPDlg::OnBnClickedButtonExplorer()
{
	CRes cRes;

	// 画面上の入力フィールドからファイル名・ディレクトリ名を取り込む
	UpdateData(true);

	// 入力の状態を確認する
	if (m_outDir.GetLength() == 0) {
		MessageBox("出力先のディレクトリが指定されていません。", "Error", MB_OK);
		return;
	}

	// 出力先ディレクトリの存在を確認する
	CFileFind find;
	bool dirExists = find.FindFile(m_outDir);
	if (!dirExists) {
		MessageBox("指定された出力先ディレクトリが存在しません。", "Error", MB_OK);
		return;
	}

	// 開く
	ShellExecute(
		NULL,				//親ウィンドウのハンドル
		"open",				//ファイルの操作
		m_outDir,			//ファイル又はアプリケーションのパス
		NULL,			//アプリケーションに渡す引数
		NULL,				// デフォルトのディレクトリ
		SW_SHOW	// アプリケーションが実行されたときのウィンドウの状態
	);

	// 描画しなおす
	objChipMaker.DoDraw();
}


void CBMPtoBGMAPDlg::OnBnClickedButtonReflog()
{
	CRes cRes;

	// 画面上の入力フィールドからファイル名・ディレクトリ名を取り込む
	UpdateData(true);

	// 入力の状態を確認する
	if (m_strOutName.GetLength() == 0) {
		MessageBox("出力先の主ファイル名が指定されていません。", "Error", MB_OK);
		return;
	}
	if (m_outDir.GetLength() == 0) {
		MessageBox("出力先のディレクトリが指定されていません。", "Error", MB_OK);
		return;
	}

	// 出力先ディレクトリの存在を確認する
	CFileFind find;
	bool dirExists = find.FindFile(m_outDir);
	if (!dirExists) {
		MessageBox("指定された出力先ディレクトリが存在しません。", "Error", MB_OK);
		return;
	}

	// 既存ファイルがあるかを確認する
	CString path = m_outDir;
	CString logFilePath = m_outDir + CString("\\") + m_strOutName + ".log";
	logFilePath.Replace("\\\\", "\\");
	bool bmpExists = find.FindFile(logFilePath);
	if (!bmpExists) {
		MessageBox("ログファイルが存在しません。", "Error", MB_OK);
		return;
	}

	// 開く
	ShellExecute(
		m_hWnd,				//親ウィンドウのハンドル
		"open",				//ファイルの操作
		logFilePath,	//ファイル又はアプリケーションのパス
		NULL,				//アプリケーションに渡す引数
		NULL,				// デフォルトのディレクトリ
		SW_SHOW	// アプリケーションが実行されたときのウィンドウの状態
	);
	// 描画しなおす
	objChipMaker.DoDraw();
}

