#pragma once
#ifndef __CHIPMAKER_H__
#define __CHIPMAKER_H__

#include "cfbmp.h"
#include "CRes.h"
#include "LogFile.h"
#include "memory_map_buffer.h"

class ChipMaker {
public:
	//=====================================
	// RXgN^
	//=====================================
	ChipMaker();	//ftHgRXgN^
	virtual ~ChipMaker();	// fXgN^

private:
	//=====================================
	// oϐ
	//=====================================
	CDC* pDCSource;	// \[XƂȂrbg}bv摜DC
	CDC* pDCConverted;
	CDC* pDCPalet;
	CRect srcPictureRect;
	CRect cnvPictureRect;
	CRect palPictureRect;
	Cfbmp srcBitmap;
	Cfbmp cnvBitmap;
	Cfbmp palBitmap;
	int convertedChipCount;	// ϊς̃`bv
	BG_DEF_UNIT* bg_map;
	CMap<int,int,int,int> stepCodesMap;	// BGR[hԍɑΉ鑫R[h
	CArray<int> stepCodesArrays[256];	// R[hɑΉBGR[h̃Xg

public:
	//=====================================
	// \bh
	//=====================================
	// E
	CRes Initialize(CDC* pDCSource,CRect& rSrcPictureRect, CDC* pDCConverted, CRect& rCnvPictureRect, CDC* pDCPalet, CRect& rPalPictureRect);	// 
	CRes InitializeConverted();
	CRes Release();						// 
	// ǂݍ
	CRes LoadSrcBitmap(const char* filename);	// rbg}bv摜ǂݍ
	CRes LoadPresetBitmap(const char* filename);	// vZbgp^[̃rbg}bv摜ǂݍ
	CRes ReadStepCSV(const char* filename, CLogFile* pLogFile);
	// `
	CRes DoDraw();						// `悷
	// ϊ
	CRes Convert(int offset, bool presetExists, CMap<int, int, int, int>* pPalErrorMap, BOOL checkPaletBlock, CLogFile* pLogFile);	// ϊ
	BG_DEF_UNIT ConvertChip(int x, int y, CMap<int, int, int, int>* pPalErrorMap, BOOL checkPaletBlock, CLogFile* pLog);	// `bvϊ
	BG_DEF_UNIT CompareChip(int sx, int sy, int targetBGCode, BOOL checkPaletBlock, CLogFile* pLog);
	// ۑ
	CRes SaveFiles(CString bmpFilePath, CString mdtFilePath, CString pworldFilePath, CString csvFilPath, CLogFile* pLogFile);	// ϊʂۑ
	CRes CreateBGMapImage(CDC* pDC, const char* filename, CMap<int, int, int, int>* pPalErrorMap, CLogFile* pLogFile);
	CRes DrawChipCodeNumber(int px, int py, int meshSizeX, int meshSizeY, Cfbmp* pBmp, RGBQUAD colNormal, RGBQUAD colFirst, CMap<int,int,int,int>* pMap);
	CRes DrawNumber(Cfbmp* pBmp, int x, int y, int number, RGBQUAD& quad);
	CRes CreateSPDefImage(CDC* pDC, const char* filename, CLogFile* pLogFile);
	CRes DrawDefCodeNumber(int code, int px, int py, int meshSizeX, int meshSizeY, Cfbmp* pBmp, RGBQUAD col);
	//
	// e擾
	CString GetSrcBitmapInfo();
	bool IsSrcBitmapReady();
	CString GetCnvBitmapInfo();
};

#endif
