﻿
// BMPtoBGMAPDlg.h : ヘッダー ファイル
//

#pragma once
#include "ChipMaker.h"

// CBMPtoBGMAPDlg ダイアログ
class CBMPtoBGMAPDlg : public CDialogEx
{
// コンストラクション
public:
	CBMPtoBGMAPDlg(CWnd* pParent = nullptr);	// 標準コンストラクター

// ダイアログ データ
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_BMPTOBGMAP_DIALOG };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV サポート


// 実装
protected:
	HICON m_hIcon;

	// 生成された、メッセージ割り当て関数
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

	// メンバ変数
	ChipMaker objChipMaker;
	CDC* pDCSource;	// ソースとなる画像のDC
	CDC* pDCConverted;	// 変換後画像のDC
	CDC* pDCPalet;	// パレット表示のDC

	// メソッド
	bool InitializeApp();
	int GetOffsetValue();
public:
	CStatic bmpSource;
	CStatic bmpConverted;
	CString m_srcBmpPath;
	afx_msg void OnClose();
	afx_msg void OnBnClickedButtonRefsrc();
	afx_msg void OnBnClickedButtonLoadsrc();
	afx_msg void OnBnClickedButtonConvert();
	afx_msg void OnBnClickedButtonRefout();
	CStatic bmpPalet;
	CString m_outDir;
	CString m_strOutName;
	CString m_strSrcBmpInfo;
	CString m_strCnvInfo;
	CString m_strStepCSV;
	CString m_presetBmpPath;
	CString m_patternOffset;
	afx_msg void OnBnClickedButtonRefstepcsv();
	afx_msg void OnBnClickedButtonRefbmp();
	// ソースBMPのパスからデフォルト値を設定するときにtrue
	BOOL m_bCheckDefPath;
	afx_msg void OnBnClickedButtonAutoset();
	afx_msg void OnBnClickedButtonExplorer();
	afx_msg void OnBnClickedButtonReflog();
	afx_msg void OnBnClickedButtonRefpresetbmp();
	BOOL m_comparePaletBlock;
};
