/*
 *	<< zmsc_i.h >> for Z-MUSIC SYSTEM ver.2.0/GNU C Compiler/libc
 *	Copyright 1994,95 A.Takahashi
 */

#ifndef	__ZMSCLIB_H
#define	__ZMSCLIB_H

#ifdef	FORWORD
#define	__PROTO_TYPE
#endif

#ifdef	__STDC__
#define	__PROTO_TYPE
#endif

#define	asm	__asm
#define	inline	__inline
#define	typeof	__typeof

const	extern	int	ZMSC_TIMER;
const	extern	void	*ZMSC_PTR;

typedef	struct	_trap3_reg {
/*	f[^WX^ */
	int	d0;
	int	d1;
	int	d2;
	int	d3;
	int	d4;
	int	d5;
	int	d6;
	int	d7;
/* AhXWX^ */
	int	a0;
	int	a1;
	int	a2;
	int	a3;
	int	a4;
	int	a5;
} TRAP3_REG;

#define	ZMSC_BUF_SIZE	76
typedef	struct	_zms_buff {
	char	*trk_top;
	int	trk_buf_size;
	char	*trk_buf_end;	/* ==dev_end_ptr */
	char	*adpcm_buffer_top;
	int	adpcm_buffer_size;
	char	*adpcm_buffer_end;
	char	*adpcm_work_top;
	int	adpcm_work_size;
	char	*adpcm_work_end;
	char	*adpcm_buffer_next;
	char	*adpcm_work_now;
	int	adpcm_work_true_size;
	char	*seq_wk_tbl;
	char	*seq_wk_tbl2;
	char	*adpcm_tbl;
	char	*wave_tbl;
	char	*neiro;
	char	*trk_po_tbl;
	int	*trk_len_tbl;
} ZBUFF;
#define	dev_end_ptr	trk_buf_end

#define	ZMSC_STAT_SIZE	99
typedef	struct	_zms_stat {
	char	midi_ch;
	char	midi_mode;
	char	f_midi;
	char	pcm8_on;
	short	pcm8_mode;
	char	ex_process;
	char	wait_p;
	char	lastfile[91];
} ZSTAT;

#define	ZMSC_ERR_COUNT	12
typedef	struct	_zms_error {
	int	syscount;
	char	z_errno[8];
} ZERROR;

#define	ZMSC_WORK_SIZE	256
typedef	struct	_play_work {
	short	p_on_count;
	short	p_gate_time;
	void	*p_data_pointer;
	char	p_fo_spd;
	char	p_ch;
	char	p_not_empty;
	char	p_amod_step;
	struct	{
		void	*p_wvpm_loop;
		short	p_wvpm_lpmd;
		char	p_altp_flg;
		char	rsv1[9];
	} p_mstep_tbl;
	char	p_fo_mode;
	char	p_pgm;
	char	p_pan;
	char	p_vol;
	struct	{
		void	*p_wvpm_point;
		void	*p_wvpm_end;
	} p_mrvs_tbl;
	struct	{
		char	p_om;
		char	p_sync;
	} p_sp_tie;
	char	p_af;
	char	p_se_mode;
	short	p_pmod_tbl[8];
	int	p_total;
	char	p_fo_lvl;
	char	p_note[8];
	char	p_extra_ch;
	char	aftc_n;
	short	p_bend_rng_f;
	short	p_bend_rng_m;
	short	p_detune_f;
	short	p_detune_m;
	short	p_port_dly;
	short	p_bend_dly;
	char	p_port_work;
	char	p_port_rvs;
	short	p_port_work2;
	char	p_amod_tbl[8];	/* ==p_arcc_tbl[8]; */
	struct	{
		void	*p_wvam_point;
		void	*p_wvam_end;
	} p_arvs_tbl;
	short	p_pmod_work4;
	short	p_port_flg;
	short	p_bend_flg;
	char	p_aftc_tbl[8];
	short	p_aftc_dly;
	short	p_aftc_work;
	struct	{
		void	*p_wvam_loop;
		short	p_wvam_lpmd;
		char	p_alta_flg;
		char	rsv2;
	} p_astep_tbl;
	short	p_pmod_step2;
	short	p_pmod_work;
	short	p_pmod_work2;
	char	p_pmod_work3;
	char	p_pmod_n;
	char	p_sync_wk;
	char	p_rpt_last;
	char	p_pb_range;
	char	p_arcc;
	short	p_pmod_flg;
	char	p_pmod_sw;
	char	p_amod_sw;	/* ==p_arcc_sw */
	char	p_bend_sw;
	char	p_aftc_flg;
	char	p_md_flg;
	char	p_waon_flg;
	short	p_pmod_dly;
	short	p_amod_dly;	/* ==p_arcc_dly */
	short	p_port_step;
	char	p_bank_msb;	/* ==p_ol1 */
	char	p_bank_lsb;	/* ==p_ol2 */
	char	p_effect1;	/* ==p_ol3 */
	char	p_effect3;	/* ==p_ol4 */
	char	p_d6_last;	/* ==p_cf */
	char	p_amod_step2;
	char	p_vset_flg;
	char	p_arcc_rst;
	char	p_arcc_def;
	void	*p_coda_ptr;
	void	*p_pointer;
	void	*p_do_loop_ptr;
	short	p_pmod_work5;
	short	p_pmod_work6;
	char	p_amod_flg;	/* ==p_arcc_flg */
	char	p_aftc_sw;
	char	p_dumper;
	char	p_tie_flg;
	short	p_pmod_dpt;
	char	p_seq_flag;
	char	p_do_loop_flag;
	short	p_pmod_spd;
	short	p_amod_spd;
	int	p_total_olp;
	short	p_pmod_step;
	char	p_tie_pmod;
	char	p_tie_bend;
	char	p_tie_amod;	/* ==p_tie_arcc */
	char	p_tie_aftc;
	char	p_pan2;
	char	p_non_off;
	char	p_frq;
	char	p_velo;
	short	p_amod_work4;
	char	p_pmod_rvs;
	char	p_waon_dly;
	char	p_waon_work;
	char	p_waon_num;	/* ==p_note_last */
	char	p_rpt_cnt[8];
	char	p_maker;
	char	p_device;
	char	p_module;
	char	p_last_aft;
	short	p_amod_work;	/* ==p_arcc_work */
	char	p_amod_work2;	/* ==p_arcc_work2 */
	char	p_amod_work3;
	char	p_amod_work7;
	char	p_amod_n;	/* ==p_arcc_n */
	short	p_arcc_work5;	/* ==p_amod_work5 */
	short	p_arcc_work6;	/* ==p_amod_work6 */
	char	p_pmod_wf;
	char	p_amod_dpt;
	char	p_amod_wf;
	char	p_dpm_n;
	char	p_pmod_omt;
	char	p_amod_omt;	/* ==p_arcc_omt */
	char	p_pmod_mode;
	char	p_arcc_mode;
	char	p_pmod_chain;
	char	p_amod_chain;
	char	p_jump_flg;
	char	p_waon_mark;
	short	p_marker;
	char	p_amod_rvs;
	char	p_ne_buff;	/* ==p_user */
} ZPWORK;

/*
 *	҂̓ƒfiƓsjɂCunion ł͐錾܂(^^;
 */
#define	p_arcc_tbl	p_amod_tbl
#define	p_arcc_sw	p_amod_sw
#define	p_arcc_dly	p_amod_dly
#define	p_ol1	p_bank_msb
#define	p_ol2	p_bank_lsb
#define	p_ol3	p_effect1
#define	p_ol4	p_effect3
#define	p_cf	p_d6_last
#define	p_arcc_flg	p_amod_flg
#define	p_tie_arcc	p_tie_amod
#define	p_note_last	p_waon_num
#define	p_arcc_work	p_amod_work
#define	p_arcc_work2	p_amod_work2
#define	p_arcc_n	p_amod_n
#define	p_amod_work5	p_arcc_work5
#define	p_amod_work6	p_arcc_work6
#define	p_arcc_omt	p_amod_omt
#define	p_user	p_ne_buff

/*
 * OύXꂽ́F
 *
 *	$8f:p_rpt_last?  p_rpt_last
 *	$90:p_@b_range   p_pb_range
 */


#ifdef	__PROTO_TYPE

/*
 *	CuɈˑ֐
 */

int	zmsc_keep_chk( void );
int	zmsc_type_chk( void );
//int	adpcm_read( void *,int,int,int,int,int,int);
int	release_support();
/*
 * entry   : int	release_support( int * );
 * release : int	release_support( 0,int );
 */

/*
 *	CCWJ֐
 */

static	inline	void	TRAP3( TRAP3_REG *par0 ){

	register long	res0	asm("d0");

	asm volatile (
		"* ZMUSIC TRAP3( TRAP3_REG * )\n"
		"	movem.l	d0-d7/a0-a6,-(sp)\n"
		"	movea.l	%1,a6\n"
		"	movem.l	(a6)+,d0-d7/a0-a5\n"
		"	trap	#$03\n"
		"	movem.l	d0-d7/a0-a5,-(a6)\n"
		"	movem.l	(sp)+,d0-d7/a0-a6\n"
		:	"=d"	(res0)
		:	"g"	(par0)
		:	"a6"
	);
}

static	inline	void	m_init( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x00;

	asm volatile (
		"* ZMUSIC $00 m_init( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	int	m_alloc( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x01;

	asm volatile (
		"* ZMUSIC $01 m_alloc( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_assign( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x02;

	asm volatile (
		"* ZMUSIC $02 m_assign( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_vget( char par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x03;

	asm volatile (
		"* ZMUSIC $03 m_vget( char,char * )\n"
		"	move.b	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	int	m_vset( char par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x04;

	asm volatile (
		"* ZMUSIC $04 m_vset( char,char * )\n"
		"	move.b	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	int	m_tempo( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x05;
	register void	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $05 m_tempo( int )\n"
		"	move.l	%3,d2\n"
		"	trap	#$03\n"
		"	move.l	%1,_ZMSC_TIMER\n"
		"	.bss\n"
		"	.comm	_ZMSC_TIMER,4\n"
		"	.text\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_trk( char par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x06;

	asm volatile (
		"* ZMUSIC $06 m_trk( char,char * )\n"
		"	move.b	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	int	m_free( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x07;

	asm volatile (
		"* ZMUSIC $07 m_free( char )\n"
		"	move.b	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_play( int par0,int par1,short par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x08;

	asm volatile (
		"* ZMUSIC $08 m_play( int,int,short )\n"
		"	movem.l	d3-d4,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	move.w	%4,d4\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3-d4\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_stat( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x09;

	asm volatile (
		"* ZMUSIC $09 m_stat( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_stop( int par0,int par1,short par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x0a;

	asm volatile (
		"* ZMUSIC $0a m_stop( int,int,short )\n"
		"	movem.l	d3-d4,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	move.w	%4,d4\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3-d4\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_cont( int par0,int par1,short par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x0b;

	asm volatile (
		"* ZMUSIC $0b m_cont( int,int,short )\n"
		"	movem.l	d3-d4,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	move.w	%4,d4\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3-d4\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	char	*m_atoi( char par0 ){

	register char	*res0	asm("d0");
	register long	call	asm("d1")=0x0c;

	asm volatile (
		"* ZMUSIC $0c m_atoi( char )\n"
		"	move.b	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	void	init_all( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x0d;

	asm volatile (
		"* ZMUSIC $0d init_all( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	void	int_stop( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x0e;

	asm volatile (
		"* ZMUSIC $0e int_stop( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	void	m_play2( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x0f;

	asm volatile (
		"* ZMUSIC $0f m_play2( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	int	adpcm_read( void *par0,int par1,int par2,int par3,int par4,int par5,int par6){

	register long	res0	asm("d0");

	asm volatile (
		"* ZMUSIC $10 adpcm_read( void *,int,int,int,int,int,int)\n"
		"	movem.l	d3-d7,-(sp)\n"
		"	movea.l	%1,a1\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	move.l	%4,d4\n"
		"	move.l	%5,d5\n"
		"	move.l	%6,d6\n"
		"	move.l	%7,d7\n"
		"	moveq.l	#$10,d1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3-d7\n"
		:	"=d"	(res0)
		:	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		,	"g"	(par3)
		,	"g"	(par4)
		,	"g"	(par5)
		,	"g"	(par6)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	int	play_cnv_data( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x11;

	asm volatile (
		"* ZMUSIC $11 play_cnv_data( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	void	se_play( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x12;

	asm volatile (
		"* ZMUSIC $12 se_play( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
}

static	inline	void	se_adpcm1( char *par0,int par1,int par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x13;

	asm volatile (
		"* ZMUSIC $13 se_adpcm1( char *,int,int )\n"
		"	movem.l	d3,-(sp)\n"
		"	movea.l	%2,a1\n"
		"	move.l	%3,d2\n"
		"	move.l	%4,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","a1","d2"
	);
}

static	inline	void	se_adpcm2( int par0,int par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x14;

	asm volatile (
		"* ZMUSIC $14 se_adpcm2( int,int )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2"
	);
}

static	inline	void	set_ch_mode( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x15;

	asm volatile (
		"* ZMUSIC $15 set_ch_mode( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	midi_rec( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x16;

	asm volatile (
		"* ZMUSIC $16 midi_rec( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	int	midi_rec_end( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x17;
	register void	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $17 midi_rec_end( int )\n"
		"	move.l	%3,d2\n"
		"	trap	#$03\n"
		"	move.l	%1,_ZMSC_PTR\n"
		"	.bss\n"
		"	.comm	_ZMSC_PTR,4\n"
		"	.text\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	midi_trns( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x18;

	asm volatile (
		"* ZMUSIC $18 midi_trns( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	int	calc_total( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x19;

	asm volatile (
		"* ZMUSIC $19 calc_total( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	fade_out( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1a;

	asm volatile (
		"* ZMUSIC $1a fade_out( int );\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	int	m_vset2( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1b;

	asm volatile (
		"* ZMUSIC $1b m_vset( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
	return ( res0 );
}

static	inline	void	send_rd_exc( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1c;

	asm volatile (
		"* ZMUSIC $1c send_rd_exc( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	send_exc( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1d;

	asm volatile (
		"* ZMUSIC $1d send_exc( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_p_rsv( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1e;

	asm volatile (
		"* ZMUSIC $1e sc55_p_rsv( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_reverb( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x1f;

	asm volatile (
		"* ZMUSIC $1f sc55_reverb( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_chorus( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x20;

	asm volatile (
		"* ZMUSIC $20 sc55_chorus( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_part_parameter( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x21;

	asm volatile (
		"* ZMUSIC $21 sc55_part_parameter( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_drum_parameter( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x22;

	asm volatile (
		"* ZMUSIC $22 sc55_drum_parameter( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_print( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x23;

	asm volatile (
		"* ZMUSIC $23 sc55_print( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	sc55_display( char par0,int *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x24;

	asm volatile (
		"* ZMUSIC $24 sc55_display( char,int * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.b	%2,d3\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","a1"
	);
}

static	inline	void	mt32_p_rsv( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x25;

	asm volatile (
		"* ZMUSIC $25 mt32_p_rsv( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_reverb( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x26;

	asm volatile (
		"* ZMUSIC $26 mt32_reverb( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_setup( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x27;

	asm volatile (
		"* ZMUSIC $27 mt32_p_rsv( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_drum( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x28;

	asm volatile (
		"* ZMUSIC $28 mt32_drum( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_common( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x29;

	asm volatile (
		"* ZMUSIC $29 mt32_common( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_partial( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2a;

	asm volatile (
		"* ZMUSIC $2a mt32_partial( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_patch( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2b;

	asm volatile (
		"* ZMUSIC $2b mt32_patch( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	mt32_print( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2c;

	asm volatile (
		"* ZMUSIC $2c mt32_print( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_setup( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2d;

	asm volatile (
		"* ZMUSIC $2d u220_setup( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_common( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2e;

	asm volatile (
		"* ZMUSIC $2e( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_d_setup( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x2f;

	asm volatile (
		"* ZMUSIC $2f u220_setup( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_p_setup( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x30;

	asm volatile (
		"* ZMUSIC $30 u220_p_setup( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_print( int par0,char par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x31;

	asm volatile (
		"* ZMUSIC $31 u220_print( int,char,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_timbre( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x32;

	asm volatile (
		"* ZMUSIC $32 u220_timbre( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	u220_drum( int par0,int par1,char *par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x33;

	asm volatile (
		"* ZMUSIC $33 u220_drum( int,int,char * )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.l	%3,d3\n"
		"	movea.l	%4,a1\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","d2","a1"
	);
}

static	inline	void	m1_midi_ch( char *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x34;

	asm volatile (
		"* ZMUSIC $34 m1_midi_ch( char * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
}

static	inline	void	send_to_m1( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x35;

	asm volatile (
		"* ZMUSIC $35 send_to_m1( char )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.b	%1,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1"
	);
}

static	inline	void	m1_p_setup( char *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x36;

	asm volatile (
		"* ZMUSIC $36 m1_p_setup( char * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
}

static	inline	void	m1_e_setup( char *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x37;

	asm volatile (
		"* ZMUSIC $37 m1_e_setup( char * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
}

static	inline	void	m1_print( int par0,char *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x38;

	asm volatile (
		"* ZMUSIC $38 m1_print( int,char * )\n"
		"	move.l	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	moveq.l	#$38,%1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
}

static	inline	int	block_adpcm_data( char *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x39;

	asm volatile (
		"* ZMUSIC $39 block_adpcm_data( char * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
	return ( res0 );
}

static	inline	char	*get_trk_tbl( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3a;
	register char	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $3a get_trk_tbl( void )\n"
		"	trap	#$03\n"
		"	move.l	%0,_ZMSC_PTR\n"
		"	.bss\n"
		"	.comm	_ZMSC_PTR,4\n"
		"	.text\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		:	"d1"
	);
	return ( res1 );
}

static	inline	void	set_loop_time( char par0,void *par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3b;

	asm volatile (
		"* ZMUSIC $3b set_loop_time( char,void * )\n"
		"	move.b	%2,d2\n"
		"	movea.l	%3,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2","a1"
	);
}

static	inline	ZPWORK	*get_play_work( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3c;
	register ZPWORK	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $3c get_play_work( char )\n"
		"	move.b	%3,d2\n"
		"	trap	#$03\n"
		"	move.l	%0,_ZMSC_PTR\n"
		"	.bss\n"
		"	.comm	_ZMSC_PTR,4\n"
		"	.text\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res1 );
}

static	inline	int	get_timer_mode( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3d;

	asm volatile (
		"* ZMUSIC $3d get_timer_mode( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
	return ( res0 );
}

static	inline	void	set_fm_master_vol( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3e;

	asm volatile (
		"* ZMUSIC $3e set_fm_master_vol( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	set_timer_value( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x3f;

	asm volatile (
		"* ZMUSIC $3f set_timer_value( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	jump_active( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x41;

	asm volatile (
		"* ZMUSIC $41 jump_active( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	set_mclk( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x42;

	asm volatile (
		"* ZMUSIC $42 set_mclk( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	int	picture_sync( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x43;

	asm volatile (
		"* ZMUSIC $43 picture_sync( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	void	mask_channels( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x44;

	asm volatile (
		"* ZMUSIC $44 mask_channels( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	ZBUFF	*buffer_info( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x45;
	register ZBUFF	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $45 buffer_info( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		:	"d1"
	);
	return ( res1 );
}

static	inline	void	set_zpd_tbl( int *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x46;

	asm volatile (
		"* ZMUSIC $46 set_zpd_tbl( int * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
}

static	inline	void	set_output_level( int par0,char par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x47;

	asm volatile (
		"* ZMUSIC $47 set_output_level( int,char )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2"
	);
}

static	inline	void	eox_wait( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x48;

	asm volatile (
		"* ZMUSIC $48 eox_wait( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	set_wave_form1( int *par0,int par1,int par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x49;

	asm volatile (
		"* ZMUSIC $49 set_wave_form1( int *,int,int )\n"
		"	movem.l	d3,-(sp)\n"
		"	movea.l	%2,a1\n"
		"	move.l	%3,d2\n"
		"	move.l	%4,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","a1","d2"
	);
}

static	inline	int	set_wave_form2( int *par0,int par1,int par2 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4a;

	asm volatile (
		"* ZMUSIC $4a set_wave_form2( int *,int,int )\n"
		"	movem.l	d3,-(sp)\n"
		"	movea.l	%2,a1\n"
		"	move.l	%3,d2\n"
		"	move.l	%4,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		,	"g"	(par2)
		:	"d1","a1","d2"
	);
	return ( res0 );
}

static	inline	void	mask_tracks( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4b;

	asm volatile (
		"* ZMUSIC $4b mask_tracks( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	set_output_level2( int par0,char par1 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4c;

	asm volatile (
		"* ZMUSIC $4c set_output_level2( int,char )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.l	%2,d2\n"
		"	move.b	%3,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		,	"g"	(par1)
		:	"d1","d2"
	);
}

static	inline	int	get_loop_time( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4d;

	asm volatile (
		"* ZMUSIC $4d get_loop_time( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
	return ( res0 );
}

static	inline	char	*get_1st_comment( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4e;
	register char	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $4e get_1st_comment( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		:	"d1"
	);
	return ( res1 );
}

static	inline	void	int_start( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x4f;

	asm volatile (
		"* ZMUSIC $4f int_start( void )\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		:	"d1"
	);
}

static	inline	ZSTAT	*zm_status( void ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x50;
	register ZSTAT	*res1	asm("a0");

	asm volatile (
		"* ZMUSIC $50 zm_status( void )\n"
		"	trap	#$03\n"
		"	move.l	%1,%0\n"
		"	lea.l	-12(a0),a0\n"
		"	move.l	%1,_ZMSC_PTR\n"
		"	.bss\n"
		"	.comm	_ZMSC_PTR,4\n"
		"	.text\n"
		:	"=d"	(res0)
		,	"=a"	(res1)
		:	"ri"	(call)
		:	"d1"
	);
	return ( (ZSTAT *)res0 );
}

static	inline	void	sc55_init( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x51;

	asm volatile (
		"* ZMUSIC $51 sc55_init( char )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.b	%2,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1"
	);
}

static	inline	void	mt32_init( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x52;

	asm volatile (
		"* ZMUSIC $52 mt32_init( char )\n"
		"	movem.l	d3,-(sp)\n"
		"	move.b	%2,d3\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,d3\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1"
	);
}

static	inline	void	intercept_play( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x54;

	asm volatile (
		"* ZMUSIC $54 intercept_play( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	int	m_inp1( int par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x55;

	asm volatile (
		"* ZMUSIC $55 m_inp1( int )\n"
		"	move.l	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
	return ( res0 );
}

static	inline	void	m_out1( char par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x56;

	asm volatile (
		"* ZMUSIC $56 m_out1( char )\n"
		"	move.b	%2,d2\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","d2"
	);
}

static	inline	void	occupied_size( int *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x57;

	asm volatile (
		"* ZMUSIC $57 occupied_size( int * )\n"
		"	movea.l	%2,a1\n"
		"	trap	#$03\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a1"
	);
}

static	inline	void	call_int_play_ope( ZPWORK *par0 ){

	register long	res0	asm("d0");
	register long	call	asm("d1")=0x58;

	asm volatile (
		"* ZMUSIC $58 call_int_play_ope( ZPWORK * )\n"
		"	movem.l	a5,-(sp)\n"
		"	movea.l	%2,a5\n"
		"	trap	#$03\n"
		"	movem.l	(sp)+,a5\n"
		:	"=d"	(res0)
		:	"ri"	(call)
		,	"g"	(par0)
		:	"d1","a5"
	);
}

#undef	__PROTO_TYPE
#else

int	zmsc_keep_chk();
int	zmsc_type_chk();
void	TRAP3();
void	m_init();
int	m_alloc();
int	m_assign();
int	m_vget();
int	m_vset();
int	m_tempo();
int	m_trk();
int	m_free();
int	m_play();
int	m_stat();
int	m_stop();
int	m_cont();
char	*m_atoi();
void	init_all();
void	int_stop();
void	m_play2();
int	adpcm_read();
int	play_cnv_data();
void	se_play();
void	se_adpcm1();
void	se_adpcm2();
void	set_ch_mode();
void	midi_rec();
int	midi_rec_end();
int	midi_trns();
int	calc_total();
int	fade_out();
int	m_vset2();
void	send_rd_exc();
void	send_exc();
void	sc55_p_rsv();
void	sc55_reverb();
void	sc55_chorus();
void	sc55_part_parameter();
void	sc55_drum_parameter();
void	sc55_print();
void	sc55_display();
void	mt32_p_rsv();
void	mt32_reverb();
void	mt32_setup();
void	mt32_drum();
void	mt32_common();
void	mt32_partial();
void	mt32_patch();
void	mt32_print();
void	u220_setup();
void	u220_common();
void	u220_d_setup();
void	u220_p_setup();
void	u220_print();
void	u220_timbre();
void	u220_drum();
void	m1_midi_ch();
void	send_to_m1();
void	m1_p_setup();
void	m1_e_setup();
void	m1_print();
int	block_adpcm_data();
char	*get_trk_tbl();
void	set_loop_time();
ZPWORK	*get_play_work();
int	get_timer_mode();
void	set_fm_master_vol();
void	set_timer_value();
int	release_support();
void	jump_active();
void	set_mclk();
int	picture_sync();
void	mask_channels();
ZBUFF	*buffer_info();
void	set_zpd_tbl();
void	set_output_level();
void	eox_wait();
void	set_wave_form1();
int	set_wave_form2();
void	mask_tracks();
void	set_output_level2();
int	get_loop_time();
char	*get_1st_comment();
void	int_start();
ZSTAT	*zm_status();
void	sc55_init();
void	mt32_init();
void	intercept_play();
int	m_inp1();
void	m_out1();
void	occupied_size();
void	call_int_play_ope();

#endif

#endif
