/*
 *	<< zmsclib.h >> for Z-MUSIC SYSTEM ver.2.0/C-Compiler PRO-68K/GNU C Compiler/libc
 *	Copyright 1993,94,95 A.Takahashi
 */

#ifndef	__ZMSCLIB_H
#define	__ZMSCLIB_H

#ifdef	FORWORD
#define	__PROTO_TYPE
#endif

#ifdef	__STDC__
#define	__PROTO_TYPE
#endif

const	extern	int	ZMSC_TIMER;
const	extern	void	*ZMSC_PTR;

typedef	struct	_trap3_reg {
/*	f[^WX^ */
	int	d0;
	int	d1;
	int	d2;
	int	d3;
	int	d4;
	int	d5;
	int	d6;
	int	d7;
/* AhXWX^ */
	int	a0;
	int	a1;
	int	a2;
	int	a3;
	int	a4;
	int	a5;
} TRAP3_REG;

#define	ZMSC_BUF_SIZE	76
typedef	struct	_zms_buff {
	char	*trk_top;
	int	trk_buf_size;
	char	*trk_buf_end;	/* ==dev_end_ptr */
	char	*adpcm_buffer_top;
	int	adpcm_buffer_size;
	char	*adpcm_buffer_end;
	char	*adpcm_work_top;
	int	adpcm_work_size;
	char	*adpcm_work_end;
	char	*adpcm_buffer_next;
	char	*adpcm_work_now;
	int	adpcm_work_true_size;
	char	*seq_wk_tbl;
	char	*seq_wk_tbl2;
	char	*adpcm_tbl;
	char	*wave_tbl;
	char	*neiro;
	char	*trk_po_tbl;
	int	*trk_len_tbl;
} ZBUFF;
#define	dev_end_ptr	trk_buf_end

#define	ZMSC_STAT_SIZE	99
typedef	struct	_zms_stat {
	char	midi_ch;
	char	midi_mode;
	char	f_midi;
	char	pcm8_on;
	short	pcm8_mode;
	char	ex_process;
	char	wait_p;
	char	lastfile[91];
} ZSTAT;

#define	ZMSC_ERR_COUNT	12
typedef	struct	_zms_error {
	int	syscount;
	char	z_errno[8];
} ZERROR;

#define	ZMSC_WORK_SIZE	256
typedef	struct	_play_work {
	short	p_on_count;
	short	p_gate_time;
	void	*p_data_pointer;
	char	p_fo_spd;
	char	p_ch;
	char	p_not_empty;
	char	p_amod_step;
	struct	{
		void	*p_wvpm_loop;
		short	p_wvpm_lpmd;
		char	p_altp_flg;
		char	rsv1[9];
	} p_mstep_tbl;
	char	p_fo_mode;
	char	p_pgm;
	char	p_pan;
	char	p_vol;
	struct	{
		void	*p_wvpm_point;
		void	*p_wvpm_end;
	} p_mrvs_tbl;
	struct	{
		char	p_om;
		char	p_sync;
	} p_sp_tie;
	char	p_af;
	char	p_se_mode;
	short	p_pmod_tbl[8];
	int	p_total;
	char	p_fo_lvl;
	char	p_note[8];
	char	p_extra_ch;
	char	aftc_n;
	short	p_bend_rng_f;
	short	p_bend_rng_m;
	short	p_detune_f;
	short	p_detune_m;
	short	p_port_dly;
	short	p_bend_dly;
	char	p_port_work;
	char	p_port_rvs;
	short	p_port_work2;
	char	p_amod_tbl[8];	/* ==p_arcc_tbl[8]; */
	struct	{
		void	*p_wvam_point;
		void	*p_wvam_end;
	} p_arvs_tbl;
	short	p_pmod_work4;
	short	p_port_flg;
	short	p_bend_flg;
	char	p_aftc_tbl[8];
	short	p_aftc_dly;
	short	p_aftc_work;
	struct	{
		void	*p_wvam_loop;
		short	p_wvam_lpmd;
		char	p_alta_flg;
		char	rsv2;
	} p_astep_tbl;
	short	p_pmod_step2;
	short	p_pmod_work;
	short	p_pmod_work2;
	char	p_pmod_work3;
	char	p_pmod_n;
	char	p_sync_wk;
	char	p_rpt_last;
	char	p_pb_range;
	char	p_arcc;
	short	p_pmod_flg;
	char	p_pmod_sw;
	char	p_amod_sw;	/* ==p_arcc_sw */
	char	p_bend_sw;
	char	p_aftc_flg;
	char	p_md_flg;
	char	p_waon_flg;
	short	p_pmod_dly;
	short	p_amod_dly;	/* ==p_arcc_dly */
	short	p_port_step;
	char	p_bank_msb;	/* ==p_ol1 */
	char	p_bank_lsb;	/* ==p_ol2 */
	char	p_effect1;	/* ==p_ol3 */
	char	p_effect3;	/* ==p_ol4 */
	char	p_d6_last;	/* ==p_cf */
	char	p_amod_step2;
	char	p_vset_flg;
	char	p_arcc_rst;
	char	p_arcc_def;
	void	*p_coda_ptr;
	void	*p_pointer;
	void	*p_do_loop_ptr;
	short	p_pmod_work5;
	short	p_pmod_work6;
	char	p_amod_flg;	/* ==p_arcc_flg */
	char	p_aftc_sw;
	char	p_dumper;
	char	p_tie_flg;
	short	p_pmod_dpt;
	char	p_seq_flag;
	char	p_do_loop_flag;
	short	p_pmod_spd;
	short	p_amod_spd;
	int	p_total_olp;
	short	p_pmod_step;
	char	p_tie_pmod;
	char	p_tie_bend;
	char	p_tie_amod;	/* ==p_tie_arcc */
	char	p_tie_aftc;
	char	p_pan2;
	char	p_non_off;
	char	p_frq;
	char	p_velo;
	short	p_amod_work4;
	char	p_pmod_rvs;
	char	p_waon_dly;
	char	p_waon_work;
	char	p_waon_num;	/* ==p_note_last */
	char	p_rpt_cnt[8];
	char	p_maker;
	char	p_device;
	char	p_module;
	char	p_last_aft;
	short	p_amod_work;	/* ==p_arcc_work */
	char	p_amod_work2;	/* ==p_arcc_work2 */
	char	p_amod_work3;
	char	p_amod_work7;
	char	p_amod_n;	/* ==p_arcc_n */
	short	p_arcc_work5;	/* ==p_amod_work5 */
	short	p_arcc_work6;	/* ==p_amod_work6 */
	char	p_pmod_wf;
	char	p_amod_dpt;
	char	p_amod_wf;
	char	p_dpm_n;
	char	p_pmod_omt;
	char	p_amod_omt;	/* ==p_arcc_omt */
	char	p_pmod_mode;
	char	p_arcc_mode;
	char	p_pmod_chain;
	char	p_amod_chain;
	char	p_jump_flg;
	char	p_waon_mark;
	short	p_marker;
	char	p_amod_rvs;
	char	p_ne_buff;	/* ==p_user */
} ZPWORK;

/*
 *	҂̓ƒfiƓsjɂCunion ł͐錾܂(^^;
 */
#define	p_arcc_tbl	p_amod_tbl
#define	p_arcc_sw	p_amod_sw
#define	p_arcc_dly	p_amod_dly
#define	p_ol1	p_bank_msb
#define	p_ol2	p_bank_lsb
#define	p_ol3	p_effect1
#define	p_ol4	p_effect3
#define	p_cf	p_d6_last
#define	p_arcc_flg	p_amod_flg
#define	p_tie_arcc	p_tie_amod
#define	p_note_last	p_waon_num
#define	p_arcc_work	p_amod_work
#define	p_arcc_work2	p_amod_work2
#define	p_arcc_n	p_amod_n
#define	p_amod_work5	p_arcc_work5
#define	p_amod_work6	p_arcc_work6
#define	p_arcc_omt	p_amod_omt
#define	p_user	p_ne_buff

/*
 * OύXꂽ́F
 *
 *	$8f:p_rpt_last?  p_rpt_last
 *	$90:p_@b_range   p_pb_range
 */


#ifdef	__PROTO_TYPE

int	zmsc_keep_chk( void );
int	zmsc_type_chk( void );
void	TRAP3( TRAP3_REG * );
void	m_init( void );
int	m_alloc( int );
int	m_assign( int );
int	m_vget( char,char * );
int	m_vset( char,char * );
int	m_tempo( int );
int	m_trk( char,char * );
int	m_free( char );
int	m_play( int,int,short );
int	m_stat( int );
int	m_stop( int,int,short );
int	m_cont( int,int,short );
char	*m_atoi( char );
void	init_all( void );
void	int_stop( void );
void	m_play2( void );
int	adpcm_read( void *,int,int,int,int,int,int );
int	play_cnv_data( int,char * );
void	se_play( int,char * );
void	se_adpcm1( char *,int,int );
void	se_adpcm2( int,int );
void	set_ch_mode( int );
void	midi_rec( void );
int	midi_rec_end( int );
int	midi_trns( int,char * );
int	calc_total( int );
int	fade_out( int );
int	m_vset2( int,char * );
void	send_rd_exc( int,int,char * );
void	send_exc( int,char * );
void	sc55_p_rsv( int,char,char * );
void	sc55_reverb( int,char,char * );
void	sc55_chorus( int,char,char * );
void	sc55_part_parameter( int,int,char * );
void	sc55_drum_parameter( int,int,char * );
void	sc55_print( int,char,char * );
void	sc55_display( char,int * );
void	mt32_p_rsv( int,char,char * );
void	mt32_reverb( int,char,char * );
void	mt32_setup( int,char,char * );
void	mt32_drum( int,int,char * );
void	mt32_common( int,int,char * );
void	mt32_partial( int,int,char * );
void	mt32_patch( int,int,char * );
void	mt32_print( int,char,char * );
void	u220_setup( int,char,char * );
void	u220_common( int,int,char * );
void	u220_d_setup( int,char,char * );
void	u220_p_setup( int,int,char * );
void	u220_print( int,char,char * );
void	u220_timbre( int,int,char * );
void	u220_drum( int,int,char * );
void	m1_midi_ch( char * );
void	send_to_m1( char );
void	m1_p_setup( char * );
void	m1_e_setup( char * );
void	m1_print( int,char * );
int	block_adpcm_data( char * );
char	*get_trk_tbl( void );
void	set_loop_time( char,void * );
ZPWORK	*get_play_work( char );
int	get_timer_mode( void );
void	set_fm_master_vol( int );
void	set_timer_value( int );
int	release_support();
/*
 * entry   : int	release_support( int * );
 * release : int	release_support( 0,int );
 */
void	jump_active( int );
void	set_mclk( int );
int	picture_sync( int );
void	mask_channels( int );
ZBUFF	*buffer_info( void );
void	set_zpd_tbl( int * );
void	set_output_level( int,char );
void	eox_wait( int );
void	set_wave_form1( int *,int,int );
int	set_wave_form2( int *,int,int );
void	mask_tracks( int );
void	set_output_level2( int,char );
int	get_loop_time( void );
char	*get_1st_comment( void );
void	int_start( void );
ZSTAT	*zm_status( void );
void	sc55_init( char );
void	mt32_init( char );
void	intercept_play( int );
int	m_inp1( int );
void	m_out1( char );
void	occupied_size( int * );
void	call_int_play_ope( ZPWORK * );

#undef	__PROTO_TYPE
#else

int	zmsc_keep_chk();
int	zmsc_type_chk();
void	TRAP3();
void	m_init();
int	m_alloc();
int	m_assign();
int	m_vget();
int	m_vset();
int	m_tempo();
int	m_trk();
int	m_free();
int	m_play();
int	m_stat();
int	m_stop();
int	m_cont();
char	*m_atoi();
void	init_all();
void	int_stop();
void	m_play2();
int	adpcm_read();
int	play_cnv_data();
void	se_play();
void	se_adpcm1();
void	se_adpcm2();
void	set_ch_mode();
void	midi_rec();
int	midi_rec_end();
int	midi_trns();
int	calc_total();
int	fade_out();
int	m_vset2();
void	send_rd_exc();
void	send_exc();
void	sc55_p_rsv();
void	sc55_reverb();
void	sc55_chorus();
void	sc55_part_parameter();
void	sc55_drum_parameter();
void	sc55_print();
void	sc55_display();
void	mt32_p_rsv();
void	mt32_reverb();
void	mt32_setup();
void	mt32_drum();
void	mt32_common();
void	mt32_partial();
void	mt32_patch();
void	mt32_print();
void	u220_setup();
void	u220_common();
void	u220_d_setup();
void	u220_p_setup();
void	u220_print();
void	u220_timbre();
void	u220_drum();
void	m1_midi_ch();
void	send_to_m1();
void	m1_p_setup();
void	m1_e_setup();
void	m1_print();
int	block_adpcm_data();
char	*get_trk_tbl();
void	set_loop_time();
ZPWORK	*get_play_work();
int	get_timer_mode();
void	set_fm_master_vol();
void	set_timer_value();
int	release_support();
void	jump_active();
void	set_mclk();
int	picture_sync();
void	mask_channels();
ZBUFF	*buffer_info();
void	set_zpd_tbl();
void	set_output_level();
void	eox_wait();
void	set_wave_form1();
int	set_wave_form2();
void	mask_tracks();
void	set_output_level2();
int	get_loop_time();
char	*get_1st_comment();
void	int_start();
ZSTAT	*zm_status();
void	sc55_init();
void	mt32_init();
void	intercept_play();
int	m_inp1();
void	m_out1();
void	occupied_size();
void	call_int_play_ope();

#endif

#endif
