//-------------------------------------------------------------------------
//  KonKon-BLADE CvO
//-------------------------------------------------------------------------
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "resource.h"

#include "DxLib.h"

#include "LogFile.h"
#include "Utils.h"
#include "WaitForSync.h"
#include "ScreenMode.h"

#include "GameConstants.h"
#include "dicontrol.h"
#include "DGControl.h"

#include "DShowControl.h"

#include "KonConfParser.h"
#include "Game.h"

// konkonRA
extern "C" {
#include "../../core/koncore.h"
}

//----------< vg^Cv錾 >----------
//
static	BOOL	SetDefaultScreenMode();
static	BOOL	ReleaseApp();

// -----< O[oϐ >-----
//
CLogFile	g_objDebugLog;								// fobOpO
CLogFile	g_objErrorLog;								// G[pO
DICONTROL	g_objDIControl(DICONTROL_BUFFER_UNIT);		// ̓jbg

//--------------------------------------------------------------------
//	[  ]
//		int WINAPI WinMain( HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow )
//
//	[  ]
//		iȗj
//
//	[ ߂l ]
//		iȗj
//
//	[  ]
//		WinMain ֐
//--------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	BOOL	bRes;
	int iRes;

	// -----< fobOOJn >-----
	//
	remove("kon_win.log");
	bRes = g_objDebugLog.SetFileName("kon_win.log");
	if (bRes == FALSE) {
		return FALSE;
	}
	g_objDebugLog.SetMode(LOGFILE_DEBUG);
	//	g_objDebugLog.SetMode( LOGFILE_NOTOUT );
	CUtils::SetDebugLog(&g_objDebugLog);

	// -----< G[OJn >-----
	//
	remove("kon_win_error.log");
	bRes = g_objErrorLog.SetFileName("kon_win_error.log");
	if (bRes == FALSE) {
		return FALSE;
	}
	g_objErrorLog.SetMode(LOGFILE_DEBUG);
	//	g_objErrorLog.SetMode( LOGFILE_NOTOUT );
	CUtils::SetErrorLog(&g_objErrorLog);

	//----------< ʃ[hݒ >----------
	//
	bRes = SetDefaultScreenMode();
	if (bRes == FALSE) {
		g_objErrorLog.ErrorLog("Error : ʃ[h̏ݒɎs܂B\n");
		MessageBox(NULL, "ʃ[h̏ݒɎs܂B", "Error", MB_OK);
		ReleaseApp();
		return __LINE__;
	}

	//----------< ݒ荞 >----------
	//
	CKonConfParser* pConf = CKonConfParser::GetInstance();
	pConf->Load("KonConf.cnf");

	// UEBhE[hŐݒ肷
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	pScreenMode->SetFullScreen(FALSE);
	pScreenMode->SetScreenWidth(pConf->m_iWindowModeWidth);
	pScreenMode->SetScreenHeight(pConf->m_iWindowModeHeight);
	pScreenMode->UpdateViewRect();

	// -----< p[^ >-----
	//
	// R}hC𕪉
	CGStr commandLine = lpCmdLine;
	CDStringArray paramArray;
	commandLine.Explode(" ", paramArray);
	// Č`ɍς
	int argc = paramArray.Length();
	char** argv = (char**)malloc(sizeof(char*) * argc);
	if (argv == NULL) { return -1; }
	for (int i = 0; i < argc; i++) {
		argv[i] = paramArray[i];
	}

	// R}hC
	iRes = parse_parameters(argc, argv, pConf->m_iXVIMode, pConf->m_iDefaultGameLevel);
	if (iRes == 1) {
		// o[W\ďI
		char buffer[256];
		memset(buffer, 0, sizeof(buffer));
		sprintf_s(buffer, VERSION_INFO_F, VERSION_0, VERSION_1, VERSION_2);
		MessageBox(NULL, buffer, "Version", MB_OK);
		ReleaseApp();
		return 0;
	}
	if (iRes == 2) {
		// wv\ďI
		MessageBox(NULL, get_usage_string(), "Usage", MB_OK);
		ReleaseApp();
		return 0;
	}
	if (startup_param.parse_result == 1)
	{
		char msg[256];
		sprintf_s(msg, "p[^słBerror_code=%d\n%s\n"
			, startup_param.parse_result
			, startup_param.error_message);
		MessageBox(NULL, msg, "Error", MB_OK);

		return startup_param.parse_result;
	}
	// XRAOݒ̐ݒ⑫
	if (pConf->m_iScoreLog == 1) { startup_param.record_score_log = 1; }

	//----------< EBhE̓o^ƍ쐬 >----------
	//
	// DxLibBŏ͕KEBhE[hŏ
	SetWindowText("KonKon-BLADE");
	//
	// FlipVSync҂邩ۂ̔
#ifdef NOWAIT_TO_BOSS
	SetWaitVSyncFlag(FALSE);	// Flipvsync҂Ȃ
#else
	if (pConf->m_iWaitVsync) {
		// VSync҂
		SetWaitVSyncFlag(TRUE);
	}
	else {
		// VSync҂Ȃ
		SetWaitVSyncFlag(FALSE);
	}
#endif
	ChangeWindowMode(TRUE);
	SetGraphMode(pScreenMode->GetScreenWidth(), pScreenMode->GetScreenHeight(), 32, SCREEN_FREQ);
	if (DxLib_Init() == -1)		// cwCu
	{
		return -1;			// G[N璼ɏI
	}

	//----------< Q[IuWFNg̎O >----------
	//
	CGGame* pGame = CGGame::GetInstance();
	bRes = pGame->Prepare();
	if (bRes == FALSE) {
		g_objErrorLog.ErrorLog("::WinMain : CGGameIuWFNg̎OɎs܂B\n");
		ReleaseApp();
		return __LINE__;
	}

	//----------< Q[̏ >----------
	//
	// <<< s >>>
	int result = koncore();	// Q[S
	if (result != 0) {
		MessageBox(NULL, "koncoreG[ŏI܂B", "Error", MB_OK);
		g_objErrorLog.ErrorLog("koncoreG[ŏI܂B");
	}

	// ----------< AvP[V̏I >----------
	//
	ReleaseApp();
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseApp()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̃\[Xs܂B
//		hwnd  NULL w肳ꂽꍇ́AEBhE֘Ã[X
//		ȗ܂B
//--------------------------------------------------------------------
BOOL ReleaseApp()
{
	// -----< Q[{̂ >-----
	//
	// <<< Q[{ >>>
	CGGame* pGame = CGGame::GetInstance();
	if (pGame != NULL) {
		pGame->Release();
	}

	// <<< ʃ[h >>>
	CGScreenMode::ReleaseInstance();

	// DxLib
	//
	DxLib_End();

	// -----< O͍Ō̍Ōɉ >-----
	//
	g_objDebugLog.Close();
	g_objErrorLog.Close();
	g_objDIControl.CloseFile();

	//CoUninitialize();
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefaultScreenMode()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHg̃XN[[hݒ肵܂B
//--------------------------------------------------------------------
BOOL SetDefaultScreenMode()
{
	BOOL bRes;
	CGScreenMode* pScreenMode;

	// <<< ftHgݒŏ >>>
	pScreenMode = CGScreenMode::GetInstance();
	if (pScreenMode == NULL) {
		g_objErrorLog.ErrorLog("::SetDefaultScreenMode : CGScreenMode IuWFNg擾ł܂łB");
		MessageBox(NULL, "ʃ[hݒpIuWFNg̍쐬Ɏs܂B", "Error", MB_OK);
		return __LINE__;
	}

	bRes = pScreenMode->Initialize();
	if (bRes == FALSE) {
		g_objErrorLog.ErrorLog("::SetDefaultScreenMode : CGScreenMode IuWFNg̏Ɏs܂B");
		MessageBox(NULL, "ʃ[hݒpIuWFNg̏Ɏs܂B", "Error", MB_OK);
		CGScreenMode::ReleaseInstance();
		return __LINE__;
	}

	/// <<< konkoñftHgݒ >>>
	// \ʂ̃TCY
	int screenWidth = 768;	// 256 * 3;
	int screenHeight = 512;	// 256 * 2;

	// 掞RenderTargetTexturẽTCYij
	int surfaceWidth = 256;
	int surfaceHeight = 256;

	// lݒ肷
	pScreenMode->SetFullScreen(FALSE);
	pScreenMode->SetScreenWidth(screenWidth);
	pScreenMode->SetScreenHeight(screenHeight);
	pScreenMode->SetSurfaceWidth(surfaceWidth);
	pScreenMode->SetSurfaceHeight(surfaceHeight);
	pScreenMode->UpdateViewRect();

	// <<< I >>>
	return TRUE;
}
