//====================================================
// KonConfParser
//====================================================
#ifndef __KONCONFPARSER_H__
#define __KONCONFPARSER_H__

#include "Utils.h"
#include "Str.h"
#include "DISemantics.h"


class CKonConfParser : public CUtils {
	// -----< \z >-----
	//
	private:
		CKonConfParser();								// RXgN^
		virtual ~CKonConfParser();						// fXgN^

	public:
		static CKonConfParser* GetInstance();					// CX^X擾

	protected:
		BOOL SetDefault();								// lݒ

	// -----<  >-----
	//
	public:
		static CKonConfParser m_sInstance;				// B̃CX^Xւ̃|C^

	public:
		//
		// Controller setting.
		int m_iControllerId;
		//
		int m_iTriggerA;
		int m_iTriggerB;
		int m_iTriggerPause;
		int m_iTriggerSS;
		//
		BYTE m_byteKeyBoardA;
		BYTE m_byteKeyBoardB;
		BYTE m_byteKeyBoardPause;
		BYTE m_byteKeyBoardSS;
		//
		// Screen setting.
		int m_iFullScreen;
		int m_iFullScreenMode;
		int m_iFullScreenWidth;
		int m_iFullScreenHeight;
		int m_iFullScreenDisplay;
		int m_iFullScreenVirtual;
		//
		int m_iWindowModeWidth;
		int m_iWindowModeHeight;
		//
		int m_iWaitVsync;			// Flipvsync҂ꍇ1
		int m_iFPS;				// ʂ̎g
		//
		// Sound setting.
		int m_iBGMVolume;
		int m_iSEVolume;
		//
		// MISC setting.
		int m_iXVIMode;
		int m_iBilinearFilter;
		int m_iReplayMode;			// 0:Ȃ  1:Save  2:Load
		int m_iScoreLog;			// 0:Ȃ  1:Save
		int m_iDefaultGameLevel;	// 0:EASY  1:NOVICE  2:NORMAL  3:HARD
		//
		// DISemanticsz
		DISemantics m_sTriggerConf;

	public:
		void initialize();
		void Load(const char* path);
		BOOL TakeInKeyValue(const char* key,const char* value);
		BYTE KeyCodeConvert(const CGStr& rKeyString);

	private:
		void BuildTriggerConfig();
};

#endif
