//=============================================================
// KonConfParser
//=============================================================
#include "system.h"
#include <stdio.h>
#include <stdlib.h>

#include "DGDXInclude.h"
#include "DISemantics.h"

#include "KonConfParser.h"

// -----< VOgIuWFNg̏ >-----
//
CKonConfParser CKonConfParser::m_sInstance;


//--------------------------------------------------------------------
//	[  ]
//		CKonConfParser()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CKonConfParser::CKonConfParser()
{
	initialize();
}


//--------------------------------------------------------------------
//	[  ]
//		~CKonConfParser()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CKonConfParser::~CKonConfParser()
{
	// Nothing to do.
}


//--------------------------------------------------------------------
//	[  ]
//		static CKonConfParser* GetInstance()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		CX^Xւ̃|C^
//
//	[  ]
//		CX^Xւ̃|C^擾
//--------------------------------------------------------------------
CKonConfParser* CKonConfParser::GetInstance()
{
	return &m_sInstance;
}


//--------------------------------------------------------------------
//	[  ]
//		void initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lݒ肵܂
//--------------------------------------------------------------------
void CKonConfParser::initialize()
{
	//
	// Controller setting.
	m_iControllerId = 0;
	//
	m_iTriggerA = 0;
	m_iTriggerB = 1;
	m_iTriggerPause = 9;
	m_iTriggerSS = 8;
	//
	m_byteKeyBoardA = KeyCodeConvert(CGStr("X"));
	m_byteKeyBoardB = KeyCodeConvert(CGStr("Z"));
	m_byteKeyBoardPause = KeyCodeConvert(CGStr("ESCAPE"));
	m_byteKeyBoardSS = KeyCodeConvert(CGStr("S"));
	//
	// Screen setting.
	m_iFullScreen = 0;
	m_iFullScreenMode = 0;
	m_iFullScreenWidth = 768;
	m_iFullScreenHeight = 512;
	m_iFullScreenDisplay = -1;
	m_iFullScreenVirtual = 0;
	//
	m_iWindowModeWidth = 768;
	m_iWindowModeHeight = 512;
	//
	m_iWaitVsync = 0;
	//
	// Sound setting.
	m_iBGMVolume = 127;
	m_iSEVolume = 127;
	//
	// MISC setting.
	m_iXVIMode = 0;
	m_iBilinearFilter = 0;
	m_iReplayMode = 0;
	m_iScoreLog = 0;
	m_iDefaultGameLevel = 1;	// NOVICE
	//
	// DISemantics
	for (int i = 0; i < 32; i++) {
		m_sTriggerConf.m_sTrrigerInfo[i].m_lTrrigerID = -1;
		m_sTriggerConf.m_sTrrigerInfo[i].m_iVirtualKeyCode = -1;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void Load(const char* path)
//
//	[  ]
//		char* path	t@CpX
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ݒt@Cǂݍ
//--------------------------------------------------------------------
void CKonConfParser::Load(const char* path)
{
	char buffer[256];

	// U
	initialize();

	// t@C̓e荞
	DebugLog("ݒt@C̓ǂݍ݂݂܂B[%s]\n", path);
	FILE* fn = NULL;
	errno_t eRes =fopen_s(&fn, path, "rt");
	if (eRes != 0) {
		// t@CJȂ̂ŃftHgŎs
		// sɂ̓t@Ĉ͖ŃG[ł͂Ȃ
		DebugLog("ݒt@C݂܂łBftHg̐ݒŋN܂B[%s]\n", path);
		return;
	}

	// ǂݍ݂Ȃ珈
	while (fgets(buffer, 255, fn) != NULL) {
		// g
		CGStr line = buffer;
		line.Trim();

		// s̓XLbv
		if (line.Length() == 0) {
			continue;
		}

		// 擪 # ȂXLbv
		if (line.IsHead("#")) {
			continue;
		}

		// = ̑Oŕ
		CDStringArray strArray;
		BOOL bRes = line.Explode("=", strArray);
		if (!bRes) {
			// Ɏs
			continue;
		}
		CGStr key = strArray[0];
		CGStr value = strArray[1];
		DebugLog("Key = [%s], value = [%s]", key.GetString(), value.GetString());

		// 荞݂
		bRes = TakeInKeyValue(key.GetString(), value.GetString());
		if (!bRes) {
			DebugLog(" ... ERROR\n");
			ErrorLog("[ERROR] ݒ̎荞݂Ɏs܂Bkey = [%s], value = [%s]\n", key.GetString(), value.GetString());
			continue;
		}

		// 荞
		DebugLog(" ... OK\n");
	}

	// t@C
	fclose(fn);

	// gKݒ\z
	BuildTriggerConfig();
}




//--------------------------------------------------------------------
//	[  ]
//		BYTE KeyCodeConvert( const CGStr& rKeyString )
//
//	[  ]
//		const CGStr& rKeyString
//
//	[ ߂l ]
//		zL[R[h
//		G[̏ꍇ 0
//
//	[  ]
//		zL[R[hɕϊ܂B
//--------------------------------------------------------------------
BYTE CKonConfParser::KeyCodeConvert(const CGStr& rKeyString)
{
	if (rKeyString.Length() == 1) {
		const BYTE* pString = (BYTE*)rKeyString.GetString();
		if ((*pString >= '0') && (*pString <= '9'))return *pString;
		if ((*pString >= 'A') && (*pString <= 'Z'))return *pString;
		if ((*pString >= 'a') && (*pString <= 'z'))return (*pString - 'a') + 'A';
		return 0;			// ܂ŗG[
	}

	if (rKeyString == "LBUTTON")return VK_LBUTTON;
	if (rKeyString == "RBUTTON")return VK_RBUTTON;
	if (rKeyString == "CANCEL")return VK_CANCEL;
	if (rKeyString == "MBUTTON")return VK_MBUTTON;

	if (rKeyString == "BACK")return VK_BACK;
	if (rKeyString == "TAB")return VK_TAB;

	if (rKeyString == "CLEAR")return VK_CLEAR;
	if (rKeyString == "RETURN")return VK_RETURN;

	if (rKeyString == "SHIFT")return VK_SHIFT;
	if (rKeyString == "CONTROL")return VK_CONTROL;
	if (rKeyString == "MENU")return VK_MENU;
	if (rKeyString == "PAUSE")return VK_PAUSE;
	if (rKeyString == "CAPITAL")return VK_CAPITAL;

	if (rKeyString == "KANA")return VK_KANA;
	if (rKeyString == "HANGEUL")return VK_HANGEUL;
	if (rKeyString == "HANGUL")return VK_HANGUL;
	if (rKeyString == "JUNJA")return VK_JUNJA;
	if (rKeyString == "FINAL")return VK_FINAL;
	if (rKeyString == "HANJA")return VK_HANJA;
	if (rKeyString == "KANJI")return VK_KANJI;

	if (rKeyString == "ESCAPE")return VK_ESCAPE;

	if (rKeyString == "CONVERT")return VK_CONVERT;
	if (rKeyString == "NONCONVERT")return VK_NONCONVERT;
	if (rKeyString == "ACCEPT")return VK_ACCEPT;
	if (rKeyString == "MODECHANGE")return VK_MODECHANGE;

	if (rKeyString == "SPACE")return VK_SPACE;
	if (rKeyString == "PRIOR")return VK_PRIOR;
	if (rKeyString == "NEXT")return VK_NEXT;
	if (rKeyString == "END")return VK_END;
	if (rKeyString == "HOME")return VK_HOME;
	if (rKeyString == "LEFT")return VK_LEFT;
	if (rKeyString == "UP")return VK_UP;
	if (rKeyString == "RIGHT")return VK_RIGHT;
	if (rKeyString == "DOWN")return VK_DOWN;
	if (rKeyString == "SELECT")return VK_SELECT;
	if (rKeyString == "PRINT")return VK_PRINT;
	if (rKeyString == "EXECUTE")return VK_EXECUTE;
	if (rKeyString == "SNAPSHOT")return VK_SNAPSHOT;
	if (rKeyString == "INSERT")return VK_INSERT;
	if (rKeyString == "DELETE")return VK_DELETE;
	if (rKeyString == "HELP")return VK_HELP;

	if (rKeyString == "LWIN")return VK_LWIN;
	if (rKeyString == "RWIN")return VK_RWIN;
	if (rKeyString == "APPS")return VK_APPS;

	if (rKeyString == "NUMPAD0")return VK_NUMPAD0;
	if (rKeyString == "NUMPAD1")return VK_NUMPAD1;
	if (rKeyString == "NUMPAD2")return VK_NUMPAD2;
	if (rKeyString == "NUMPAD3")return VK_NUMPAD3;
	if (rKeyString == "NUMPAD4")return VK_NUMPAD4;
	if (rKeyString == "NUMPAD5")return VK_NUMPAD5;
	if (rKeyString == "NUMPAD6")return VK_NUMPAD6;
	if (rKeyString == "NUMPAD7")return VK_NUMPAD7;
	if (rKeyString == "NUMPAD8")return VK_NUMPAD8;
	if (rKeyString == "NUMPAD9")return VK_NUMPAD9;
	if (rKeyString == "MULTIPLY")return VK_MULTIPLY;
	if (rKeyString == "ADD")return VK_ADD;
	if (rKeyString == "SEPARATOR")return VK_SEPARATOR;
	if (rKeyString == "SUBTRACT")return VK_SUBTRACT;
	if (rKeyString == "DECIMAL")return VK_DECIMAL;
	if (rKeyString == "DIVIDE")return VK_DIVIDE;
	if (rKeyString == "F1")return VK_F1;
	if (rKeyString == "F2")return VK_F2;
	if (rKeyString == "F3")return VK_F3;
	if (rKeyString == "F4")return VK_F4;
	if (rKeyString == "F5")return VK_F5;
	if (rKeyString == "F6")return VK_F6;
	if (rKeyString == "F7")return VK_F7;
	if (rKeyString == "F8")return VK_F8;
	if (rKeyString == "F9")return VK_F9;
	if (rKeyString == "F10")return VK_F10;
	if (rKeyString == "F11")return VK_F11;
	if (rKeyString == "F12")return VK_F12;
	if (rKeyString == "F13")return VK_F13;
	if (rKeyString == "F14")return VK_F14;
	if (rKeyString == "F15")return VK_F15;
	if (rKeyString == "F16")return VK_F16;
	if (rKeyString == "F17")return VK_F17;
	if (rKeyString == "F18")return VK_F18;
	if (rKeyString == "F19")return VK_F19;
	if (rKeyString == "F20")return VK_F20;
	if (rKeyString == "F21")return VK_F21;
	if (rKeyString == "F22")return VK_F22;
	if (rKeyString == "F23")return VK_F23;
	if (rKeyString == "F24")return VK_F24;

	if (rKeyString == "NUMLOCK")return VK_NUMLOCK;
	if (rKeyString == "SCROLL")return VK_SCROLL;

	if (rKeyString == "LSHIFT")return VK_LSHIFT;
	if (rKeyString == "RSHIFT")return VK_RSHIFT;
	if (rKeyString == "LCONTROL")return VK_LCONTROL;
	if (rKeyString == "RCONTROL")return VK_RCONTROL;
	if (rKeyString == "LMENU")return VK_LMENU;
	if (rKeyString == "RMENU")return VK_RMENU;

	if (rKeyString == "ATTN")return VK_ATTN;
	if (rKeyString == "CRSEL")return VK_CRSEL;
	if (rKeyString == "EXSEL")return VK_EXSEL;
	if (rKeyString == "EREOF")return VK_EREOF;
	if (rKeyString == "PLAY")return VK_PLAY;
	if (rKeyString == "ZOOM")return VK_ZOOM;
	if (rKeyString == "NONAME")return VK_NONAME;
	if (rKeyString == "PA1")return VK_PA1;
	if (rKeyString == "OEM_CLEAR")return VK_OEM_CLEAR;

	// ܂łG[
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL TakeInKeyValue(const char* key, const char* value)
//
//	[  ]
//		const char* key		L[
//		const char* value	l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ݒ̃L[ƒl荞
//--------------------------------------------------------------------
BOOL CKonConfParser::TakeInKeyValue(const char* key, const char* value)
{
	CGStr strKey = key;
	CGStr strValue = value;
	strValue.Trim();

	// Controller setting.
	if (strKey == "CONTROLLER_ID") {
		int numDevs = joyGetNumDevs();

		// Rg[ID
		m_iControllerId = atoi(value);
		// l̃NbsO
		if (m_iControllerId < 0) { m_iControllerId = 0; }
		if (m_iControllerId >= numDevs) { m_iControllerId = numDevs - 1; }
		//
		// wȂ̏ꍇ-1
		if (strlen(value) == 0) { m_iControllerId = -1; }
		// O
		DebugLog(", parsed[%d]", m_iControllerId);
	}
	else if (strKey == "TRIGGER_A") {
		m_iTriggerA = DISEM_EMPTY_TRIGGER_ID;
		if (strValue.Length() > 0) {
			m_iTriggerA = atoi(value);
		}
		// O
		DebugLog(", parsed[%d]", m_iTriggerA);
	}
	else if (strKey == "TRIGGER_B") {
		m_iTriggerB = DISEM_EMPTY_TRIGGER_ID;
		if (strValue.Length() > 0) {
			m_iTriggerB = atoi(value);
		}
		// O
		DebugLog(", parsed[%d]", m_iTriggerB);
	}
	else if (strKey == "TRIGGER_PAUSE") {
		m_iTriggerPause = DISEM_EMPTY_TRIGGER_ID;
		if (strValue.Length() > 0) {
			m_iTriggerPause = atoi(value);
		}
		// O
		DebugLog(", parsed[%d]", m_iTriggerPause);
	}
	else if (strKey == "TRIGGER_SS") {
		m_iTriggerSS = DISEM_EMPTY_TRIGGER_ID;
		if (strValue.Length() > 0) {
			m_iTriggerSS = atoi(value);
		}
		// O
		DebugLog(", parsed[%d]", m_iTriggerSS);
	}
	else if (strKey == "KEYBOARD_A") {
		m_byteKeyBoardA = KeyCodeConvert(strValue);
		if (strValue.Length() == 0) { m_byteKeyBoardA = -1; }
		// O
		DebugLog(", parsed[0x%02X]", m_byteKeyBoardA);
	}
	else if (strKey == "KEYBOARD_B") {
		m_byteKeyBoardB = KeyCodeConvert(strValue);
		if (strValue.Length() == 0) { m_byteKeyBoardB = -1; }
		// O
		DebugLog(", parsed[0x%02X]", m_byteKeyBoardB);
	}
	else if (strKey == "KEYBOARD_PAUSE") {
		m_byteKeyBoardPause = KeyCodeConvert(strValue);
		if (strValue.Length() == 0) { m_byteKeyBoardPause = -1; }
		// O
		DebugLog(", parsed[0x%02X]", m_byteKeyBoardPause);
	}
	else if (strKey == "KEYBOARD_SS") {
		m_byteKeyBoardSS = KeyCodeConvert(strValue);
		if (strValue.Length() == 0) { m_byteKeyBoardSS = -1; }
		// O
		DebugLog(", parsed[0x%02X]", m_byteKeyBoardSS);
	}
	else if (strKey == "FULLSCREEN") {
		m_iFullScreen = 0;
		if (strValue == "TRUE") {
			m_iFullScreen = 1;
		}
		// O
		DebugLog(", parsed[%d]", m_iFullScreen);
	}
	else if (strKey == "FULLSCREEN_MODE") {
		m_iFullScreenMode = atoi(value);
		// O
		DebugLog(", parsed[%d]", m_iFullScreenMode);
	}
	else if (strKey == "FULLSCREEN_WIDTH") {
		int width = atoi(value);
		if (width >= 256) {
			m_iFullScreenWidth = atoi(value);
		}
		else {
			m_iFullScreenWidth = 256;
		}
		// O
		DebugLog(", parsed[%d]", m_iFullScreenWidth);
	}
	else if (strKey == "FULLSCREEN_HEIGHT") {
		int height = atoi(value);
		if (height >= 256) {
			m_iFullScreenHeight = height;
		}
		else {
			m_iFullScreenHeight = 256;
		}
		// O
		DebugLog(", parsed[%d]", m_iFullScreenHeight);
	}
	else if (strKey == "FULLSCREEN_DISPLAY") {
		// vC}fBXvC𔻒肷
		if (strValue.Length() == 0) {
			m_iFullScreenDisplay = -1;
		}
		else if ((value[0] < '0') || (value[0] > '9')) {
			m_iFullScreenDisplay = -1;
		}
		else {
			// lݒ肷
			m_iFullScreenDisplay = atoi(value);
		}
		// O
		DebugLog(", parsed[%d]", m_iFullScreenDisplay);
	}
	else if (strKey == "FULLSCREEN_VIRTUAL") {
		m_iFullScreenVirtual = 0;
		if (strValue == "TRUE") {
			m_iFullScreenVirtual = 1;
		}
		// O
		DebugLog(", parsed[%d]", m_iFullScreenVirtual);
	}
	else if (strKey == "WINDOWMODE_WIDTH") {
		int width = atoi(value);
		if (width >= 256) {
			m_iWindowModeWidth = width;
		}
		else {
			m_iWindowModeWidth = 256;
		}
		// O
		DebugLog(", parsed[%d]", m_iWindowModeWidth);
	}
	else if (strKey == "WINDOWMODE_HEIGHT") {
		int height = atoi(value);
		if (height >= 256) {
			m_iWindowModeHeight = height;
		}
		else {
			m_iWindowModeHeight = 256;
		}
		// O
		DebugLog(", parsed[%d]", m_iWindowModeHeight);
	}
	else if (strKey == "WAIT_VSYNC") {
		if (strValue == "TRUE") {
			m_iWaitVsync = 1;
		}
		else {
			m_iWaitVsync = 0;
		}
		// O
		DebugLog(", parsed[%d]", m_iWaitVsync);
	}
	else if (strKey == "BGM_VOLUME") {
		int vol = atoi(value);
		if (vol < 0) { vol = 0; }
		if (vol > 256) { vol = 255; }
		m_iBGMVolume = vol;
		// O
		DebugLog(", parsed[%d]", m_iBGMVolume);
	}
	else if (strKey == "SE_VOLUME") {
		int vol = atoi(value);
		if (vol < 0) { vol = 0; }
		if (vol > 256) { vol = 255; }
		m_iSEVolume = vol;
		// O
		DebugLog(", parsed[%d]", m_iSEVolume);
	}
	else if (strKey == "XVI_MODE") {
		if (strValue == "TRUE") {
			m_iXVIMode = 1;
		}
		else {
			m_iXVIMode = 0;
		}
		// O
		DebugLog(", parsed[%d]", m_iXVIMode);
	}
	else if (strKey == "BILINEAR_FILTER") {
		if (strValue == "TRUE") {
			m_iBilinearFilter = 1;
		}
		else {
			m_iBilinearFilter = 0;
		}
		// O
		DebugLog(", parsed[%d]", m_iBilinearFilter);
		}
	else if (strKey == "REPLAY_MODE") {
		int mode = atoi(value);
		m_iReplayMode = mode;
		// O
		DebugLog(", parsed[%d]", m_iReplayMode);
		}
	else if (strKey == "SCORE_LOG") {
			int mode = atoi(value);
			m_iScoreLog = mode;
			// O
			DebugLog(", parsed[%d]", m_iScoreLog);
		}
	else if (strKey == "GAME_LEVEL") {
		int game_level = atoi(value);
		if (game_level < 0) { game_level = 0; }
		if (game_level > 3) { game_level = 3; }
		m_iDefaultGameLevel = game_level;
		// O
		DebugLog(", parsed[%d]", m_iDefaultGameLevel);
	}
	else {
		// m̐ݒ荀
		ErrorLog("m̐ݒ荀ڂo܂Bkey=[%s], value=[%s]\n", key, value);
		return FALSE;
	}

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void BuildTriggerConfig()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ݒ̃L[ƒl荞
//--------------------------------------------------------------------
void CKonConfParser::BuildTriggerConfig()
{
	DITrrigerInfo trgA, trgB, trgPause, trgSS;

	// A
	trgA.m_lTrrigerID = (m_iControllerId != -1 ? m_iTriggerA : 0);
	trgA.m_iVirtualKeyCode = m_byteKeyBoardA;

	// B
	trgB.m_lTrrigerID = (m_iControllerId != -1 ? m_iTriggerB : 1);
	trgB.m_iVirtualKeyCode = m_byteKeyBoardB;

	// Pause
	trgPause.m_lTrrigerID = (m_iControllerId != -1 ? m_iTriggerPause : 9);
	trgPause.m_iVirtualKeyCode = m_byteKeyBoardPause;

	// SS
	trgSS.m_lTrrigerID = (m_iControllerId != -1 ? m_iTriggerSS : 8);
	trgSS.m_iVirtualKeyCode = m_byteKeyBoardSS;

	// 荞
	m_sTriggerConf.m_sTrrigerInfo[0] = trgA;
	m_sTriggerConf.m_sTrrigerInfo[1] = trgB;
	m_sTriggerConf.m_sTrrigerInfo[2] = trgPause;
	m_sTriggerConf.m_sTrrigerInfo[3] = trgSS;
}
