//==============================================================================
//  Project
//    Game.cpp				Q[ŜǗNX
//		CVS ID : $Id: Game.cpp,v 1.2 2010/08/07 02:27:53 gtn Exp $
//==============================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tchar.h>

#include "DGDXInclude.h"
#include "DGControl.h"
#include "DShowControl.h"
#include "dicontrol.h"

#include "KonConfParser.h"
#include "Game.h"
#include "ScreenMode.h"
#include "../../devs/win/DevsContextWin.h"
#include "../../core/constants.h"

// -----< O[oϐ̓ >-----
//
extern DICONTROL g_objDIControl;

// -----< VOgIuWFNg̏ >-----
//
CGGame* CGGame::m_pInstance = NULL;

//============================
// vg^Cv錾
//============================
extern void toggle_fullscreen();

//--------------------------------------------------------------------
//	[  ]
//		CGGame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGGame::CGGame()
{
	BOOL bRes;

	// <<<  >>>
	bRes = SetDefault();
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		~CGGame()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGGame::~CGGame()
{
	BOOL bRes;

	// <<<  >>>
	bRes	= Release();
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		CGGame* GetInstance()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		B̃CX^Xւ̃|C^
//
//	[  ]
//		VOg̃IuWFNgԂ܂B
//--------------------------------------------------------------------
CGGame* CGGame::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new CGGame();
	}
	return m_pInstance;
}

//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̏lݒs܂B
//--------------------------------------------------------------------
BOOL CGGame::SetDefault()
{
	m_pDGControl	= NULL;									// `惆jbgO
	m_bIsFinished	= FALSE;								// IĂȂ

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Prepare()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNggOs܂B
//--------------------------------------------------------------------
BOOL CGGame::Prepare() {
	return TRUE;
}



//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize( hwnd )
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CGGame::Initialize()
{
	BOOL      bRes;
	CKonConfParser* pConf = CKonConfParser::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();

	// ܂
	bRes = Release();
	if (bRes == FALSE)return FALSE;

	// <<< ʂ̏ >>>
	// DGControl𓾂
	m_pDGControl = CDGControl::GetInstance();
	if (m_pDGControl == NULL) {
		DebugLog("CGGame::Initialize : DGControlIuWFNg\zł܂łB\n");
		return FALSE;
	}

	// tB^OKp
	if (pConf->m_iBilinearFilter == 0) {
		SetFullScreenScalingMode(DX_FSSCALINGMODE_NEAREST);
	}
	else {
		SetFullScreenScalingMode(DX_FSSCALINGMODE_BILINEAR);
	}

	// tXN[ݒ
	if (pConf->m_iFullScreenMode == 0) {
		// ủ݂𑜓xv
		if (pConf->m_iFullScreenVirtual == 1) {
			// ^tXN[
			SetFullScreenResolutionMode(DX_FSRESOLUTIONMODE_BORDERLESS_WINDOW);
		}
		else {
			// ݂̉𑜓xŃtXN[
			SetFullScreenResolutionMode(DX_FSRESOLUTIONMODE_DESKTOP);
		}
	}
	else {
		// 𑜓x_CNgɎw肷
		SetFullScreenResolutionMode(DX_FSRESOLUTIONMODE_NATIVE);
	}

	// UWindow[hŃXN[ݒ肷
	pScreenMode->SetFullScreen(FALSE);
	pScreenMode->SetScreenWidth(pConf->m_iWindowModeWidth);
	pScreenMode->SetScreenHeight(pConf->m_iWindowModeHeight);
	pScreenMode->UpdateViewRect();

	// ʂ
	bRes = m_pDGControl->Initialize(
		  pScreenMode->GetFullScreen()
		, pScreenMode->GetScreenWidth()
		, pScreenMode->GetScreenHeight()
		, SCREEN_FREQ
	);
	if (bRes == FALSE) {
		DebugLog("CGGame::Initialize : ʂ̏Ɏs܂B\n");
		return FALSE;
	}

	// tXN[ŋNꍇ̓gO
	if (pConf->m_iFullScreen) {
		toggle_fullscreen();
	}

	// <<< ̓jbg̏ >>>
	g_objDIControl.Initialize(pConf->m_iControllerId);	// XeBbNO
	g_objDIControl.SetKeyConfig(VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT);
	g_objDIControl.SetDISemantics(pConf->m_sTriggerConf);	// XeBbÑL[RtBOZbg

	// <<< Xg[~O >>>
	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	pDShowControl = CDShowControl::GetInstance();
	bRes = pDShowControl->Initialize();
	if (!bRes) {
		ErrorLog("CGGameCore::Initialize : DShowControl̏Ɏs܂B\n");
		return FALSE;
	}

	// <<< DevsContext >>>
	CDevsContextWin* pDevsContext = CDevsContextWin::GetInstance();
	// }X^[{[ݒ肷
	pDevsContext->m_iBGMVolume = pConf->m_iBGMVolume;
	pDevsContext->m_iSEVolume = pConf->m_iSEVolume;

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
BOOL CGGame::Release()
{
	BOOL bRes;

	// -----< DShowControl̉ >-----
	//
	CDShowControl* pDShowControl;
	pDShowControl = CDShowControl::GetInstance();
	bRes = pDShowControl->StopAllMedia();
	if (!bRes) {
		ErrorLog("CGGame::Release : DShowControlMedia~ɃG[܂B\n");
		// sĂɐi
	}
	bRes = pDShowControl->StopAllSE();
	if (!bRes) {
		ErrorLog("CGGame::Release : DShowControlSE~ɃG[܂B\n");
		// sĂɐi
	}
	bRes = pDShowControl->Release();
	if (!bRes) {
		ErrorLog("CGGame::Release : DShowControl̉ɃG[܂B\n");
		// sĂɐi
	}

	// -----< ̓foCX֘Ả >-----
	//
	g_objDIControl.Release();

	// -----< ʂ܂̉ >-----
	//
	// IuWFNg
	if( m_pDGControl!=NULL ){
		CDGControl::DeleteInstance();
	}
	m_pDGControl = NULL;

	// ItO
	m_bIsFinished	= FALSE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsFinished()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		IvĂ@FTRUE
//		IvĂȂFFALSE
//
//	[  ]
//		IvĂ邩ۂԂ܂B
//--------------------------------------------------------------------
BOOL CGGame::IsFinished()
{
	return m_bIsFinished;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CheckFinishRequest()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		vȌIvm TRUE
//		ȊO FALSE
//
//	[  ]
//		vOȊ삪Ă邩ۂ`FbN܂B
//		Q[̋Î߂Ɏgp܂B
//--------------------------------------------------------------------
BOOL CGGame::CheckFinishRequest()
{
	if( GetAsyncKeyState( VK_ESCAPE )  ){
		return TRUE;
	} else {
		return FALSE;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		BOOL TakeInInputState()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		͏荞݂܂B
//--------------------------------------------------------------------
BOOL CGGame::TakeInInputState()
{
	// ͏Ԏ荞
	g_objDIControl.GetState();			// ͏Ԃ荞

	return TRUE;
}
