#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iocslib.h>
#include <doslib.h>
#include <interrupt.h>

#include "../GTNLIB/GTNLIB.H"
#include "video.h"
#include "../address_map.h"
#include "../../../core/game_context.h"

/// @brief }bvobt@HW}bvɓ]
/// @return F0, sF0ȊO
int draw_memory_map_buffer() {
    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;

    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // XvCg̃XN[WX^]
    draw_memory_map_buffer_sp();

    // BG̃XN[WX^]
    draw_memory_map_buffer_bg();

    // GRP̃XN[WX^]
    draw_memory_map_buffer_grp();

    // TXT̃XN[WX^]
    draw_memory_map_buffer_txt();

    // PCG̓]
    draw_transfer_pcg();
}

/// @brief XvCg̃XN[WX^]
/// @return F0, sF0ȊO
void draw_memory_map_buffer_sp() {
    int sizeSpBuffer = sizeof(SP_UNIT) << 7;
    dmacpy((short*)(p_memory_map_buffer->sp_unit), SP_DATA_ADDRESS(0), sizeSpBuffer/(32/8));
}

/// @brief BG̃XN[WX^]
/// @return F0, sF0ȊO
void draw_memory_map_buffer_bg() {
    *BGSC0X = p_memory_map_buffer->bg_scroll_unit.bg0x;
    *BGSC0Y = p_memory_map_buffer->bg_scroll_unit.bg0y;
    *BGSC1X = p_memory_map_buffer->bg_scroll_unit.bg1x;
    *BGSC1Y = p_memory_map_buffer->bg_scroll_unit.bg1y;
    *BGCTRL = p_memory_map_buffer->bg_scroll_unit.ctrl.mixed;
}

/*
/// @brief }bvBG̒`f[^]
/// @param page BG̃y[Wԍ
/// @return F0, sF0ȊO
int draw_memory_map_buffer_bgdef(int page) {
    short* target;
    target = (unsigned short*)(page==0 ? BGCD0(0,0) : BGCD1(0,0));
    dmacpy( (unsigned short*)(p_memory_map_buffer->bg_def[page])
                , target
                , (sizeof(BG_DEF_UNIT)*64*64 )/4 );
}
*/

/*
/// @brief }bvBG̒`f[^]
/// @param page BG̃y[Wԍ
/// @return F0, sF0ȊO
int draw_memory_map_buffer_bgdiff(int bgmap_page, int bg_page) {
    BBOX* area_x = &(p_stage_context->bg_redraw_x);
    BBOX* area_y = &(p_stage_context->bg_redraw_y);
    int x, y;
    unsigned short* target;
    BG_DEF_UNIT* bgdef;
    int bgmap_index;
    int countx, county;

	// W
	int bgview_x, bgview_y;		// ړOr[ʒuihbgPʁj
	int n_bgview_x, n_bgview_y;	// ړr[ʒuihbgPʁj
	int dx, dy;			// XN[ʁihbgj
	bgview_x = p_stage_context->prev_bgview_x >> 8;	// Ot[ʒu
	bgview_y = p_stage_context->prev_bgview_y >> 8;
	n_bgview_x = p_stage_context->bgview_x >> 8;	// t[ʒu
	n_bgview_y = p_stage_context->bgview_y >> 8;
	dx = n_bgview_x - bgview_x;	// 
	dy = n_bgview_y - bgview_y;

    // Xړ]
    countx = 0;
    if(dx!=0) {
        for (y = area_x->y0; y <= area_x->y1; y++)
        {
            for (x = area_x->x0; x <= area_x->x1; x++)
            {
                bgmap_index = (p_stage_context->bgmap_width * y) + x;
                bgdef = &(p_stage_context->bg_map[bgmap_page][bgmap_index]);
                target = BGCDP(bg_page, (x & 63), (y & 63));
                *target = bgdef->code.mixed;
                countx++;
            }
        }
    }

    // Yړ]
    county=0;
    if(dy!=0) {
        for (y = area_y->y0; y <= area_y->y1; y++)
        {
            for (x = area_y->x0; x <= area_y->x1; x++)
            {
                bgmap_index = (p_stage_context->bgmap_width * y) + x;
                bgdef = &(p_stage_context->bg_map[bgmap_page][bgmap_index]);
                target = BGCDP(bg_page, (x & 63), (y & 63));
                *target = bgdef->code.mixed;
                county++;
            }
        }
    }

    // I
    return 0;
}
*/

void draw_memory_map_buffer_grp() {
    dmacpy( (unsigned short*)(&(p_memory_map_buffer->grp_scroll_unit)), GRP_SRC_ADDRESS, (2*4*2)/4 );
}

void draw_memory_map_buffer_txt() {
    short* p = TXT_SCR_ADDRESS;
    *p++ = p_memory_map_buffer->txt_scroll_unit.tx_x;
    *p = p_memory_map_buffer->txt_scroll_unit.tx_y;
}

/// @brief PCG̓]
/// @return 
void draw_transfer_pcg() {
    int i;

    // SP]
    for(i=0;i<p_memory_map_buffer->transsp_count;i++) {
        transfer_sp(
            p_memory_map_buffer->transsp[i].set     // ubN
            ,p_memory_map_buffer->transsp[i].offset // ]
            ,p_memory_map_buffer->transsp[i].target // ]
            ,p_memory_map_buffer->transsp[i].cnt    // ]
            );
    }
    p_memory_map_buffer->transsp_count = 0;

    // PAL]
    for(i=0;i<p_memory_map_buffer->transpal_count;i++) {
        transfer_pal(
            p_memory_map_buffer->transpal[i].set     // ubN
            ,p_memory_map_buffer->transpal[i].offset // ]
            ,p_memory_map_buffer->transpal[i].target // ]
            ,p_memory_map_buffer->transpal[i].cnt    // ]
            );
    }
    p_memory_map_buffer->transpal_count = 0;
}
