#include <stdio.h>
#include <stdlib.h>

#include <iocslib.h>
#include <doslib.h>
#include <interrupt.h>

#include "../../../core/game_context.h"
#include "../address_map.h"

// vg^Cv錾
volatile int vd_wait;
extern int vd_wait_skipped;
interrupt void vd_task();

/// @brief N1񂾂sʏ
/// @return F0, sF0ȊO
int screen_startup() {
    int i;
    SP_UNIT* pSp;

    C_CUROFF();
    VDISPST(0,0,0);
    
    // BG`̈̃̈ڑ
    game_context.memory_map_buffer.bg_def[0] = (BG_DEF_UNIT*)(BGCDP(0, 0, 0));
    game_context.memory_map_buffer.bg_def[1] = (BG_DEF_UNIT*)(BGCDP(1, 0, 0));

    // V-SYNCݒ
    VDISPST(vd_task,0,1);

    // SP
    SP_INIT();
    SP_OFF();

    // -----< ŏP̉ʏ >-----
    //
    // <<< ׂẲʕ\B >>>
	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// ʂ̃vCIeBݒ肷
	p_memory_map_buffer->vc_priority.bit.sp = 0;      // XvCg̓eLXgƃOtBbN̊
	p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
	p_memory_map_buffer->vc_priority.bit.grp = 1;     // OtBbNO
	p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
	p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
	p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
	p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

    // rfIRg[̐ݒ
    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;

    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // <<< rfI֘A\[X̓eNAčĕ\ >>>
    //
    // eLXg
    T_CLR();

    // ʃ[hݒ
    //CRTMOD(10);          // ʂ̏  14F256*256dot/z512*512/256F/HiReso
    CRTMOD(6);          // ʂ̏  6F256*256dot/z512*512/16F/HiReso
    //CRTMOD(14);          // ʂ̏  14F256*256dot/z512*512/65536F/HiReso

    // OtBbNNAĕ\ONɂ
    G_CLR_ON();

    // BGĕ\
    BGCTRLST(0,0,0);    // BG0:gȂ
    BGCTRLST(1,1,0);    // BG1:eLXgGA1ŕ\

    // XvCg̃P[V
    for(i=0;i<128;i++){
        pSp = (SP_UNIT*)( SP_DATA_ADDRESS(i) );
        pSp->x = 0;
        pSp->y = 0;
    }

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;

	// ʂ̃vCIeBݒ肷
	p_memory_map_buffer->vc_priority.bit.sp = 0;      // XvCg̓eLXgƃOtBbN̊
	p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
	p_memory_map_buffer->vc_priority.bit.grp = 1;     // OtBbNO
	p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
	p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
	p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
	p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

    // BG ON/OFF
    p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
    p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
    p_memory_map_buffer->bg_scroll_unit.ctrl.bit.disp_cpu = 1;

    // rfIRg[̐ݒ
    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;

    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // BGXN[WX^
    *(BGCTRL) = p_memory_map_buffer->bg_scroll_unit.ctrl.mixed;

    return 0;
}

/// @brief Q[Jn̉ʏ
/// @return F0, sF0ȊO
int screen_init() {
    // Nothing to do.
    return 0;
}

/// @brief ʂ̌n
/// @return F0, sF0ȊO
int screen_dispose() {
    // rfIRg[̐ݒ
    // ON/OFF̐ݒ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
    p_memory_map_buffer->vc_onoff.bit.son = 0;
    p_memory_map_buffer->vc_onoff.bit.ton = 1;
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;

    // ʂ̃vCIeBݒ肷
    p_memory_map_buffer->vc_priority.bit.sp = 1;      // XvCg̓eLXgƃOtBbN̊
    p_memory_map_buffer->vc_priority.bit.txt = 0;     // eLXg
    p_memory_map_buffer->vc_priority.bit.grp = 2;     // OtBbNO
    p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
    p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
    p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
    p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // eLXgŜ
    memset(TXT_TOP_ADDRESS, 0, 128*1024*4); // 64word * 1024line * 4planes

    // ʂ
    C_CURON();
    VDISPST(0,0,0);
    CRTMOD(16);  /*  ʂ̏  16F768*512dot/z1024*1024/16F/HiReso */
    //SP_OFF();

    // BG`̈
    game_context.memory_map_buffer.bg_def[0] = NULL;
    game_context.memory_map_buffer.bg_def[1] = NULL;

    return 0;
}

/// @brief VSYNC҂
/// @param force_wait ԂɍĂȂƂłIɑ҂ꍇ1
/// @return F0, sF0ȊO
int wait_for_vsync(int force_wait) {
    if(force_wait==1) { vd_wait = 1; }
    if(vd_wait) {
        // 1t[Ɏ܂Ăꍇ͑҂
        vd_wait_skipped = 0;
        while(vd_wait);
    } else {
        // 1t[ɊԂɍȂi荞ݏŊɃtOOFFj
        vd_wait_skipped = 1;
    }

    // ҂tO𗧂Ă
    vd_wait = 1;
	return 0;
}

/// @brief vsyncOɎs鏈
/// @return F0, sF0ȊO
int screen_pre_vsync(){
    // BG
    //draw_memory_map_buffer_bgdiff(0, 1);   // WX^ɓ]

    return 0;
}

/// @brief vsyncɎs鏈
/// @return F0, sF0ȊO
int screen_post_vsync(){
    draw_memory_map_buffer();
    return 0;
}

/// @brief A荞ݏ
/// @return Ȃ
interrupt void vd_task()
{
    // A҂̃tO낷
    vd_wait = 0;

    // 荞ݏ͕K̃}NŏI邱
    IRTE();
}
