#include <stdio.h>
#include <stdlib.h>

#include <iocslib.h>
#include <doslib.h>
#include <interrupt.h>
#include <dirent.h>

#include "../../../core/game_context.h"
#include "../../../core/shop.h"
#include "../../../core/gameover.h"
#include "../GTNLIB/KEY.H"

#include "../sound/sound.h"
#include "../resource/resource.h"
#include "../../devs.h"

/// @brief VXeŜ̏
/// @return F0, sF0ȊO
int system_startup() {
    int zmusic_check;
    int result;
    const char* res_filename;

    // -----< \[Xݒlǂݍ >-----
	//
    res_filename = (startup_param.XVI == 0 ? RES_X68 : RES_X68_XVI);
    result = parse_resource_conf(res_filename);
    if (result != 0) {
		printf("[ERROR] \[Xݒ̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
    
    // X[p[oCU[h
    p_application_context->SSP = SUPER(0);

    // Z-MUSIC풓mF
    zmusic_check = zm_sdinit();
    if(zmusic_check<0) {
        printf("Z-MUSIC풓Ă܂\n");
        return -1;
    }
 
    // TEh֘A
    sound_init();

    // I
    return 0;
}

/// @brief VXeŜ̏I
/// @return F0, sF0ȊO
int system_dispose() {
    int zmusic_check;

    // Z-MUSIC~
   zmusic_check = zm_sdinit();
    if(zmusic_check==0) {
        m_stop(0, 0, 0);
    }

    // ʉ܂Ƃ߂ĉ
    release_sound_context();

    // X[poCU[hƂɖ߂
    SUPER(p_application_context->SSP);    /* X[p[oCU[h畜A */

    // I
    return 0;
}

/// @brief vsyncOɎs鏈
/// @return F0, sF0ȊO
int system_pre_vsync() {
    int result;

    // <<< ̓foCX̏荞 >>>
    result = takein_input();
    if(result!=0) {
        return result;
    }

	// gK[Ɋւv~eBuȏԔs
	parse_trigger_state();

    // I
    return 0;
}

/// @brief V-SYNCɍsVXen̏
/// @return F0, sF-1
int system_post_vsync() {
    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		void save_all_clear_log()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		I[NÃOL^
//--------------------------------------------------------------------
void save_all_clear_log(void* pTim)
{
	char clear_log_path[_MAX_PATH];
	int dir_exists;
	const char* dir_path = "./ClearLog";
	int length;

	// -----< XN[Vbgۑ >-----
	//
	// ۑ̃pX
	dir_exists = make_continuous_filename(	//
		clear_log_path
		, dir_path
		, "CLR"
		, "log"
	);
	if (dir_exists == -1) {
		kon_log("[ERROR] save_all_clear_log : XN[Vbg̕ۑtpX𐶐ł܂łB\n");
		return;
	}

	// fBNg
	if (dir_exists == 0) {
        //kon_log("making directory [%s]\n", dir_path);
		mkdir(dir_path);
	}

	// Oۑ
	save_all_clear_log_file(clear_log_path, pTim);
}

// NOP Functions
void open_score_log()
{
    // Nothing to do.
    return;
}
void score_log(const char* pMes
	, int frame_count
	, int stage_count
	, int stage
	, int section
	, int socre
	, int point
	, int left
	, int hp
	, int mp
	, int combo_lv
	, int timelimit
	, int lv_blade
	, int lv_magic
	, int lv_charge
	, int bomb_charge
	, int time_bonus
	, int hp_bonus
) {
    // Nothing to do.
    return;
}
void close_score_log()
{
    // Nothing to do.
    return;
}

//--------------------------------------------------------------------
//	[  ]
//		int check_dir_exists(const char* dir_path)
//
//	[  ]
//		const char* dir_path    fBNgւ̃pX
//
//	[ ߂l ]
//		0:݂Ȃ
//      1:݂
//
//	[  ]
//		w̃pX̃fBNg݂邩ۂ𔻒肷
//--------------------------------------------------------------------
int check_dir_exists(const char* dir_path)
{
    DIR *dir;
    struct dirent *dp;
    int dir_exists = 0;

    // I[v݂
    dir = opendir(dir_path);
    if (dir == NULL) {
        // fBNg݂͑Ȃ
        //kon_log("fBNg݂͑ȂB[%s]\n", dir_path);
        dir_exists = 0;
    } else {
        // fBNg݂͑
        //kon_log("fBNg݂͑B[%s]\n", dir_path);
        dir_exists = 1;
        closedir(dir);
    }

    // ʂԂ
    return dir_exists;
}
