#define __SOUND_C__
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "doslib.h"
#include "iocslib.h"

#include "../GTNLIB/GTNLIB.H"
#include "../../../core/game_context.h"

#include "../../../libs/x68/ZMSCLIB.H"
#include "../../devs.h"
#include "sound.h"

//======================================
// 萔`
//======================================
/*  vg^Cv錾iGTNLIB̐؂藣֐j */
int  zm_sdinit();
void zm_zmdplay(char*);
void zm_fadeout(int);
void zm_pcmplay(char*,int,int);
int  zm_offset(char*);


//======================================
// GTNLIB̐؂藣\bh
//======================================
/*------------------------  hCȍ  ---------------------------*/
int zm_sdinit()
{
int	tst;

tst=zmsc_keep_chk();			/*  풓`FbN  */
if( tst )return(tst);			/*  풓ĂȂ烊^[  */

m_init();

return(0);
}



/*-----------------------  aflX^[g  ---------------------------*/
void zm_zmdplay(zmd)
char *zmd;
{
m_stop( 0b111111111111111 , 0 , 0 ) ;
init_all();
play_cnv_data( 0 , zmd + 7 ) ;
}


/*----------------------  afltF[h  -----------------------------*/
void zm_fadeout(speed)
int speed;
{
fade_out( speed ) ;
}


/*----------------------  `cobl rd  ---------------------------*/
void zm_pcmplay(buff,size,frq)
char *buff;
int  size;
int  frq;
{
    se_adpcm1(buff, size, (frq << 8) + 3);
}


/*----------------------  ItZbgl߂  ------------------*/
int zm_offset(zmd)
char *zmd;
{
int i=0;

while(1){
	if(*zmd==-1)break;
	zmd++;
	i+=1;
	}

zmd++;
i+=1;
if(*zmd==-1){
		zmd++;
		i+=1;
		}

return(i);

}


//======================================
// \bh
//======================================
/// @brief BGMǂݍ
/// @return F0, sF0ȊO
int load_bgm(int index, char* path) {
    int size;
    // Ô߉Ă
    release_bgm(index);

    // t@Cǂݍ
    size = fsize(path);
    zm_data.zmd[index] = (char*)malloc(size);
    zm_data.zmdsize[index] = size;
    betaread(path, zm_data.zmd[index], size);

    // I
    return 0;
}

/// @brief BGM̃f[^
/// @return F0, sF0ȊO
int release_bgm(int index) {
    // ~
    m_stop(0, 0, 0);

    // 
    if(zm_data.zmd[index]!=NULL) {
        free(zm_data.zmd[index]);
    }
    zm_data.zmd[index] = NULL;
    zm_data.zmdsize[index] = 0;

    return 0;
}

/// @brief SEǂݍ
/// @return F0, sF0ȊO
int load_se(int index, char* path) {
    int size;

    // t@Cǂݍ
    size = fsize(path);
    zm_data.pcm[index] = (char*)malloc(size);
    zm_data.pcmsize[index] = size;
    betaread(path, zm_data.pcm[index], size);

    // I
    return 0;
}

/// @brief SẼf[^
/// @return F0, sF0ȊO
int release_se(int index) {
    // ~
    m_stop(0, 0, 0);

    // 
    if (zm_data.pcm[index] != NULL)
    {
        free(zm_data.pcm[index]);
    }
    zm_data.pcm[index] = NULL;
    zm_data.pcmsize[index] = 0;

    return 0;
}

//======================================
// J\bh
//======================================
/// @brief TEh֘Ȁ
/// @return F0, sF0ȊO
int sound_init() {
    int result;

    // ReLXg
    memset(&zm_data, 0, sizeof(zm_data));

    // Z-MUSIC
    result = zm_sdinit();
    if( result!=0 ) {
        return -1;
    }

    return 0;
}

/// @brief w肳ꂽtrackԍBGMĐ
/// @param track gbNԍ
/// @return F0, sF0ȊO
int sound_play_bgm( int track ) {
    char buffer[256];

    // wȂȂ牽ɐ
    if( track==SOUND_NULL ) {
        return 0;
    }

    // Đ~
	sound_stop_bgm();

    // SILENTwȂ~߂邾
    if (track == SOUND_SILENT) {
        return 0;
    }

    // fBNgړ
//    chdir(BGM_BASE_PATH);
    memset(buffer, 0, sizeof(buffer));
    getcwd(buffer, sizeof(buffer) - 1);
    chdir(resource_conf.dir_bgm);

    // Đ
    zm_zmdplay(zm_data.zmd[ track ]);

    // fBNgɖ߂
//    chdir(BGM_RETURN_PATH);
    chdir(buffer);

    return 0;
}

/// @brief BGM~
/// @return F0, sF0ȊO
int sound_stop_bgm() {
    m_stop(0, 0, 0);

    return 0;
}

/// @brief w肳ꂽԍ̌ʉĐ
/// @param no 
/// @param frq  X68000Ŗ炷Ƃ̎gw
/// @return 
int sound_play_se( int no, int frq ) {
    int result;
    // Đ
    zm_pcmplay(zm_data.pcm[no], zm_data.pcmsize[no], frq);

    return 0;
}
