#define __RESOURCE_C__
#include <stdio.h>
#include <stdlib.h>

#include "doslib.h"
#include "iocslib.h"

#include "../GTNLIB/GTNLIB.H"
#include "../address_map.h"
#include "../../../core/game_context.h"
#include "../../../core/stage.h"

#include "../sound/sound.h"
#include "../../devs.h"
#include "resource.h"

//======================================
// vg^Cv錾
//======================================
void hide_screen(int mode);
//
int load_loading_sp();
void draw_loading_sp(int pos);
void on_finish_loading();
//
// SOUND֘A
void load_bgms(int bgm_index);
void load_se_context();
void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int index, int priority, int frames, int same_priority_wait, int frq);
void attach_se_item(SE_ITEM* pSEItem, int index, int priority, int frames, int same_priority_wait, int frq);

//======================================
// ϐ`
//======================================
// PCG]pobt@
TPCG_BUFFER tpcg_buffer;

//--------------------------------------------------------------------
//	[  ]
//		void hide_screen(int mode)
//
//	[  ]
//		int mode        ʃ[h
//
//	[ ߂l ]
//      Ȃ
//
//	[  ]
//		\[X̃[h󋵂Ȃ悤ɉʕ\ׂĉB
//--------------------------------------------------------------------
void hide_screen(int mode)
{
    int i;
    SP_UNIT* pSp;

    // <<< \B >>>
    // \ON/OFFݒ  SĂB
    p_memory_map_buffer->vc_onoff.mixed = *(VIDEO_SWITCH_ADDRESS);
    p_memory_map_buffer->vc_onoff.bit.ton = 0;
    p_memory_map_buffer->vc_onoff.bit.son = 0;
    p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
    // D揇ʐݒ  SP擪ɂ
    p_memory_map_buffer->vc_priority.mixed = *(VIDEO_PRIORITY_ADDRESS);
    p_memory_map_buffer->vc_priority.bit.sp = 0;
    p_memory_map_buffer->vc_priority.bit.grp = 1;
    p_memory_map_buffer->vc_priority.bit.txt = 2;
    p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;
    p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;
    p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;
    p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;

    // eLXgʂNA
    T_CLR();
    do_wait_vsync(1);

    // XvCg̃P[V
    for(i=0;i<128;i++){
        pSp = (SP_UNIT*)( SP_DATA_ADDRESS(i) );
        pSp->x = 0;
        pSp->y = 0;
    }

//    p_memory_map_buffer->vc_onoff.bit.son = 1;
//    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;

	// ʃ[hݒ肷
    if (p_application_context->grp_already_read == 0) {
    	CRTMOD(mode);
        G_CLR_ON();
    }
    BGCTRLST(0, 0, 0);  // BG0:gȂ
    BGCTRLST(1, 1, 0);  // BG1:gȂ

    // G_CLR_ON󂯂ĉ߂ĕ\BBSP͕\B
    p_memory_map_buffer->vc_onoff.mixed = *(VIDEO_SWITCH_ADDRESS);
    p_memory_map_buffer->vc_onoff.bit.ton = 0;
    p_memory_map_buffer->vc_onoff.bit.son = 1;
    p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
    p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    do_wait_vsync(1);
}

/// @brief [fBOSPǂݍ
int load_loading_sp()
{
    int result;

    // SPǂݍ
    result = Wbetaread("resources\\X68\\common\\LOADING.SP"
                , SP_DEF_ADDRESS(0xC0)
                , fsize("resources\\X68\\common\\LOADING.SP"));
    if(result!=0) {
        kon_log("load_loading_sp : Faile to load LOADING SP\n");
        return result;
    }

    // pbg
    result = Wbetaread("resources\\X68\\common\\LOADING.PAL"
                , SP_PAL_ADDRESS(5)
                , fsize("resources\\X68\\common\\LOADING.PAL"));
    if(result!=0) {
        kon_log("load_loading_sp : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }

    // I
    return 0;
}

/// @brief LOADING̃XvCg`悷
/// @param pos ̕\ʒuB0GOALB1邲Ƃɍɂ
void draw_loading_sp(int pos)
{
    SP_UNIT* sp;
    int done_pos_x = 256-16 -8;
    int done_pos_y = 256    -8;

	sp = p_memory_map_buffer->sp_unit;

    // GOAL`悷
    SP_SET(sp, done_pos_x     , done_pos_y, 0xC4, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, done_pos_x + 16, done_pos_y, 0xC5, 5, 0, 0, 3);
    sp++;

    // LOADING`悷
    SP_SET(sp, done_pos_x - 64-2 - (pos * 8), done_pos_y, 0xC0, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, done_pos_x - 48-2 - (pos * 8), done_pos_y, 0xC1, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, done_pos_x - 32-2 - (pos * 8), done_pos_y, 0xC2, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, done_pos_x - 16-2 - (pos * 8), done_pos_y, 0xC3, 5, 0, 0, 3);
    sp++;
    SP_SET(sp, done_pos_x - 12-2 - (pos * 8), done_pos_y, 0xC6 + (pos & 1), 7, 1, 0, 3);
    sp++;

    // `悷
    draw_memory_map_buffer();
}

/// @brief ǂݍݏȈ
void on_finish_loading()
{
    // <<< ǂݍ݊ Xe[WI[v >>>
    // OtBbNʂ̃XN[ʒu
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    // vCIeBݒύX
    p_memory_map_buffer->vc_priority.mixed = *(VIDEO_PRIORITY_ADDRESS);
    p_memory_map_buffer->vc_priority.bit.sp = 1;
    p_memory_map_buffer->vc_priority.bit.grp = 0;
    p_memory_map_buffer->vc_priority.bit.txt = 2;
    p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;
    p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;
    p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;
    p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;
    // ʂ̕\ON/OFFݒ
    p_memory_map_buffer->vc_onoff.bit.son = 1;
    p_memory_map_buffer->vc_onoff.bit.ton = 1;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    // AɓȂʂ̏ԂXV
    do_wait_vsync(1);
}

// ^Cg \[Xǂݍ
int resource_load_title()
{
    int size;
    int result;
    int loading_pos = 6;

    // ʕ\B
    p_application_context->grp_already_read = 0;
    hide_screen(10);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\title\\SPBG_TTL.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\title\\SPBG_TTL.SP"));
    if(result!=0) {
        kon_log("resource_load_title : Faile to load TITLE SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\title\\SPBG_TTL.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\title\\SPBG_TTL.PAL"));
    if(result!=0) {
        kon_log("resource_load_title : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< GRP摜 >>>
    result = load_rl256("resources\\X68\\title\\title_256.RL");
    if(result!=0) {
        kon_log("resource_load_title : OtBbN̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\title\\HELP.TRL", "resources\\X68\\title\\HELP.PAL");
    if(result!=0) {
        kon_log("resource_load_title : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // eLXg]pbgǂݍ
    result = load_transpal("resources\\X68\\title\\HELP.PAL");
    //kon_log("HELP.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_title);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();

    // <<< \ON/OFFݒ >>>
    // ON/OFF̐ݒ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
    p_memory_map_buffer->vc_onoff.bit.gs4 = 1;
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}

// GfBO \[Xǂݍ
int resource_load_ending()
{
    int size;
    int result;
    int loading_pos = 6;

    // ʕ\B
    p_application_context->grp_already_read = 0;
    hide_screen(2);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 768;
    draw_memory_map_buffer_grp();

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\ed\\SPBG_ED.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\ed\\SPBG_ED.SP"));
    if(result!=0) {
        kon_log("resource_load_ed : Faile to load ED SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\ed\\SPBG_ED.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\ed\\SPBG_ED.PAL"));
    if(result!=0) {
        kon_log("resource_load_ed : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< GRP摜 >>>
    result = load_rl16("resources\\X68\\ed\\TRANS_16.RL");
    if(result!=0) {
        kon_log("resource_load_ending : OtBbN̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\ed\\ED.TRL", "resources\\X68\\ed\\ED.PAL");
    if(result!=0) {
        kon_log("resource_load_ending : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< pbgǂݍ >>>
    result = load_transpal("resources\\X68\\ed\\ED.PAL");
    //kon_log("ED.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_ending);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();

    // <<< \ON/OFFݒ >>>
    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}

/// @brief Xe[W1̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st1() {
    int size;
    int result;
    int loading_pos = 11;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    // [fBOSP`
    draw_loading_sp(loading_pos--);

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if (result != 0) {
            kon_log("resource_load_st1 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--);

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st1\\SPBG_ST1.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st1\\SPBG_ST1.SP"));
    if(result!=0) {
        kon_log("resource_load_st1 : Faile to load ST1 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // pbg
    result = Wbetaread("resources\\X68\\st1\\SPBG_ST1.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st1\\SPBG_ST1.PAL"));
    if(result!=0) {
        kon_log("resource_load_st1 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st1\\BG_ST1.MDT"
        , "resources\\X68\\st1\\BG_ST1_PWM.pwm"
        , 0
        , def_stage_bg_size[0][0]
        , def_stage_bg_size[0][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--);

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st1\\TXT1.TRL", "resources\\X68\\st1\\TXT1.PAL");
    if(result!=0) {
        kon_log("resource_load_st1 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st1);
    draw_loading_sp(loading_pos--);

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--);

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // BGp^[
    result = load_transsp("resources\\X68\\st1\\BG_ST1_T.SP");
    //kon_log("BG_ST1_T : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // BOSS1
    result = load_transsp("resources\\X68\\st1\\BOSS1.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--);

    result = load_transpal("resources\\X68\\st1\\TXT1.PAL");
    //kon_log("TXT1.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // I
    on_finish_loading();
    return 0;
}

/// @brief Xe[W2̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st2() {
    int size;
    int result;
    VC_ONOFF vc_sw;
    int loading_pos = 11;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    draw_memory_map_buffer_grp();

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if(result!=0) {
            kon_log("resource_load_st2 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--);

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st2\\SPBG_ST2.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st2\\SPBG_ST2.SP"));
    if(result!=0) {
        kon_log("resource_load_st2 : Faile to load ST2 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // pbg
    result = Wbetaread("resources\\X68\\st2\\SPBG_ST2.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st2\\SPBG_ST2.PAL"));
    if(result!=0) {
        kon_log("resource_load_st2 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st2\\BG_ST2.MDT"
        , "resources\\X68\\st2\\BG_ST2_PWM.pwm"
        , 0
        , def_stage_bg_size[1][0]
        , def_stage_bg_size[1][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--);

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st2\\TXT2.TRL", "resources\\X68\\st2\\TXT2.PAL");
    if(result!=0) {
        kon_log("resource_load_st2 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--);

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st2);
    draw_loading_sp(loading_pos--);

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--);

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // BGp^[
    result = load_transsp("resources\\X68\\st2\\BG_ST2_T.SP");
    //kon_log("BG_ST2_T : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // BOSS2
    result = load_transsp("resources\\X68\\st2\\BOSS2.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--);

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--);

    result = load_transpal("resources\\X68\\st2\\TXT2.PAL");
    //kon_log("TXT2.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // ]
    //transfer_pal(0, 0, 4, 1);
    //transfer_sp(0, 0, 0x40, 2*3);

    // <<< \ON/OFFݒ >>>
    vc_sw.mixed = *(VIDEO_SWITCH_ADDRESS);
    vc_sw.bit.son = 1;
    vc_sw.bit.ton = 1;
    vc_sw.bit.gs3 = 1;
    vc_sw.bit.gs2 = 1;
    vc_sw.bit.gs1 = 1;
    vc_sw.bit.gs0 = 1;
    *(VIDEO_SWITCH_ADDRESS) = vc_sw.mixed;

    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}

/// @brief Xe[W3̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st3() {
    int size;
    int result;
    VC_ONOFF vc_sw;
    int loading_pos = 13;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    draw_memory_map_buffer_grp();

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if(result!=0) {
            kon_log("resource_load_st3 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st3\\SPBG_ST3.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st3\\SPBG_ST3.SP"));
    if(result!=0) {
        kon_log("resource_load_st3 : Faile to load ST3 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\st3\\SPBG_ST3.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st3\\SPBG_ST3.PAL"));
    if(result!=0) {
        kon_log("resource_load_st3 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st3\\BG_ST3.MDT"
        , "resources\\X68\\st3\\BG_ST3_PWM.pwm"
        , 0
        , def_stage_bg_size[2][0]
        , def_stage_bg_size[2][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st3\\TXT3.TRL", "resources\\X68\\st3\\TXT3.PAL");
    if(result!=0) {
        kon_log("resource_load_st3 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st3);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BGp^[
    result = load_transsp("resources\\X68\\st3\\BG_ST3_ANIM.SP");
    //kon_log("BG_ST3_ANIM : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // GL
    result = load_transsp("resources\\X68\\st3\\SPBG_EN3.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->ene_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BOSS3
    result = load_transsp("resources\\X68\\st3\\BOSS3.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st3\\BOSS3.PAL");
    //kon_log("BOSS3.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->boss_pal_stot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st3\\TXT3.PAL");
    //kon_log("TXT3.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // ]
    //transfer_pal(0, 0, 4, 1);
    //transfer_sp(0, 0, 0x40, 2*3);

    // <<< \ON/OFFݒ >>>
    vc_sw.mixed = *(VIDEO_SWITCH_ADDRESS);
    vc_sw.bit.son = 1;
    vc_sw.bit.ton = 1;
    vc_sw.bit.gs3 = 1;
    vc_sw.bit.gs2 = 1;
    vc_sw.bit.gs1 = 1;
    vc_sw.bit.gs0 = 1;
    *(VIDEO_SWITCH_ADDRESS) = vc_sw.mixed;

    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}


/// @brief Xe[W4̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st4() {
    int size;
    int result;
    VC_ONOFF vc_sw;
    int loading_pos = 12;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    draw_memory_map_buffer_grp();

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if(result!=0) {
            kon_log("resource_load_st4 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st4\\SPBG_ST4.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st4\\SPBG_ST4.SP"));
    if(result!=0) {
        kon_log("resource_load_st4 : Faile to load ST4 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\st4\\SPBG_ST4.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st4\\SPBG_ST4.PAL"));
    if(result!=0) {
        kon_log("resource_load_st4 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st4\\BG_ST4.MDT"
        , "resources\\X68\\st4\\BG_ST4_PWM.pwm"
        , 0
        , def_stage_bg_size[3][0]
        , def_stage_bg_size[3][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st4\\TXT4.TRL", "resources\\X68\\st4\\TXT4.PAL");
    if(result!=0) {
        kon_log("resource_load_st4 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st4);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BGp^[
    result = load_transsp("resources\\X68\\st4\\BG_ST4_ANIM.SP");
    //kon_log("BG_ST4_ANIM : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BOSS4
    result = load_transsp("resources\\X68\\st4\\BOSS4.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st4\\BOSS4.PAL");
    //kon_log("BOSS4.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->boss_pal_stot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st4\\TXT4.PAL");
    //kon_log("TXT4.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // ]
    //transfer_pal(0, 0, 4, 1);
    //transfer_sp(0, 0, 0x40, 2*3);
	transfer_sp(p_stage_context->bgmap_anim_sp_slot, 16*3, 0x00, 16*3);

    // <<< \ON/OFFݒ >>>
    vc_sw.mixed = *(VIDEO_SWITCH_ADDRESS);
    vc_sw.bit.son = 1;
    vc_sw.bit.ton = 1;
    vc_sw.bit.gs3 = 1;
    vc_sw.bit.gs2 = 1;
    vc_sw.bit.gs1 = 1;
    vc_sw.bit.gs0 = 1;
    *(VIDEO_SWITCH_ADDRESS) = vc_sw.mixed;

    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}


/// @brief Xe[W5̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st5() {
    int size;
    int result;
    VC_ONOFF vc_sw;
    int loading_pos = 13;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    draw_memory_map_buffer_grp();

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if(result!=0) {
            kon_log("resource_load_st5 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st5\\SPBG_ST5.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st5\\SPBG_ST5.SP"));
    if(result!=0) {
        kon_log("resource_load_st5 : Faile to load ST5 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\st5\\SPBG_ST5.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st5\\SPBG_ST5.PAL"));
    if(result!=0) {
        kon_log("resource_load_st5 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st5\\BG_ST5.MDT"
        , "resources\\X68\\st5\\BG_ST5_PWM.pwm"
        , 0
        , def_stage_bg_size[4][0]
        , def_stage_bg_size[4][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st5\\TXT5.TRL", "resources\\X68\\st5\\TXT5.PAL");
    if(result!=0) {
        kon_log("resource_load_st5 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st5);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BGp^[
    result = load_transsp("resources\\X68\\st5\\BG_ST5_ANIM.SP");
    //kon_log("BG_ST5_ANIM : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // GL
    result = load_transsp("resources\\X68\\st5\\SPBG_EN5.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->ene_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BOSS5
    result = load_transsp("resources\\X68\\st5\\BOSS5.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st5\\BOSS5.PAL");
    //kon_log("BOSS5.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->boss_pal_stot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st5\\TXT5.PAL");
    //kon_log("TXT5.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // ]
    //transfer_pal(0, 0, 4, 1);
    //transfer_sp(0, 0, 0x40, 2*3);

    // <<< \ON/OFFݒ >>>
    vc_sw.mixed = *(VIDEO_SWITCH_ADDRESS);
    vc_sw.bit.son = 1;
    vc_sw.bit.ton = 1;
    vc_sw.bit.gs3 = 1;
    vc_sw.bit.gs2 = 1;
    vc_sw.bit.gs1 = 1;
    vc_sw.bit.gs0 = 1;
    *(VIDEO_SWITCH_ADDRESS) = vc_sw.mixed;

    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}


/// @brief Xe[W6̃\[Xǂݍ
/// @return F0, sF0ȊO
int resource_load_st6() {
    int size;
    int result;
    VC_ONOFF vc_sw;
    int loading_pos = 12;

    // ʕ\B
    hide_screen(6);
    // [fBOSPǂݍ
    result = load_loading_sp();
    if(result!=0) {
        kon_log("[ERROR] LOADING SP̓ǂݍ݂Ɏs܂B\n");
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // ܂}XNŉBԂɂ
    p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
    p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
    p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
    draw_memory_map_buffer_grp();

    // <<< GRP摜 >>>
    if (p_application_context->grp_already_read == 0) {
        result = load_rl16("resources\\X68\\common\\FRAME_16.RL");
        if(result!=0) {
            kon_log("resource_load_st6 : OtBbN̓ǂݍ݂Ɏs܂B\n");
            return result;
        }
        p_application_context->grp_already_read = 1;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BG/SP`ǂݍ >>>
    //
    // SP/BG`
    result = Wbetaread("resources\\X68\\st6\\SPBG_ST6.SP"
                , SP_DEF_ADDRESS(0)
                , fsize("resources\\X68\\st6\\SPBG_ST6.SP"));
    if(result!=0) {
        kon_log("resource_load_st6 : Faile to load ST6 SP\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // pbg
    result = Wbetaread("resources\\X68\\st6\\SPBG_ST6.PAL"
                , SP_PAL_ADDRESS(1)
                , fsize("resources\\X68\\st6\\SPBG_ST6.PAL"));
    if(result!=0) {
        kon_log("resource_load_st6 : pbgǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGp^[ǂݍ݁@>>>
    //
	result = load_bgmap(
        "resources\\X68\\st6\\BG_ST6.MDT"
        , "resources\\X68\\st6\\BG_ST6_PWM.pwm"
        , 0
        , def_stage_bg_size[5][0]
        , def_stage_bg_size[5][1]
        , 0
        );
    if(result!=0) { printf("Error\n"); return result; }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< eLXgǂݍ >>>
    result = load_trl("resources\\X68\\st6\\TXT6.TRL", "resources\\X68\\st6\\TXT6.PAL");
    if(result!=0) {
        kon_log("resource_load_st6 : eLXg摜̓ǂݍ݂Ɏs܂B\n");
        return result;
    }
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< BGMǂݍ >>>
    load_bgms(bgmindex_st6);
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< ʉǂݍ >>>
    load_se_context();
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSSPǂݍ >>>
    // @
    result = load_transsp("resources\\X68\\common\\JIKI.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->jiki_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BGp^[
    result = load_transsp("resources\\X68\\st6\\BG_ST6_ANIM.SP");
    //kon_log("BG_ST6_ANIM : TRANSSP load index : %d\n", result);
    p_stage_context->bgmap_anim_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // BOSS6
    result = load_transsp("resources\\X68\\st6\\BOSS6.SP");
    //kon_log("JIKI.SP : TRANSSP load index : %d\n", result);
    p_stage_context->boss_sp_slot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    // <<< TRANSPALǂݍ >>>
    result = load_transpal("resources\\X68\\common\\JIKI.PAL");
    //kon_log("JIKI_PAL : TRANSPAL load index : %d\n", result);
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st6\\BOSS6.PAL");
    //kon_log("BOSS6.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->boss_pal_stot = result - 1;
    draw_loading_sp(loading_pos--); // [fBOSP`

    result = load_transpal("resources\\X68\\st6\\TXT6.PAL");
    //kon_log("TXT6.PAL : TRANSPAL load index : %d\n", result);
    p_stage_context->text_pal_slot = result - 1;
	p_stage_context->text_pal_block = 0;
    p_stage_context->shop_pal_block = 1;
	p_stage_context->int_pal_block = 2;

    // ]
    //transfer_pal(0, 0, 4, 1);
    //transfer_sp(0, 0, 0x40, 2*3);

    // <<< \ON/OFFݒ >>>
    vc_sw.mixed = *(VIDEO_SWITCH_ADDRESS);
    vc_sw.bit.son = 1;
    vc_sw.bit.ton = 1;
    vc_sw.bit.gs3 = 1;
    vc_sw.bit.gs2 = 1;
    vc_sw.bit.gs1 = 1;
    vc_sw.bit.gs0 = 1;
    *(VIDEO_SWITCH_ADDRESS) = vc_sw.mixed;

    // ON/OFF̐ݒ
    *(VIDEO_SWITCH_ADDRESS) = p_memory_map_buffer->vc_onoff.mixed;
    // ʂ̃vCIeBݒ肷
    *(VIDEO_PRIORITY_ADDRESS) = p_memory_map_buffer->vc_priority.mixed;

    // I
    return 0;
}

/// @brief Xe[W̃\[X
/// @return F0, sF0ȊO
int resource_release_stage() {
    int i;

    // BGM
    sound_stop_bgm();
    // BGM
    for(i=0;i<ZMD_TRACK_MAX;i++) {
        release_bgm(i);
    }

    // PCG]f[^
    for(i=0;i<tpcg_buffer.tsp_read_count;i++) {
        free(tpcg_buffer.tsp_buff[i]);
        tpcg_buffer.tsp_buff[i] = NULL;
    }
    tpcg_buffer.tsp_read_count = 0;

    for(i=0;i<tpcg_buffer.tpal_read_count;i++) {
        free(tpcg_buffer.tpal_buff[i]);
        tpcg_buffer.tpal_buff[i] = NULL;
    }
    tpcg_buffer.tpal_read_count = 0;
    return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_bgm_single(int zmd_index, char* filepath)
//
//	[  ]
//		int zmd_index			X68000ŗLBZMD̓ǂݍݐobt@CfbNX
//		const char* filepath	\[Xt@Cւ̃tpX
//
//	[ ߂l ]
//		Fǉ\[X̃CfbNXԍ
//		sF-1
//
//	[  ]
//		BGM̃\[X1Ȃ荞݂܂
//--------------------------------------------------------------------
int resource_load_bgm_single(int zmd_index, char* filepath)
{
    int result;

    // BGM̃\[Xǂݍ
    result = load_bgm(zmd_index, filepath);
    if(result!=0) {
        kon_log("resource_load_bgm_single : BGM\[X̓ǂݍ݂Ɏs܂Bindex=%d, path=%s\n", zmd_index, filepath);
    }

    // CfbNXԂ
    return zmd_index;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_release_bgm_single(int index)
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		BGM̃\[X
//--------------------------------------------------------------------
int resource_release_bgm_single(int index)
{
    int iRes = 0;

    // 
	iRes = release_bgm(index);
    if (iRes != 0)
    {
        kon_log("resource_release_bgm_single : Đ~EɎs܂B\n");
        return -1;
    }

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void load_bgms(int bgm_index);
//
//	[  ]
//		int bgm_index   Xe[W̃CfbNXi0:title, 2:ed, 3:st1, 4:st2 ...j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		w̃t@CpXBGM\[Xǂݍ݁ASOUND_CONTEXT
//		f܂B
//--------------------------------------------------------------------
void load_bgms(int bgm_index)
{
    char path[256];

	int i;

	// <<< OɑSJ >>>
	sound_stop_bgm();
    for(i=0;i<ZMD_TRACK_MAX;i++) {
    	release_bgm(i);
    }
    // CfbNX𐮂
    for(i=0;i<(bgmtype_count + MAX_SECTION);i++) {
        p_sound_context->bgm_index[i] = i;
    }

	// <<< ǂݍ >>>
	for (i = 0; i < (bgmtype_count + MAX_SECTION); i++) {
		// ݒ肪Ȃ΃XLbv
		if (resource_conf.bgm[bgm_index][i] == NULL) {
            p_sound_context->bgm_index[i] = SOUND_NULL; // `Ȃ̔ԍ
			continue;
		}

        // "STOP"~w
        if (strcmp(SOUND_SILENT_WORD, resource_conf.bgm[bgm_index][i]) == 0) {
            p_sound_context->bgm_index[i] = SOUND_SILENT; // ~w̔ԍ
            continue;
        }

        // ǂݍ
        make_fullpath(path, resource_conf.dir_bgm, resource_conf.bgm[bgm_index][i]);
        load_bgm(p_sound_context->bgm_index[i], path);
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int index, int priority, int frames, int same_priority_wait)
//
//	[  ]
//		SE_ITEM* pSEItem
//		char* pFilepath
//      int index
//		int priority
//		int frames
//		int same_priority_wait
//      int frq                     gwi0-4j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		pFilepatȟʉǂݍ݁Aw肵SE_ITEM̍\̂ɑݒ肵܂B
//--------------------------------------------------------------------
void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int index, int priority, int frames, int same_priority_wait, int frq)
{
    // SEǂݍ
    load_se(index, pFilepath);
    // lݒ
    attach_se_item(pSEItem, index, priority, frames, same_priority_wait, frq);
}


//--------------------------------------------------------------------
//	[  ]
//		void attach_se_item(SE_ITEM* pSEItem, int index, int priority, int frames, int same_priority_wait, int frq)
//
//	[  ]
//		SE_ITEM* pSEItem
//      int index
//		int priority
//		int frames
//		int same_priority_wait
//      int frq
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ǂݍݍςPCMgāAw肵SE_ITEM̍\̂ɑݒ肵܂B
//--------------------------------------------------------------------
void attach_se_item(SE_ITEM* pSEItem, int index, int priority, int frames, int same_priority_wait, int frq)
{
    // lݒ
	pSEItem->index = index;
	pSEItem->priority = priority;
	pSEItem->frames = frames;
	pSEItem->same_priority_wait = same_priority_wait;
    pSEItem->x68frq = frq;

    // L
    pSEItem->valid = 1;
}

//--------------------------------------------------------------------
//	[  ]
//		void load_se_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SE܂Ƃ߂ēǂݍSOUND_CONTEXTɌʂ𔽉f܂
//--------------------------------------------------------------------
void load_se_context()
{
    int i;
    int default_frq = 2;
    int index;
    char buffer[256];
    // ǂݍݍςȂ牽Ȃ
    if(p_sound_context->se_already_read) {
        return;
    }

   	// ʉǂݍ݁iREFȊOj
    index = 0;
	for (i = 0; i < setype_count; i++) {
        char* filename;
		// REFŎn܂ꍇ̓XLbv
		filename = resource_conf.se[i].filename;
        //kon_log("load_se_content : index = %d, filename = %s\n", i, filename);
        if ((filename == NULL) || (strlen(filename) == 0))
        {
            continue;
        }
        if (strncmp(filename, "ref:", 4)==0) {
			continue;
		}

		// t@C荞
		make_fullpath(buffer, resource_conf.dir_se, resource_conf.se[i].filename);
		load_se_item(&(p_sound_context->se_item[i])
			, buffer
            , index++
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
            , resource_conf.se[i].x68frq
		);
        /*
		kon_log("SE loaded [%d] : index=%d (%s, %d, %d, %d, %d)\n"
			, i
			, index-1
            , buffer
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
            , resource_conf.se[i].x68frq
		);
        */
	}

	// ʉREF
	for (i = 0; i < setype_count; i++) {
        char* filename;
        int seindex;
        // t@CȂꍇ̓XLbv
        if(resource_conf.se[i].filename==NULL) {
            continue;
        }
		// REFȊO̓XLbv
		filename = resource_conf.se[i].filename;
		if (strncmp(filename, "ref:", 4)!=0) {
			continue;
		}

		// N
		seindex = to_seindex(resource_conf.se[i].filename + 4);

		// N悪̏ꍇ̓G[
		if (p_sound_context->se_item[seindex].valid == 0) {
			kon_log("[ERROR] QƐ̌ʉݒ肳Ă܂BQƐF%s\n", filename);
			continue;
		}

        attach_se_item(&(p_sound_context->se_item[i])
			, p_sound_context->se_item[seindex].index
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
            , resource_conf.se[i].x68frq
		);
        /*
		kon_log("SE Attached [%d] : (%d, %d, %d, %d, %d)\n"
			, i
			, p_sound_context->se_item[seindex].index
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
            , resource_conf.se[i].x68frq
		);
        */
	}

    //
	// ǂݍݍ
	p_sound_context->se_already_read = 1;
}


//--------------------------------------------------------------------
//	[  ]
//		void release_sound_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SE܂Ƃ߂ĉSOUND_CONTEXTɌʂ𔽉f܂
//--------------------------------------------------------------------
void release_sound_context()
{
    int i;
    // SE
    for(i=0;i<setype_count;i++) {
        release_se(i);
    }
    // BGM
    for(i=0;i<ZMD_TRACK_MAX;i++) {
        release_bgm(i);
    }
    // ReLXg
    memset(p_sound_context, 0, sizeof(SOUND_CONTEXT));
}

// /// @brief PIC摜ǂݍŉʂɕ\
// /// @param filename t@C
// /// @return F0, sF0ȊO
// int load_pic(char* filename) {
//     UBYTE *FileBuf;
//     UBYTE *WorkBuf;
//     ULONG Flag;
//     int ret;

//     int filesize = fsize(filename);
//     FileBuf = (UBYTE *)malloc(filesize);
//     WorkBuf = (UBYTE *)malloc(512 * 1024);
//     Flag = APF_NOINITCRT | APF_NOPRFC | APF_NOADJUST | APF_NOPRC;

//     ret = APICLOAD(
//         (UWORD *)0xc00000,         /* Load Ptr */
//         filename, /* Load FileName */
//         -1, -1,                    /* Load Position */
//         FileBuf, filesize,         /* Load FileBuf */
//         Flag,
//         WorkBuf /* WorkBuf */
//     );

//     free(FileBuf);
//     free(WorkBuf);

//     return ret;
// }

//--------------------------------------------------------------------
//	[  ]
//		int load_rl16(char* filename)
//
//	[  ]
//		char* filename t@Cւ̃|C^
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		RL`16F摜ǂݍ݂܂
//--------------------------------------------------------------------
int load_rl16(char* filename)
{
    int result;
    int filesize;
    unsigned char* buffer;
    int palsize;
    unsigned char* p;

    // t@CTCỸobt@mۂēǂݍ
    filesize = fsize(filename);
    buffer = (unsigned char*)malloc(filesize);
    if(buffer==NULL) {
        kon_log("load_rl16 : ǂݍ݃obt@mۂł܂łBsize=%d\n", filesize);
        return -1;
    }
    result = betaread(filename, buffer, filesize);
    if(result!=0) {
        kon_log("load_rl16 : t@C̓ǂݍ݂Ɏs܂B\n", filename);
        free(buffer);
        return -1;
    }

    // pbg]
    palsize = 2 * 16;
    dmacpy((short*)buffer, GRP_PAL_ADDRESS, (palsize/4));

    // OtBbNWJB1byte2hbg̏񂪓̂
    // GTNLIB̓WJ֐ł͒ړWJłȂB
    p = buffer;
    p += palsize;
    {
        unsigned short* walker = (unsigned short *)0xC00000;
        while (((int)walker < 0xE00000) && ((p-buffer)<filesize))
        {
            int c;
            int val = *p;
            int cnt = *(p+1);

            for (c = 0; c <= cnt; c++)
            {
                *walker++ = (short)((val >> 4) & 0xF);
                *walker++ = (short)(val & 0xF);
                if ((int)walker >= 0xE00000) {
                    break;
                }
            }
            p++;
            p++;
        }
    }

    // 
    free(buffer);

    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int load_rl256(char* filename)
//
//	[  ]
//		char* filename t@Cւ̃|C^
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		RL`256F摜ǂݍ݂܂
//--------------------------------------------------------------------
int load_rl256(char* filename)
{
    int result;
    int filesize;
    char* buffer;
    int palsize;
    unsigned char* p;

    // t@CTCỸobt@mۂēǂݍ
    filesize = fsize(filename);
    buffer = (char*)malloc(filesize);
    if(buffer==NULL) {
        kon_log("load_rl256 : ǂݍ݃obt@mۂł܂łBsize=%d\n", filesize);
        return -1;
    }
    result = betaread(filename, buffer, filesize);
    if(result!=0) {
        kon_log("load_rl256 : t@C̓ǂݍ݂Ɏs܂B\n", filename);
        free(buffer);
        return -1;
    }

    // pbg]
    {
        palsize = 2 * 256;
        dmacpy((short*)buffer, GRP_PAL_ADDRESS, (palsize/4));
    }

    // OtBbNWJ
    {
        int c;
        unsigned short* walker = (unsigned short *)0xC00000;
        p = buffer;
        p += palsize;
        while (walker < (unsigned short*)0xD00000)
        {
            for (c = 0; c <= *(p + 1); c++)
            {
                *walker++ = (short)*p;
                if (walker >= (unsigned short*)0xD00000)
                {
                    break;
                }
            }
            *p++;
            *p++;
            if (walker >= (unsigned short*)0xD00000)
            {
                break;
            }
        }
    }

    // 
    free(buffer);

    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		load_trl(char* trl_filename, char* pal_filename)
//
//	[  ]
//		char* trl_filename TRLt@C̃t@C
//		char* pal_filename eLXg̃pbgt@C
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		TRL`̉摜eLXgʂɓǂݍ݂܂
//--------------------------------------------------------------------
int load_trl(char* trl_filename, char* pal_filename)
{
    int filesize = fsize(trl_filename);
    //char* buffer = (char*)malloc(filesize);
    //char* p = buffer;
    //if(buffer==NULL) {
    //    kon_log("load_trl : ̊mۂɎs܂Bsize=%d\n", filesize);
    //    return -1;
    //}

    // pbgǂݍ
    Wbetaread(pal_filename, TXT_PAL_ADDRESS, 32);

    // eLXg摜ǂݍ
    //betaread(trl_filename, buffer, filesize);

    // WJ
    //rl_ext_b(p, (char*)TXT_TOP_ADDRESS, filesize);
    rl_ext_b_file(trl_filename, (char*)TXT_TOP_ADDRESS, filesize);
    //free(buffer);

    return 0;
}


// ]SPǂݍ
int load_transsp(char* filename) {
    int size;
    if(tpcg_buffer.tsp_read_count>=TRANSSP_SLOTS) {
        // XbgI[o[
        return -1;
    }

    // ǂݍ
    size = fsize(filename);
    tpcg_buffer.tsp_buff[tpcg_buffer.tsp_read_count] = (short*)malloc(size);
    Wbetaread(filename, tpcg_buffer.tsp_buff[tpcg_buffer.tsp_read_count], size);
    tpcg_buffer.tsp_read_count++;
    return tpcg_buffer.tsp_read_count;
}

// ]PALǂݍ
int load_transpal(char* filename) {
    int size;
    if(tpcg_buffer.tpal_read_count>=TRANSPAL_SLOTS) {
        // XbgI[o[
        return -1;
    }

    // ǂݍ
    size = fsize(filename);
    tpcg_buffer.tpal_buff[tpcg_buffer.tpal_read_count] = (short*)malloc(size);
    Wbetaread(filename, tpcg_buffer.tpal_buff[tpcg_buffer.tpal_read_count], size);
    tpcg_buffer.tpal_read_count++;
    return tpcg_buffer.tpal_read_count;
}

/// @brief PCG]̃ubNPCGɃf[^]
/// @param slot 
/// @param topIndex 
/// @param count 
/// @return 
int transfer_sp(int slot, int offsetIndex, int targetIndex, int count) {
    short* fromAddress = tpcg_buffer.tsp_buff[slot] + (0x40*offsetIndex);
    short* targetAddress = SP_DEF_ADDRESS(targetIndex);
    dmacpy( fromAddress, targetAddress, (0x80*count)/4 );
    return 0;
}

/// @brief PCG]̃ubNPALɃf[^]
/// @param slot 
/// @param topBlock 
/// @param targetBlock 
/// @param count ]pbgubN
/// @return 
int transfer_pal(int slot, int topBlock, int targetBlock, int count) {
    int i;
    short* fromAddress = tpcg_buffer.tpal_buff[slot] + (16 * topBlock);
    short* targetAddress = SP_PAL_ADDRESS(targetBlock);
    dmacpy( fromAddress, targetAddress, (32*count)/4 );
    return 0;
}
