//=============================================================================
// Windows̃rfIRg[̎
//=============================================================================
extern "C" {
#include "../../devs.h"
#include "../../../core/game_context.h"
#include "../../../core/kon_util.h"
}

#include "DevsContextWin.h"
#include "DGControl.h"
#include "ScreenMode.h"
#include "WaitForSync.h"
#include "../resource/resource.h"

// -----< vg^Cv錾 >-----
//
int draw_memory_map_buffer_bg_page(int page);

//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		X68000̃}bvɑobt@ɏ܂ꂽe
//      ʏɊGvbg܂
//--------------------------------------------------------------------
int draw_memory_map_buffer() {
    // PCG]
    draw_transfer_pcg();

    // `Jn
    CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
    CDGControl* pDGControl = CDGControl::GetInstance();
    CDevsContextWin* pDevs = CDevsContextWin::GetInstance();

    // `RenderTargetɕύX
    if (pDevs->m_iRenderTargetIndex < 0) {
        kon_log("[ERROR] video : RenderTarget쐬Ă܂B\n");
        return -1;
    }
    if (pDevs->m_iRenderTargetIndex > 0) {
        kon_log("[ERROR] video : 䂪ԈĂȂRenderTargetIndex͏0łȂ΂Bindex=%d\n", pDevs->m_iRenderTargetIndex);
    }
    pDGControl->SetRenderTarget(pDevs->m_iRenderTargetIndex);

    // `悷
	for (int priority = 0; priority < 3; priority++) {
        int rev_priority = 2 - priority;
		if (p_memory_map_buffer->vc_priority.bit.txt == rev_priority) {
			draw_memory_map_buffer_txt();       // TXT`
		}
		if (p_memory_map_buffer->vc_priority.bit.sp == rev_priority) {
			draw_memory_map_buffer_bg();        // BG`
			draw_memory_map_buffer_sp();        // SP`
		}
		if (p_memory_map_buffer->vc_priority.bit.grp == rev_priority) {
			draw_memory_map_buffer_grp();       // GRP`
		}
	}

    // `obNobt@ɖ߂
    pDGControl->SetRenderTargetAsBackBuffer();

    // xNAĂ`
    pDGControl->Clear();
    RECT* pViewRect = pScreenMode->GetViewRect();
    pDGControl->DrawRenderTargetTexture(
        pDevs->m_iRenderTargetIndex
        , pViewRect->left
        , pViewRect->top
        , pScreenMode->GetViewWidth()
        , pScreenMode->GetViewHeight()
    );

    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int draw_transfer_pcg()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		SP̃p^[f[^̓]s܂B
//      Windows̏ꍇ́AۂɃp^[̂ł͂ȂA
//      `ςSP̃CfbNXŃR[hԍ̃}bsO
//      ܂B
//--------------------------------------------------------------------
int draw_transfer_pcg() {
    // SP]
    for (int i = 0; i < p_memory_map_buffer->transsp_count; i++) {
        transfer_sp(
              p_memory_map_buffer->transsp[i].set       // ubN
            , p_memory_map_buffer->transsp[i].offset    // ]
            , p_memory_map_buffer->transsp[i].target    // ]
            , p_memory_map_buffer->transsp[i].cnt       // ]
        );
    }
    p_memory_map_buffer->transsp_count = 0;

    // PAL̓]iWindows̏ꍇ͋U肷邾j
    for (int i = 0; i < p_memory_map_buffer->transpal_count; i++) {
        transfer_pal(
              p_memory_map_buffer->transpal[i].set       // ubN
            , p_memory_map_buffer->transpal[i].offset    // ]
            , p_memory_map_buffer->transpal[i].target    // ]
            , p_memory_map_buffer->transpal[i].cnt       // ]
        );
    }
    p_memory_map_buffer->transpal_count = 0;

    // I
    return 0;

}

//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer_sp()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		XvCg̕`EXN[s܂B
//--------------------------------------------------------------------
int draw_memory_map_buffer_sp() {
    if (p_memory_map_buffer->vc_onoff.bit.son == 0) {
        return 0;
    }

    CDGControl* pDGControl = CDGControl::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();

	// XvCg`
    for (int i = 127; i >= 0; i--) {
        // R[h擾
		int spIndex = p_memory_map_buffer->sp_unit[i].code.bit.code;
        int palBlock = p_memory_map_buffer->sp_unit[i].code.bit.color;
        if (pContext->m_palBlockRead[palBlock] == false) {
            palBlock = 0;
        }
            // R[hCfbNXɕϊ
		int mappedSPIndex = pContext->m_spIndexMap[palBlock][spIndex];
        // X,YWݒ
		int x = p_memory_map_buffer->sp_unit[i].x;
		int y = p_memory_map_buffer->sp_unit[i].y;

        // ]\Ɋւ鉉Z
		//float spZoomSizeX = pContext->m_pixelZoomX;
		//float spZoomSizeY = pContext->m_pixelZoomY;
		if (p_memory_map_buffer->sp_unit[i].code.bit.h_rev) {
			//x -= 16;
            //spZoomSizeX *= -1;
		}
		if (p_memory_map_buffer->sp_unit[i].code.bit.v_rev) {
			//y -= 16;
            //spZoomSizeY *= -1;
		}

        // `悷
		pDGControl->DrawSprite(
			mappedSPIndex                           // SPCfbNX
			, (long)(x)    // `XW
			, (long)(y)    // `YW
			, p_memory_map_buffer->sp_unit[i].code.bit.h_rev    // `g嗦X
			, p_memory_map_buffer->sp_unit[i].code.bit.v_rev    // `g嗦Y
			, 0xFFFFFFFF                            // fBt[Y
			, 0                                     // ZW
		);
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer_bg()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		BG̃XN[WX^rfIRg[ɔf܂B
//      Windowsł̓XN[̂قAt[BGʂ̉摜ׂ
//      `܂B
//--------------------------------------------------------------------
int draw_memory_map_buffer_bg() {
    int result;
    if (p_memory_map_buffer->vc_onoff.bit.son == 0) {
        return 0;
    }

    // BG0`
    result = draw_memory_map_buffer_bg_page(0);
    if (result != 0) {
        kon_log("[ERROR] BG0̕`撆ɃG[܂B\n");
        return -1;
    }

    // BG1`
    result = draw_memory_map_buffer_bg_page(1);
    if (result != 0) {
        kon_log("[ERROR] BG0̕`撆ɃG[܂B\n");
        return -1;
    }

    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer_bg_page( int page )
//
//	[  ]
//		int page        BGy[Wԍs
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		BG̃XN[WX^rfIRg[ɔf܂B
//      Windowsł̓XN[̂قAt[BGʂ̉摜ׂ
//      `܂B
//--------------------------------------------------------------------
int draw_memory_map_buffer_bg_page(int page) {
    CDGControl* pDGControl = CDGControl::GetInstance();
    CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
    CDevsContextWin* pContext = CDevsContextWin::GetInstance();

    // y[Wԍ`FbN
    if ((page != 0) && (page != 1)) {
        return -1;
    }

    // ON/OFF`FbN
    int onoff = 0;
    if (page == 0) {
        onoff = p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff;
    }
    else {
        onoff = p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff;
    }

    // OFFȂ牽Ȃ
    if (onoff == 0) {
        return 0;
    }

    /*
    // XN[ʒu擾
    int bg_x = 0;
    int bg_y = 0;
    if (page == 0) {
        bg_x = p_memory_map_buffer->bg_scroll_unit.bg0x;
        bg_y = p_memory_map_buffer->bg_scroll_unit.bg0y;
    }
    else {
        bg_x = p_memory_map_buffer->bg_scroll_unit.bg1x;
        bg_y = p_memory_map_buffer->bg_scroll_unit.bg1y;
    }
    */
    BBOX drawArea;
	drawArea.x0 = ((p_stage_context->bgview_hx >> 8) + 0  ) / 8;
	drawArea.y0 = ((p_stage_context->bgview_hy >> 8) + 0  ) / 8;
	drawArea.x1 = ((p_stage_context->bgview_hx >> 8) + 255) / 8;
	drawArea.y1 = ((p_stage_context->bgview_hy >> 8) + 255) / 8;
    int mWidth = drawArea.x1 - drawArea.x0 + 1;
    int mHeight = drawArea.y1 - drawArea.y0 + 1;
    int dx = -((p_stage_context->bgview_hx >> 8) & 7);
    int dy = -((p_stage_context->bgview_hy >> 8) & 7);

    // `悷
    BG_DEF_UNIT* pBGDef = p_memory_map_buffer->bg_def[page];
    for (int y = 0; y < mHeight; y++) {
        for (int x = 0; x < mWidth; x++) {
            int bgX = (drawArea.x0 + x) & 63;
            int bgY = (drawArea.y0 + y) & 63;

            BG_DEF_UNIT bgDef = p_memory_map_buffer->bg_def[page][bgY * 64 + bgX];

            int bgCode = bgDef.code.bit.code;
            int palBlock = bgDef.code.bit.color;
            if (pContext->m_palBlockRead[palBlock] == false) {
                palBlock = 0;
            }
            int mappedSPIndex = pContext->m_bgIndexMap[palBlock][bgCode];
            int px = x * 8 + dx;
            int py = y * 8 + dy;

            //float spZx = pContext->m_pixelZoomX;
            //float spZy = pContext->m_pixelZoomY;
            if (bgDef.code.bit.h_rev) {
                //px += 8;
                //spZx *= -1;
            }
            if (bgDef.code.bit.v_rev) {
                //py += 8;
                //spZy *= -1;
            }
            pDGControl->DrawSprite(
                  mappedSPIndex
                , (long)(px)
                , (long)(py)
                , bgDef.code.bit.h_rev
                , bgDef.code.bit.v_rev
                , 0xFFFFFFFF
                , 0
            );
        }
    }

    // I
    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer_grp()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		OtBbNʂ`܂B
//--------------------------------------------------------------------
int draw_memory_map_buffer_grp() {
    CDGControl* pDGControl = CDGControl::GetInstance();
    CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
    CDevsContextWin* pContext = CDevsContextWin::GetInstance();
    int px;
    int py;

    if (p_memory_map_buffer->vc_onoff.bit.gs4 == 0) {
        // Page=3
        if (p_memory_map_buffer->vc_onoff.bit.gs3) {
            px = p_memory_map_buffer->grp_scroll_unit.sc3_x;
            py = p_memory_map_buffer->grp_scroll_unit.sc3_y;

            pDGControl->DrawScaledGraphic(
                pContext->m_grpIndexMap[3]
                , (long)(px)
                , (long)(py)
                , 1.0
                , 1.0
                , 0xFFFFFFFF
                , 0);
        }

        // Page=2
        if (p_memory_map_buffer->vc_onoff.bit.gs2) {
            px = p_memory_map_buffer->grp_scroll_unit.sc2_x;
            py = p_memory_map_buffer->grp_scroll_unit.sc2_y;

            pDGControl->DrawScaledGraphic(
                pContext->m_grpIndexMap[2]
                , (long)(px)
                , (long)(py)
                , 1.0
                , 1.0
                , 0xFFFFFFFF
                , 0);
        }

        // Page=1
        if (p_memory_map_buffer->vc_onoff.bit.gs1) {
            px = p_memory_map_buffer->grp_scroll_unit.sc1_x;
            py = p_memory_map_buffer->grp_scroll_unit.sc1_y;

            pDGControl->DrawScaledGraphic(
                pContext->m_grpIndexMap[1]
                , (long)(px)
                , (long)(py)
                , 1.0
                , 1.0
                , 0xFFFFFFFF
                , 0);
        }
    }

    // Page=0
    if ((p_memory_map_buffer->vc_onoff.bit.gs0) || (p_memory_map_buffer->vc_onoff.bit.gs4)) {
        px = p_memory_map_buffer->grp_scroll_unit.sc0_x;
        py = p_memory_map_buffer->grp_scroll_unit.sc0_y;

        pDGControl->DrawScaledGraphic(
            pContext->m_grpIndexMap[0]
            , (long)(px)
            , (long)(py)
            , 1.0
            , 1.0
            , 0xFFFFFFFF
            , 0);
    }

    return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int draw_memory_map_buffer_txt()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		OtBbNʂ`܂B
//--------------------------------------------------------------------
int draw_memory_map_buffer_txt() {
    // \ON/OFF
    if (p_memory_map_buffer->vc_onoff.bit.ton == 0) {
        return 0;
    }

    CDGControl* pDGControl = CDGControl::GetInstance();
    CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
    CDevsContextWin* pContext = CDevsContextWin::GetInstance();

    int px = p_memory_map_buffer->txt_scroll_unit.tx_x;
    int py = p_memory_map_buffer->txt_scroll_unit.tx_y;

    pDGControl->DrawScaledGraphic(
        pContext->m_txtIndexMap
        , (long)(px)
        , (long)(py)
        , 1.0
        , 1.0
        , 0xFFFFFFFF
        , 0);

    return 0;
}
