extern "C" {
#include "../../devs.h"
#include "../../../core/game_context.h"
#include "../../../core/kon_util.h"
#include "../../../core/common.h"

extern int vd_wait_skipped;    // ҂XLbvꂽƂ1tO
}

#include <shlwapi.h>
#include <direct.h>
#include <stdio.h>
#include <sys/stat.h>

#include "dicontrol.h"
#include "DGControl.h"
#include "ScreenMode.h"
#include "WaitForSync.h"
#include "DevsContextWin.h"

#include "../../../konkonWin//konkonWin//KonConfParser.h"

// -----< O[oϐ̓ >-----
//
// ̓jbg
extern DICONTROL g_objDIControl;

//============================
// vg^Cv錾
//============================
void toggle_fullscreen();
CGStr get_ss_filename();

//--------------------------------------------------------------------
//	[  ]
//		int screen_startup()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		vO̊JnɂP񂾂sʌn̏
//--------------------------------------------------------------------
int screen_startup() {
	// ʂ̍XVԊuݒ肷
	//DWORD dwWaitTime = (DWORD)((float)1000.0 / (float)55.0);		// X68000V-SYNCɋ߂56msŐݒB_ȉ؂̂ĕlā{P
	DWORD dwWaitTime = 18;		// X68000V-SYNCɋ߂56msŐݒB_ȉ؂̂ĕlā{P
	WaitForSync(dwWaitTime);				// ̏

	// BG`̈̃̈m
	game_context.memory_map_buffer.bg_def[0] = (BG_DEF_UNIT*)(calloc(sizeof(BG_DEF_UNIT), 64 * 64));
	game_context.memory_map_buffer.bg_def[1] = (BG_DEF_UNIT*)(calloc(sizeof(BG_DEF_UNIT), 64 * 64));

	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int screen_init()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[WJnɎsʂ̏
//--------------------------------------------------------------------
int screen_init() {
	CDGControl* pDGControl = CDGControl::GetInstance();
	CDevsContextWin* pDevs = CDevsContextWin::GetInstance();

	// `eNX`쐬
	int rttIndex = pDGControl->GetRenderTargetIndex("RTT");
	if (rttIndex == -1) {
		CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
		rttIndex = pDGControl->AddRenderTargetTexture("RTT", pScreenMode->GetSurfaceWidth(), pScreenMode->GetSurfaceHeight());
	}
	pDevs->m_iRenderTargetIndex = rttIndex;

	// 摜NAĂ
	pDGControl->Clear();
	pDGControl->Flip();
	pDGControl->Clear();
	pDGControl->Flip();

	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int screen_pre_vsync()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		V-SYNC̑OɎsʌn̏B
//		obNobt@ɑ΂āAẢ摜`揈sB
//--------------------------------------------------------------------
int screen_pre_vsync() {
	int result;

	// XN[[hgOꍇ̓gO
	if (p_input_parser->keyin_toggle_fullscreen == 1) {
		// ʃ[h؂ւ
		toggle_fullscreen();

		// gOςɂ
		p_input_parser->keyin_toggle_fullscreen = 2;
	}
	
	// obNobt@ɕ`悷
	result = draw_memory_map_buffer();

	// XN[VbgƂ
	if (p_input_parser->ss_clicked) {
		// t@CXL
		CGStr ssFile;
		ssFile = get_ss_filename();

		// XN[VbgƂ
		CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
		int saveResult;
		saveResult = SaveDrawScreenToPNG(
			0
			, 0
			, pScreenMode->GetScreenWidth()
			, pScreenMode->GetScreenHeight()
			, ssFile.GetString()
			, 0
		);
	}
	return result;
}


//===========================================
// XN[Vbg̃t@C
//===========================================
CGStr get_ss_filename()
{
	int result;

	// fBNgp
	CGStr dirName = "ScreenShot";
	BOOL dirExists = PathIsDirectoryA(dirName.GetString());
	if (!dirExists) {
		result = _mkdir(dirName.GetString());
		if (result < 0) {
			// fBNg쐬Ɏs
			kon_log("XN[Vbgp̃fBNg쐬Ɏs܂");
			return NULL;
		}
	}

	// t@CXL
	int no;
	char buffer[256];
	memset(buffer, 0, sizeof(buffer));

	CGStr baseFileNo = "00000";
	CGStr ssFilePath;
	ssFilePath = dirName + "\\SS.png";
	for (no = 0; no <= 99999; no++) {
		_itoa(no, buffer, 10);
		CGStr fileNoStr;
		CGStr fileName;
		fileNoStr = baseFileNo + CGStr((const char*)buffer);
		int length = fileNoStr.Length();
		int offset = length - baseFileNo.Length();

		fileName = dirName + CGStr("\\SS") + (fileNoStr.GetString() + offset) + CGStr(".png");

		BOOL exists = PathFileExistsA(fileName.GetString());
		if (!exists) {
			// 󂫂݂
			ssFilePath = fileName;
			break;
		}
	}

	// 肵t@CԂ
	return ssFilePath;
}


//--------------------------------------------------------------------
//	[  ]
//		void toggle_fullscreen()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		tXN[[hƃEBhE[h݂ɐ؂ւ܂B
//--------------------------------------------------------------------
void toggle_fullscreen() {
	int iRes;
	BOOL bRes;
	CKonConfParser* pConf = CKonConfParser::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();

	// <<< ʃ[h̑lύX >>>
	//
	// tXN[[h̐ݒ؂ւ
	BOOL bFull = pScreenMode->GetFullScreen();
	bFull = (bFull == TRUE ? FALSE : TRUE);
	pScreenMode->SetFullScreen(bFull);

	// tXN[[hŃXN[TCYς
	if (bFull) {
		// tXN[
		if (pConf->m_iFullScreenMode == 0) {
			// tXN[Łủ݂ʃTCYvBXN[TCY͌ŒŗǂB
			pScreenMode->SetScreenWidth(768);
			pScreenMode->SetScreenHeight(512);
		}
		else {
			// tXN[ŉʃTCYw
			pScreenMode->SetScreenWidth(pConf->m_iFullScreenWidth);
			pScreenMode->SetScreenHeight(pConf->m_iFullScreenHeight);
		}
	}
	else {
		// EBhE[h
		pScreenMode->SetScreenWidth(pConf->m_iWindowModeWidth);
		pScreenMode->SetScreenHeight(pConf->m_iWindowModeHeight);
	}
	pScreenMode->UpdateViewRect();

	// <<< ʐݒύX >>>
	//
	// tXN[̉ʂI
	if (pConf->m_iFullScreenDisplay >= 0) {
		iRes = SetUseDirectDrawDeviceIndex(pConf->m_iFullScreenDisplay);
		if (iRes != 0) {
			kon_log("toggle_fullscreen : SetUseDirectDrawDeviceIndexɎs܂B\n");
			return;
		}
	}

	// ʃTCYݒ
	iRes = SetGraphMode(pScreenMode->GetScreenWidth(), pScreenMode->GetScreenHeight(), 32, SCREEN_FREQ);
	if (iRes != 0) {
		kon_log("toggle_fullscreen : SetGraphModeɎs܂B\n");
		return;
	}

	// <<< ʃ[h؂ւ >>>
	//
	// [h؂ւ
	BOOL bWindowMode = (bFull == TRUE ? FALSE : TRUE);
	iRes = ChangeWindowMode(bWindowMode);
	if (iRes != DX_CHANGESCREEN_OK) {
		kon_log("toggle_fullscreen : fBXvC[h̕ύXɎs܂B\n");
		return;
	}

	// j󂳂郊\[Xč\z
	CDGControl* pDGControl = CDGControl::GetInstance();
	bRes = pDGControl->Reset();
	if (bRes == FALSE) {
		kon_log("toggle_fullscreen : \[X̍č\zɎs܂B\n");
		return;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		int screen_post_vsync()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		V-SYNC̃^C~OɎsʌn̏B
//		obNobt@tgɃtbv܂B
//--------------------------------------------------------------------
int screen_post_vsync() {
	CDGControl* pDGControl = CDGControl::GetInstance();

	// Present()
	BOOL bRes = pDGControl->Flip();
	if (bRes == FALSE) {
		//kon_log("[ERROR] screen_post_vsync : obNobt@ Flip ł܂łB\n");
		return -1;
	}

	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int screen_dispose()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Ỉʌn̉
//--------------------------------------------------------------------
int screen_dispose() {
	// BG`̈̃̈
	free(game_context.memory_map_buffer.bg_def[0]);
	free(game_context.memory_map_buffer.bg_def[1]);
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int wait_for_vsync(int force_wait)
//
//	[  ]
//		int force_wait	҂ꍇ1BWindowsł͖B
//
//	[ ߂l ]
//		ԂɍĂF0
//		ԂɍĂȂF1
//
//	[  ]
//		V-SYNC҂܂Bۂ͒Ԋũ^CXCX҂܂B
//--------------------------------------------------------------------
int wait_for_vsync(int force_wait) {
	BOOL result = TRUE;

	// [hŃVtgꂽ瑁肷
	if (!(g_objDIControl.IsOnLoad() && GetAsyncKeyState(VK_LSHIFT))) {
		result = WaitForSync();
	}

	// resultTRUÊƂ͑҂
	if (result == TRUE) {
		vd_wait_skipped = 0;
	}
	else {
		vd_wait_skipped = 1;
	}
	return 0;
}
