#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <sys/stat.h>
#include <sys/types.h>

extern "C" {
#include "../../../core/constants.h"
#include "../../../core/game_context.h"
#include "../../../core/common.h"
#include "../../devs.h"
#include "../../../core/shop.h"
#include "../../../core/gameover.h"
#include "../../../core/kon_util.h"
}

#include "DGControl.h"
#include "DShowControl.h"
//#include "SoundUnit.h"
#include "dicontrol.h"
#include "DevsContextWin.h"
#include "ScreenMode.h"

#include "../../../konkonWin/konkonWin/Game.h"
#include "../../../konkonWin/konkonWin/KonConfParser.h"

// -----< ` >-----
//
#define INPUTDATA_FILENAME "inputdata"

typedef struct _SAVE_HEADER {
	// o[W
	char version[4];

	// ^CfbNX
	int vrand_index;

	// Q[ݒiCONFIGݒj
	GAME_PROPERTIES game_properties;

	// gKݒ
	DISemantics trigger_semantics;

	// XVI[h
	int xvi_mode;
} SAVE_HEADER;

// -----< O[oϐ̓ >-----
//
// ̓jbg
extern DICONTROL g_objDIControl;
// Ot@C
extern CLogFile	g_objDebugLog;								// G[pO

// -----< O[oϐ >-----
//
int stash_state = 0;
SAVE_HEADER save_header;
FILE* score_log_fn = NULL;

// -----< vg^Cv錾 >-----
//
void stash_save_header(SAVE_HEADER* save_header);
int restore_save_header(SAVE_HEADER* save_header);


//--------------------------------------------------------------------
//	[  ]
//		int system_startup()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Q[̃VXeɊւ鏉s܂B
//--------------------------------------------------------------------
int system_startup() {
	BOOL bRes;
	int iRes;
	const char* res_filename;

	CGGame* pGame = CGGame::GetInstance();

	// -----< \[Xݒlǂݍ >-----
	//
	res_filename = (startup_param.XVI == 0 ? RES_WIN : RES_WIN_XVI);
	iRes = parse_resource_conf(res_filename);
	if (iRes != 0) {
		kon_log("[ERROR] [ERROR] \[Xݒ̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	//----------< DevsContext >----------
	//
	CDevsContextWin* pDevsContextWin = CDevsContextWin::GetInstance();
	pDevsContextWin->initialize();

	 
	//----------< Q[CX^X̏ >----------
	//
	bRes = pGame->Initialize();
	if (bRes == FALSE) {
		kon_log("[ERROR] system : Q[CX^X̏Ɏs܂B\n");
		return -1;
	}

	//----------< I >----------
	//
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int system_dispose()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Q[̃VXeɊւIs܂B
//--------------------------------------------------------------------
int system_dispose() {
	int iRes;

	// -----< Q[̃CX^X >-----
	//
	CGGame* pGame = CGGame::GetInstance();
	BOOL bRes = pGame->Release();
	if (!bRes) {
		kon_log("[ERROR] system_dispose : Q[CX^X̉Ɏs܂B\n");
		return -1;
	}

	// -----< VXeݒl̓ǂݍݐobt@ >-----
	//
	iRes = release_resource_conf();
	if (iRes != 0) {
		kon_log("[ERROR] [ERROR] \[Xݒ̓ǂݍݐobt@̉Ɏs܂B\n");
		return -1;
	}


	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int system_pre_vsync()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		VSYNCOɎs鏈
//--------------------------------------------------------------------
int system_pre_vsync() {
	// <<< ͏Ԃ̎荞݂͍s >>>
	int result = takein_input();
	if (result != 0) {
		return result;
	}

	// gK[Ɋւv~eBuȏԔs
	parse_trigger_state();

	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int takein_input()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		͏Ԃ荞Ń}bvobt@ɏԂ𔽉f܂B
//--------------------------------------------------------------------
int takein_input() {
	BOOL bRes;
	int pause_prev, ss_prev;

	CGGame* pGame = CGGame::GetInstance();

	bRes = pGame->TakeInInputState();
	if (bRes == FALSE) {
		kon_log("[ERROR] ::WinMain : ͏Ԃ̎荞݂Ɏs܂B\n");
		return -1;
	}

	// -----< WCXeBbN̏荞 >-----
	//
	p_memory_map_buffer->input_unit.mixed = 0;

	// L[͂̏Ԃ荞
	p_memory_map_buffer->input_unit.bit.down = g_objDIControl.IsDown();
	p_memory_map_buffer->input_unit.bit.left = g_objDIControl.IsLeft();
	p_memory_map_buffer->input_unit.bit.right = g_objDIControl.IsRight();
	p_memory_map_buffer->input_unit.bit.up = g_objDIControl.IsUp();

	p_memory_map_buffer->input_unit.bit.trg_b = g_objDIControl.IsButton(0);
	p_memory_map_buffer->input_unit.bit.trg_a = g_objDIControl.IsButton(1);

	// -----< WCXeBbNȊO̓͂荞 >-----
	//
	// |[Y{^
	pause_prev = p_input_parser->keyin_pause;
	p_input_parser->keyin_pause = 0;
	if (GetAsyncKeyState(VK_ESCAPE) || (g_objDIControl.IsButton(2))) {
		p_input_parser->keyin_pause = 1;
	}
	// |[Y{^̃NbN
	if ((pause_prev == 0) && (p_input_parser->keyin_pause == 1)) {
		p_input_parser->pause_clicked = 1;
	}
	else {
		p_input_parser->pause_clicked = 0;
	}

	// SS{^
	ss_prev = p_input_parser->keyin_ss;
	p_input_parser->keyin_ss = 0;
	if (g_objDIControl.IsButton(3)) {
		p_input_parser->keyin_ss = 1;
	}
	// SS{^̃NbN
	if ((ss_prev == 0) && (p_input_parser->keyin_ss == 1)) {
		p_input_parser->ss_clicked = 1;
	}
	else {
		p_input_parser->ss_clicked = 0;
	}

	// SŋVbvij
	p_input_parser->keyin_force_shop = 0;
	if (GetAsyncKeyState('S')) {
		if (p_stage_context->stage_mode == STAGE_MODE_NORMAL) {
			p_input_parser->keyin_force_shop = 1;
		}
	}

	// GŋQ[I[o[ij
	p_input_parser->keyin_force_over = 0;
	if (GetAsyncKeyState('G')) {
		if (p_stage_context->stage_mode == STAGE_MODE_NORMAL) {
			p_input_parser->keyin_force_over = 1;
		}
	}

	// -----< L[͔ >-----
	//
	// tXN[[h̐؂ւ
	if (
		(GetAsyncKeyState(VK_MENU) & 0x8000)
		&& (GetAsyncKeyState(VK_RETURN) & 0x8000)
		&& (p_input_parser->keyin_toggle_fullscreen==0)
		) {
		// gÕtO𗧂Ă
		p_input_parser->keyin_toggle_fullscreen = 1;
	}
	else {
		// L[ꂽԂZbg
		p_input_parser->keyin_toggle_fullscreen = 0;
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int input_recorder_open()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		͏̋L^EĐJn܂B
//		Windows REPLAY_MODE ݒ肳Ăꍇɋ@\܂B
//			0 : Ȃ
//			1 : L^
//			2 : Đ
//--------------------------------------------------------------------
int input_recorder_open()
{
	char filename[_MAX_PATH];
	int result;
	CKonConfParser* pConf = CKonConfParser::GetInstance();

	// Z[u
	if (pConf->m_iReplayMode == 1) {
		if (g_objDIControl.IsOnSave() == FALSE) {
			// SAVE_HEADERɕۑĂ
			stash_save_header(&save_header);
			stash_state = 1;
			// L^Jn
			result = make_continuous_filename(filename, "InputData", INPUTDATA_FILENAME, "dat");
			if (result == 0) {
				_mkdir("InputData");
			}
			g_objDIControl.StartToSave(filename);
		}
	}

	// [h
	if (pConf->m_iReplayMode == 2) {
		if (g_objDIControl.IsOnLoad() == FALSE) {
			// SAVE_HEADERɕۑĂ
			stash_save_header(&save_header);
			stash_state = 1;

			// wb_ǂݍ
			sprintf(filename, "%s.dat", INPUTDATA_FILENAME);
			FILE* fn = fopen(filename, "rb");
			if (fn == NULL) {
				return -1;
			}
			SAVE_HEADER sh;
			fread(&sh, sizeof(SAVE_HEADER), 1, fn);
			fclose(fn);

			// wb_̓eKp
			result = restore_save_header(&sh);

			// wb_̓eȂ΃[hJn
			if (result == 0) {
				// [hJn
				g_objDIControl.StartToLoad(filename, sizeof(SAVE_HEADER));
			}
			else {
				// o[WႢȂǂŃ[hłȂ
				restore_save_header(&save_header);
				g_objDebugLog.ErrorLog("͋L^̃o[WقȂ܂BvO:%d.%d%d, f[^:%d.%d%d\n"
					, VERSION_0, VERSION_1, VERSION_2
					, sh.version[0], sh.version[1], sh.version[2]
				);
				stash_state = 0;
				// [hs\Ȃ̂Őݒ߂
				pConf->m_iReplayMode = 0;
			}
		}
	}

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int input_recorder_close()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		͏̋L^EĐ~܂B
//		WindowsŎsĂꍇ̂݋@\܂B
//--------------------------------------------------------------------
int input_recorder_close()
{
	CKonConfParser* pConf = CKonConfParser::GetInstance();

	// Z[uȂwb_ƈꏏɕۑ
	if (pConf->m_iReplayMode == 1) {
		if ((g_objDIControl.IsOnSave()) && (stash_state == 1)) {
			g_objDIControl.CloseFile((char*)(&save_header), sizeof(SAVE_HEADER));
		}
		//
		stash_state = 0;
	}

	// [hȂďԕA
	if (pConf->m_iReplayMode == 2) {
		if (g_objDIControl.IsOnLoad()) {
			// 
			g_objDIControl.CloseFile();
		}
		// ԕA
		if (stash_state == 1) {
			restore_save_header(&save_header);
			stash_state = 0;
		}
	}

	// I
	return 0;
}

//=============================================================================
// ݂̏ԂSAVE_HEADEȐ\z
//=============================================================================
void stash_save_header(SAVE_HEADER* save_header)
{
	// SAVE_HEADERɕۑ
	memset(save_header, 0, sizeof(SAVE_HEADER));
	// o[WL^
	save_header->version[0] = VERSION_0;
	save_header->version[1] = VERSION_1;
	save_header->version[2] = VERSION_2;
	save_header->version[3] = 0;
	// ̑L^
	save_header->vrand_index = vrand_index;
	save_header->game_properties = *p_game_properties;
	save_header->trigger_semantics = g_objDIControl.m_sSemantics;
	save_header->xvi_mode = startup_param.XVI;
}

//=============================================================================
// SAVE_HEADEȐ񂩂Ԃ𕜌
//   0:  -1:o[WႢ
//=============================================================================
int restore_save_header(SAVE_HEADER* save_header)
{
	if (stash_state != 1) {
		return 0;
	}
	// SAVE_HEADER畜A
	vrand_index = save_header->vrand_index;
	*p_game_properties = save_header->game_properties;
	g_objDIControl.m_sSemantics = save_header->trigger_semantics;
	startup_param.XVI = save_header->xvi_mode;

	// o[WmF
	if (
		(save_header->version[0] != VERSION_0)
		|| (save_header->version[1] != VERSION_1)
		|| (save_header->version[2] != VERSION_2)
		|| (save_header->version[3] != 0)
		) {
		return -1;
	}
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int system_post_vsync()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		VSYNC荞݂̂ƂɎs鏈
//--------------------------------------------------------------------
int system_post_vsync() {
	int iRes;

	// bZ[W
	MSG			msg;								// Window bZ[W
	memset(&msg, 0, sizeof(msg));

	// <<< WindowsbZ[W̏ >>>
	iRes = ProcessMessage();
	if (iRes != 0) {
		//kon_log("system_post_vsync : ProcessMessage()0ȊOԂ܂BvOI܂BiRes=%d\n", iRes);
		p_application_context->quit_requested = 1;
		return -1;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void save_all_clear_log()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		I[NÃOL^
//--------------------------------------------------------------------
void save_all_clear_log(void* pTim)
{
	char clear_log_path[_MAX_PATH];
	int dir_exists;
	const char* dir_path = "./ClearLog";
	int length;

	// vC̓OcȂ
	CKonConfParser* pConf = CKonConfParser::GetInstance();
	if (pConf->m_iReplayMode == 2) {
		// Đ̏ꍇ̓XLbv
		return;
	}

	// -----< Oۑ >-----
	//
	// ۑ̃pX
	dir_exists = make_continuous_filename(	//
		clear_log_path
		, dir_path
		, "ClearLog"
		, "log"
	);
	if (dir_exists == -1) {
		kon_log("[ERROR] save_all_clear_log : XN[Vbg̕ۑtpX𐶐ł܂łB\n");
		return;
	}

	// fBNg
	if (dir_exists == 0) {
		_mkdir(dir_path);
	}

	// Oۑ
	save_all_clear_log_file(clear_log_path, pTim);

	// -----< eLXgۑ >-----
	//
	// ۑ̃pX̊gqu
	length = strlen(clear_log_path);
	clear_log_path[length - 3] = 'p';
	clear_log_path[length - 2] = 'n';
	clear_log_path[length - 1] = 'g';

	// XN[Vbgۑ
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	int saveResult;
	saveResult = SaveDrawScreenToPNG(
		0
		, 0
		, pScreenMode->GetScreenWidth()
		, pScreenMode->GetScreenHeight()
		, clear_log_path
		, 0
	);
}


//--------------------------------------------------------------------
//	[  ]
//		int open_score_log()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		XRAOt@C̏o͏s܂B
//--------------------------------------------------------------------
void open_score_log() {
	char filename[_MAX_PATH];
	int result;

	// t@CɊJĂꍇ́AU
	if (score_log_fn != NULL) {
		fclose(score_log_fn);
	}

	// t@C
	result = make_continuous_filename(filename, "ScoreLog", "score_log", "csv");
	if (result == 0) {
		_mkdir("ScoreLog");
	}

	// t@CJ
	score_log_fn = fopen(filename, "wt");
	if (score_log_fn == NULL) {
		printf("open_score_log : t@CJ܂łB[%s]\n", filename);
		return;
	}

	// wb_Ă
	fprintf(score_log_fn, "Mes,frame_count,stage_count,stage,section,socre,point,left,hp,mp,combo_lv,timelimit,lv_blade,lv_magic,lv_charge,bomb_charge,time_bonus,hp_bonus\n");

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void score_log(const char* pMes
//					, int frame_count
//					, int stage_count
//					, int stage
//					, int section
//					, int socre
//					, int point
//					, int left
//					, int hp
//					, int mp
//					, int combo_lv
//					, int timelimit
//					, int lv_blade
//					, int lv_magic
//					, int lv_charge
//					, int bomb_charge
//					, int time_bonus
//					, int hp_bonus)
//
//	[  ]
//		const char* pMes	ObZ[W
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RÃXRAOo͂܂B
//		o͐́AvbgtH[rh̏ɂقȂ܂B
//--------------------------------------------------------------------
void score_log(const char* pMes
	, int frame_count
	, int stage_count
	, int stage
	, int section
	, int socre
	, int point
	, int left
	, int hp
	, int mp
	, int combo_lv
	, int timelimit
	, int lv_blade
	, int lv_magic
	, int lv_charge
	, int bomb_charge
	, int time_bonus
	, int hp_bonus
) {
	// OI[vĂȂꍇ́Â܂ܕԂ
	if (score_log_fn == NULL) {
		return;
	}

	// Oo
	fprintf(score_log_fn
		, "%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n"
		, pMes
		, frame_count
		, stage_count
		, stage
		, section
		, socre
		, point
		, left
		, hp
		, mp
		, combo_lv
		, timelimit
		, lv_blade
		, lv_magic
		, lv_charge
		, bomb_charge
		, time_bonus
		, hp_bonus
	);

	// tbV
	fflush(score_log_fn);
}


//--------------------------------------------------------------------
//	[  ]
//		void close_score_log()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Ot@C܂
//--------------------------------------------------------------------
void close_score_log() {
	if (score_log_fn != NULL) {
		fclose(score_log_fn);
	}
	score_log_fn = NULL;
	return;
}

//--------------------------------------------------------------------
//	[  ]
//		int check_dir_exists(const char* dir_path)
//
//	[  ]
//		const char* dir_path    fBNgւ̃pX
//
//	[ ߂l ]
//		0:݂Ȃ
//      1:݂
//
//	[  ]
//		w̃pX̃fBNg݂邩ۂ𔻒肷
//--------------------------------------------------------------------
int check_dir_exists(const char* dir_path)
{
	int result;
	struct stat st;
	int dir_exists = 0;

	// fBNg݊mF
	result = stat(dir_path, &st);
	//kon_log("dir_path = %s\n", dir_path);
	//kon_log("result=%d, st_mode=%08X\n", result, st.st_mode);
	if ((result == 0) && ((st.st_mode & 0040000) != 0)) {
		// ݂
		dir_exists = 1;
	}
	else {
		dir_exists = 0;
	}

	// ʂԂ
	return dir_exists;
}
