#include <sys/stat.h>

extern "C" {
#include "../../devs.h"
#include "../../../core/game_context.h"
#include "../../../core/stage.h"
#include "../../../core/kon_util.h"
}

#include "DGControl.h"
#include "DShowControl.h"
//#include "SoundUnit.h"
#include "ScreenMode.h"
#include "Utils.h"
#include "Str.h"
#include "DevsContextWin.h"
#include "resource.h"

//=================================
// vg^Cv錾
//=================================
// SP/PALǂݍݏ
int load_sp(const char* filename, int startSPIndex, int spCount, int startBGIndex, int bgCount, int palBlock = 0);
int load_sp_allpal(const char* filename, int startSPIndex, int spCount, int startBGIndex, int bgCount);
//
// PCG]
int load_transsp(const char* filename, int slot, int palblock, int with_bg);	// ]SPǂݍ
int load_transsp_all(const char* filename, int slot, int with_bg);			// ]SPǂݍ
//
// SOUND֘A
void load_bgms(int bgm_index);
void load_se_context();
void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int priority, int frames, int same_priority_wait);
void attach_se_item(SE_ITEM* pSEItem, int index, int priority, int frames, int same_priority_wait);
//void release_sound_context();
// 
// ̑
CGStr fullpath(const char* dir, const char* filename);

//--------------------------------------------------------------------
//	[  ]
//		int resource_load_title()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		^Cgʌ̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_title() {
	int i;
	int result;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// XvCg̃P[V
	for (i = 0; i < 128; i++) {
		p_memory_map_buffer->sp_unit[i].x = 0;
		p_memory_map_buffer->sp_unit[i].y = 0;
	}

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\title\\SPBG_TTL.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("resource_load_st1 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< GRP̓ǂݍ >-----
	//
	int grpTextureIndex[2];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\title\\title0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\title\\title1_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0)) {
		kon_log("[ERROR] resource_load_title : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[2];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0)) {
		kon_log("[ERROR] resource_load_title : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_title : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[0];
	pContext->m_grpIndexMap[2] = grpIndex[1];
	pContext->m_grpIndexMap[3] = grpIndex[1];

	// <<< TEXTiHELPj >>>
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\title\\HELP_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_title : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_title : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_title : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_title);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_ending()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		GfBÕ\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_ending() {
	BOOL bRes;
	int result;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO


	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\ed\\SPBG_ED.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_ed : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< eLXg̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\ed\\ED_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_ending : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_ending : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_ending : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// -----< GRP̓ǂݍ >-----
	//
	int grpTextureIndex[1];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\ed\\TRANS_F.bmp", 0x00000000, TRUE);
	if (grpTextureIndex[0] < 0) {
		kon_log("[ERROR] resource_load_ending : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[1];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	if (grpIndex[0] < 0) {
		kon_log("[ERROR] resource_load_ending : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_ending : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_ending);

	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st1()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W1̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st1() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st1\\SPBG_ST1.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st1 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st1 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st1\\BG_ST1_T.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st1 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st1\\BOSS1.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st1 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st1\\BG_ST1.mdt"
		, "resources\\Win\\st1\\BG_ST1_PWM.pwm"
		, 0
		, def_stage_bg_size[0][0]
		, def_stage_bg_size[0][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st1 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st1\\TXT1_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st1 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st1 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st1 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st1 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st1 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st1 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st1);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st2()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W2̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st2() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st2\\SPBG_ST2.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st2 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st2 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st2\\BG_ST2_T.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st2 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st2\\BOSS2.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st2 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st2\\BG_ST2.mdt"
		, "resources\\Win\\st2\\BG_ST2_PWM.pwm"
		, 0
		, def_stage_bg_size[1][0]
		, def_stage_bg_size[1][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st2 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st2\\TXT2_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st2 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st2 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st2 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st2 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st2 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st2 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st2);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st3()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W3̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st3() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st3\\SPBG_ST3.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st3\\SPBG_ST3_ANIM.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// GL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st3\\SPBG_EN3.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : Gp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->ene_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st3\\BOSS3.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st3\\BG_ST3.mdt"
		, "resources\\Win\\st3\\BG_ST3_PWM.pwm"
		, 0
		, def_stage_bg_size[2][0]
		, def_stage_bg_size[2][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st3 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st3\\TXT3_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st3 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st3 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st3 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st3 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st3 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st3 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st3);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st4()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W4̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st4() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st4\\SPBG_ST4.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st4 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st4 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st4\\SPBG_ST4_ANIM.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st4 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st4\\BOSS4.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st4 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st4\\BG_ST4.mdt"
		, "resources\\Win\\st4\\BG_ST4_PWM.pwm"
		, 0
		, def_stage_bg_size[3][0]
		, def_stage_bg_size[3][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st4 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st4\\TXT4_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st4 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st4 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st4 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st4 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st4 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st4 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st4);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st5()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W5̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st5() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st5\\SPBG_ST5.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st5\\SPBG_ST5_ANIM.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// GL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st5\\SPBG_EN5.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : Gp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->ene_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st5\\BOSS5.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st5\\BG_ST5.mdt"
		, "resources\\Win\\st5\\BG_ST5_PWM.pwm"
		, 0
		, def_stage_bg_size[4][0]
		, def_stage_bg_size[4][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st5 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st5\\TXT5_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st5 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st5 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st5 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st5 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st5 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st5 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st5);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_st6()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W6̃\[Xǂݍ݂܂
//--------------------------------------------------------------------
int resource_load_st6() {
	int result;
	int slot;
	BOOL bRes;

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();
	pContext->initialize();	// }bsO

	// ܂}XNŉBԂɂ
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;

	// -----< SP/BGǂݍ >-----
	//
	result = load_sp_allpal("resources\\Win\\st6\\SPBG_ST6.bmp", 0, 256, 0, 256);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st6 : SP/BG`̉摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< SP̃p^[p̃LN^摜ǂݍ >-----
	//
	memset(&(pContext->tpcg_buffer), 0, sizeof(TPCG_BUFFER));
	// L
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\common\\JIKI.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st6 : p^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->jiki_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// BGAjp^[
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st6\\SPBG_ST6_ANIM.bmp", slot, 1);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st6 : BGp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->bgmap_anim_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// {XL
	slot = pContext->tpcg_buffer.tsp_read_count;
	result = load_transsp_all("resources\\Win\\st6\\BOSS6.bmp", slot, 0);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st6 : {Xp^[p̃LN^摜ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	p_stage_context->boss_sp_slot = slot;
	pContext->tpcg_buffer.tsp_read_count++;

	// -----< BG̃}bv`ǂݍ >-----
	//
	result = load_bgmap(
		"resources\\Win\\st6\\BG_ST6.mdt"
		, "resources\\Win\\st6\\BG_ST6_PWM.pwm"
		, 0
		, def_stage_bg_size[5][0]
		, def_stage_bg_size[5][1]
		, 1
	);
	if (result != 0) {
		kon_log("[ERROR] resource_load_st6 : BG}bv̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}

	// -----< wiOtBbN̓ǂݍ >-----
	//
	int txtTextureIndex = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\st6\\TXT6_F.bmp", 0x00000000, TRUE);
	if (txtTextureIndex < 0) {
		kon_log("[ERROR] resource_load_st6 : TXT̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int txtIndex = pDGControl->AddGraphic(NULL, txtTextureIndex);
	if (txtIndex < 0) {
		kon_log("[ERROR] resource_load_st6 : TXT̓o^Ɏs܂B\n");
		return -1;
	}
	RECT rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(txtIndex, rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st6 : TXT̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// TXT̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_txtIndexMap = txtIndex;

	// pbg]̐ݒNOPƂď
	p_stage_context->text_pal_slot = -1;
	p_stage_context->text_pal_block = -1;
	p_stage_context->shop_pal_block = -1;
	p_stage_context->int_pal_block = -1;

	// -----< GRP̃t[̓ǂݍ >-----
	//
	int grpTextureIndex[4];
	grpTextureIndex[0] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME0_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[1] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME1_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[2] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME2_F.bmp", 0x00000000, TRUE);
	grpTextureIndex[3] = pDGControl->AddTextureForGraphic(NULL, "resources\\Win\\common\\FRAME3_F.bmp", 0x00000000, TRUE);
	if ((grpTextureIndex[0] < 0) || (grpTextureIndex[1] < 0) || (grpTextureIndex[2] < 0) || (grpTextureIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st6 : GRP̓ǂݍ݂Ɏs܂B\n");
		return -1;
	}
	int grpIndex[4];
	grpIndex[0] = pDGControl->AddGraphic(NULL, grpTextureIndex[0]);
	grpIndex[1] = pDGControl->AddGraphic(NULL, grpTextureIndex[1]);
	grpIndex[2] = pDGControl->AddGraphic(NULL, grpTextureIndex[2]);
	grpIndex[3] = pDGControl->AddGraphic(NULL, grpTextureIndex[3]);
	if ((grpIndex[0] < 0) || (grpIndex[1] < 0) || (grpIndex[2] < 0) || (grpIndex[3] < 0)) {
		kon_log("[ERROR] resource_load_st6 : GRP̓o^Ɏs܂B\n");
		return -1;
	}
	rect = { 0 ,0, pScreenMode->GetScreenWidth() - 1, pScreenMode->GetScreenHeight() - 1 };
	bRes = pDGControl->SetGraphicView(grpIndex[0], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[1], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[2], rect);
	bRes &= pDGControl->SetGraphicView(grpIndex[3], rect);
	if (bRes == FALSE) {
		kon_log("[ERROR] resource_load_st6 : GRP̃r[|[gݒɎs܂B\n");
		return -1;
	}
	// GRP̃y[WԍƃCfbNXԍ̃}bvo^
	pContext->m_grpIndexMap[0] = grpIndex[0];
	pContext->m_grpIndexMap[1] = grpIndex[1];
	pContext->m_grpIndexMap[2] = grpIndex[2];
	pContext->m_grpIndexMap[3] = grpIndex[3];

	// -----< ̓ǂݍ >-----
	//
	// BGM
	load_bgms(bgmindex_st6);
	// SEǂݍ
	load_se_context();

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_release_stage()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		Xe[W̃\[X܂
//--------------------------------------------------------------------
int resource_release_stage() {
	CDGControl* pDGControl = CDGControl::GetInstance();
	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	CDevsContextWin* pDevsContextWin = CDevsContextWin::GetInstance();

	// \[X
	pDShowControl->StopAllMedia();
	pDShowControl->StopAllSE();
	pDShowControl->ReleaseMedias();
	pDShowControl->ReleaseSEs();
	memset(p_sound_context, 0, sizeof(SOUND_CONTEXT));

	// ʌñ\[X
	pDGControl->ReleaseItems();

	// }bsO
	pDevsContextWin->initialize();

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_load_bgm_single(int zmd_index, char* filepath)
//
//	[  ]
//		int zmd_index			X68000ŗLBZMD̓ǂݍݐobt@CfbNX
//		char* filepath	\[Xt@Cւ̃tpX
//
//	[ ߂l ]
//		Fǉ\[X̃CfbNXԍ
//		sF-1
//
//	[  ]
//		BGM̃\[X1Ȃ荞݂܂
//--------------------------------------------------------------------
int resource_load_bgm_single(int zmd_index, char* filepath)
{
	int index;
	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	CDevsContextWin* pDevsContext = CDevsContextWin::GetInstance();

	index = pDShowControl->AddAudio(filepath, pDevsContext->m_iBGMVolume, TRUE);
	return index;
}


//--------------------------------------------------------------------
//	[  ]
//		int resource_release_bgm_single(int index)
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		BGM̃\[X
//--------------------------------------------------------------------
int resource_release_bgm_single(int index)
{
	BOOL bRes;
	CDShowControl* pDShowControl = CDShowControl::GetInstance();

	bRes = pDShowControl->StopAllMedia();
	if (!bRes) {
		kon_log("resource_release_bgm_single : Đ~Ɏs܂B\n");
		return -1;
	}

	bRes = pDShowControl->ReleaseMedia(index);
	if (!bRes) {
		kon_log("resource_release_bgm_single : fBÃ[XɎs܂Bindex=%d\n", index);
		return -1;
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		void load_bgms(int bgm_index);
//
//	[  ]
//		int stage_index	BGM̃CfbNX
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		w̃t@CpXBGM\[Xǂݍ݁ASOUND_CONTEXT
//		f܂B
//--------------------------------------------------------------------
void load_bgms(int bgm_index)
{
	int i;
	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	CDevsContextWin* pDevsContext = CDevsContextWin::GetInstance();

	// <<< OɑSJ >>>
	pDShowControl->StopAllMedia();
	pDShowControl->ReleaseMedias();

	// <<< ǂݍ >>>
	for (i = 0; i < (bgmtype_count + MAX_SECTION); i++) {
		// ݒ肪Ȃ΃XLbv
		if (resource_conf.bgm[bgm_index][i] == NULL) {
			p_sound_context->bgm_index[i] = SOUND_NULL; // `Ȃ̔ԍ
			continue;
		}

		// "SILENT"~w
		if (strcmp(SOUND_SILENT_WORD, resource_conf.bgm[bgm_index][i]) == 0) {
			p_sound_context->bgm_index[i] = SOUND_SILENT; // ~w̔ԍ
			continue;
		}

		// t@C̃tpX
		CGStr fullPath = fullpath(resource_conf.dir_bgm, resource_conf.bgm[bgm_index][i]).GetString();

		// ǂݍ
		p_sound_context->bgm_index[i] = pDShowControl->AddAudio(fullPath.GetString(), pDevsContext->m_iBGMVolume, TRUE);
		if (p_sound_context->bgm_index[i] < 0) {
			kon_log("load_bgms : BGM̓ǂݍ݂Ɏs܂BPath=%s\n", fullPath);
		}
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int priority, int frames, int same_priority_wait)
//
//	[  ]
//		SE_ITEM* pSEItem
//		char* pFilepath
//		int priority
//		int frames
//		int same_priority_wait
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		pFilepatȟʉǂݍ݁Aw肵SE_ITEM̍\̂ɑݒ肵܂B
//--------------------------------------------------------------------
void load_se_item(SE_ITEM* pSEItem, char* pFilepath, int priority, int frames, int same_priority_wait)
{
	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	CDevsContextWin* pDevsContext = CDevsContextWin::GetInstance();

	pSEItem->index = pDShowControl->AddSE(pFilepath, pDevsContext->m_iSEVolume, 0);
	attach_se_item(pSEItem, pSEItem->index, priority, frames, same_priority_wait);
}


//--------------------------------------------------------------------
//	[  ]
//		void attach_se_item(SE_ITEM* pSEItem, int index, int XVI, int priority, int frames, int same_priority_wait)
//
//	[  ]
//		SE_ITEM* pSEItem
//		int index
//		int priority
//		int frames
//		int same_priority_wait
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ǂݍݍςPCMgāAw肵SE_ITEM̍\̂ɑݒ肵܂B
//--------------------------------------------------------------------
void attach_se_item(SE_ITEM* pSEItem, int index, int priority, int frames, int same_priority_wait)
{
//	CGSoundUnit* pSoundUnit = CGSoundUnit::GetInstance();
	pSEItem->index = index;
	pSEItem->priority = priority;
	pSEItem->frames = frames;
	pSEItem->same_priority_wait = same_priority_wait;
	//
	// L
	pSEItem->valid = 1;
}


//--------------------------------------------------------------------
//	[  ]
//		void load_se_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SE܂Ƃ߂ēǂݍSOUND_CONTEXTɌʂ𔽉f܂
//--------------------------------------------------------------------
void load_se_context()
{
	int i;
	//CGSoundUnit* pSoundUnit = CGSoundUnit::GetInstance();
	CDShowControl* pDShowControl = CDShowControl::GetInstance();

	// USJ
	pDShowControl->ReleaseSEs();
	for (i = 0; i < setype_count; i++) {
		memset(&(p_sound_context->se_item[i]), 0, sizeof(SE_ITEM));
	}

	// ʉǂݍ݁iREFȊOj
	for (i = 0; i < setype_count; i++) {
		// ݒ肪ꍇ̓XLbv
		if (resource_conf.se[i].filename == NULL) {
			continue;
		}
		// REFŎn܂ꍇ̓XLbv
		CGStr filename;
		filename = resource_conf.se[i].filename;
		if (filename.IsHead("ref:") == TRUE) {
			continue;
		}

		// t@C荞
		CGStr filePath;
		filePath = fullpath(resource_conf.dir_se, resource_conf.se[i].filename);
		load_se_item(&(p_sound_context->se_item[i])
			, (char*)(filePath.GetString())
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
		);
		/*
		kon_log("SE loaded [%d] : (%s, %d, %d, %d)\n"
			, i
			, filePath.GetString()
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
		);
		*/
	}

	// ʉREF
	for (i = 0; i < setype_count; i++) {
		// t@CȂꍇ̓XLbv
		if (resource_conf.se[i].filename == NULL) {
			continue;
		}
		// REFȊO̓XLbv
		CGStr filename;
		filename = resource_conf.se[i].filename;
		if (filename.IsHead("ref:") == FALSE) {
			continue;
		}

		// N
		int seindex = to_seindex(resource_conf.se[i].filename + 4);
		if (seindex < 0) {
			kon_log("[ERROR] sȌʉw肳܂Bkey=[%s]\n", resource_conf.se[i].filename + 4);
			continue;
		}
		
		// N悪̏ꍇ̓G[
		if (p_sound_context->se_item[seindex].valid == 0) {
			kon_log("[ERROR] QƐ̌ʉݒ肳Ă܂BQƐF%s\n", filename);
			continue;
		}

		attach_se_item(&(p_sound_context->se_item[i])
			, p_sound_context->se_item[seindex].index
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
		);
		/*
		kon_log("SE Attached [%d] : (%d, %d, %d, %d)\n"
			, i
			, p_sound_context->se_item[seindex].index
			, resource_conf.se[i].priority
			, resource_conf.se[i].frames
			, resource_conf.se[i].same_priority_wait
		);
		*/
	}

	// ǂݍݍ
	p_sound_context->se_already_read = 1;
}


//--------------------------------------------------------------------
//	[  ]
//		void release_sound_context()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SE܂Ƃ߂ĉSOUND_CONTEXTɌʂ𔽉f܂
//--------------------------------------------------------------------
void release_sound_context()
{
	// WAVE
	//CGSoundUnit* pSoundUnit = CGSoundUnit::GetInstance();
	//pSoundUnit->StopAll();
	//pSoundUnit->ReleaseWave();

	CDShowControl* pDShowControl = CDShowControl::GetInstance();
	pDShowControl->StopAllSE();
	pDShowControl->ReleaseSEs();

	// ReLXg̓eNA
	memset(p_sound_context, 0, sizeof(SOUND_CONTEXT));
}


//--------------------------------------------------------------------
//	[  ]
//		int load_sp(const char* filename, int startSPIndex, int spCount, int startBGIndex)
//
//	[  ]
//		const char* filename	ǂݍރp^[f[^̉摜t@C
//		int startSPIndex		SP̓ǂݍݐCfbNXԍ
//		int spCount				ǂݍSP̐
//		int startBGIndex		BG`̊JnCfbNXԍ
//		int bgCount				`BG̐iǂݍ܂Ȃꍇ0ȉwj
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		SP̃p^[f[^ǂݍ݂܂B
//		w肷摜́i2n~2nj̐`̉摜łKv܂B
//		ォEɌāAspCount̃XvCg̒`startSPIndex
//		̗̈ɓǂݍ݂܂B
//		startBGIndexw肷ƁAǂݍSP`ɂBGPCGf[^
//		ƂĂǂݍ݂܂B
//--------------------------------------------------------------------
int load_sp_allpal(const char* filename, int startSPIndex, int spCount, int startBGIndex, int bgCount)
{
	int result;

	// BMP̃t@C̍Ō .BMP 
	CGStr basename;
	basename = filename;
	basename.DeleteLastStr(".bmp");
	basename.DeleteLastStr(".BMP");
	basename.DeleteLastStr(".Bmp");

	// Cǂݍ
	result = load_sp(filename, startSPIndex, spCount, startBGIndex, bgCount, 0);
	if (result != 0) {
		kon_log("[ERROR] load_sp_allpal : t@C[%s]̓ǂݍ݂Ɏs܂B\n", filename);
		return -1;
	}

	// ׂẴpbgɂēǂݍ
	for (int i = 1; i <= 15; i++) {
		char fname[256];
		sprintf(fname, "%s_%02d.bmp", basename.GetString(), i);
		
		result = load_sp(fname, startSPIndex, spCount, startBGIndex, bgCount, i);
		if (result != 0) {
			kon_log("[ERROR] load_sp_allpal : t@C[%s]̓ǂݍ݂Ɏs܂B\n", fname);
			// G[oƂĂ̂܂ܑ
		}
	}

	// I
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int load_sp(const char* filename, int startSPIndex, int spCount, int startBGIndex)
//
//	[  ]
//		const char* filename	ǂݍރp^[f[^̉摜t@C
//		int startSPIndex		SP̓ǂݍݐCfbNXԍ
//		int spCount				ǂݍSP̐
//		int startBGIndex		BG`̊JnCfbNXԍ
//		int bgCount				`BG̐iǂݍ܂Ȃꍇ0ȉwj
//		int palBlock			pbgubNi1`15j
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		SP̃p^[f[^ǂݍ݂܂B
//		w肷摜́i2n~2nj̐`̉摜łKv܂B
//		ォEɌāAspCount̃XvCg̒`startSPIndex
//		̗̈ɓǂݍ݂܂B
//		startBGIndexw肷ƁAǂݍSP`ɂBGPCGf[^
//		ƂĂǂݍ݂܂B
//--------------------------------------------------------------------
int load_sp(const char* filename, int startSPIndex, int spCount, int startBGIndex, int bgCount, int palBlock)
{
	if ((palBlock >= 16) || (palBlock < 0)) {
		kon_log("[ERROR] palBlockɕsȒlw肳܂BpalBLock = %d\n", palBlock);
		return -1;
	}

	// 摜\[Xǂݍ
	CDGControl* pDGControl = CDGControl::GetInstance();
	//CGScreenMode* pScreenMode = CGScreenMode::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();

	// eNX`ǂݍ
	long textureId = pDGControl->AddTextureForSprite(NULL, filename, 0x00000000, TRUE);
	long meshSizeX = pDGControl->GetTextureWidth(textureId) / 16;
	long meshSizeY = pDGControl->GetTextureHeight(textureId) / 16;

	// pbgubN̓ǂݍݏԂXV
	pContext->m_palBlockRead[palBlock] = TRUE;

	// XvCgo^
	int spReadCount = 0;
	for (int y = 0; y < meshSizeY; y++) {
		for (int x = 0; x < meshSizeX; x++) {
			// DGControlSPo^
			int spIndex = pDGControl->AddSprite(NULL, textureId);

			pDGControl->SetSpriteRect(spIndex, x * 16, y * 16, (x * 16) + 15, (y * 16) + 15);
			pDGControl->SetSpriteCenter(spIndex, 16, 16);

			// }bvobt@SPR[hSP̃CfbNXɃ}bv
			pContext->m_spIndexMap[palBlock][startSPIndex + ((y * 16) + x)] = spIndex;
			spReadCount += 1;
			if (spReadCount >= spCount) { break; }
		}
		if (spReadCount >= spCount) { break; }
	}

	// BG`ȂȂ炱ŏI
	if (bgCount <= 0) {
		return 0;
	}

	// BG̃p^[o^
	int bgIndex = startBGIndex;
	int spIndex = 0;
	int bgReadCount = 0;
	for (int y = 0; y < min(4, meshSizeY); y++) {
		for (int x = 0; x < meshSizeX; x++) {
			// code 0
			spIndex = pDGControl->AddSprite(NULL, textureId);
			pDGControl->SetSpriteRect(spIndex, x * 16, y * 16, (x * 16) + 8 - 1, (y * 16) + 8 - 1);
			pContext->m_bgIndexMap[palBlock][bgIndex++] = spIndex;
			bgReadCount++;
			if (bgReadCount >= bgCount) { break; }

			// code 1
			spIndex = pDGControl->AddSprite(NULL, textureId);
			pDGControl->SetSpriteRect(spIndex, x * 16, (y * 16) + 8, (x * 16) + 8 - 1, ((y * 16) + 8) + 8 - 1);
			pContext->m_bgIndexMap[palBlock][bgIndex++] = spIndex;
			bgReadCount++;
			if (bgReadCount >= bgCount) { break; }

			// code 2
			spIndex = pDGControl->AddSprite(NULL, textureId);
			pDGControl->SetSpriteRect(spIndex, (x * 16) + 8, y * 16, ((x * 16) + 8) + 8 - 1, (y * 16) + 8 - 1);
			pContext->m_bgIndexMap[palBlock][bgIndex++] = spIndex;
			bgReadCount++;
			if (bgReadCount >= bgCount) { break; }

			// code 3
			spIndex = pDGControl->AddSprite(NULL, textureId);
			pDGControl->SetSpriteRect(spIndex, (x * 16) + 8, (y * 16) + 8, ((x * 16) + 8) + 8 - 1, ((y * 16) + 8) + 8 - 1);
			pContext->m_bgIndexMap[palBlock][bgIndex++] = spIndex;
			bgReadCount++;
			if (bgReadCount >= bgCount) { break; }

			// SPǉ
			spReadCount += 1;
		}
		if (bgReadCount >= bgCount) { break; }
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int load_transsp(const char* filename, int slot, int palblock, int with_bg)
//
//	[  ]
//		const char* filename	ǂݍރp^[f[^̉摜t@C
//		int slot				Xbgԍ
//		int palblock			pbgubNԍi0`15j
//		int with_bg				BGp^[WJꍇ1w
//
//	[ ߂l ]
//		F0
//		sF-1
//
//	[  ]
//		PCG]p̃p^[f[^ǂݍ݂܂B
//		w肷摜́i2n~2nj̐`̉摜łKv܂B
//		palblock̓XvCg̃pbgubNɑΉ܂B
//		palblock0̓ftHg̒`ŁAỸpbgubN
//		f[^ȂƂɎgXvCg̒`ƂĎ舵܂B
//--------------------------------------------------------------------
int load_transsp(const char* filename, int slot, int palblock, int with_bg) {
	CDGControl* pDGControl = CDGControl::GetInstance();
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();

	// eNX`ǂݍ
	int textureId = pDGControl->AddTextureForSprite(NULL, filename, 0x00000000, TRUE);
	if (textureId < 0) {
		kon_log("[ERROR] load_transsp : PCG]p̃p^[f[^̓ǂݍ݂Ɏs܂B[%s]\n", filename);
		return -1;
	}

	// eNX`̃TCY𓾂
	long textureWidth = pDGControl->GetTextureWidth(textureId);
	long textureHeight = pDGControl->GetTextureHeight(textureId);
	long spCountX = textureWidth / 16;
	long spCountY = textureHeight / 16;

	// eNX`摜ɂ16x16̃TCYŃp^[o^
	for (int y = 0; y < spCountY; y++) {
		for (int x = 0; x < spCountX; x++) {
			int spBuffIndex = (y * spCountX) + x;
			if (spBuffIndex >= 256) {
				kon_log("[ERROR] load_transsp : ]pLN^f[^̃p^[ől256𒴂܂B\n");
				return -1;
			}

			TPCG_BUFFER* pBuffer = &(pContext->tpcg_buffer);
			{
				// <<< SPo^ >>>
				int spIndex = pDGControl->AddSprite(NULL, textureId);
				if (spIndex < 0) {
					kon_log("[ERROR] load_transsp : SP̓o^Ɏs܂B\n");
					return -1;
				}
				pDGControl->SetSpriteRect(spIndex, x * 16, y * 16, (x * 16) + 15, (y * 16) + 15);
				pDGControl->SetSpriteCenter(spIndex, 16, 16);

				// }bvɓo^
				pBuffer->tsp_buff[slot][palblock][spBuffIndex] = spIndex;
			}
			if (with_bg) {
				// <<< BGo^ >>>
				int bgBuffIndex = spBuffIndex * 4;
				int bgIndex = -1;

				// 0
				if (bgBuffIndex < TRANSBG_MAXSIZE) {
					bgIndex = pDGControl->AddSprite(NULL, textureId);
					pDGControl->SetSpriteRect(bgIndex, (x * 16), (y * 16), (x * 16) + 7, (y * 16) + 7);
					pBuffer->tbg_buff[slot][palblock][bgBuffIndex] = bgIndex;
				}
				bgBuffIndex += 1;

				// 1
				if (bgBuffIndex < TRANSBG_MAXSIZE) {
					bgIndex = pDGControl->AddSprite(NULL, textureId);
					pDGControl->SetSpriteRect(bgIndex, (x * 16), (y * 16)+8, (x * 16) + 7, (y * 16) + 15);
					pBuffer->tbg_buff[slot][palblock][bgBuffIndex] = bgIndex;
				}
				bgBuffIndex += 1;

				// 2
				if (bgBuffIndex < TRANSBG_MAXSIZE) {
					bgIndex = pDGControl->AddSprite(NULL, textureId);
					pDGControl->SetSpriteRect(bgIndex, (x * 16) + 8, (y * 16), (x * 16) + 15, (y * 16) + 7);
					pBuffer->tbg_buff[slot][palblock][bgBuffIndex] = bgIndex;
				}
				bgBuffIndex += 1;

				// 3
				if (bgBuffIndex < TRANSBG_MAXSIZE) {
					bgIndex = pDGControl->AddSprite(NULL, textureId);
					pDGControl->SetSpriteRect(bgIndex, (x * 16) + 8, (y * 16) + 8, ((x * 16) + 15), ((y * 16) + 15));
					pBuffer->tbg_buff[slot][palblock][bgBuffIndex] = bgIndex;
				}
				bgBuffIndex += 1;

				// `FbN
				if (bgBuffIndex > TRANSBG_MAXSIZE) {
					kon_log("load_transp : ǂݍݐ̔z tbg_buff ̍őTCYz܂Bindex=%d, max=%d\n", bgBuffIndex, TRANSBG_MAXSIZE);
				}
			}
		}
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int load_transsp_all(const char* filename, int slot, int with_bg)
//
//	[  ]
//		const char* filename	ǂݍރp^[f[^̉摜t@C
//		int slot				Xbgԍ
//		int with_bg				BGp^[WJꍇ1w
//
//	[ ߂l ]
//		F0
//		sF-1
//
//	[  ]
//		PCG]p̃p^[f[^ǂݍ݂܂B
//		w肷摜́i2n~2nj̐`̉摜łKv܂B
//		palblock=0`15ׂĂɂĂ܂Ƃ߂Ď荞݂܂B
//--------------------------------------------------------------------
int load_transsp_all(const char* filename, int slot, int with_bg) {
	int result;

	// ftHgǂݍ
	result = load_transsp(filename, slot, 0, with_bg);
	if (result != 0) {
		kon_log("[ERROR] load_transsp : t@C[%s]̓ǂݍݒɃG[܂B\n", filename);
		return result;
	}

	// BMP̃t@C̍Ō .BMP 
	CGStr basename;
	basename = filename;
	basename.DeleteLastStr(".bmp");
	basename.DeleteLastStr(".BMP");
	basename.DeleteLastStr(".Bmp");

	// pbgubNꂼɂēǂݍ
	for (int i = 1; i <= 15; i++) {
		char fname[256];
		sprintf(fname, "%s_%02d.bmp", basename.GetString(), i);

		// t@CȂ΃ftHgg
		FILE* fn = fopen(fname, "rb");
		if (fn == NULL) {
			sprintf(fname, "%s", filename);
		}
		else {
			fclose(fn);
		}

		result = load_transsp(fname, slot, i, with_bg);
		if (result != 0) {
			kon_log("[ERROR] load_transsp_all : t@C[%s]̓ǂݍ݂Ɏs܂B\n", fname);
			// G[oƂĂ̂܂ܑ
		}
	}

	// I
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int load_transpal(const char* filename)
//
//	[  ]
//		const char* filename	ǂݍރpbgf[^̉摜t@C
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		PCG]p̃pbgf[^ǂݍ݂܂B
//		Windowsł̓pbgȂ̂ŁAł͉ɐI܂B
//--------------------------------------------------------------------
int load_transpal(const char* filename) {
	// Nothing to do.
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		transfer_sp(int slot, int offsetIndex, int targetIndex, int count)
//
//	[  ]
//		int slot			]p^[̃Xbgԍ
//		int offsetIndex		]f[^̃R[hԍ̃ItZbgl
//		int targetIndex		]SPR[h
//		int count			]p^[
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		XvCg̒`f[^܂B
//		Windowsł́ASPR[hɑΉXvCg̃CfbNXԍ
//		w肳ꂽIDŒu邱ƂŁAPCG̋
//		܂B
// 
//		transfer_sp()́AWindowsł̓pbgubNƂ̈͂ł܂B
//		ׂẴpbgubNɂāAǂݍ񂾂܂܂̐FKp
//		܂B
//--------------------------------------------------------------------
int transfer_sp(int slot, int offsetIndex, int targetIndex, int count) {
	CDevsContextWin* pContext = CDevsContextWin::GetInstance();

	// pbgubNɂẴ[v
	for (int p = 0; p < 16; p++) {
		if (pContext->m_palBlockRead[p] == false) { continue; }

		// XvCg̃CfbNX؂ւ
		for (int i = 0; i < count; i++) {
			int spIndex = (pContext->tpcg_buffer).tsp_buff[slot][p][offsetIndex + i];
			pContext->m_spIndexMap[p][targetIndex + i] = spIndex;
		}

		// BG̃CfbNX؂ւ
		int bgTargetIndex = targetIndex * 4;
		for (int i = 0; i < count * 4; i++) {
			if ((bgTargetIndex + i) >= 256) {
				// ]悪256ȏBG̒`̈ł͂Ȃ̂Ŗ
				break;
			}
			if (((offsetIndex * 4) + i) >= TRANSBG_MAXSIZE) {
				// ]̃CfbNXɊւ郍WbNs̏ꍇ
				kon_log("transfer_sp : ]̃CfbNXԍtbg_buff[][][]̃TCYz܂Bindex=%d, max=%d\n"
					, ((offsetIndex * 4) + i)
					, TRANSBG_MAXSIZE
				);
				break;
			}
			int bgIndex = (pContext->tpcg_buffer).tbg_buff[slot][p][(offsetIndex * 4) + i];
			pContext->m_bgIndexMap[p][bgTargetIndex + i] = bgIndex;
		}
	}
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int transfer_pal(int slot, int topBlock, int targetBlock, int count)
//
//	[  ]
//		int slot			]pbg̃Xbgԍ
//		int offsetIndex		]f[^̃pbgubNԍ̃ItZbgl
//		int targetIndex		]̃pbgubN
//		int count			]ubN
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		PCG]̃ubNPALɃf[^]܂B
//		Windowsł̓pbgȂ̂ŁAł͉ɐI܂B
//--------------------------------------------------------------------
int transfer_pal(int slot, int topBlock, int targetBlock, int count) {
	// Nothing to do.
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr fullpath(const char* dir, const char* filename)
//
//	[  ]
//		const char* dir			fBNg
//		const char* filename	t@C
//
//	[ ߂l ]
//		tpX
//
//	[  ]
//		dirfilenameătpX܂B
//--------------------------------------------------------------------
CGStr fullpath(const char* dir, const char* filename)
{
	CGStr path;
	path = CGStr(dir);

	// fBNgZbg
	if ((path.StrLast("\\")==FALSE) && (path.StrLast("/")==FALSE)) {
		path += "/";
	}

	// t@Cq
	path += filename;

	// ʂԂ
	return path;
}
