//--------------------------------------------------------------------
//    xNgNX
//--------------------------------------------------------------------

#ifndef __VECTOR_H__
#define __VECTOR_H__

#include "system.h"

// ----------< NX` >----------
//
template < class TTYPE > class CGVector
{
	// -----< \z >-----
	//
	public:
		CGVector();										// ftHgRXgN^
		CGVector( const int iDimension );				// RXgN^
		CGVector( const CGVector< TTYPE>& rVector );	// Rs[RXgN^
		virtual ~CGVector();							// fXgN^

		BOOL SetDimension( int iDimension );			// ݒ肷
		int  GetDimension();							// 擾

	// -----< f[^o >-----
	//
	protected:
		int		m_iDimension;							// 
		TTYPE*	m_pValue;								// Wlz

	// -----<  >-----
	//
	public:
		BOOL	SetValue( int iAxis , TTYPE  tValue );	// WlݒiƁj
		BOOL	SetValue( TTYPE* pValue );				// WlݒizŎwj
		TTYPE	GetValue( int iAxis );					// Wl擾iƁj
		BOOL	GetValue( TTYPE* pResult );				// Wl擾izŎ擾j

		// -----< Z >-----
		//
		CGVector< TTYPE >&	operator= ( const CGVector< TTYPE >& rVector );	// 

		CGVector< TTYPE >	operator+ ( const CGVector< TTYPE >& rVector );	// a
		CGVector< TTYPE >&	operator+=( const CGVector< TTYPE >& rVector );

		CGVector< TTYPE >	operator- ( const CGVector< TTYPE >& rVector );	// 
		CGVector< TTYPE >&	operator-=( const CGVector< TTYPE >& rVector );

		CGVector< TTYPE >	operator* ( const CGVector< TTYPE >& rVector );	// 
		CGVector< TTYPE >&	operator*=( const CGVector< TTYPE >& rVector );

		CGVector< TTYPE >	operator/ ( const CGVector< TTYPE >& rVector );	// 
		CGVector< TTYPE >&	operator/=( const CGVector< TTYPE >& rVector );

		CGVector< TTYPE >	operator% ( const CGVector< TTYPE >& rVector );	// ]
		CGVector< TTYPE >&	operator%=( const CGVector< TTYPE >& rVector );

		BOOL	operator==( const CGVector< TTYPE >& rVector );		// r
		BOOL	operator!=( const CGVector< TTYPE >& rVector );
		BOOL	operator< ( const CGVector< TTYPE >& rVector );
		BOOL	operator<=( const CGVector< TTYPE >& rVector );
		BOOL	operator> ( const CGVector< TTYPE >& rVector );
		BOOL	operator>=( const CGVector< TTYPE >& rVector );

		CGVector< TTYPE>	operator& ( const CGVector< TTYPE >& rVector );	// rbgZ
		CGVector< TTYPE>&	operator&=( const CGVector< TTYPE >& rVector );
		CGVector< TTYPE>	operator| ( const CGVector< TTYPE >& rVector );
		CGVector< TTYPE>& 	operator|=( const CGVector< TTYPE >& rVector );
		CGVector< TTYPE>	operator~ ();
		CGVector< TTYPE>	operator^ ( const CGVector< TTYPE >& rVector );
		CGVector< TTYPE>&	operator^=( const CGVector< TTYPE >& rVector );

		TTYPE&	operator[]( const int iIndex );			// ANZXZq
};


//--------------------------------------------------------------------
//  [  ]
//		CGVector()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//		gpO SetDimension() Ă΂˂΂ȂȂB
//--------------------------------------------------------------------
template < class TTYPE >
CGVector< TTYPE >::CGVector()
{
	m_iDimension = 0;
	m_pValue     = NULL;
}


//--------------------------------------------------------------------
//  [  ]
//		CGVector( int iDimension )
//
//	[  ]
//		int iDimension		
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGVector< TTYPE >::CGVector( int iDimension )
{
	m_iDimension = 0;
	m_pValue     = NULL;

	// l̐ݒ
	//
	SetDimension( iDimension );
}


//--------------------------------------------------------------------
//	[  ]
//		CGVector( const CGVector& rVector )
//
//	[  ]
//		const CGVector& rVector		Rs[Ƃւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template< class TTYPE>
CGVector< TTYPE >::CGVector( const CGVector<TTYPE>& rVector )
{
	// l̃Rs[
	//
	m_iDimension = rVector.m_iDimension;

	m_pValue     = new TTYPE[ m_iDimension ];
	for( int i=0;i<rVector.m_iDimension;i++ ){
		m_pValue[i] = rVector.m_pValue[i];
	}
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~CGVector()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template< class TTYPE >
CGVector< TTYPE >::~CGVector()
{
	// z̉
	if( m_pValue ){
		delete[] m_pValue;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDimension( int iDimension )
//
//	[  ]
//		int iDimension		
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ݒ肵܂B
//		ftHgRXgN^ō\zꍇɁAgpOɎs
//		ĂB
//		łɐݒ肳ĂIuWFNgɑ΂ĎgpƁA
//		܂Ŋi[Ă͔jAIuWFNg͏܂B
//		 0 w肷ƁA 0 ̃xN^iexN^jƂ
//		邱Ƃł܂B
//--------------------------------------------------------------------
template< class TTYPE >
BOOL CGVector< TTYPE >::SetDimension( int iDimension )
{
	// łɑ݂
	//
	if( m_iDimension!=0 ){
		delete[] m_pValue;
	}
	m_iDimension = 0;
	m_pValue     = NULL;

	// 
	//
	if( iDimension!=0 ){
		m_iDimension = iDimension;					// 
		m_pValue     = new TTYPE[ iDimension ];		// z
		if( m_pValue==NULL ){
			m_iDimension = 0;
			return FALSE;
		}
	}

	// I
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		int	GetDimension()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		
//
//	[  ]
//		IuWFNg̎Ԃ܂B
//		QWȂ 2 , RWȂ 3 łB
//--------------------------------------------------------------------
template< class TTYPE >
int CGVector< TTYPE >::GetDimension()
{
	return m_iDimension;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL	SetValue( int iAxis , TTYPE tValue )
//
//	[  ]
//		int		iAxis		̃R[hԍ
//		TTYPE	tValue		Zbgl
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵ɒlݒ肵܂B
//		Ȃ炩̗RŎs FALSE ԂAl͕ύX܂B
//--------------------------------------------------------------------
template< class TTYPE >
BOOL CGVector< TTYPE >::SetValue( int iAxis , TTYPE tValue )
{
	// G[`FbN
	//
	if( iAxis >= m_iDimension ){
		return FALSE;
	}

	// l̐ݒ
	//
	m_pValue[ iAxis ] = tValue;

	// I
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL	SetValue( TTYPE* pValue )
//
//	[  ]
//		TTYPE*	pValue		l̔z
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɒlݒ肵܂B
//		ɂ́Aȏ̃TCYTTYPE^zw肵܂B
//		w肵z̐擪玟̗vfݒΏۂ̒lƌȂ܂B
//--------------------------------------------------------------------
template< class TTYPE >
BOOL CGVector< TTYPE >::SetValue( TTYPE* pValue )
{
	// G[`FbN
	//
	if( pValue==NULL ){
		return FALSE;
	}

	// lݒ
	//
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] = pValue[i];
	}

	// I
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE	GetValue( int iAxis )
//
//	[  ]
//		int	iAxis		擾鎲̃R[hԍ
//
//	[ ߂l ]
//		Wl
//		sȒl͂ꍇ͖̋`
//
//	[  ]
//		iAxis Ŏw肳鎲̍WlԂ܂B
//--------------------------------------------------------------------
template< class TTYPE >
TTYPE CGVector< TTYPE >::GetValue( int iAxis )
{
	return m_pValue[iAxis];
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL	GetValue( TTYPE* pResult )
//
//	[  ]
//		ʂi[zւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		WlzŕԂ܂B
//--------------------------------------------------------------------
template< class TTYPE >
BOOL CGVector< TTYPE >::GetValue( TTYPE* pResult )
{
	// G[`FbN
	//
	if( pResult==NULL ){
		return FALSE;
	}

	// lԂ
	//
	for( int i=0;i<m_iDimension;i++ ){
		pResult[i] = m_pValue[i];
	}

	// I
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	<<<<< Zq >>>>>
//--------------------------------------------------------------------
// -----<  >-----
//
template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator= ( const CGVector< TTYPE >& rVector )
{
	SetDimension( rVector.m_iDimension );
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] = rVector.m_pValue[i];
	}

	return *this;
}


// -----< a >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator+ ( const CGVector<TTYPE>& rVector )
{
	CGVector< TTYPE >	tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] + rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator+=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] += rVector.m_pValue[i];
	}

	return *this;
}


// -----<  >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator- ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] - rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator-=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] -= rVector.m_pValue[i];
	}

	return *this;
}


// -----<  >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator* ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] * rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator*=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] *= rVector.m_pValue[i];
	}

	return *this;
}


// -----<  >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator/ ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] / rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator/=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] /= rVector.m_pValue[i];
	}

	return *this;
}


// -----< ] >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator% ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] % rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator%=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] %= rVector.m_pValue[i];
	}

	return *this;
}


// -----< r >-----
//
template < class TTYPE >
BOOL	CGVector< TTYPE >::operator==( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( m_pValue[i]!=rVector.m_pValue[i] )return FALSE;
	}

	return TRUE;
}

template < class TTYPE >
BOOL	CGVector< TTYPE >::operator!=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( m_pValue[i]!=rVector.m_pValue[i] )return TRUE;
	}

	return FALSE;
}

template < class TTYPE >
BOOL	CGVector< TTYPE >::operator< ( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( !(m_pValue[i] < rVector.m_pValue[i]) )return FALSE;
	}

	return TRUE;
}

template < class TTYPE >
BOOL	CGVector< TTYPE >::operator<=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( !(m_pValue[i] <= rVector.m_pValue[i]) )return FALSE;
	}

	return TRUE;
}

template < class TTYPE >
BOOL	CGVector< TTYPE >::operator> ( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( !(m_pValue[i] > rVector.m_pValue[i]) )return FALSE;
	}

	return TRUE;
}

template < class TTYPE >
BOOL	CGVector< TTYPE >::operator>=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		if( !(m_pValue[i] >= rVector.m_pValue[i]) )return FALSE;
	}

	return TRUE;
}


// -----< rbgZ >-----
//
template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator& ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] & rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >&	CGVector< TTYPE >::operator&=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] &= rVector.m_pValue[i];
	}

	return *this;
}

template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator| ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] | rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >& CGVector< TTYPE >::operator|=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] |= rVector.m_pValue[i];
	}

	return *this;
}

template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator~ ()
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = ~m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >	CGVector< TTYPE >::operator^ ( const CGVector< TTYPE >& rVector )
{
	CGVector< TTYPE > tRes( m_iDimension );

	for( int i=0;i<m_iDimension;i++ ){
		tRes.m_pValue[i] = m_pValue[i] ^ rVector.m_pValue[i];
	}

	return tRes;
}

template < class TTYPE >
CGVector< TTYPE >& CGVector< TTYPE >::operator^=( const CGVector< TTYPE >& rVector )
{
	for( int i=0;i<m_iDimension;i++ ){
		m_pValue[i] ^= rVector.m_pValue[i];
	}

	return *this;
}


// -----< ANZXZq >-----
//
template < class TTYPE >
TTYPE&	CGVector< TTYPE >::operator[]( const int iIndex )
{
	return m_pValue[iIndex];
}


#endif
