//====================================================================
//  [eBeB֐QNX
//====================================================================
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "system.h"

#include "LogFile.h"

#include "Utils.h"

CLogFile* CUtils::m_pDebugLog = NULL;				// fobOOl
CLogFile* CUtils::m_pErrorLog = NULL;				// G[Ol

//--------------------------------------------------------------------
//	[  ]
//		CUtils()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CUtils::CUtils()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CUtils( CLogFile* pDebugLog , CLogFile* pErrorLog )\
//
//	[  ]
//		CLogFile* pDebugLog			fobOOt@Cւ̃|C^
//		CLogFile* pErrorLog			G[Ot@Cւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOt@Cw̃RXgN^
//--------------------------------------------------------------------
CUtils::CUtils(CLogFile* pDebugLog, CLogFile* pErrorLog)
{
	SetDefault();

	// fobOOւ̃|C^Zbg
	SetDebugLog(pDebugLog);
	SetErrorLog(pErrorLog);
}


//--------------------------------------------------------------------
//	[  ]
//		CUtils( CUtils& rUtils )
//
//	[  ]
//		CUtils& rUtils				Rs[RXgN^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CUtils::CUtils(CUtils& rUtils)
{
	SetDefault();
	CopyMembers(rUtils);
}


//--------------------------------------------------------------------
//	[  ]
//		~CUtils()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CUtils::~CUtils()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
void CUtils::SetDefault()
{
	// Nothing to do.
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CUtils& rUtils )
//
//	[  ]
//		CUtils& rUtils				Rs[Ƃւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̕܂B
//--------------------------------------------------------------------
BOOL CUtils::CopyMembers(CUtils& rUtils)
{
	// -----< ܂ >-----
	//
	Release();

	// -----< e̕ >-----
	//
	m_pDebugLog = rUtils.m_pDebugLog;
	m_pErrorLog = rUtils.m_pErrorLog;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓e
//--------------------------------------------------------------------
void CUtils::Release()
{
	// Nothing to do.
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDebugLog( CLogFile* pLogFile )
//
//	[  ]
//		CLogFile* pLogFile			Ot@Cւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fobOOt@Cւ̃|C^ݒ肵܂B
//		fobOOt@Cݒ肷ƁAOo͊֐gp\ɂȂ܂B
//--------------------------------------------------------------------
BOOL CUtils::SetDebugLog(CLogFile* pLogFile)
{
	m_pDebugLog = pLogFile;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetErrorLog( CLogFile* pLogFile )
//
//	[  ]
//		CLogFile* pLogFile			Ot@Cւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		G[Ot@Cւ̃|C^ݒ肵܂B
//		G[Ot@Cݒ肷ƁAOo͊֐gp\ɂȂ܂B
//--------------------------------------------------------------------
BOOL CUtils::SetErrorLog(CLogFile* pLogFile)
{
	m_pErrorLog = pLogFile;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ] static
//		void SetDebugLogMode( int iMode )
//
//	[  ]
//		int iMode					Ȍo̓[h
//									iݒ\ȒlCLogFileŒ`Ă܂j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOɏo̓xݒ肵܂B
//		Õx CLogFile ɏ܂B
//--------------------------------------------------------------------
void CUtils::SetDebugLogMode(int iMode)
{
	if (m_pDebugLog == NULL)return;
	m_pDebugLog->SetMode(iMode);
	return;
}


//--------------------------------------------------------------------
//	[  ] static
//		void SetErrorLogMode( int iMode )
//
//	[  ]
//		int iMode					Ȍo̓[h
//									iݒ\ȒlCLogFileŒ`Ă܂j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G[Oɏo̓xݒ肵܂B
//		Õx CLogFile ɏ܂B
//--------------------------------------------------------------------
void CUtils::SetErrorLogMode(int iMode)
{
	if (m_pErrorLog == NULL)return;
	m_pErrorLog->SetMode(iMode);
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void Log_Debug( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOt@Cݒ肳Ăꍇ́AOt@C
//		bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::Log_Debug(const char* pMes, ...)
{
	if (m_pDebugLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pDebugLog->Log(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void Log_Error( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G[Ot@Cݒ肳Ăꍇ́AOt@C
//		bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::Log_Error(const char* pMes, ...)
{
	if (m_pErrorLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pErrorLog->Log(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void DebugLog( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOt@Cݒ肳Ăꍇ́AOt@C
//		bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::DebugLog(const char* pMes, ...)
{
	if (m_pDebugLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pDebugLog->DebugLog(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void CheckLog( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOt@Cݒ肳Ăꍇ́AOt@C
//		bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::CheckLog(const char* pMes, ...)
{
	if (m_pDebugLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pDebugLog->CheckLog(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void TraceLog( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fobOOt@Cݒ肳Ăꍇ́AOt@C
//		bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::TraceLog(const char* pMes, ...)
{
	if (m_pDebugLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pDebugLog->TraceLog(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		void ErrorLog( char* pMes , ... )
//
//	[  ]
//		char* pMes					o̓tH[}bg
//		...							
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G[Ot@Cݒ肳Ăꍇ́AOt@C
//		G[bZ[Wo͂܂B
//--------------------------------------------------------------------
void CUtils::ErrorLog(const char* pMes, ...)
{
	if (m_pErrorLog == NULL)return;

	// }[J[쐬
	va_list	marker;
	va_start(marker, pMes);

	// o
	m_pErrorLog->ErrorLog(pMes, marker);

	// ԂsvBBB
	va_end(marker);
}


//--------------------------------------------------------------------
//	[  ]
//		double PI()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		΂ɋ߂ double l
//
//	[  ]
//		΂ɋ߂ double lԂ܂B
//--------------------------------------------------------------------
double CUtils::PI()
{
	double dPI;
	dPI = 3.1415926535897932384626433832795;
	return dPI;
}


//--------------------------------------------------------------------
//	[  ] static
//		FLOAT FRandom( FLOAT fCenter , FLOAT fOffset , FLOAT fMax )
//
//	[  ]
//		FLOAT fCenter				l
//		FLOAT fOffset				ItZbgl
//		FLOAT fMax					̍őUꕝ
//
//	[ ߂l ]
//		ꂽl
//
//	[  ]
//		ItZbgCőUꕝwt̗l𐶐ĕԂ܂B
//		fCenter  fOffset Zlɑ΂āA0.0`fMax ܂ł
//		Ԃ̗lZĕԂ܂B
//--------------------------------------------------------------------
FLOAT CUtils::FRandom(FLOAT fCenter, FLOAT fOffset, FLOAT fMax)
{
	// <<< lZo >>>
	FLOAT fValue;
	fValue = fCenter + fOffset;

	// <<< c擾 >>>
	FLOAT fRandomValue;
	fRandomValue = ((FLOAT)rand() / (FLOAT)RAND_MAX) * fMax;

	// <<< ʂԂ >>>
	fValue += fRandomValue;
	return fValue;
}


//--------------------------------------------------------------------
//	[  ] static
//		long  LRandom( long  lCenter , long  lOffset , long  lMax )
//
//	[  ]
//		long lCenter				l
//		long lOffset				ItZbgl
//		long lMax					̍őUꕝ
//
//	[ ߂l ]
//		ꂽl
//
//	[  ]
//		ItZbgCőUꕝwt̗l𐶐ĕԂ܂B
//		lCenter  lOffset Zlɑ΂āA0`lMax ܂ł
//		Ԃ̗lZĕԂ܂B
//--------------------------------------------------------------------
long CUtils::LRandom(long lCenter, long lOffset, long lMax)
{
	// <<< lZo >>>
	long lValue;
	lValue = lCenter + lOffset;

	// <<< 𐶐 >>>
	long lRandomValue;
	long lDivValue;
	lDivValue = RAND_MAX / lMax;
	lRandomValue = rand() / lDivValue;

	// <<< ʂԂ >>>
	lValue += lRandomValue;
	return lValue;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSideValue(
//				  FLOAT fPx  , FLOAT fPy		// Ώۂ̓_
//				, FLOAT fLx1 , FLOAT fLy1		// n_
//				, FLOAT fLx2 , FLOAT fLy2		// I_
//
//	[  ]
//		FLOAT fPx					]_̂wW
//		FLOAT fPy					]_̂xW
//		FLOAT fLx1					n_wW
//		FLOAT fLy1					I_xW
//		FLOAT fLx2					I_wW
//		FLOAT fLy2					I_xW
//
//	[ ߂l ]
//		F0
//		F1
//		EF-1
//
//	[  ]
//		Cӂ̒ɑ΂āACӂ̓_Eɂ邩Aɂ邩A
//		ɂ邩𔻒肵ĕԂ܂B
//--------------------------------------------------------------------
long CUtils::GetSideValue(
	FLOAT fPx, FLOAT fPy		// Ώۂ̓_
	, FLOAT fLx1, FLOAT fLy1		// n_
	, FLOAT fLx2, FLOAT fLy2		// I_
) {
	// OςZo
	FLOAT fValue = fPx * (fLy1 - fLy2)
		+ fLx1 * (fLy2 - fPy)
		+ fLx2 * (fPy - fLy1);

	// ʂ肷
	long lResult = 0;
	if (fValue > 0.0f) { lResult = 1; }
	if (fValue < 0.0f) { lResult = -1; }

	// ʂԂ
	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CUtils::IsInTriangle(
//					  FLOAT fPx  , FLOAT fPy
//					, FLOAT fTx1 , FLOAT fTy1
//					, FLOAT fTx2 , FLOAT fTy2
//					, FLOAT fTx3 , FLOAT fTz3
//					)
//
//	[  ]
//		FLOAT fPx,fPy				]_̍W
//		FLOAT fLx1,fLy1				Op`̒_P
//		FLOAT fLx2,fLy2				Op`̒_Q
//		FLOAT fLx3,fLy3				Op`̒_R
//
//	[ ߂l ]
//		FTRUE
//		OFFALSE
//
//	[  ]
//		w肵_Aw肵Op`̓ɂ邩ۂԂ܂B
//		Op`̒_̎w菇́AEłł\܂B
//--------------------------------------------------------------------
BOOL CUtils::IsInTriangle(
	FLOAT fPx, FLOAT fPy
	, FLOAT fTx1, FLOAT fTy1
	, FLOAT fTx2, FLOAT fTy2
	, FLOAT fTx3, FLOAT fTy3
) {
	// eӂɑ΂āA_ǂ瑤ɂ邩𔻒
	long lSide12 = CUtils::GetSideValue(fPx, fPy, fTx1, fTy1, fTx2, fTy2);
	long lSide23 = CUtils::GetSideValue(fPx, fPy, fTx2, fTy2, fTx3, fTy3);
	long lSide31 = CUtils::GetSideValue(fPx, fPy, fTx3, fTy3, fTx1, fTy1);

	// SĂ̕Ȃ
	BOOL bResult = FALSE;
	if ((lSide12 >= 0) && (lSide23 >= 0) && (lSide31 >= 0)) {
		bResult = TRUE;
	}
	if ((lSide12 <= 0) && (lSide23 <= 0) && (lSide31 <= 0)) {
		bResult = TRUE;
	}

	// ʂԂ
	return bResult;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsInRectangle(
//					  FLOAT fPx  , FLOAT fPy
//					, FLOAT fRx1 , FLOAT fRy1
//					, FLOAT fRx2 , FLOAT fRy2
//					, FLOAT fRx3 , FLOAT fRz3
//					, FLOAT fRx4 , FLOAT fRz4
//					)
//
//	[  ]
//		FLOAT fPx,fPy				]_
//		FLOAT fRx1,fRy1				_P
//		FLOAT fRx2,fRy2				_Q
//		FLOAT fRx3,fRy3				_R
//		FLOAT fRx4,fRy4				_S
//
//	[ ߂l ]
//		FTRUE
//		OFFALSE
//
//	[  ]
//		Cӂ̎lp`ɑ΂āACӂ̓_ɂ邩
//		Oɂ邩𔻒肵ĕԂ܂B
//		_PQRƁA_PRŚAQ̎Op`̂A
//		ꂩɑĂ TRUE Ɣ肵܂B
//--------------------------------------------------------------------
BOOL CUtils::IsInRectangle(
	FLOAT fPx, FLOAT fPy
	, FLOAT fRx1, FLOAT fRy1
	, FLOAT fRx2, FLOAT fRy2
	, FLOAT fRx3, FLOAT fRy3
	, FLOAT fRx4, FLOAT fRy4
) {
	// Op`ɕāAꂼɂĔ肷
	BOOL bIn1, bIn2;
	bIn1 = CUtils::IsInTriangle(fPx, fPy, fRx1, fRy1, fRx2, fRy2, fRx3, fRy3);
	bIn2 = CUtils::IsInTriangle(fPx, fPy, fRx1, fRy1, fRx3, fRy3, fRx4, fRy4);

	// ǂ炩Ɋ܂܂ĂꍇTRUE
	BOOL bResult = FALSE;
	if ((bIn1 == TRUE) || (bIn2 == TRUE)) {
		bResult = TRUE;
	}

	// ʂԂ
	return bResult;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ConvertEndianWord(WORD* array, int elementCount)
//
//	[  ]
//		WORD* array			ϊΏۂ̔z
//		int elementCount	z̗vf
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽWORDl̔zɂāA8oCgƉ8oCg
//		ւ܂B
//--------------------------------------------------------------------
BOOL CUtils::ConvertEndianWord(WORD* array, int elementCount)
{
	unsigned char s;
	unsigned char* p = (unsigned char*)(array);
	for (int i = 0; i < elementCount; i ++) {
		s = *p;
		*p = *(p + 1);
		*(p + 1) = s;
		p += 2;
	}

	return TRUE;
}
