//--------------------------------------------------------------------
//  ^Op֐
//--------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "TRControl.h"

//--------------------------------------------------------------------
//	[  ]
//		CTRControl()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CTRControl::CTRControl()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CTRControl( long lQDivNum , long lZoomRatio )
//
//	[  ]
//		long lQDivNum				XO̕
//		long lZoomRatio				g嗦
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		̃RXgN^
//		Ɋւڍׂ SetDivision() QƂĂB
//--------------------------------------------------------------------
CTRControl::CTRControl( long lQDivNum , long lZoomRatio )
{
	SetDefault();
	SetDivision( lQDivNum , lZoomRatio );
}


//--------------------------------------------------------------------
//	[  ]
//		CTRControl( CTRControl& rTRControl )
//
//	[  ]
//		CTRControl& rTRControl		Rs[RXgN^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CTRControl::CTRControl( CTRControl& rTRControl )
{
	SetDefault();
	CopyMembers( rTRControl );
}


//--------------------------------------------------------------------
//	[  ]
//		~CTRControl()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CTRControl::~CTRControl()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lݒ肵܂B
//--------------------------------------------------------------------
void CTRControl::SetDefault()
{
	m_lZoomRatio	= 0;
	m_lQDiv			= 0;
	m_pSinTable		= NULL;
	m_pCosTable		= NULL;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CTRControl& rTRControl )
//
//	[  ]
//		CTRControl& rTRControl		Rs[IuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̕܂B
//--------------------------------------------------------------------
BOOL CTRControl::CopyMembers( CTRControl& rTRControl )
{
	// ܂͉
	//
	Release();

	// 
	//
	BOOL bRes;
	bRes = SetDivision( rTRControl.m_lQDiv , rTRControl.m_lZoomRatio );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejAԂɖ߂܂B
//--------------------------------------------------------------------
void CTRControl::Release()
{
	// e[u
	//
	if( m_pSinTable ){
		free( m_pSinTable );
	}
	m_pSinTable	= NULL;

	if( m_pCosTable ){
		free( m_pCosTable );
	}
	m_pCosTable		= NULL;

	// p[^
	//
	m_lZoomRatio	= 0;
	m_lQDiv			= 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDivision( long lQDivNum , long lZoomRatio )
//
//	[  ]
//		long lQDivNum				XO̕
//		long lZoomRatio				g嗦
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		^Op֐̕ݒ肵܂B
//		XO lQDivNum ɕ܂B
//		Q΃WÁA4*lQVDivNum ɓ܂B
//		Sin()  Cos() ́A(2^lZoomRatio){ꂽOp֐̒l
//		Ԃ܂B@Ƃ΁AlZoomRatio  6 w肳ꂽꍇ
//		Sin() , Cos()  -64<sin,cos<64 ̒lԂ܂B
//--------------------------------------------------------------------
BOOL CTRControl::SetDivision( long lQDivNum , long lZoomRatio )
{
	// ܂͉
	Release();

	// ̈m
	m_pSinTable = (long*)malloc( sizeof( long )*lQDivNum*4 );
	if( m_pSinTable==NULL ){
		return FALSE;
	}

	m_pCosTable = (long*)malloc( sizeof( long )*lQDivNum*4 );
	if( m_pCosTable==NULL ){
		free( m_pSinTable );
		m_pSinTable	= NULL;
		return FALSE;
	}

	memset( m_pSinTable , 0 , sizeof( long )*lQDivNum*4 );
	memset( m_pCosTable , 0 , sizeof( long )*lQDivNum*4 );

	// lݒ
	m_lQDiv			= lQDivNum;
	m_lZoomRatio	= lZoomRatio;

	for( long i=0;i<(m_lQDiv*4);i++ ){
		m_pSinTable[i] = (long)(-((double)(1<<m_lZoomRatio))*sin( (1.57079632679489661923132169163975*( (double)i ))/((double)m_lQDiv) ));
		m_pCosTable[i] = (long)( ((double)(1<<m_lZoomRatio))*cos( (1.57079632679489661923132169163975*( (double)i ))/((double)m_lQDiv) ));
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long Sin( long lDir )
//
//	[  ]
//		long lDir					̃CfbNXԍ
//
//	[ ߂l ]
//		sin ̒l
//
//	[  ]
//		^Op֐ŁAsin ̒lԂ܂B
//--------------------------------------------------------------------
long CTRControl::Sin( long lDir )
{
	return m_pSinTable[ lDir ];
}


//--------------------------------------------------------------------
//	[  ]
//		long Cos( long lDir )
//
//	[  ]
//		long lDir					̃CfbNXԍ
//
//	[ ߂l ]
//		cos ̒l
//
//	[  ]
//		^Op֐ŁAcos ̒lԂ܂B
//--------------------------------------------------------------------
long CTRControl::Cos( long lDir )
{
	return m_pCosTable[ lDir ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GetZoomRatio()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ăg嗦
//
//	[  ]
//		Op֐̊g嗦Ԃ܂B
//--------------------------------------------------------------------
long CTRControl::GetZoomRatio()
{
	return m_lZoomRatio;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetDivision()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		
//
//	[  ]
//		Q΃WA̕Ԃ܂B
//--------------------------------------------------------------------
long CTRControl::GetDivision()
{
	return m_lQDiv*4;
}


//--------------------------------------------------------------------
//	[  ]
//		CTRControl& operator=( CTRControl& rTRControl )
//
//	[  ]
//		CTRControl& rTRControl		Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CTRControl& CTRControl::operator=( CTRControl& rTRControl )
{
	CopyMembers( rTRControl );
	return *this;
}
