//------------------------------------------------------------------------------
//	NX
//------------------------------------------------------------------------------

#ifndef __CGSTR_H__
#define __CGSTR_H__

#include "DStringArray.h"

#define	CGSTR_MAX_ENDCODE		2					// GhR[h̃TCY̍ő
													// Unicode ƂQB

class CGStr{
	// -----< \z >-----
	//
	public:
		CGStr();									// \z
		CGStr( CGStr& rStr );						// Rs[RXgN^

		CGStr( const char* pStr );					// RXgN^

		virtual ~CGStr();							// fXgN^

	private:
		BOOL	SetDefault();						// RXgN^xł̏lݒ
		BOOL	CopyMembers( const CGStr& rStr );	// IuWFNg̓e𕡐
		BOOL	FreeString();						// ݒ肳Ă镶


	// -----<  >-----
	//
	private:
		char*	m_pString;							// 

	// -----< \bh >-----
	//
	public:
		BOOL	Initialize();						// 
		BOOL	Release();							// IuWFNg̓ej

		// <<< 񑀍 >>>
		BOOL	SetString( const char* pString );	// ݒ肷
		const char*	GetString() const;				// 擾
		BOOL	AppendString( const char* pString );	// 𑫂
		BOOL	AppendString( const CGStr& rString );
		BOOL	InsertString( const char* pString );	// ̑Oɕڑ
		BOOL	InsertString( const CGStr& rString );

		BOOL	DeleteLastCR();							// ̈ԍŌ \n 폜
		BOOL	StrLast( const CGStr& rString ) const;	// w蕶񂪕̍ŌɊ܂܂ꍇ TRUE
		BOOL	StrLast( const char*  pString ) const;	// w蕶񂪕̍ŌɊ܂܂ꍇ TRUE
		BOOL	DeleteLastStr( const CGStr& rString );	// w蕶񂪍ŌɂĂꍇA폜
		BOOL	DeleteLastStr( const char*  pString );	// w蕶񂪍ŌɂĂꍇA폜

		BOOL	Trim();									// E̋󔒂폜

		// <<< ֐ >>>
		BOOL	IsHead( const char*  pString );			// ̐擪w蕶ƈvH
		BOOL	IsHead( const CGStr& rString );			// ̐擪w蕶ƈvH

		// <<< R[h̃GR[hp^[ɈˑR[h >>>
		long	Length() const;									// 񒷂Ԃ
		long	MBLength() const;								// Ԃi}`oCgΉj
		long	GetMBLetterSize( const char* pLetter ) const;	// P̃oCg擾
		BOOL	IsEndCode( const unsigned char* pLetter );		// GhR[hۂԂ
		BOOL	IsCRCode( const unsigned char* pLetter );		// sR[hۂԂ
		BOOL	SetEndCode( unsigned char* pLetter );			// GhR[h
		BOOL	ConvertKANA_HtoZ();								// pJiSpJiɕϊ

		// <<< ̑ >>>
													// wLN^ŕ
		BOOL	Explode( const CGStr& rKey , CDStringArray& rElements );
		BOOL	Explode( const char*  pKey , CDStringArray& rElements );
		BOOL	Implode( const CGStr& rKey , CDStringArray& rElements );
		BOOL	Implode( const char*  pKey , CDStringArray& rElements );

		BOOL	Split( const CGStr& rKey , CGStr& rLeft , CGStr& rRight );	// ؂藣
		BOOL	Split( const char*  pKey , CGStr& rLeft , CGStr& rRight );

		BOOL	CleanRelativeFSExpression( const char* pDesc );	// t@CVXe\ŁA΃pX\NA
		BOOL	IsFSFullPathString( const char* pDescriptor , BOOL bDriveEnabled=TRUE );	// tpX̕\ۂ𔻒肷

	private:
		BOOL	CheckKey( const unsigned char* pString , const CGStr& rKey );
		long	KanaConvert( unsigned char* pSource , unsigned char* pTarget );	// pJiPSpJiPɒu

	// -----< ÓI֐ >-----
	//
	public:
		static BOOL isHankakuKana( unsigned char cCode );		// w肳ꂽlpJiۂ𔻒肷
		static CGStr CreateTimeString();						// ݎ̕iYYYYMMDDHHMMSSj

	// -----< Zq >-----
	//
	public:
		CGStr&	operator=( const CGStr& rStr );				// IuWFNg̑Zq
		CGStr&	operator=( const char* pString );			// ̑Zq

		CGStr	operator+( const CGStr& rString ) const;	// IuWFNg𑫂
		CGStr	operator+( const char* pString ) const;		// 𑫂

		CGStr&	operator+=( const char* pString );			// += Zq
		CGStr&	operator+=( const CGStr& rString );

		BOOL	operator==( const char* pString ) const;	// rZq
		BOOL	operator==( const CGStr& rString ) const;

		BOOL	operator!=( const char* pString ) const;	// ےrZq
		BOOL	operator!=( const CGStr& rString ) const;
};

#endif
