//------------------------------------------------------------------------------
//	NX
//------------------------------------------------------------------------------

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef __SYSTEM_WINDOWS__
#include <mbstring.h>
#endif

#include "Str.h"


//--------------------------------------------------------------------
//	[  ]
//		CGStr()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGStr::CGStr()
{
	// <<< lݒ >>>
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr( CGStr& rStr )
//
//	[  ]
//		CGStr& rStr					Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CGStr::CGStr( CGStr& rStr )
{
	// <<< lݒ >>>
	SetDefault();

	// <<< IuWFNg̓e𕡐 >>>
	BOOL bRes;
	bRes	= CopyMembers( rStr );
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr( const char* pStr )
//
//	[  ]
//		const char* pStr			ݒ肷镶
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		񏉊̃RXgN^
//--------------------------------------------------------------------
CGStr::CGStr( const char* pStr )
{
	// <<< lݒ >>>
	SetDefault();

	// <<< IuWFNgɕݒ >>>
	BOOL bRes;
	bRes = SetString( pStr );
}


//--------------------------------------------------------------------
//	[  ]
//		~CGStr()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGStr::~CGStr()
{
	// -----<  >-----
	//
	BOOL bRes;
	bRes = Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̏lݒ
//--------------------------------------------------------------------
BOOL CGStr::SetDefault()
{
	m_pString	= NULL;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( const CGStr& rStr )
//
//	[  ]
//		const CGStr& rStr			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CGStr::CopyMembers( const CGStr& rStr )
{
	// <<<  >>>
	BOOL bRes;
	bRes = Initialize();
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< ݒ >>>
	//
	bRes = SetString( rStr.GetString() );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL FreeString()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ݒ肳Ă镶܂B
//--------------------------------------------------------------------
BOOL CGStr::FreeString()
{
	if( m_pString!=NULL ){
		free( m_pString );
	}
	m_pString	= NULL;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		
//--------------------------------------------------------------------
BOOL CGStr::Initialize()
{
	// <<<  >>>
	BOOL bRes;
	bRes = Release();
	if( bRes==FALSE ){
		return FALSE;
	}

	// Ƃ邱Ɩ
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ejAmۂĂ郊\[X܂B
//--------------------------------------------------------------------
BOOL CGStr::Release()
{
	// <<< ̉ >>>
	BOOL bRes = FreeString();
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetString( const char* pString )
//
//	[  ]
//		const char* pString			ݒ肷镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɑ΂ĕݒ肵܂B
//		̕񂪂ꍇɂ́AxĂ
//		Vݒ肵܂B
//		pString  NULL w肵ꍇ́Aݒ肳Ă镶
//		Ċ֐I܂B
//--------------------------------------------------------------------
BOOL CGStr::SetString( const char* pString )
{
	// <<< NULL ̏ꍇ͕ďI >>>
	if( pString==NULL ){
		FreeString();
		return TRUE;
	}

	// <<< ̒𑪂 >>>
	long lLength;
	lLength	= strlen( pString );

	// <<< mۂ >>>
	char* pNewString;
	pNewString	= (char*)malloc( lLength+1 );
	if( pNewString==NULL ){
		return FALSE;
	}
	memset( pNewString , 0 , lLength+1 );

	// <<< 񕡐 >>>
	strcpy( pNewString , pString );

	// <<< ̕񂪂ꍇɂ͉ >>>
	if( m_pString!=NULL ){
		free( m_pString );
	}
	m_pString = NULL;

	// <<< VKݒ >>>
	m_pString = pNewString;

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetString() const
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		IuWFNgɊi[Ă镶
//
//	[  ]
//		 char* ŕԂ܂B
//--------------------------------------------------------------------
const char* CGStr::GetString() const
{
	return m_pString;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AppendString( const char* pString )
//
//	[  ]
//		const char* pString			ǉ镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̂ɕڑ܂B
//--------------------------------------------------------------------
BOOL CGStr::AppendString( const char* pString )
{
	BOOL bRes;

	// <<< NULL wȂȂɂȂ >>>
	if( pString==NULL ){
		return TRUE;
	}

	// <<< 𑪂ăm >>>
	long lLength;
	lLength	= strlen( pString ) + Length();

	char* pNewString;
	pNewString	= (char*)malloc( lLength+1 );
	if( pNewString==NULL ){
		return FALSE;
	}
	memset( pNewString , 0 , lLength+1 );

	// <<< 񕡐 >>>
	if( GetString()!=NULL ){
		strcpy( pNewString , GetString() );
	}
	strcat( pNewString , pString );

	// <<< ̕ĐVݒ >>>
	bRes = SetString( pNewString );
	if( bRes==FALSE ){
		free( pNewString );
		return FALSE;
	}

	free( pNewString );
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AppendString( const CGStr& rString )
//
//	[  ]
//		CGStr& rString				ǉ镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̌ɕA܂B
//--------------------------------------------------------------------
BOOL CGStr::AppendString( const CGStr& rString )
{
	BOOL bRes;
	bRes	= AppendString( rString.GetString() );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL InsertString( const char* pString )
//
//	[  ]
//		char* pString				}镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̑Oɕڑ܂B
//--------------------------------------------------------------------
BOOL CGStr::InsertString( const char* pString )
{
	BOOL bRes;

	// <<< NULL wȂȂɂȂ >>>
	if( pString==NULL ){
		return TRUE;
	}

	// <<< 𑪂ăm >>>
	long lLength;
	lLength	= strlen( pString ) + Length();

	char* pNewString;
	pNewString	= (char*)malloc( lLength+1 );
	if( pNewString==NULL ){
		return FALSE;
	}
	memset( pNewString , 0 , lLength+1 );

	// <<< ̕ >>>
	strcpy( pNewString , pString );
	if( m_pString!=NULL ){
		strcat( pNewString , GetString() );
	}

	// <<< ̕ŐVKݒ >>>
	bRes = SetString( pNewString );
	if( bRes==FALSE ){
		free( pNewString );
		return FALSE;
	}

	free( pNewString );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL InsertString( const CGStr& rString )
//
//	[  ]
//		CGStr& rString				A镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̑Oɕ}ĘA܂B
//--------------------------------------------------------------------
BOOL CGStr::InsertString( const CGStr& rString )
{
	BOOL bRes;
	bRes	= InsertString( rString.GetString() );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteLastCR()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̈ԍŌオ \n A \0 ɒu܂B
//--------------------------------------------------------------------
BOOL CGStr::DeleteLastCR()
{
	BOOL bRes;

	// <<< 񂪂Ȃ΁Â܂܂܂ >>>
	if( m_pString==NULL ){
		return TRUE;
	}

	// <<< ŌT >>>
	unsigned char* pWork;
	unsigned char* pLast;

	pWork	= (unsigned char*)m_pString;
	pLast	= pWork;

	while( 1 ){
		if( IsEndCode( pWork )==TRUE ){
			break;
		}
		pLast	= pWork;					// GhR[hł͂Ȃ̂ōXV

		pWork += GetMBLetterSize( (char*)pWork );	// ̕mF
	}

	// <<< Ōオ \n GhR[hɂ >>>
	if( IsCRCode( pLast )==TRUE ){
		bRes = SetEndCode( pLast );
		if( bRes==FALSE ){
			return FALSE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StrLast( const CGStr& rString ) const
//
//	[  ]
//		const CGStr& rString		܂܂邩ۂmF镶
//
//	[ ߂l ]
//		  ܂܂FTRUE
//		܂܂ȂFFALSE
//
//	[  ]
//		񂪁ArString ŎŏIĂꍇ TRUE 
//		Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::StrLast( const CGStr& rString ) const
{
	BOOL bRes;
	bRes	= StrLast( rString.GetString() );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StrLast( const char* pString ) const
//
//	[  ]
//		const char* pString			܂܂邩ۂmF镶
//
//	[ ߂l ]
//		  ܂܂FTRUE
//		܂܂ȂFFALSE
//
//	[  ]
//		񂪁ApString ŎŏIĂꍇ TRUE 
//		Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::StrLast( const char* pString ) const
{
	long	lLength;
	long	lStringLength;
	CGStr	objString;

	// 񒷂mF
	objString	= pString;
	lLength			= Length();
	lStringLength	= objString.Length();

	// rʒumF
	long lDiff;
	lDiff	= lLength - lStringLength;
	if( lDiff<0 ){
		return FALSE;
	}

	// r
	BOOL bResult;
	if( strcmp( m_pString+lDiff , pString )==0 ){
		bResult	= TRUE;
	} else {
		bResult	= FALSE;
	}

	return bResult;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteLastStr( const CGStr& rString )
//
//	[  ]
//		const CGStr& rString			폜镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̍Ō rString ĂꍇA폜܂B
//		iGhR[h㏑܂Bj
//		̍Ō rString ĂȂꍇɂ́A
//		Ȃɂ TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::DeleteLastStr( const CGStr& rString )
{
	BOOL        bRes;
	const char* pString = rString.GetString();

	bRes	= DeleteLastStr( pString );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteLastStr( const char* pString )
//
//	[  ]
//		const char* pString			폜镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̍Ō pString ĂꍇA폜܂B
//		iGhR[h㏑܂Bj
//		̍Ō pString ĂȂꍇɂ́A
//		Ȃɂ TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::DeleteLastStr( const char* pString )
{
	long	lLength;					// 
	long	lStringLength;				// w肳ꂽ̒
	CGStr	objString;					// w肳ꂽ CGStr ɂ
	BOOL	bRes;

	// 񒷂mF
	objString		= pString;
	lLength			= Length();
	lStringLength	= objString.Length();

	// rʒumF
	long lDiff;
	lDiff	= lLength - lStringLength;
	if( lDiff<0 ){
		return TRUE;
	}

	// r
	if( strcmp( m_pString+lDiff , pString )!=0 ){
		// ŌɊ܂܂Ȃ̂ŁAɕԂ
		return TRUE;
	}

	// GhR[hŏ㏑
	bRes	= SetEndCode( (unsigned char*)(m_pString+lDiff) );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Trim()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̍EɂAXy[XC^uCs폜܂B
//		ʂ́AIuWFNĝɔf܂B
//--------------------------------------------------------------------
BOOL CGStr::Trim()
{
	// -----< mF >-----
	//
	if( m_pString==NULL ){ return TRUE; }
	if( *m_pString==0x00 ){ return TRUE; }

	// -----< 擪o >-----
	//
	unsigned char* pWork	= (unsigned char*)m_pString;
	unsigned char* pStart	= NULL;
	unsigned char* pEnd		= NULL;
	while( *pWork!=0x00 ){
		if( *pWork==' '  ){ pWork++; continue; }	// 
		if( *pWork=='\t' ){ pWork++; continue; }	// ^u
		if( *pWork=='\r' ){ pWork++; continue; }	// s
		if( *pWork=='\n' ){ pWork++; continue; }	// s

		// ̐擪o甲
		break;
	}
	pStart	= pWork;

	// 󕶎ȂA܂
	if( *pStart==0x00 ){
		if( m_pString!=NULL ){ free( m_pString ); }
		m_pString = (char*)malloc( 1 );
		m_pString[0] = 0x00;
		return TRUE;
	}

	// -----< 󔒂łȂŌ̎̕o >-----
	//
	pEnd	= pStart;
	while( *pWork!=0x00 ){
		BOOL bNotSpace = TRUE;
		if( *pWork==' '  ){ bNotSpace=FALSE; }
		if( *pWork=='\t' ){ bNotSpace=FALSE; }
		if( *pWork=='\r' ){ bNotSpace=FALSE; }
		if( *pWork=='\n' ){ bNotSpace=FALSE; }

		// 󔒕ł͂Ȃꍇ́AŏIʒuXV
		if( bNotSpace==TRUE ){
			pEnd	= pWork;
		}

		// ̈ʒu
		pWork = _mbsinc( pWork );
	}

	// Ō̎擾
	unsigned char cOld = *pEnd;
	pEnd = _mbsinc( pEnd );

	// -----< ؂oăobt@Ɋi[ >-----
	//
	*pEnd = 0x00;
	long lLength = strlen( (const char*)pStart );

	// m
	unsigned char* pNewString = (unsigned char*)malloc( lLength+1 );
	if( pNewString==NULL ){
		*pEnd = cOld;
		return FALSE;
	}

	// 
	strcpy( (char*)pNewString , (char*)pStart );

	// -----< ̓eւ >-----
	//
	free( m_pString );
	m_pString = (char*)pNewString;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsHead( const char* pString )
//		BOOL IsHead( const CGStr& rString )
//
//	[  ]
//		const char* pString			r
//		const CGStr& rString		r
//
//	[ ߂l ]
//		v@@@FTRUE
//		vȂFFALSE
//
//	[  ]
//		̐擪Aw肵ƈv邩ۂ𔻒肵܂B
//		Ƃ΁A"0x00FF00FF" ɑ΂ "0x" Ɏw肵s
//		TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::IsHead( const char* pString )
{
	int iRes;

	// 擪r
	#ifdef __SYSTEM_WINDOWS__
	iRes	= _mbsncmp( (const unsigned char*)m_pString , (const unsigned char*)pString , _mbstrlen( pString ) );
	#else
	iRes	= strcmp( m_pString , pString , strlen( pString ) );
	#endif

	// ʂԂ
	if( iRes!=0 )return FALSE;
	return TRUE;
}

BOOL CGStr::IsHead( const CGStr& rString )
{
	BOOL bRes;
	bRes	= IsHead( rString.GetString() );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		long Length() const
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ă镶̒
//		G[̏ꍇ -1
//
//	[  ]
//		ݒ肳Ă镶̒oCgPʂŕԂ܂B
//		񂪐ݒ肳ĂȂꍇ 0 Ԃ܂B
//--------------------------------------------------------------------
long CGStr::Length() const
{
	// <<< ݒ肳ĂȂ 0 Ԃ >>>
	if( m_pString==NULL ){
		return 0;
	}

	// <<< 𐔂ĕԂ >>>
	long lLength;
	lLength	= strlen( m_pString );

	return lLength;
}


//--------------------------------------------------------------------
//	[  ]
//		long MBLength() const
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ă镶
//
//	[  ]
//		ݒ肳Ă镶̕Ԃ܂B
//		}`oCgɂĂAPPJEg܂B
//--------------------------------------------------------------------
long CGStr::MBLength() const
{
	// <<< ݒ肳ĂȂ 0 >>>
	if( m_pString==NULL ){
		return 0;
	}

	// << |C^ & o >>>
	long	lLength;
	char*	pWork;

	lLength	= 0;
	pWork	= m_pString;
	while( 1 ){
		// GhR[hŔ
		if( *pWork==0 ){
			break;
		}

		// JEg
		lLength += 1;
		pWork	+= GetMBLetterSize( pWork );
	}

	// <<< Ԃ >>>
	return lLength;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetMBLetterSize( const char* pLetter ) const
//
//	[  ]
//		ւ̃|C^
//
//	[ ߂l ]
//		pLetter ẃA擪̃oCg
//
//	[  ]
//		̃oCgԂ܂B
//		̊֐́AS-JIS pɋLqĂ܂B
//--------------------------------------------------------------------
long CGStr::GetMBLetterSize( const char* pLetter ) const
{
	unsigned char cLetter;
	cLetter	= (unsigned char)(*pLetter);

	// WrbgڂɃrbgĂȂΔp
	if( cLetter<0x80 ){
		return 1;
	}

	// J^Jȉꍇ͔p
	if( CGStr::isHankakuKana( cLetter )==TRUE ){
		return 1;
	}

	// WrbgڂĂăJ^Jił͂Ȃ̂łQoCgR[h
	return 2;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsEndCode( const unsigned char* pLetter )
//
//	[  ]
//		const unsigned char* pLetter	ւ̃|C^
//
//	[ ߂l ]
//		        GhR[hFTRUE
//		GhR[hł͂ȂFFALSE
//
//	[  ]
//		ւ̐擪 pLetter Ɏw肵܂B
//		pLetter GhR[hwĂꍇɂ TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::IsEndCode( const unsigned char* pLetter )
{
	if( *pLetter==0x00 ){
		return TRUE;
	}

	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsCRCode( const unsigned char* pLetter )
//
//	[  ]
//		const unsigned char* pLetter	ւ̃|C^
//
//	[ ߂l ]
//		  sR[hFTRUE
//		sł͂ȂFFALSE
//
//	[  ]
//		ւ̐擪 pLetter Ɏw肵܂B
//		pLetter sR[hwĂꍇɂ TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::IsCRCode( const unsigned char* pLetter )
{
	if( *pLetter=='\n' ){
		return TRUE;
	}

	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetEndCode( unsigned char* pLetter )
//
//	[  ]
//		char* pLetter				GhR[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pLetter ɃGhR[h݂܂B
//--------------------------------------------------------------------
BOOL CGStr::SetEndCode( unsigned char* pLetter )
{
	*pLetter	= 0x00;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ConvertKANA_HtoZ()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pJiSpJiɕϊ܂B
//		sƁAg̕񂪏܂B
//--------------------------------------------------------------------
BOOL CGStr::ConvertKANA_HtoZ()
{
	// -----< ϊ̒Zo >-----
	//
	long lConvertedLength = 0;			// ϊ̕
	int iCurrentLength = Length();		// ϊO̕

	// <<< XL >>>
	unsigned char* pWork = (unsigned char*)m_pString;
	while( (pWork!=0x00) && ((pWork-(unsigned char*)m_pString)<iCurrentLength) ){
		// P̒o
		long lLetterSize = CGStr::GetMBLetterSize( (const char*)pWork );

		// pJi͂QoCgɒu邱Ƃz肷
		if( CGStr::isHankakuKana(*pWork)==TRUE ){
			lLetterSize += 1;
		}

		// ʂZ
		lConvertedLength += lLetterSize;

		// P|C^i߂
		pWork += GetMBLetterSize( (const char*)pWork );
	}

	// -----< ϊ >-----
	//
	// <<< ̈肱 >>>
	unsigned char* pConverted = NULL;
	pConverted = (unsigned char*)malloc( lConvertedLength + CGSTR_MAX_ENDCODE );
	if( pConverted==NULL ){ return FALSE; }	// mۂɎs
	memset( pConverted , 0 , lConvertedLength + CGSTR_MAX_ENDCODE );

	// -----< ϊ >-----
	//
	pWork = (unsigned char*)m_pString;
	long lLetterSize = -1;
	while( (pWork!=0x00) && ((pWork-(unsigned char*)m_pString)<iCurrentLength) ){
		// <<< p肵āAU蕪 >>>
		if( CGStr::isHankakuKana( *pWork )==TRUE ){
			// p̏ꍇAϊĒu
			lLetterSize = KanaConvert( (unsigned char*)pWork , (unsigned char*)pConverted );
			if( lLetterSize==-1 ){
				// ϊG[
				free( pConverted );
				return FALSE;
			}
		} else {
			// płȂꍇAP̂܂ܕ
			lLetterSize = GetMBLetterSize( (const char*)pWork );
			strncat( (char*)pConverted , (char*)pWork , lLetterSize );
		}

		// <<< P|C^i߂ >>>
		pWork += lLetterSize;
	}

	// -----< ϊ̕œeu >-----
	//
	free( m_pString );
	m_pString = (char*)pConverted;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Explode( const CGStr& rKey , CDStringArray& rElements )
//
//	[  ]
//		const CGStr&   rKey			̃L[ƂȂ镶
//		CDStringArray& rElements	ʂi[邽߂ CDStringArray ւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		 rKey ŕAz rElements Ɋi[܂B
//--------------------------------------------------------------------
BOOL CGStr::Explode( const CGStr& rKey , CDStringArray& rElements )
{
	BOOL bRes;

	// <<< 𕡐 >>>
	unsigned char* pString;
	pString	= (unsigned char*)malloc( Length()+CGSTR_MAX_ENDCODE );
	if( pString==NULL ){
		return NULL;
	}
	memcpy( pString , GetString() , Length() );
	bRes = SetEndCode( pString+Length() );
	if( bRes==FALSE ){
		free( pString );
		return FALSE;
	}

	// <<< Ȃi[ >>>
	unsigned char*	pTop;
	unsigned char*	pWork;

	rElements.Release();
	pTop	= pString;
	pWork	= pString;

	while( 1 ){
		// ؂蕶A̓GhR[hƈvA؂菈
		if(    (CheckKey( pWork , rKey )==TRUE)
			|| (IsEndCode( pWork )      ==TRUE)
		){
			// vf擾
			long lLength;
			lLength = pWork-pTop;

			// vfpm
			unsigned char* pElem;
			pElem = (unsigned char*)malloc( lLength+CGSTR_MAX_ENDCODE );
			if( pElem==NULL ){
				free( pString );
				return FALSE;
			}
			memcpy( pElem,pTop,lLength );
			bRes = SetEndCode( pElem+lLength );
			if( bRes==FALSE ){
				free( pElem );
				free( pString );
				return FALSE;
			}

			// vfǉ
			long lIndex;
			lIndex = rElements.Add( (char*)pElem );
			free( pElem );
			if( lIndex==-1 ){
				free( pString );
				return FALSE;
			}

			// GhR[hȂI
			if( IsEndCode( pWork )==TRUE ){
				break;
			}

			// GhR[hłȂ΃|C^𓮂
			pWork	= pWork + rKey.Length();
			pTop	= pWork;
			continue;
		}

		// |C^i߂
		long lLetterLength;
		lLetterLength	= GetMBLetterSize( (char*)pWork );
		pWork			+= lLetterLength;
	}

	// <<< ꎞobt@ďI >>>
	free( pString );
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Explode( const char* pKey , CDStringArray& rElements )
//
//	[  ]
//		const char*    pKey			̃L[ƂȂ镶
//		CDStringArray& rElements	ʂi[邽߂ CDStringArray ւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		 pKey ŕAz rElements Ɋi[܂B
//--------------------------------------------------------------------
BOOL CGStr::Explode( const char* pKey , CDStringArray& rElements )
{
	return Explode( CGStr( pKey ) , rElements );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Implode( const CGStr& rKey , CDStringArray& rElements )
//
//	[  ]
//		CGStr&         rKey			vfԂɑ}镶
//		CDStringArray& rElements 	vfi[ CDStringArray ւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z rElements Ɋi[ꂽArKey ŋ؂P
//		Ɍ܂B
//--------------------------------------------------------------------
BOOL CGStr::Implode( const CGStr& rKey , CDStringArray& rElements )
{
	long i;
	BOOL bRes;

	// <<< vf̐擾 >>>
	long lCount;
	lCount	= rElements.Length();

	// <<<  >>>
	CGStr	objResult;
	bRes = objResult.Initialize();
	if( bRes==FALSE ){
		return FALSE;
	}

	for( i=0;i<lCount;i++ ){
		if( i!=0 ){
			bRes = objResult.AppendString( rKey );
			if( bRes==FALSE ){
				return FALSE;
			}
		}

		bRes	= objResult.AppendString( rElements[ i ] );
		if( bRes==FALSE ){
			return FALSE;
		}
	}

	// <<< ʂi[ >>>
	bRes = SetString( objResult.GetString() );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Implode( const char* pKey , CDStringArray& rElements )
//
//	[  ]
//		const char*    pKey			vfԂɑ}镶
//		CDStringArray& rElements 	vfi[ CDStringArray ւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		z rElements Ɋi[ꂽApKey ŋ؂P
//		Ɍ܂B
//--------------------------------------------------------------------
BOOL CGStr::Implode( const char* pKey , CDStringArray& rElements )
{
	return Implode( CGStr( pKey ) , rElements );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Split( const CGStr& rKey , CGStr& rLeft , CGStr& rRight )
//
//	[  ]
//		const CGStr& rKey			؂藣L[
//		CGStr&       rLeft			
//		CGStr&       rRight			E
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Ɋ܂܂ rKey ̍ƉEŕ܂B
//		ʂ́ArLeft  rRight Ɋi[܂B
//		 rKey ܂܂Ȃꍇɂ FALSE ŕԂ܂B
//--------------------------------------------------------------------
BOOL CGStr::Split( const CGStr& rKey , CGStr& rLeft , CGStr& rRight )
{
	long i,c;
	BOOL bRes;

	// -----< 񒷎擾 >-----
	//
	long lLength;
	lLength	= Length();

	long lKeyLength;
	lKeyLength	= rKey.Length();

	// 񒷂̍擾
	long lDiff;
	lDiff	= lLength-lKeyLength;
	if( lDiff<0 ){
		return FALSE;
	}

	// -----< T >-----
	//
	long lIndex	= -1;
	for( i=0;i<lDiff;i++ ){
		BOOL bAgree = TRUE;
		for( c=0;c<lKeyLength;c++ ){
			if( m_pString[i+c]!=rKey.m_pString[c] ){
				bAgree = FALSE;
				break;
			}
		}

		if( bAgree==TRUE ){
			lIndex	= i;
			break;
		}

		// }`oCg̏ꍇ́ATCYԂ̕␳B
		long lLetterSize;
		lLetterSize = GetMBLetterSize( m_pString+(i+c) );
		i += lLetterSize -1;
	}

	// -----< L[ꍇ̓G[ >-----
	//
	if( lIndex==-1 ){
		return FALSE;
	}

	// -----< E쐬 >-----
	//
	// 
	unsigned char* pLeftString;
	pLeftString	= (unsigned char*)malloc( lIndex + CGSTR_MAX_ENDCODE );
	if( pLeftString==NULL ){
		return FALSE;
	}
	memcpy( pLeftString , m_pString , lIndex );
	bRes = SetEndCode( pLeftString + lIndex );
	if( bRes==FALSE ){
		free( pLeftString );
		return FALSE;
	}
	rLeft	= (char*)pLeftString;
	free( pLeftString );

	// E
	rRight	= m_pString + lIndex + lKeyLength;		// E쐬

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Split( const char* pKey , CGStr& rLeft , CGStr& rRight )
//
//	[  ]
//		const char* pKey			؂藣L[
//		CGStr&      rLeft			
//		CGStr&      rRight			E
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Ɋ܂܂ rKey ̍ƉEŕ܂B
//		ʂ́ArLeft  rRight Ɋi[܂B
//		 rKey ܂܂Ȃꍇɂ FALSE ŕԂ܂B
//--------------------------------------------------------------------
BOOL CGStr::Split( const char* pKey , CGStr& rLeft , CGStr& rRight )
{
	CGStr	objKey;
	objKey	= pKey;

	BOOL bRes;
	bRes	= Split( objKey , rLeft , rRight );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CleanRelativeFSExpression( const char* pDesc )
//
//	[  ]
//		const char* pDesc		t@CfBXNv^̕
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		񂪃t@CVXẽpX\ہA
//		΃pX\NA܂B
//			a/b/c/../d  -> a/b/d
//			a/b/c/./d   -> a/b/c/d
//--------------------------------------------------------------------
BOOL CGStr::CleanRelativeFSExpression( const char* pDesc )
{
	long i;
	BOOL bRes;

	// -----< t@CfBXNv^ɂĕ >-----
	//
	CDStringArray aryElems;
	bRes	= Explode( pDesc , aryElems );
	if( bRes==FALSE ){ return FALSE; }

	// -----< pX >-----
	//
	CDStringArray aryNewElems;
	for( i=0;i<aryElems.Length();i++ ){
		CGStr strElem;
		strElem = aryElems[ i ];

		// <<< 󕶎͖ >>>
		if( strElem=="" ){ continue; }

		// <<< . ͖ >>>
		if( strElem=="." ){ continue; }

		// <<< .. ̏ꍇ́AŌ̗vf폜 >>>
		if( strElem==".." ){
			long lRemoveIndex;
			lRemoveIndex = aryNewElems.Length()-1;
			if( lRemoveIndex<0 ){ continue; }	// [g̐e̓[gfBNg

			aryNewElems.Remove( lRemoveIndex );
			continue;
		}

		// <<< . ł .. łȂꍇ́Avfǉ >>>
		aryNewElems.Add( strElem.GetString() );
	}

	// -----< Č >-----
	//
	bRes = Implode( pDesc , aryNewElems );
	if( bRes==FALSE ){ return FALSE; }

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsFSFullPathString( const char* pDescriptor , BOOL bDriveEnabled )
//
//	[  ]
//		const char* pDescriptor		t@CfBXNv^̕
//		BOOL bDriveEnabled			MS-DOS/Windowsñt@CVXêƂTRUE
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@CVXe\Ɖ肵ƂA
//		̕\tpX\ۂ𔻒肵ĕԂ܂B
//--------------------------------------------------------------------
BOOL CGStr::IsFSFullPathString( const char* pDescriptor , BOOL bDriveEnabled )
{
	CGStr strDescriptor( pDescriptor );					// t@CfXNv^
	CGStr strNetworkRoot;								// lbg[NpXw̃[g\
	strNetworkRoot	= strDescriptor + strDescriptor;

	// -----< Zꍇ >-----
	//
	if( Length()<3 ){ return FALSE; }

	// -----< hCus̃[gw̏ꍇ >-----
	//
	if( bDriveEnabled==TRUE ){
		// \ ŊJnA\\ ł͂Ȃꍇ̓hCus̃pXw
		if(    (IsHead(strDescriptor) ==TRUE )
			&& (IsHead(strNetworkRoot)==FALSE)
		){
			return FALSE;
		}
	}

	// -----<  >-----
	//
	CGStr	strIniPath		= "";
	BOOL	bRelativePath	= TRUE;		// ΃pX\̂ƂTRUE

	// \\ ŊJnꍇ̓lbg[NpX
	if( IsHead( strNetworkRoot )==TRUE ){ bRelativePath = FALSE; }

	// ?:\ ŊJnꍇ̓[JtpX
	if( GetString()[1]==':' ){
		CGStr strWork( GetString()+2 );			// C: ȍ~̕i\a\b\cƂj
		if( strWork.IsHead(pDescriptor)==TRUE ){	// t@CfBXNv^ŊJnmF
			bRelativePath = FALSE;
		}
	}

	// -----< ʂԂ >-----
	//
	if( bRelativePath==TRUE ){
		return FALSE;
	}
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CheckKey( const unsigned char* pString , const CGStr& rKey )
//
//	[  ]
//		const unsigned char*  pString	̐擪ւ̃|C^
//		const CGStr& rKey				L[
//
//	[ ߂l ]
//		      vFTRUE
//		vȂFFALSE
//
//	[  ]
//		 pString ̐擪AL[ rKey ƈv邩
//		ۂmF܂B
//--------------------------------------------------------------------
BOOL CGStr::CheckKey( const unsigned char* pString , const CGStr& rKey )
{
	// L[ւ̃|C^擾
	const char* pKeyString = rKey.GetString();

	// L[񒷂擾
	long        lLength;
	lLength	= rKey.Length();

	// r
	long i;
	for( i=0;i<lLength;i++ ){
		if( pKeyString[i]!=pString[i] ){
			return FALSE;
		}
	}

	// v
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long KanaConvert( const char* pSource , const char* pDestination )
//
//	[  ]
//		const char* pSource				ϊւ̃|C^
//		const char* pTarget				ϊ敶ւ̃|C^
//
//	[ ߂l ]
//		ϊ̃CNgJEg
//
//	[  ]
//		
//--------------------------------------------------------------------
long CGStr::KanaConvert( unsigned char* pSource , unsigned char* pDestination )
{
	const char* pNormalLetter[] = {		// 0xa1 - 0xdf ̕R[h
		  "B", "u", "v", "A", "E", "", "@"				// a1-
		, "B", "D", "F", "H", "", "", "", "b"		// a8-
		, "[", "A", "C", "E", "G", "I", "J", "L"		// b0-
		, "N", "P", "R", "T", "V", "X", "Z", "\"		// b8-
		, "^", "`", "c", "e", "g", "i", "j", "k"		// c0-
		, "l", "m", "n", "q", "t", "w", "z", "}"		// c8-
		, "~", "", "", "", "", "", "", ""		// d0-
		, "", "", "", "", "", "", "J", "K"		// d8-
    };
	const char* pDirtyLetter1[] = {			// _ϊiJ`^sj
		  "K", "M"											// b0-
		, "O", "Q", "S", "U", "W", "Y", "[", "]"		// b8-
		, "_", "a", "d", "f", "h"
	};
	const char* pDirtyLetter2[] = {			// _ϊinsj
		  "o", "r", "u", "x", "{"							// c8-
	};
	const char* pHalfDirtyLetter[] = {		// _ϊ
		  "p", "s", "v", "y", "|"							// c8-
	};

	unsigned char* pLetter = NULL;		// ϊ㕶
	long lIncrementCount = -1;

	// _
	if( *(pSource+1)==0xDE ){
		if( (*pSource>=0xB6) && (*pSource<=0xC4) ){	// J`g
			pLetter = (unsigned char*)( pDirtyLetter1[ (*pSource)-0xB6 ] );
			lIncrementCount = 2;
		}
		if( (*pSource>=0xCA) && (*pSource<=0xCE) ){	// n`z
			pLetter = (unsigned char*)( pDirtyLetter2[ (*pSource)-0xCA ] );
			lIncrementCount = 2;
		}
	}

	// _
	if( *(pSource+1)==0xDF ){
		if( (*pSource>=0xCA) && (*pSource<=0xCE) ){
			pLetter = (unsigned char*)( pHalfDirtyLetter[ (*pSource)-0xCA ] );
			lIncrementCount = 2;
		}
	}

	// ʏ̕ϊ
	if( pLetter==NULL ){
		pLetter = (unsigned char*)( pNormalLetter[ (*pSource)-0xA1 ] );
			lIncrementCount = 1;
	}

	// 
	strcat( (char*)pDestination , (char*)pLetter );
	return lIncrementCount;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL isHankakuKana( unsigned char cCode )
//
//	[  ]
//		unsigned char cCode			
//
//	[ ߂l ]
//		pJiFTRUE
//		pJił͂ȂFFALSE
//
//	[  ]
//		w肳ꂽR[hpJił邩ۂ𔻒肵܂B
//--------------------------------------------------------------------
BOOL CGStr::isHankakuKana( unsigned char cCode )
{
	BOOL bResult = FALSE;

	// 
	if( (cCode>=0xA1) && (cCode<=0xDF) ){
		bResult = TRUE;
	}

	// ʂԂ
	return bResult;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr CreateTimeString()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		l̕
//
//	[  ]
//		l̃IuWFNgĕԂ܂B
//--------------------------------------------------------------------
CGStr CGStr::CreateTimeString()
{
	// ݂̎l𓾂
	time_t sTime;
	time( &sTime );

	// [J^Cɕϊ
	struct tm *today;
	today = localtime( &sTime );

	// ɕϊ
	char buffer[1024];
	sprintf( buffer , "%04d%02d%02d%02d%02d%02d" , today->tm_year+1900 , today->tm_mon+1 , today->tm_mday , today->tm_hour , today->tm_min , today->tm_sec );

	// IuWFNgĕԂ
	CGStr strResult	= buffer;
	return strResult;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr& operator=( const CGStr& rStr )
//
//	[  ]
//		const CGStr& rStr			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CGStr& CGStr::operator=( const CGStr& rStr )
{
	// <<< IuWFNg̓eRs[ >>>
	BOOL bRes;
	bRes	= CopyMembers( rStr );
	if( bRes==FALSE ){
		return *this;
	}

	// <<< Ԃ >>>
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr& operator=( const char* pStr )
//
//	[  ]
//		const char* pString			镶
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CGStr& CGStr::operator=( const char* pStr )
{
	// <<<  >>>
	BOOL bRes;
	bRes	= Initialize();
	if( bRes==FALSE ){
		return *this;
	}

	// <<< ݒ >>>
	bRes	= SetString( pStr );
	if( bRes==FALSE ){
		return *this;
	}

	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr	operator+( const CGStr& rString ) const
//
//	[  ]
//		const CGStr& rString		
//
//	[ ߂l ]
//		Ai[IuWFNg
//
//	[  ]
//		ZZq
//--------------------------------------------------------------------
CGStr	CGStr::operator+( const CGStr& rString ) const
{
	// <<< ʊi[pIuWFNg >>>
	CGStr	objStr;

	// <<< Z >>>
	objStr	= *this;
	objStr.AppendString( rString );

	return objStr;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr operator+( const char* pString ) const
//
//	[  ]
//		const char* pString			鐔
//
//	[ ߂l ]
//		Ai[IuWFNg
//
//	[  ]
//		ZZq
//--------------------------------------------------------------------
CGStr	CGStr::operator+( const char* pString ) const
{
	// <<< ʊi[pIuWFNg >>>
	CGStr	objStr;

	// <<< Z >>>
	objStr	= *this;
	objStr.AppendString( pString );

	// <<< Ԃ >>>
	return objStr;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr& operator+=( const char* pString )
//
//	[  ]
//		const char* pString			A镶
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		ZZq
//--------------------------------------------------------------------
CGStr& CGStr::operator+=( const char* pString )
{
	BOOL bRes;
	bRes	= AppendString( pString );
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr& operaotr+=( const CGStr& rString )
//
//	[  ]
//		const CGStr& rString		A镶ւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		ZZq
//--------------------------------------------------------------------
CGStr& CGStr::operator+=( const CGStr& rString )
{
	BOOL bRes;
	bRes	= AppendString( rString );
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL operator==( const char* pString ) const
//
//	[  ]
//		const char* pString			rΏۂ̕
//
//	[ ߂l ]
//		  vFTRUE
//		svFFALSE
//
//	[  ]
//		rZq
//		̓evĂꍇ TRUE Ԃ܂B
//		̊i[ʒuقȂĂĂA񂪈v
//		TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::operator==( const char* pString ) const
{
	// -----< NULL ꍇɂ >-----
	//
	if( pString==NULL ){
		if( GetString()!=NULL )return FALSE;
		return TRUE;
	}
	if( GetString()==NULL ){
		if( pString!=NULL )return FALSE;
		return TRUE;
	}

	// -----< ̕Ƃ NULL łȂꍇ >-----
	//
	if( strcmp( pString , GetString() )!=0 )return FALSE;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL operator==( const CGStr& rString ) const
//
//	[  ]
//		const CGStr& rString		rΏƂ̕
//
//	[ ߂l ]
//		  vFTRUE
//		svFFALSE
//
//	[  ]
//		rZq
//		̓evĂꍇ TRUE Ԃ܂B
//		̊i[ʒuقȂĂĂA񂪈v
//		TRUE Ԃ܂B
//--------------------------------------------------------------------
BOOL CGStr::operator==( const CGStr& rString ) const
{
	// -----< NULL ꍇɂ >-----
	//
	if( rString.GetString()==NULL ){
		if( GetString()!=NULL )return FALSE;
		return TRUE;
	}
	if( GetString()==NULL ){
		if( rString.GetString()!=NULL )return FALSE;
		return TRUE;
	}

	// -----< ̕Ƃ NULL łȂꍇ >-----
	//
	if( strcmp( rString.GetString() , GetString() )!=0 )return FALSE;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL operator!=( const char* pString ) const
//
//	[  ]
//		const char* pString			rΏƂ̕
//
//	[ ߂l ]
//		@vFFALSE
//		svFTRUE
//
//	[  ]
//		operator== ̔ےԂ܂B
//--------------------------------------------------------------------
BOOL CGStr::operator!=( const char* pString ) const
{
	BOOL bRes;
	bRes	= ( *this==pString );

	if( bRes==TRUE )return FALSE;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL operator!=( CGStr& rString ) const
//
//	[  ]
//		const CGStr& rString		rΏƂ̕
//
//	[ ߂l ]
//		@vFFALSE
//		svFTRUE
//
//	[  ]
//		operator== ̔ےԂ܂B
//--------------------------------------------------------------------
BOOL CGStr::operator!=( const CGStr& rString ) const
{
	BOOL bRes;
	bRes	= ( *this==rString );

	if( bRes==TRUE )return FALSE;
	return TRUE;
}
