//-------------------------------------------------------------------------
//                      - rghnqh -
//  an Shooting game system Integrated with Object Resources and Images.
//
//		soundunit.h		TEhjbg wb_
//                                                    Programmed by.fsm
//-------------------------------------------------------------------------

#ifndef __SOUNDUNIT_H__
#define __SOUNDUNIT_H__

#include <MMSystem.h>
#include <dsound.h>

#include "system.h"
#include "DArrayHash.h"
#include "Str.h"

class SOUNDDATA;													// DirectSoundBufferNX
class DSCONTROL;													// DirectSoundNX

//----------------------------------------------------------
//    ǗNX
//----------------------------------------------------------
class CGSoundUnit{
	// -----< \z >-----
	//
	public:
		static CGSoundUnit* GetInstance();							// CX^X擾

		CGSoundUnit();												// RXgN^
		virtual ~CGSoundUnit();										// fXgN^
		static CGSoundUnit s_objSoundUnit;							// IuWFNg

	protected:
		DSCONTROL*	m_pDSControl;									// DirectSoundRg[ւ̃|C^

		CDArrayHash< long >	m_hashWavePage;							// WAVt@C̃y[Wԍ

		HWND		m_hWnd;											// EBhEnh

	// -----< C >-----
	//
	public:
		BOOL	Initialize( int iMaxPage );							// 
		void	Release();											// IuWFNg̃[X
		void	SetHWnd( HWND hWnd );								// EBhEnhZbg

	// -----< f[^̓ǂݍ݁^j >-----
	//
	public:
																	// waveǂݍށBy[WԍԂ
		int		AddWave( char* pFName,char* pWaveName,int iPolyNum, long volume );
		void	ReleaseWave();										// Wave

	// -----< Đ^~ >-----
	//
	public:
		BOOL	PlayWave( int iPage,BOOL bLoop=FALSE );				// Đ
		BOOL	PlayWave( const char* pName , BOOL bLoop=FALSE );	// OwōĐ
																	// AwavĐ
		BOOL	PlayConnectWave( int iPage1,int iPage2,BOOL bLoop=FALSE );
		BOOL	PlayConnectWave( const char* pName1 , const char* pName2 , BOOL bLoop=FALSE );
		BOOL 	SetPolyCursor( int iPage,int iNum );				// Đobt@̃J[\ύX
		BOOL	StopWave( int iPage );								// ~
		BOOL	StopWave( const char* pName );

		BOOL	StopAll();

	// -----< ̑̑ >-----
	//
	public:
		int		GetWavePage( const char* pWaveName );
		CDObjArray< CGStr >	GetWaveNameList();						// o^ĂWav̖̂zŕԂ
};


//----------------------------------------------------------
//    Xbhɓnp[^
//----------------------------------------------------------
typedef struct _CONNECTSOUNDPARAM
{
	SOUNDDATA*			m_pSoundData;								// ĐSOUNDDATAւ̃|C^
	LPDIRECTSOUNDBUFFER m_pIntroSoundBuffer;						// CgDirectSoundBuffer
	BOOL				m_bLoop;									// [v邩ۂ
}CONNECTSOUNDPARAM;

#endif
