//-------------------------------------------------------------------------
//                      - rghnqh -
//  an Shooting game system Integrated with Object Resources and Images.
//
//		soundunit.cpp	TEhjbg 
//                                                    Programmed by.fsm
//-------------------------------------------------------------------------

#include "system.h"
#include <mmsystem.h>
#include <dsound.h>
#include <stdio.h>
#include <stdlib.h>

#include "system.h"
#include "DArrayHash.h"

#include "DSControl.h"							// DirectSound Control
#include "SoundUnit.h"

				// -----< vg^Cv錾 >-----
static DWORD WINAPI SU_ConnectSoundThread( LPVOID pParam );	// ATEh̍Đ

				// ----< O[oϐ >-----
static HANDLE				hConnectSoundEvent = NULL;
static CONNECTSOUNDPARAM*	psCSP = NULL;
static HANDLE				hConnectSoundThread = NULL;
static DWORD				dwThreadID = 0;

CGSoundUnit CGSoundUnit::s_objSoundUnit;

//------------------------------------------------< CX^X擾 >
//
CGSoundUnit* CGSoundUnit::GetInstance()
{
	return &( CGSoundUnit::s_objSoundUnit );
}


//------------------------------------------------< RXgN^ >
//
CGSoundUnit::CGSoundUnit()
{
	m_pDSControl = NULL;							// |C^
	m_hWnd		= NULL;								// EBhEnh
}


//------------------------------------------------< fXgN^ >
//
CGSoundUnit::~CGSoundUnit()
{
	Release();

	if( m_pDSControl ){							// DSControl̉
		m_pDSControl->Release();
		delete m_pDSControl;
		m_pDSControl = NULL;
	}

	m_hashWavePage.Release();						// Wavẽy[Wԍz
}


//------------------------------------------------< @>
//
BOOL CGSoundUnit::Initialize( int iMaxPage )
{
	Release();									// Oɉ

	if( m_hWnd==NULL ){
		return FALSE;
	}

	// WavePage̊i[
	m_hashWavePage.Initialize();					

	// DSControl쐬
	m_pDSControl = new DSCONTROL( m_hWnd );
	if( m_pDSControl==NULL ){
		return FALSE;
	}

	// DSControl
	BOOL bRes;
	bRes = m_pDSControl->Initialize( iMaxPage );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//------------------------------------------------<  >
//
void CGSoundUnit::Release()
{
	if( hConnectSoundEvent )CloseHandle( hConnectSoundEvent );
	if( hConnectSoundThread )TerminateThread( hConnectSoundThread,0 );
	if( hConnectSoundThread )CloseHandle( hConnectSoundThread );
	if( psCSP )free( psCSP );
	hConnectSoundEvent = NULL;
	hConnectSoundThread = NULL;
	psCSP = NULL;
	dwThreadID = 0;


												// DSControl̉
	if( m_pDSControl!=NULL ){
		m_pDSControl->Release();
		delete m_pDSControl;
		m_pDSControl = NULL;
	}
												// z̉
	m_hashWavePage.Release();
}


//------------------------------------------------< WAVE̒ǉ >
//
int CGSoundUnit::AddWave( char* pFileName,char* pWaveName,int iPolyNum, long volume )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return 0;		// DirectSoundΖ

	int iPage;
	iPage = m_pDSControl->Add( pFileName,iPolyNum, volume );	// ǂݍ
	if( iPage==-1 ){								// ǂݍݎs
		return -1;
	}

	this->m_hashWavePage.Add( pWaveName , iPage );			// Ozɒǉ
	return iPage;
}


//------------------------------------------------< Wavẻ >
//
void CGSoundUnit::ReleaseWave()
{
	if( m_pDSControl==NULL )return;
	if( m_pDSControl->IsAvail()==FALSE )return;		// DirectSoundΖ

	m_hashWavePage.Initialize();						// y[Wԍ

	if( m_pDSControl==NULL )return;					// IuWFNg΃LZ

	m_pDSControl->ReleaseSound( 0 );					// 
}


//------------------------------------------------< EBhEnh̐ݒ >
//
void CGSoundUnit::SetHWnd( HWND hWnd )
{
	m_hWnd = hWnd;
}


//------------------------------------------------< WAVE̍Đ >
//
BOOL CGSoundUnit::PlayWave( int iPage,BOOL  bLoop )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return TRUE;	// DirectSoundΖ

	BOOL bRes;
	bRes = m_pDSControl->Play( iPage,bLoop );
	return bRes;
}


//------------------------------------------------< WAVE̍Đ >
BOOL CGSoundUnit::PlayWave( const char* pName , BOOL bLoop )
{
	BOOL bRes;

	// CfbNX擾
	long lIndex;
	lIndex = GetWavePage( pName );
	if( lIndex<0 ){
		//ErrorLog( "CGSoundUnit::PlayWave : Đׂ̃CfbNXԍł܂łB\n" );
		return FALSE;
	}

	// ubW
	bRes = PlayWave( lIndex , bLoop );
	if( bRes==FALSE ){
		//ErrorLog( "CGSoundUnit::PlayWave : ĐɎs܂B\n" );
		return FALSE;
	}

	// 
	return TRUE;
}


//------------------------------------------------< WAVẼ|tHjbNJ[\ύX >
//
BOOL CGSoundUnit::SetPolyCursor( int iPage,int iNum )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return TRUE;	// DirectSoundΖ

	BOOL bRes;
	bRes = m_pDSControl->SetPolyCursor( iPage,iNum );
	return bRes;
}


//------------------------------------------------< WAVE̒~ >
//
BOOL CGSoundUnit::StopWave( int iPage )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return TRUE;	// DirectSoundΖ

	BOOL bRes;
	bRes = m_pDSControl->Stop( iPage );
	return bRes;
}


//------------------------------------------------< WAVE̒~ >
//
BOOL CGSoundUnit::StopWave( const char* pName )
{
	BOOL bRes;
	long lIndex;

	// ~鉹̃CfbNX𓾂
	lIndex = GetWavePage( pName );
	if( lIndex<0 ){
		//ErrorLog( "CGSoundUnit::StopWave : CfbNXԍł܂łB\n" );
		return FALSE;
	}

	// ubW
	bRes = StopWave( lIndex );
	if( bRes==FALSE ){
		//ErrorLog( "CGSoundUnit::StopWave : ~Ɏs܂B\n" );
		return FALSE;
	}


	// 
	return TRUE;
}


//------------------------------------------------< WAVEy[Wԍ >
//
int CGSoundUnit::GetWavePage( const char* pWaveName )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return 0;			// DirectSoundΖ

	// ̃CfbNXԍ擾
	int iRes;
	iRes = m_hashWavePage.GetIndex( pWaveName );
	if( iRes<0 ){
		//ErrorLog( "CGsoundUnit::GetWavePage : CfbNX擾ł܂łB\n" );
		return iRes;
	}

	// ʂԂ
	return iRes;
}


//--------------------------------------------------------------------
//	[  ]
//		CDObjArray< CGStr > GetWaveNameList()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Wav̓o^̔z
//
//	[  ]
//		o^ĂWav̖̂zɊi[ĕԂ܂B
//--------------------------------------------------------------------
CDObjArray< CGStr > CGSoundUnit::GetWaveNameList()
{
	return m_hashWavePage.GetKeys();
}


//------------------------------------------------< AĐ >
//
BOOL CGSoundUnit::PlayConnectWave( int iPage1,int iPage2,BOOL bLoop )
{
	if( m_pDSControl==NULL )return FALSE;					// DSControlOƃG[
	if( m_pDSControl->IsAvail()==FALSE )return TRUE;		// DirectSoundΖ


			// -----< ʒmCxg쐬 >-----
														// ZLeB쐬
	SECURITY_ATTRIBUTES sSecurity;
	sSecurity.nLength = (DWORD)sizeof( SECURITY_ATTRIBUTES );
	sSecurity.lpSecurityDescriptor = NULL;
	sSecurity.bInheritHandle = FALSE;

														// Cxg쐬
	if( hConnectSoundEvent ){
		CloseHandle( hConnectSoundEvent );
		hConnectSoundEvent = NULL;
	}
	hConnectSoundEvent
		= CreateEvent( &sSecurity,FALSE,FALSE,"SB_ConnectSound" );
	if( hConnectSoundEvent==NULL ){
		return FALSE;
	}

			// -----< DirectSoundBuffer ɒʒmwݒ肷 >-----
														// DirectSoundBuffer擾
	LPDIRECTSOUNDBUFFER lpDSB;
	lpDSB = m_pDSControl->GetSoundData( iPage1 )->GetDirectSoundBuffer();

														// C^[tFCX擾
	LPDIRECTSOUNDNOTIFY lpNotify;
	HRESULT hRes;
	hRes = lpDSB->QueryInterface(IID_IDirectSoundNotify,(void**)&lpNotify);

	if( hRes!=S_OK ){
		CloseHandle( hConnectSoundEvent );
		hConnectSoundEvent = NULL;
		return FALSE;
	}
														// ʒmZbg
	DSBPOSITIONNOTIFY sDSBPos;
//	sDSBPos.dwOffset	= DSBPN_OFFSETSTOP;				// ĐIɒʒm
	sDSBPos.dwOffset	= m_pDSControl->GetSoundData( iPage1 )->Length-1;	// ĐIɒʒm
	sDSBPos.hEventNotify= hConnectSoundEvent;			// ΉCxg
	lpNotify->SetNotificationPositions( 1,&sDSBPos );
	lpNotify->Release();

			// -----< ʒmCxgɉXbh쐬 >-----
														// Xbhɓnp[^ݒ
	if( psCSP ){
		free( psCSP );
		psCSP = NULL;
	}
	psCSP = (CONNECTSOUNDPARAM*)malloc( sizeof( CONNECTSOUNDPARAM ) );
	if( psCSP==NULL ){
		CloseHandle( hConnectSoundEvent );
		hConnectSoundEvent = NULL;
		lpDSB->QueryInterface( IID_IDirectSoundNotify,(void**)(&lpNotify) );
		lpNotify->SetNotificationPositions( 0,NULL );
		lpNotify->Release();
		return FALSE;
	}
	psCSP->m_pSoundData		= m_pDSControl->GetSoundData( iPage2 );
	psCSP->m_pIntroSoundBuffer = m_pDSControl->GetSoundData( iPage1 )->GetDirectSoundBuffer();
	psCSP->m_bLoop			= bLoop;

														// Xbh쐬
	if( hConnectSoundThread ){
		CloseHandle( hConnectSoundThread );
		hConnectSoundThread = NULL;
	}
	hConnectSoundThread
		= CreateThread( NULL,NULL,SU_ConnectSoundThread,NULL,0,&dwThreadID );
	if( hConnectSoundThread==NULL ){
		CloseHandle( hConnectSoundEvent );
		hConnectSoundEvent = NULL;
		free( psCSP );
		psCSP = NULL;
		lpDSB->QueryInterface( IID_IDirectSoundNotify,(void**)(&lpNotify) );
		lpNotify->SetNotificationPositions( 0,NULL );
		lpNotify->Release();
		return FALSE;
	}
	SetThreadPriority( hConnectSoundThread,THREAD_PRIORITY_TIME_CRITICAL );


			// -----< Đ >-----
	BOOL bRes;
	bRes = m_pDSControl->Play( iPage1 );					// PڂĐ
	return bRes;
}


//------------------------------------------------< AĐ >
//
BOOL CGSoundUnit::PlayConnectWave( const char* pName1 , const char* pName2 , BOOL bLoop )
{
	BOOL bRes;

	long lIndex1 = GetWavePage( pName1 );
	long lIndex2 = GetWavePage( pName2 );

	// ubW
	bRes = PlayConnectWave( lIndex1 , lIndex2 , bLoop );
	return bRes;
}


//------------------------------------------------< S~ >
//
BOOL CGSoundUnit::StopAll()
{
	long i;
	BOOL bRes;

	for( i=0;i<m_hashWavePage.Length();i++ ){
		long lPage;
		lPage	= m_hashWavePage[ i ];
		bRes	= StopWave( lPage );
		if( bRes==FALSE )return FALSE;
	}

	// I
	return TRUE;
}


//------------------------------------------------< AĐXbh >
//
DWORD WINAPI SU_ConnectSoundThread( LPVOID pParam )
{
	WaitForSingleObject( hConnectSoundEvent,INFINITE );		// Cxg܂ő҂

	psCSP->m_pSoundData->Play( psCSP->m_bLoop );				// Đ

	LPDIRECTSOUNDNOTIFY lpNotify;						// Iʒm
	psCSP->m_pIntroSoundBuffer->QueryInterface( IID_IDirectSoundNotify,(void**)(&lpNotify) );
	lpNotify->SetNotificationPositions( 0,NULL );
	lpNotify->Release();

	CloseHandle( hConnectSoundEvent );						// ォÂ
	hConnectSoundEvent = NULL;
	if( psCSP )free( psCSP );
	psCSP = NULL;
	hConnectSoundThread = NULL;
	ExitThread( 0 );

	return -1;
}
