//---------------------------------------------------------------------
//  MCIRg[NXȂ
//---------------------------------------------------------------------
#include "system.h"
#include <stdio.h>
#include <stdlib.h>

#include "MCIControl.h"

//---------------------------------------------------------------------
//  MIDIʂ̃f[^
//---------------------------------------------------------------------
//--------------------------------------------------<RXgN^>
MIDIDATA::MIDIDATA()
{
	memset( FileName,0,sizeof(FileName) );		// t@COŏ
	Loop = FALSE;								// [v邩ǂ
}

//--------------------------------------------------<fXgN^>
MIDIDATA::~MIDIDATA()
{
	// Ȃ

}

//--------------------------------------------------<Zbg>
BOOL MIDIDATA::Reset()
{

	memset( FileName,0,sizeof(FileName) );		// t@CNA
	Loop = FALSE;								// [vtO

	return TRUE;								// TRUEŏI
}

//---------------------------------------------------<>
void MIDIDATA::Initialize( char* fname,BOOL loop )
{

	strcpy( FileName,fname );					// t@CZbg
	Loop = loop;								// [vtbO

}




//---------------------------------------------------------------------
//  MCIfoCX̐NX
//---------------------------------------------------------------------
//---------------------------------------------------<RXgN^>
MCICONTROL::MCICONTROL( HWND ParamHWND )
{
	hWnd = ParamHWND;							// p[^n
	MaxOfMIDIData = 0;							// MIDIo^ő吔
	NumOfMIDIData = 0;							// MIDIf[^o^
	MIDIData = 0;								// lhchʃf[^

	MIDIState = FALSE;							// MIDỈt
	CDState = FALSE;							// CD̉t
	MIDITrack = 0;								// tgbNԍ
	CDTrack = 0;
	CDLoop = 0;									// CDĐ̓[vȂ

}


//-------------------------------------------------< fXgN^ >
MCICONTROL::~MCICONTROL()
{
	Reset();									// Zbg
	if( MIDIData )delete[] MIDIData;			// MIDIʃf[^

}


//----------------------------------------------------<  >
void MCICONTROL::Reset()
{
	if( MIDIState ){							// tȂ~
		StopMIDI();
	}

	if( CDState ){
		StopCD();
	}

	ReleaseMIDI();								// MIDI[X

	ReleaseCD();								// bc[X

}


//---------------------------------------------------< MIDI >
BOOL MCICONTROL::ReadyMIDI( int NumOfMIDI )
{
	if( MIDIState ){							// tȂ牉t~߂
		StopMIDI();								// tȂ~߂
	}
	ReleaseMIDI();								// MIDI[X

	if( NumOfMIDI==0 ){							// őo^O̓_B
		return FALSE;
	}

	MIDIData = new MIDIDATA[ NumOfMIDI ];		// MIDǏʃf[^m
	int i;
	if( MIDIData==0 ){							// mۂɎs
		return FALSE;
	}
	for( i=0;i<MaxOfMIDIData;i++ )MIDIData[i].Reset();

	MaxOfMIDIData = NumOfMIDI;					// MIDI̍őo^
	NumOfMIDIData = 0;							// o^Ă鐔O
	MIDIState=FALSE;							// tFALSE
	MIDITrack = 0;								// gbNԍO

	return TRUE;								// TRUEŏI
}


//---------------------------------------------------< MIDIo^ >
int MCICONTROL::RegistMIDI( char* FName,BOOL lp )
{

	if( MIDIData==0 ){							// OȂFALSE
		return FALSE;
	}
	if( NumOfMIDIData>=MaxOfMIDIData ){			// ȏo^łȂꍇ
		return FALSE;
	}

	MIDIData[NumOfMIDIData].Initialize( FName,lp );	// MIDȈZbg

	char tstr[512],rstr[256];
	MCIERROR res;
												// ǂݍ
	sprintf( tstr,"open %s type sequencer alias midi%d wait",FName,NumOfMIDIData );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// o^s
		return FALSE;
	}
												// t\ǂׂ
	sprintf( tstr,"capability midi%d can play wait",NumOfMIDIData );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// t\ł͂ȂȂ玸s
		sprintf( tstr,"close midi%d",NumOfMIDIData );
		mciSendString( tstr,rstr,256,NULL );

		return FALSE;
	}

	NumOfMIDIData += 1;							// o^B o^{P

	return NumOfMIDIData-1;						// o^ԍԂďI
}

//---------------------------------------------------< MIDIĐ >
BOOL MCICONTROL::PlayMIDI()
{

	if( MIDIData==0 ){								// OȂ玸s
		return FALSE;
	}
	if( NumOfMIDIData < MIDITrack+1 ){				// wԍo^ĂȂꍇ
		return FALSE;
	}

	if( MIDIState ){								// tȂ܂~
		StopMIDI();
	}

	char tstr[512],rstr[256];
	MCIERROR res;
	sprintf( tstr,"play midi%d from 0",MIDITrack );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// ss
		return FALSE;
	}
	MIDIState = TRUE;							// t

	return TRUE;								// I
}

//---------------------------------------------------< MIDIgbNݒ肷 >
BOOL MCICONTROL::TrackMIDI( int num )
{

	if( MIDIData==0 ){							// OȂ玸s
		return FALSE;
	}
	if( num+1 > NumOfMIDIData ){				// o^傫Ȑw肳ꂽ
		return FALSE;
	}

	MIDITrack = num;							// gbNԍݒ

	return TRUE;
}

//---------------------------------------------------< MIDIt~ >
BOOL MCICONTROL::StopMIDI()
{

	if( MIDIState==FALSE ){						// łɒ~Ăꍇ
		return TRUE;
	}
	if( MIDIData==0 ){							// OȂ玸s
		return FALSE;
	}
	if( MIDITrack+1 > NumOfMIDIData ){			// o^傫Ȑw肳ꂽ玸s
		return FALSE;
	}

	char tstr[512],rstr[256];
	MCIERROR res;
	sprintf( tstr,"stop midi%d",MIDITrack );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// ss
		return FALSE;
	}
	MIDIState = FALSE;							// t

	return TRUE;
}


//---------------------------------------------------< MIDI[X >
void MCICONTROL::ReleaseMIDI( int num )
{

	StopMIDI();									// tȂ~߂
	for( int i=NumOfMIDIData-1;i>=num;i-- ){
		char tstr[512],rstr[256];
		sprintf( tstr,"close midi%d",i );
		mciSendString( tstr,rstr,256,NULL );	// R}hM
		MIDIData[i].Reset();					// ʏZbg
	}

	NumOfMIDIData = num;						// o^ύX

}








//---------------------------------------------------< CD >
BOOL MCICONTROL::ReadyCD( int track )
{

	if( CDState ){							// tȂ牉t~߂
		StopCD();								// tȂ~߂
	}
	ReleaseCD();								// CD[X

	CDState=FALSE;								// tFALSE
	CDTrack = track;							// gbNԍݒ

	char tstr[512],rstr[256];
	MCIERROR res;
												// I[v
	sprintf( tstr,"open cdaudio alias cd wait" );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// o^s
		return FALSE;
	}
												// t\ǂׂ
	sprintf( tstr,"capability cd can play wait" );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// t\ł͂ȂȂ玸s
		sprintf( tstr,"close cd" );
		mciSendString( tstr,rstr,256,NULL );

		return FALSE;
	}

												// Ԃ̒Pʂ̐ݒ
	sprintf( tstr,"set cd time format tmsf wait" );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// o^s
		sprintf( tstr,"close cd" );
		mciSendString( tstr,rstr,256,NULL );
		return FALSE;
	}

												// gbN擪փV[N
	sprintf( tstr,"seek cd to %02d:00:00:00 wait",CDTrack );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// V[Ns
		sprintf( tstr,"close cd" );
		mciSendString( tstr,rstr,256,NULL );
		return FALSE;
	}

	return TRUE;						// TRUEԂďI
}


//---------------------------------------------------< CD̃gbNݒ肷 >
BOOL MCICONTROL::TrackCD( int track )
{

	if( CDState ){							// tȂ牉t~߂
		StopCD();								// tȂ~߂
	}

	CDTrack = track;							// gbNԍݒ

	char tstr[512],rstr[256];
	MCIERROR res;

												// gbN擪փV[N
	sprintf( tstr,"seek cd to %02d:00:00:00 wait",CDTrack );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// V[Ns
		return FALSE;
	}

	return TRUE;						// TRUEԂďI
}


//---------------------------------------------------< CD̃[v[hݒ >
void MCICONTROL::LoopmodeCD( int mode )
{
	CDLoop = mode;
}


//---------------------------------------------------< CDĐ >
BOOL MCICONTROL::PlayCD()
{

	if( CDState ){							// tȂ牉t~߂
		StopCD();
	}

	char tstr[512],rstr[256];
	MCIERROR res;

												// gbNĐ
	sprintf( tstr,"play cd from %d:00:00:00 notify",CDTrack );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// Đs
		return FALSE;
	}

	CDState = TRUE;
	return TRUE;						// TRUEԂďI
}


//---------------------------------------------------< CD~ >
BOOL MCICONTROL::StopCD()
{
	if( CDState==FALSE ){						// t~Ȃ炻̂܂
		return TRUE;
	}

	char tstr[512],rstr[256];
	MCIERROR res;

												// gbNĐ
	sprintf( tstr,"stop cd wait" );
	res = mciSendString( tstr,rstr,256,NULL );	// R}hM
	if( res!=0 ){								// ~s
		return FALSE;
	}
	CDState = FALSE;

	return TRUE;						// TRUEԂďI
}


//---------------------------------------------------< gbNwCDĐ >
BOOL MCICONTROL::PlayCD( int track )
{

	if( TrackCD( track )==FALSE ){					// ܂V[N
		return FALSE;
	}

	if( PlayCD()==FALSE ){							// ĐɎs
		return FALSE;
	}

	return TRUE;
}


//---------------------------------------------------< [X >
void MCICONTROL::ReleaseCD()
{

	if( CDState ){
		StopCD();
	}

}
