//------------------------------------------------------------
//  DirectSound Ǘ	DirectSound control
//------------------------------------------------------------
#include "system.h"
#include <mmsystem.h>
#include <dsound.h>

#include "DSControl.h"

//------------------------------------------------------------
//  Sound Buffer ʂ̃NX
//------------------------------------------------------------
//------------------------------------------------------< RXgN^ >
SOUNDDATA::SOUNDDATA()
{
	lpDirectSound = 0;							// DirectSoundւ̃|C^
	Sound = 0;									// f[^ւ̃|C^
	Length = 0;									// f[^̒
	lpdsb = 0;									// DirectSoundBuffer ւ̃|C^
	Poly = 0;									// d˂鐔
	PolyCursor = 0;								// obt@ԍ̃J[\
	FileName = 0;								// t@C
}

//------------------------------------------------------< fXgN^ >
SOUNDDATA::~SOUNDDATA()
{
	Release();									// IOɃ[X
}

//------------------------------------------------------<  >
BOOL SOUNDDATA::Initialize( LPDIRECTSOUND lpDS )
{
	lpDirectSound = lpDS;						// DirectSound IuWFNgւ̃|C^
	return TRUE;
}

//------------------------------------------------------< f[^ǂݍ >
BOOL SOUNDDATA::Load( char* fname,int polnum, long volume )
{
	if( lpDirectSound==0 ){						// gps\Ȃ炻̂܂ܕԂ
		return FALSE;
	}
	if( polnum<=0 ){							// dˍ킹͂PȏザȂƃ_
		return FALSE;
	}

			//---------< e평 >---------
	PolyCursor = 0;
	FileName = new char[ strlen(fname)+1 ];
	if( FileName==0 ){							// t@C̃obt@mۂɎs
		return FALSE;
	}
	strcpy( FileName,fname );					// t@Cۑ
	this->volume = volume;

			//---------< 錾 >---------
	HMMIO			hmmio;									// MMIO nh
	MMCKINFO		parent, child;							// `N
	WAVEFORMATEX	wavform;								// wave format

			//---------< `N >---------
	parent.ckid				= (FOURCC)0;					// `N
	parent.cksize 			= 0;
	parent.fccType			= (FOURCC)0;
	parent.dwDataOffset		= 0;
	parent.dwFlags			= 0;
	child = parent;

			//---------< I[v >---------
	hmmio = mmioOpen(fname, NULL, MMIO_READ | MMIO_ALLOCBUF);	// MMIOI[v
	if (hmmio == NULL){											// I[vɎs
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< RIFFւ̃fBZh >---------
	parent.fccType = mmioFOURCC('W', 'A', 'V', 'E');		// RIFFւ̃fBZh
	if( mmioDescend(hmmio, &parent, NULL, MMIO_FINDRIFF)){	// wavet@Cł͂Ȃ
		mmioClose(hmmio, 0);								// nhN[Y
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;										// FALSEŕԂ
	}

			//---------< fmtւ̃fBZh >---------
	child.ckid = mmioFOURCC('f', 'm', 't', ' ');		// WAVEt@Cfmtւ̃fBZh
	if (mmioDescend(hmmio, &child, &parent, 0)){	 	// WAVEt@Cfmt`NȂ玸s
		mmioClose(hmmio, 0);
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< WAVE FORMATǂݍ >---------
												// WAVEt@CWAVEFORMATǂݍ
	if( mmioRead( hmmio,(char*)(&wavform),sizeof(wavform) )!=sizeof(wavform) ){
		mmioClose(hmmio, 0);				 	// fmt`Nǂݍ߂ȂΎs
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}
												// PCMtH[}bgWAVE܂
	if( wavform.wFormatTag!=WAVE_FORMAT_PCM ){ 	// WAVEt@CPCMtH[}bgł͂Ȃ
		mmioClose(hmmio, 0);
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< AZh >---------
	if( mmioAscend( hmmio, &child, 0) ){		// AZh
		mmioClose( hmmio, 0 );				 	// AZhs
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< data`NփfBZh >---------
	child.ckid = mmioFOURCC('d', 'a', 't', 'a');		// data`Nւ̃fBZh
	if( mmioDescend( hmmio, &child, &parent, MMIO_FINDCHUNK)){
		mmioClose(hmmio, 0);				 	// WAVEt@Cdata`N
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< obt@m >---------
	Sound  = new BYTE[ child.cksize ];
	if( Sound == NULL){									// obt@mۂɎs
		mmioClose(hmmio, 0);
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< f[^̒Zbg >---------
	Length = child.cksize;

			//---------< wavef[^ǂݍ >---------
	if( (DWORD)mmioRead( hmmio,(char*)Sound,child.cksize )!=child.cksize ){
		mmioClose(hmmio, 0);					 		// data`Nǂݍ߂Ȃ
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}

			//---------< MMIOnh >---------
	mmioClose( hmmio,0 );								// N[Y

			//---------< DirectSoundBuffer 쐬 >---------
			//---------< 錾 >---------
	DSBUFFERDESC	dsbdesc;							// SoundBuffer Lq
	PCMWAVEFORMAT	pcmwavform;							// pcm wave format
	HRESULT			res;								// ʊi[

			//---------< |C^̏ >---------
	lpdsb = new LPDIRECTSOUNDBUFFER[ polnum ];			// |C^
	if( lpdsb==0 ){										// mێs
		delete[] Sound;									// obt@
		delete[] FileName;									// t@Cobt@
		Sound=0;
		FileName = 0;

		return FALSE;
	}
	Poly = polnum;										// pӂDirectSoundBuffer̐

			//---------< ݒ >---------
	memset( &pcmwavform,0,sizeof(PCMWAVEFORMAT) );		// \̂̏
	pcmwavform.wf.wFormatTag		= WAVE_FORMAT_PCM;			// tH[}bg^O
	pcmwavform.wf.nChannels			= wavform.nChannels;		// `l
	pcmwavform.wf.nSamplesPerSec	= wavform.nSamplesPerSec;	// Tv[g
	pcmwavform.wf.nBlockAlign		= (wavform.nChannels*wavform.wBitsPerSample)/8;
	pcmwavform.wf.nAvgBytesPerSec	= pcmwavform.wf.nSamplesPerSec * pcmwavform.wf.nBlockAlign;
	pcmwavform.wBitsPerSample		= wavform.wBitsPerSample;	// rbg[x

			//---------< DirectSoundBufferLq >---------
	memset(&dsbdesc, 0, sizeof(DSBUFFERDESC));			// OŃNA
	dsbdesc.dwSize			= sizeof(DSBUFFERDESC);		// TCY
//	dsbdesc.dwFlags			= DSBCAPS_CTRLDEFAULT|DSBCAPS_CTRLPOSITIONNOTIFY;
	//dsbdesc.dwFlags = DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.dwFlags = DSBCAPS_CTRLPOSITIONNOTIFY | DSBCAPS_CTRLVOLUME;
	dsbdesc.dwBufferBytes	= Length;
	dsbdesc.lpwfxFormat		= (LPWAVEFORMATEX)&pcmwavform;

			//---------< DirectSoundBuffer쐬 >---------
	res = lpDirectSound->CreateSoundBuffer( &dsbdesc,&(lpdsb[0]),NULL );

	if( res!=DS_OK ){									// 쐬Ɏs
		delete[] Sound;									// obt@
		delete[] lpdsb;
		Sound=0;
		lpdsb=0;
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;
	}


			//---------< DirectSoundBufferɃf[^ >---------
			//---------< 錾 >---------
	LPVOID	write1,write2;
	DWORD	length1,length2;

			//---------< bN >---------
	res = lpdsb[0]->Lock( 0,Length,&write1,&length1,&write2,&length2,0 );
	if( res==DSERR_BUFFERLOST ){						// XgĂȂ
		lpdsb[0]->Restore();							// XgAĂĒ
		res = lpdsb[0]->Lock( 0,Length,&write1,&length1,&write2,&length2,0 );
	}

	if( res!=DS_OK ){									// bNɎs
		delete[] Sound;									// obt@
		Sound=0;
		lpdsb[0]->Release();							// [X
		delete[] lpdsb;									// 
		lpdsb=0;										// |C^
		delete[] FileName;									// t@Cobt@
		FileName = 0;

		return FALSE;									// FALSEŕԂ
	}

			//---------< f[^ >---------
	CopyMemory( write1,Sound,length1 );					// Pobt@
	if( write2!=NULL ){									// Qobt@
		CopyMemory( write2,Sound+length1,length2 );
	}

			//---------< AbN >---------
	res = lpdsb[0]->Unlock( write1,length1,write2,length2 );
	if( res!=DS_OK ){									// AbNɎs
		delete[] Sound;									// obt@
		Sound=0;
		lpdsb[0]->Release();							// [X
		delete[] lpdsb;									// 
		lpdsb=0;										// |C^
		delete[] FileName;								// t@Cobt@
		FileName = 0;

		return FALSE;									// FALSEŕԂ
	}

			//---------<  >---------
	for( int i=1;i<Poly;i++ ){							// 
		res = lpDirectSound->DuplicateSoundBuffer( lpdsb[0],&(lpdsb[i]) );
		if( res!=DS_OK ){								// Ɏs
			Poly = i;									// Poly̒l𒲐
			break;										// [v𔲂
		} else {
		}
	}

	// {[ݒ
	res = lpdsb[PolyCursor]->SetVolume(this->volume);
	if (res != DS_OK) {
		// {[ݒɎs
		this->Release();
		return FALSE;
	}

	return TRUE;										// TRUEŕԂ
}

//------------------------------------------------------< [X >
void SOUNDDATA::Release()
{
	int i;


			//---------< IuWFNg̃[X >---------
	if( Sound ){								// Soundf[^
		delete[] Sound;
		Sound=0;
	}
	if( lpdsb ){								// DirectSoundBuffer
		for( i=0;i<Poly;i++ )lpdsb[i]->Release();	// ܂[X
		delete[] lpdsb;							// |C^zdelete
		lpdsb=0;
	}
	if( FileName ){
		delete[] FileName;						// t@Cobt@
		FileName = 0;
	}

	this->Length = 0;
}

//------------------------------------------------------< XgA >
void SOUNDDATA::Restore()
{
	int i;
	if( lpdsb==0 ){							// obt@݂ȂȂ炻̂܂ܕԂ
		return;
	}

	for( i=0;i<Poly;i++ ){					// ܂̓XgA
		lpdsb[i]->Restore();
	}

	char* name;								// t@CRs[Ă
	name = new char[ strlen(FileName)+1 ];
	strcpy( name,FileName );
	int pol = Poly;							// |Rs[Ă

	Release();								// Ĕj

	Load( name,pol,this->volume );						// ̂ƁA蒼(-_-;

	if( name ){								// t@Cobt@jďI
		delete[] name;
	}

}

//------------------------------------------------------< Đ >
BOOL SOUNDDATA::Play( BOOL loop )
{
	if( lpDirectSound==0 ){					// gps\Ȃ炻̂܂ܕԂ
		return FALSE;
	}
	if( lpdsb[ PolyCursor ]==0 ){			// łĂȂΕԂ
		return FALSE;
	}
	if( PolyCursor >= Poly ){				// ԈlĂĂԂ
		return FALSE;
	}

	HRESULT res;
	lpdsb[PolyCursor]->Stop();					// ~
	res = lpdsb[PolyCursor]->SetCurrentPosition(0);	// ĐJ[\߂
	if( res!=DS_OK ){				// ĐJ[\̈ړɎs
		return FALSE;
	}

	if( loop ){										// Đ
		res = lpdsb[PolyCursor]->Play( 0,0,DSBPLAY_LOOPING );
	} else {
		res = lpdsb[PolyCursor]->Play( 0,0,FALSE );
	}
	if( res!=DS_OK ){						// ĐɎs
		return FALSE;
	}

	PolyCursor += 1;						// J[\𓮂
	if( PolyCursor >= Poly )PolyCursor = 0;

	return TRUE;
}

//------------------------------------------------------< ~ >
BOOL SOUNDDATA::Stop()
{
	if( lpDirectSound==0 ){					// gps\Ȃ炻̂܂ܕԂ
		return FALSE;
	}

	int i;
	for( i=0;i<Poly;i++ ){					// SĒ~
		if( lpdsb[i] ){
			lpdsb[i]->Stop();
		}
	}

	return TRUE;
}

//------------------------------------------------------< J[\ύX >
BOOL SOUNDDATA::SetPolyCursor( int num )
{

	if( num>=Poly ){						// lsꍇ
		return FALSE;
	}

	PolyCursor = num;

	return TRUE;
}


//--------------------------------------< JgDirectSoundBufferԂ >
LPDIRECTSOUNDBUFFER SOUNDDATA::GetDirectSoundBuffer()
{
	return lpdsb[PolyCursor];
}


//------------------------------------------------------------
//  DirectSound control
//------------------------------------------------------------
//------------------------------------------------------< RXgN^ >
DSCONTROL::DSCONTROL( HWND phwnd )
{
	hwnd = phwnd;								// EBhEnh
	MaxOfPages = 0;								// y[Wő吔
	NumOfPages = 0;								// o^y[W
	lpDirectSound = 0;							// DirectSoundIuWFNg
	SoundData = 0;								// SOUNDDATA

}

//------------------------------------------------------< fXgN^ >
DSCONTROL::~DSCONTROL()
{
	Release();									// ŌɃ[X

}

//------------------------------------------------------<  >
BOOL DSCONTROL::Initialize( int MaxPage )
{

		//----------< DirectSoundIuWFNg̍쐬 >----------
	HRESULT res;
	int i;

	res = DirectSoundCreate( NULL,&lpDirectSound,NULL );	// IuWFNg쐬
	if( res!=DS_OK ){								// 쐬s
		lpDirectSound = 0;

		return TRUE;
	}

		//----------< xݒ >----------
	res = lpDirectSound->SetCooperativeLevel( hwnd,DSSCL_NORMAL );
	if( res!=DS_OK ){								// ݒ莸s
		lpDirectSound->Release();
		lpDirectSound=0;

		return FALSE;
	}

		//----------< SoundDataɍ쐬Ă폜 >----------
	if( SoundData ){							// łɍ쐬Ă
		for( int i=0;i<MaxOfPages;i++ ){
			SoundData[i].Release();
		}
		delete[] SoundData;
		SoundData = 0;
	}

		//----------< SoundDataIuWFNg쐬 >----------
	NumOfPages = 0;								// ݓo^Ă鐔
	MaxOfPages = MaxPage;						// o^\ȃy[WZbg
	SoundData = new SOUNDDATA[ MaxOfPages ];	// m
	if( SoundData==0 ){							// s
		lpDirectSound->Release();
		lpDirectSound=0;

		return FALSE;
	}

		//----------< SoundDataIuWFNg >----------
	for( i=0;i<MaxOfPages;i++ ){				// SoundData
		SoundData[i].Initialize( lpDirectSound );
	}

	return TRUE;
}


BOOL DSCONTROL::IsAvail()
{
	if( lpDirectSound!=NULL )return TRUE;
	else return FALSE;
}

//------------------------------------------------------< o^ >
int DSCONTROL::Add( char* fname,int polnum, long volume )
{
	if( SoundData==0 ){							// OȂ玸s
		return -1;
	}
	if( NumOfPages >= MaxOfPages ){				// łɍő܂œo^ĂȂ玸s
		return -1;
	}
	if( SoundData[ NumOfPages ].lpdsb ){		// łɑ݂
		SoundData[ NumOfPages ].Release();
	}

	BOOL res;
	res = SoundData[ NumOfPages ].Load( fname,polnum, volume );	// [h
	if( res==FALSE ){							// [hs
		return -1;
	}

	NumOfPages += 1;							// o^{P

	return NumOfPages-1;						// y[WԍԂ
}

//------------------------------------------------------< [X >
void DSCONTROL::ReleaseSound( int num )
{

	for( int i=num;i<NumOfPages;i++ ){			// [X
		SoundData[i].Stop();
		SoundData[i].Release();
	}
	NumOfPages = 0;
}

//------------------------------------------------------< [X >
void DSCONTROL::Release()
{

	if( SoundData ){						// SoundData [X
		ReleaseSound();
		delete[] SoundData;
		SoundData = 0;
	}

	if( lpDirectSound ){					// DirectSoundIuWFNg[X
		lpDirectSound->Release();
		lpDirectSound = 0;
	}

}

//------------------------------------------------------< Đ >
BOOL DSCONTROL::Play( int page,BOOL loop )
{
	if( lpDirectSound==0 ){					// O
		return FALSE;
	}
	if( SoundData==0 ){						// O
		return FALSE;
	}
	if( page>=NumOfPages ){					// o^z玸s
		return FALSE;
	}

	BOOL res;
	res = SoundData[ page ].Play( loop );	// Đ
	if( res==FALSE ){				// ĐɎs
		return FALSE;
	}

	return res;
}

//------------------------------------------------------< PolyJ[\ݒ >
BOOL DSCONTROL::SetPolyCursor( int page,int num )
{

	if( lpDirectSound==0 ){					// O
		return FALSE;
	}
	if( SoundData==0 ){						// O
		return FALSE;
	}
	if( page>=NumOfPages ){					// o^z玸s
		return FALSE;
	}

	BOOL res;
	res = SoundData[ page ].SetPolyCursor( num );	// ݒ

	return res;
}

//------------------------------------------------------< Stop >
BOOL DSCONTROL::Stop( int page )
{

	if( lpDirectSound==0 ){					// O
		return FALSE;
	}
	if( SoundData==0 ){						// O
		return FALSE;
	}
	if( page>=NumOfPages ){					// o^z玸s
		return FALSE;
	}

	BOOL res;
	res = SoundData[ page ].Stop();				// ~

	return res;
}


//------------------------------------------------< SOUNDDATAւ̃|C^擾 >
//
SOUNDDATA* DSCONTROL::GetSoundData( int iPage )
{
	return &(SoundData[iPage]);
}
