//==============================================================================
//    ScreenMode.cpp			ʃ[hǗ
//		CVS ID : $Id: ScreenMode.cpp,v 1.2 2010/08/07 02:27:53 gtn Exp $
//==============================================================================
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ScreenMode.h"

CGScreenMode* CGScreenMode::s_pInstance	= NULL;


//--------------------------------------------------------------------
//	[  ] private
//		CGScreenMode()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGScreenMode::CGScreenMode()
{
	BOOL bRes;
	bRes	= SetDefault();
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ] private
//		CGScreenMode( CGScreenMode& rScreenMode )
//
//	[  ]
//		CGScreenMode& rScreenMode	Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//		̊֐̎gp͋֎~Ă܂B]āA܂B
//--------------------------------------------------------------------
CGScreenMode::CGScreenMode( CGScreenMode& rScreenMode )
{
	// ̊֐̎gp͋֎~Ă܂B]āÅ֐͐܂B
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		~CGScreenMode()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGScreenMode::~CGScreenMode()
{
	BOOL bRes;
	bRes	= Release();
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^ł̏lݒs܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetDefault()
{
	m_bFullScreen		= FALSE;
	m_lScreenWidth		= 0;
	m_lScreenHeight		= 0;
	m_lSurfaceWidth		= 0;
	m_lSurfaceHeight	= 0;
	memset(&m_sViewRect, 0, sizeof(m_sViewRect));

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ] static
//		CGScreenMode* GetInstance()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FCGScreenMode IuWFNgւ̃|C^
//		sFNULL
//
//	[  ]
//		CX^X擾܂B
//		CX^X\zȌꍇ́A\zĂԂ܂B
//		łɍ\zς݂̏ꍇ́A\zς݂̃IuWFNgւ̃|C^
//		Ԃ܂B
//--------------------------------------------------------------------
CGScreenMode* CGScreenMode::GetInstance()
{
	BOOL bRes;

	if( CGScreenMode::s_pInstance==NULL ){
		CGScreenMode::s_pInstance	= new CGScreenMode();
		if( CGScreenMode::s_pInstance==NULL ){
			return FALSE;
		}

		bRes	= s_pInstance->Initialize();
		if( bRes==FALSE ){
			delete s_pInstance;
			s_pInstance	= NULL;
			return NULL;
		}
	}

	return s_pInstance;
}


//--------------------------------------------------------------------
//	[  ] static
//		BOOL ReleaseInstance()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg[X܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::ReleaseInstance()
{
	if( CGScreenMode::s_pInstance==NULL ){
		return TRUE;
	}

	delete CGScreenMode::s_pInstance;
	CGScreenMode::s_pInstance	= NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::Initialize()
{
	BOOL bRes;
	bRes	= Release();
	if( bRes==FALSE ){
		return FALSE;
	}

	m_bFullScreen	= 0;
	m_lScreenWidth	= 768;
	m_lScreenHeight	= 512;
	m_lSurfaceWidth	= 256;
	m_lSurfaceHeight= 256;
	UpdateViewRect();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::Release()
{
	m_bFullScreen	= 0;
	m_lScreenWidth	= 0;
	m_lScreenHeight	= 0;
	m_lSurfaceWidth	= 0;
	m_lSurfaceHeight= 0;
	UpdateViewRect();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetFullScreen( BOOL bMode )
//
//	[  ]
//		BOOL bMode					tXN[̂Ƃ TRUE
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		tXN[[hݒ肵܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetFullScreen( BOOL bMode )
{
	m_bFullScreen	= bMode;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetScreenWidth( long lWidth )
//
//	[  ]
//		long lWidth					ʕ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ʕݒ肵܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetScreenWidth( long lWidth )
{
	m_lScreenWidth	= lWidth;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetScreenHeight( long lHeight )
//
//	[  ]
//		long lHeight				ʍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ʍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetScreenHeight( long lHeight )
{
	m_lScreenHeight	= lHeight;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetSurfaceWidth( long lWidth )
//
//	[  ]
//		long lWidth				`敝
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`T[tFX̕ݒ肵܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetSurfaceWidth( long lWidth )
{
	m_lSurfaceWidth	= lWidth;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetSurfaceHeight( long lHeight )
//
//	[  ]
//		long lHeight				`捂
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`T[tFX̍ݒ肵܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::SetSurfaceHeight( long lHeight )
{
	m_lSurfaceHeight	= lHeight;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GetFullScreen()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		tXN[[h̏ꍇ TRUE
//		EBhE[h̏ꍇ     FALSE
//
//	[  ]
//		tXN[[hԂ܂B
//--------------------------------------------------------------------
BOOL CGScreenMode::GetFullScreen()
{
	return m_bFullScreen;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetScreenWidth()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ʕ
//
//	[  ]
//		ݒ肳Ăʂ̉ʕԂ܂B
//--------------------------------------------------------------------
long CGScreenMode::GetScreenWidth()
{
	return m_lScreenWidth;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetScreenHeight()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ʍ
//
//	[  ]
//		ݒ肳ĂʍԂ܂B
//--------------------------------------------------------------------
long CGScreenMode::GetScreenHeight()
{
	return m_lScreenHeight;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSurfaceWidth()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		`T[tFX
//
//	[  ]
//		ݒ肳Ă`T[tFXԂ܂B
//--------------------------------------------------------------------
long CGScreenMode::GetSurfaceWidth()
{
	return m_lSurfaceWidth;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetSurfaceHeight()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		`T[tFX
//
//	[  ]
//		ݒ肳Ă`T[tFXԂ܂B
//--------------------------------------------------------------------
long CGScreenMode::GetSurfaceHeight()
{
	return m_lSurfaceHeight;
}


//--------------------------------------------------------------------
//	[  ]
//		void UpdateViewRect()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		r[|[gw̋`̈ČvZčXV܂
//
//	[  ]
//		r[|[g̋`̈ČvZ܂
//--------------------------------------------------------------------
void CGScreenMode::UpdateViewRect()
{
	// `TCY@3:2̃AXyNg̍\ŃXP[
	int aspectWidth = 3;
	int aspectHeight = 2;

	// AXyNg䂾킹TCY
	double rawWidth = ((double)aspectWidth) * ((double)m_lSurfaceWidth);
	double rawHeight = ((double)aspectHeight) * ((double)m_lSurfaceHeight);
	if ((rawWidth == 0.0) && (rawHeight == 0.0)) {
		// [Z
		//DebugLog("ViewRect̃TCY0łBɏI܂B\n");
		return;
	}

	// AXyNg킹TCYɑ΂g嗦𓱏o
	double zoomW, zoomH, zoom;
	zoomW = ((double)m_lScreenWidth) / ((double)rawWidth);
	zoomH = ((double)m_lScreenHeight) / ((double)rawHeight);
	zoom = (zoomW > zoomH) ? zoomH : zoomW;

	// `TCY
	long lViewWidth = (int)(((double)(rawWidth)) * zoom);
	long lViewHeight = (int)(((double)(rawHeight)) * zoom);

	// `𓱏o
	long lViewOffsetX = (m_lScreenWidth - lViewWidth) / 2;
	long lViewOffsetY = (m_lScreenHeight - lViewHeight) / 2;
	if (lViewOffsetX < 0) { lViewOffsetX = 0; }
	if (lViewOffsetY < 0) { lViewOffsetY = 0; }

	// r[͈̔͂߂
	m_sViewRect.left = lViewOffsetX;
	m_sViewRect.top = lViewOffsetY;
	m_sViewRect.right = lViewOffsetX + lViewWidth - 1;
	m_sViewRect.bottom = lViewOffsetY + lViewHeight - 1;
}


//--------------------------------------------------------------------
//	[  ]
//		RECT* GetViewRect()
//		long GetViewWidth()
//		long GetViewHeight()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		r[|[gw̋`̈i[ RECT \̂ւ̃|C^
//		r[|[gw̋`̈̕E
//
//	[  ]
//		r[|[g̋`̈Ԃ܂B
//--------------------------------------------------------------------
RECT* CGScreenMode::GetViewRect()
{
	return &m_sViewRect;
}

long CGScreenMode::GetViewWidth()
{
	return m_sViewRect.right - m_sViewRect.left + 1;
}

long CGScreenMode::GetViewHeight()
{
	return m_sViewRect.bottom - m_sViewRect.top + 1;
}


//--------------------------------------------------------------------
//	[  ]
//		CFScreenMode& operator=( CGScreenMode& rScreenMode )
//
//	[  ]
//		CGScreenMode& rScreenMode	ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		ZqB̊֐͎gp֎~Ă܂B
//		]āA܂B
//--------------------------------------------------------------------
CGScreenMode& CGScreenMode::operator=( CGScreenMode& rScreenMode )
{
	// ̊֐͋֎~Ă܂B]āA܂B
	return *this;
}
