//------------------------------------------------------------------------------
// _l
//------------------------------------------------------------------------------
#ifndef __RNDNUM_H__
#define __RNDNUM_H__

#include "Str.h"

//----------------------------------------------------------
//  CGRndNum ev[gNX`
//----------------------------------------------------------
template <class TypeRndNum>
class CGRndNum {
	// -----< \z >-----
	//
	public:
		CGRndNum();							// RXgN^
		CGRndNum( CGRndNum<TypeRndNum>& rSource );	// Rs[RXgN^
		CGRndNum( TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset );	// lwRXgN^
		virtual ~CGRndNum();				// fXgN^

	// -----<  >-----
	//
	protected:
		TypeRndNum	m_tValue;			// Sl
		TypeRndNum	m_tAmplitude;		// U蕝
		TypeRndNum	m_tOffset;			// ItZbg

	// -----< \bh >-----
	//
	protected:
		// <<<  >>>
		virtual BOOL	SetDefault();								// Ԃ\z
		virtual BOOL	CopyMembers( CGRndNum<TypeRndNum>& rSource );	// IuWFNg̓e𕡐

	public:
		// <<< ANZT >>>
		virtual BOOL		SetValue( TypeRndNum tValue );			// lݒ肷
		virtual TypeRndNum	GetValue();								// l擾
		virtual BOOL		SetAmplitude( TypeRndNum tAmplitude );	// U蕝ݒ肷
		virtual TypeRndNum	GetAmplitude();							// U蕝擾
		virtual BOOL		SetOffset( TypeRndNum tOffset );		// ItZbgݒ肷
		virtual TypeRndNum	GetOffset();							// ItZbg擾

		virtual BOOL		Initialize( TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset );
		virtual BOOL		Release();								// IuWFNg̓e
		virtual TypeRndNum	GetRandom()		= 0;					// _l擾
		virtual CGStr		GetScript()		= 0;					// XNvgo͂

	// -----< Zq >-----
	//
	public:
		virtual CGRndNum<TypeRndNum>& operator=( CGRndNum<TypeRndNum>& rSource );		// Zq
};


//----------------------------------------------------------
//  ev[g`
//----------------------------------------------------------
//--------------------------------------------------------------------
//	[  ]
//		CGRndNum()
//		CGRndNum( CGRndNum<TypeRndNum>& rSource )
//		CGRndNum( TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset )
//
//	[  ]
//		CGRndNum<TypeRndNum>& rSource		ƃIuWFNgւ̎Q
//		TypeRndNum tValue					l
//		TypeRndNum tAmplitude				̐U蕝
//		TypeRndNum tOffset					tValue ɑ΂ItZbgl
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
// ---------------------------------
// ftHgRXgN^
// ---------------------------------
template< class TypeRndNum >
CGRndNum<TypeRndNum>::CGRndNum()
{
	// Ԃ
	SetDefault();
}

// ---------------------------------
// Rs[RXgN^
// ---------------------------------
template< class TypeRndNum >
CGRndNum<TypeRndNum>::CGRndNum( CGRndNum<TypeRndNum>& rSource )
{
	// Ԃ
	SetDefault();

	// e𕡐
	BOOL bRes;
	bRes = CopyMembers( rSource );
}

// ---------------------------------
// lwRXgN^
// ---------------------------------
template< class TypeRndNum >
CGRndNum<TypeRndNum>::CGRndNum( TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset )
{
	BOOL bRes;

	// Ԃ
	bRes	= SetDefault();

	// lݒ肷
	bRes	= Initialize( tValue , tAmplitude , tOffset );
}


//--------------------------------------------------------------------
//	[  ] virtual
//		~CGRndNum()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template< class TypeRndNum >
CGRndNum<TypeRndNum>::~CGRndNum()
{
	// e
	CGRndNum<TypeRndNum>::Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgԂɂ܂
//--------------------------------------------------------------------
template< class TypeRndNum >
BOOL CGRndNum<TypeRndNum>::SetDefault()
{
	// Nothing to do.
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( TypeRndNum& rSource )
//
//	[  ]
//		TypeRndNum& rSource				Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂
//--------------------------------------------------------------------
template< class TypeRndNum >
BOOL CGRndNum<TypeRndNum>::CopyMembers( CGRndNum<TypeRndNum>& rSource )
{
	m_tValue		= rSource.m_tValue;
	m_tAmplitude	= rSource.m_tAmplitude;
	m_tOffset		= rSource.m_tOffset;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetValue( TypeRndNum tValue )
//
//	[  ]
//		TypeRndNum tValue					ݒ肷l
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lݒ肵܂
//--------------------------------------------------------------------
template<class TypeRndNum>
BOOL CGRndNum<TypeRndNum>::SetValue( TypeRndNum tValue )
{
	m_tValue	= tValue;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TypeRndNum GetValue()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ăl
//
//	[  ]
//		ݒ肳Ăl擾܂B
//--------------------------------------------------------------------
template< class TypeRndNum >
TypeRndNum CGRndNum<TypeRndNum>::GetValue()
{
	return m_tValue;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetAmplitude( TypeRndNum tAmplitude )
//
//	[  ]
//		TypeRndNum tAmplitude			U蕝
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		_l̐U蕝ݒ肵܂
//--------------------------------------------------------------------
template <class TypeRndNum>
BOOL CGRndNum<TypeRndNum>::SetAmplitude( TypeRndNum tAmplitude )
{
	m_tAmplitude	= tAmplitude;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TypeRndNum GetAmplitude()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		_l̐U蕝
//
//	[  ]
//		_l̐U蕝Ԃ܂
//--------------------------------------------------------------------
template < class TypeRndNum >
TypeRndNum CGRndNum<TypeRndNum>::GetAmplitude()
{
	return m_tAmplitude;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetOffset( TypeRndNum tOffset )
//
//	[  ]
//		TypeRndNum tOffset				ItZbgl
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		tValue ɑ΂ItZbglݒ肵܂
//--------------------------------------------------------------------
template <class TypeRndNum>
BOOL CGRndNum<TypeRndNum>::SetOffset( TypeRndNum tOffset )
{
	m_tOffset	= tOffset;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TypeRndNum GetOffset()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ItZbgl
//
//	[  ]
//		tValue ɑ΂ItZbgl擾܂
//--------------------------------------------------------------------
template <class TypeRndNum>
TypeRndNum CGRndNum<TypeRndNum>::GetOffset()
{
	return m_tOffset;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize< TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset )
//
//	[  ]
//		TypeRndNum tValue			l
//		TypeRndNum tAmplitude		U蕝
//		TypeRndNum tOffset			tValue ɑ΂ItZbg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̑܂Ƃ߂Đݒ肵܂
//--------------------------------------------------------------------
template <class TypeRndNum>
BOOL CGRndNum<TypeRndNum>::Initialize( TypeRndNum tValue , TypeRndNum tAmplitude , TypeRndNum tOffset )
{
	BOOL bRes;
	bRes	= SetValue( tValue );
	if( bRes==FALSE ){ return FALSE; }

	bRes	= SetAmplitude( tAmplitude );
	if( bRes==FALSE ){ return FALSE; }

	bRes	= SetOffset( tOffset );
	if( bRes==FALSE ){ return FALSE; }

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂
//--------------------------------------------------------------------
template <class TypeRndNum>
BOOL CGRndNum<TypeRndNum>::Release()
{
	// Nothing to do.
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TypeRndNum& operator=( TypeRndNum& rSource )
//
//	[  ]
//		TypeRndNum& rSource				Ƃւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template< class TypeRndNum >
CGRndNum<TypeRndNum>& CGRndNum<TypeRndNum>::operator=( CGRndNum<TypeRndNum>& rSource )
{
	BOOL bRes;
	bRes	= CopyMembers( rSource );
	return *this;
}

#endif
