//------------------------------------------------------------------------------
//	Oobt@
//------------------------------------------------------------------------------

#ifndef __GRINGBUFFER_H__
#define __GRINGBUFFER_H__

#include "Utils.h"
#include "DArray.h"


// -----< NX` >-----
//
template < class T > class CGRingBuffer : public CUtils
{
	// -----< \z >-----
	//
	public:
		CGRingBuffer();										// RXgN^
		CGRingBuffer( const CGRingBuffer<T>& rRingBuffer );	// Rs[RXgN^
		CGRingBuffer( long lSize );							// TCYwRXgN^
		virtual ~CGRingBuffer();							// fXgN^

	private:
		BOOL	SetDefault();
		BOOL	CopyMembers( CGRingBuffer<T>& rRingBuffer );

	// -----<  >-----
	//
	private:
		CDArray< T >	m_aryBuffer;					// obt@擪ւ̃|C^
		long				m_lHeadIndex;					// ݂̐擪CfbNX

	// -----< \bh >-----
	//
	public:
		BOOL	Initialize( long lBufferSize );				// 
		BOOL	Release();									// IuWFNg̓ej

		long	Add( T& rData );						// f[^ǉ
		T&	Get( long lIndex );							// f[^擾
		T&	GetReverse( long lIndex );					// f[^z̋t{Ɏ擾

		long	Length();									// o^ĂIuWFNg̐Ԃ

	// -----< Zq >-----
	//
	public:
		CGRingBuffer<T>& operator=( CGRingBuffer<T>& rRingBuffer );	// Zq
		T&	operator[]( long lIndex );					// CfbNXɂQ
};


// -----<  >-----
//
//--------------------------------------------------------------------
//	[  ]
//		CGRingBuffer()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
template <class T>
CGRingBuffer< T >::CGRingBuffer()
{
	BOOL bRes;
	bRes	= SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CGRingBuffer( const CGRingBuffer<T>& rRingBuffer )
//
//	[  ]
//		ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template <class T>
CGRingBuffer< T >::CGRingBuffer( const CGRingBuffer<T>& rRingBuffer )
{
	BOOL bRes;
	bRes	= SetDefault();
	bRes	= CopyMembers( rRingBuffer );
}


//--------------------------------------------------------------------
//	[  ]
//		CGRingBuffer( long lSize )
//
//	[  ]
//		long lSize					Oobt@̃TCY
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		TCYwRXgN^
//--------------------------------------------------------------------
template <class T>
CGRingBuffer< T >::CGRingBuffer( long lSize )
{
	BOOL bRes;
	long i;

	bRes	= SetDeafult();
	bRes	= Initialize( lSize );
}


//--------------------------------------------------------------------
//	[  ]
//		~CGRingBuffer()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template <class T>
CGRingBuffer< T >::~CGRingBuffer()
{
	BOOL bRes;
	bRes	= Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɏlݒ肵܂B
//		̊֐́ARXgN^Ăяo܂B
//--------------------------------------------------------------------
template <class T>
BOOL CGRingBuffer< T >::SetDefault()
{
	m_aryBuffer.Release();									// obt@擪ւ̃|C^
	m_lHeadIndex		= 0;								// ݂̐擪CfbNX

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGRingBuffer<T>& rRingBuffer )
//
//	[  ]
//		CGRingBuffer<T>& rRingBuffer ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
template <class T>
BOOL CGRingBuffer< T >::CopyMembers( CGRingBuffer<T>& rRingBuffer )
{
	m_aryBuffer			= rRingBuffer.m_aryBuffer;			// obt@擪ւ̃|C^
	m_lHeadIndex		= rRingBuffer.m_lHeadIndex;			// ݂̐擪CfbNX

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize( long lBufferSize )
//
//	[  ]
//		long lBufferSize			Oobt@̃TCY
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓eAOobt@̃TCY lBufferSize 
//		܂B
//		f[^܂܂Ăꍇ́Aj܂B
//--------------------------------------------------------------------
template <class T>
BOOL CGRingBuffer< T >::Initialize( long lBufferSize )
{
	long i;

	m_aryBuffer.Initialize( lBufferSize );
	for( i=0;i<lBufferSize;i++ ){
		this->m_aryBuffer.Add();
	}
	m_lHeadIndex	= 0;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
template <class T>
BOOL CGRingBuffer< T >::Release()
{
	m_aryBuffer.Release();
	m_lHeadIndex	= 0;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( T& rData )
//
//	[  ]
//		T& rData				o^f[^ւ̎Q
//
//	[ ߂l ]
//		ǉvf̃CfbNXԍ
//
//	[  ]
//		lǉ܂B
//		߂lɂ́Aǉf[^̃CfbNXԍ
//		Ԃ܂B
//
//		߂lɂ́AŕێĂz̃CfbNXԍ
//		Ԃ܂B߂l̒l̂ɂ́A܂Ӗ܂B
//--------------------------------------------------------------------
template <class T>
long CGRingBuffer< T >::Add( T& rData )
{
	// -----< mF >-----
	//
	long lSize;
	lSize	= m_aryBuffer.Length();
	if( lSize<=0 ){
		ErrorLog( "CGRingBuffer::Add : OɌĂяo܂B\n" );
		return -1;
	}

	// -----< CfbNXvZ >-----
	//
	m_lHeadIndex	+= 1;
	if( m_lHeadIndex>=lSize ){
		m_lHeadIndex	= 0;
	}

	// -----< f[^i[ >-----
	//
	m_aryBuffer[ m_lHeadIndex ]	= rData;

	// -----< I >-----
	//
	return m_lHeadIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		T& Get( long lIndex )
//
//	[  ]
//		long lIndex					擾CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		l擾܂B
//		lIndex=0 ́AŐV̏w܂B
//		lIndex 傫ȂقǁAo^ߋ̃f[^ɂȂĂ܂B
//		lIndex ɓo^傫Ȓlw肳ƁAo^ꂽ
//		ŌÂ̒lԂ܂B
//		Add() xĂяoOɎsƁANX T 
//		lԂ܂B
//--------------------------------------------------------------------
template <class T>
T& CGRingBuffer< T >::Get( long lIndex )
{
	// -----< CfbNXZo >-----
	//
	long lActualIndex;
	lActualIndex	= lIndex + m_lHeadIndex;
	lActualIndex	%= m_aryBuffer.Length();

	// -----< lԂ >-----
	//
	return m_aryBuffer[ lActualIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		T& GetReverse( long lIndex )
//
//	[  ]
//		long lIndex					擾CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		l擾܂B
//		lIndex=0 ́AŌÂ̏w܂B
//		lIndex 傫ȂقǁAo^Vf[^ɂȂĂ܂B
//		lIndex ɓo^傫Ȓlw肳ƁAo^ꂽ
//		ŐV̒lԂ܂B
//		Add() xĂяoOɎsƁANX T 
//		lԂ܂B
//--------------------------------------------------------------------
template <class T>
T& CGRingBuffer< T >::GetReverse( long lIndex )
{
	// -----< CfbNXZo >-----
	//
	long lActualIndex;
	long lOffset = m_aryBuffer.Length()-1;
	lActualIndex	= m_lHeadIndex - lOffset + lIndex;
	while( lActualIndex<0 ){
		lActualIndex += m_aryBuffer.Length();
	}
	lActualIndex	%= m_aryBuffer.Length();

	// -----< lԂ >-----
	//
	return m_aryBuffer[ lActualIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long Length()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		Oobt@̃TCYԂ܂B
//		lo^Ă邩ۂɂ炸Ao^\ȃf[^TCY
//		Ԃ܂B
//--------------------------------------------------------------------
template <class T>
long CGRingBuffer< T >::Length()
{
	return m_aryBuffer.Length();
}


//--------------------------------------------------------------------
//	[  ]
//		CGRingBuffer<T>& operator=( CGRingBuffer<T>& rRingBuffer )
//
//	[  ]
//		const CGRingBuffer<T>& rRingBuffer ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template <class T>
CGRingBuffer<T>& CGRingBuffer< T >::operator=( CGRingBuffer<T>& rRingBuffer )
{
	BOOL bRes;
	bRes	= CopyMembers( rRingBuffer );

	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator[]( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		lւ̎Q
//
//	[  ]
//		Get() Ɠl̓܂B
//--------------------------------------------------------------------
template <class T>
T& CGRingBuffer< T >::operator[]( long lIndex )
{
	return Get( lIndex );
}


#endif
