//------------------------------------------------------------------------------
//	wʁxNX
//		֐̖߂lƂĎgB
//------------------------------------------------------------------------------

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "GReason.h"


//--------------------------------------------------------------------
//	[  ]
//		CGReason()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGReason::CGReason()
{
	SetDefault();					// ftHgݒ
}


//--------------------------------------------------------------------
//	[  ]
//		CGReason(
//			  const char* pFileName
//			, long        lLineNumber
//			, const char* pFuncName
//			, const char* pMessage
//			, CGReason*   pParent );
//
//	[  ]
//		const char* pFileName		t@C
//		long        lLineNumnber	sԍ
//		const char* pFuncName		֐
//		const char* pMessage		bZ[W
//		CGReason*   pParent			eւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^łB
//		IuWFNg\zAe̓eIuWFNgɐݒ肵܂B
//--------------------------------------------------------------------
CGReason::CGReason(
			  const char* pFileName
			, long        lLineNumber
			, const char* pFuncName
			, const char* pMessage
			, CGReason*   pParent )
{
	BOOL bRes;

	// <<< ftHgݒ >>>
	SetDefault();

	// <<<  >>>
	bRes	= Initialize();
	if( bRes==FALSE ){
		return;
	}

	// <<< ep[^ݒ >>>
	// t@C
	bRes	= SetFileName( pFileName );
	if( bRes==FALSE ){
		Release();
		return;
	}

	// sԍ
	bRes	= SetLineNumber( lLineNumber );
	if( bRes==FALSE ){
		Release();
		return;
	}

	// ֐
	bRes	= SetFuncName( pFuncName );
	if( bRes==FALSE ){
		Release();
		return;
	}

	// bZ[W
	long lIndex;
	lIndex	= AddMessage( pMessage );
	if( lIndex==-1 ){
		Release();
		return;
	}

	// e
	bRes	= SetParent( pParent );
	if( bRes==FALSE ){
		Release();
		return;
	}

	// I
}


//--------------------------------------------------------------------
//	[  ]
//		CGReason( CGReason& rReason )
//
//	[  ]
//		CGReason& rReason			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//		NĂe܂߁Aׂĕ܂B
//--------------------------------------------------------------------
CGReason::CGReason( CGReason& rReason )
{
	BOOL bRes;

	// <<< lݒ >>>
	SetDefault();

	// <<<  >>>
	bRes	= Initialize();
	if( bRes==FALSE ){
		Release();
		return;
	}

	// <<<  >>>
	bRes = CopyMembers( rReason );
	if( bRes==FALSE ){
		Release();
		return;
	}

	// I
}


//--------------------------------------------------------------------
//	[  ]
//		~CGReason()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//		IuWFNgɐݒ肳ꂽeċNIɍ폜܂̂ŁA
//		NꂽIuWFNgʂ̏ꏊQdȂ悤
//		ĂB
//--------------------------------------------------------------------
CGReason::~CGReason()
{
	// <<<  >>>
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɑ΂āARXgN^xł̏
//		{܂B
//--------------------------------------------------------------------
BOOL CGReason::SetDefault()
{
	// <<< lݒ >>>
	//
	m_pParent		= NULL;
	m_pFileName		= NULL;
	m_lLineNumber	= 0;
	m_pFuncName		= NULL;
	m_objMessage.Release();
	m_pReasonString	= NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGReason& rReason )
//
//	[  ]
//		CGReason& rReason			Rs[ƃIuWFNg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//		ڑꂽẽN܂߁Aׂĕ܂B
//--------------------------------------------------------------------
BOOL CGReason::CopyMembers( CGReason& rReason )
{
	BOOL bRes;

	// <<<  >>>
	//
	bRes = Initialize();
	if( bRes==FALSE ){
		Release();
		return FALSE;
	}

	// <<< 擾 >>>
	//
	const char* pFileName	= rReason.GetFileName();
	long        lLineNumber	= rReason.GetLineNumber();
	const char* pFuncName	= rReason.GetFuncName();

	// <<< ݒ >>>
	//
	bRes	= SetFileName( pFileName );
	if( bRes==FALSE ){
		Release();
		return FALSE;
	}

	bRes	= SetLineNumber( lLineNumber);
	if( bRes==FALSE ){
		Release();
		return FALSE;
	}

	bRes	= SetFuncName( pFuncName );
	if( bRes==FALSE ){
		Release();
		return FALSE;
	}

	long i;
	for( i=0;i<rReason.GetMessageCount();i++ ){
		long lIndex;
		const char* pMessage = rReason.GetMessage( i );

		lIndex	= AddMessage( pMessage );
		if( lIndex==-1 ){
			Release();
			return FALSE;
		}
	}

	// <<<  >>>
	if( rReason.m_pReasonString!=NULL ){
		long lLength;
		lLength	= strlen( rReason.m_pReasonString );

		m_pReasonString	= (char*)malloc( lLength+1 );
		if( m_pReasonString==NULL ){
			Release();
			return FALSE;
		}
		memset( m_pReasonString , 0 , lLength+1 );
		strcpy( m_pReasonString , rReason.m_pReasonString );
	} else {
		m_pReasonString	= NULL;
	}

	// <<< eݒ >>>
	//
	CGReason* pParent;
	pParent	= rReason.GetParent();

	if( pParent!=NULL ){
		// VKIuWFNg쐬
		CGReason*	pReason;
		pReason	= new CGReason();
		if( pReason==NULL ){
			Release();
			return FALSE;
		}

		// IuWFNg𕡐
		*pReason	= *pParent;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//		ڑĂẽNɂẮAċNI
//		ׂč폜܂B
//--------------------------------------------------------------------
BOOL CGReason::Initialize()
{
	BOOL bRes;
	bRes = Release();
	// Release()Ƃɏ鏉ȂB
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
BOOL CGReason::Release()
{
	if( m_pParent  !=NULL )DeleteParent();
	if( m_pFileName!=NULL )SetFileName( NULL );
	if( m_pFuncName!=NULL )SetFuncName( NULL );

	ReleaseReason();
	m_objMessage.Release();
	m_lLineNumber	= 0;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetParent( CGReason* pParent )
//
//	[  ]
//		CGReason* pParent			eIuWFNgւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ȅi[ CGReason IuWFNgN
//		ڑ܂B
//		ڑIuWFNǵAdelete ŉł̂
//		Ȃ΂Ȃ܂B
//		ڑIuWFNg̐́AׂĐڑ̃IuWFNg
//		CȂ΂Ȃ܂BڑIuWFNgʂ
//		폜肷ƁAڑ̃IuWFNg delete ɂQd
//		sN܂B
//--------------------------------------------------------------------
BOOL CGReason::SetParent( CGReason* pParent )
{
	BOOL bRes;

	// -----< ̂̂Ă >-----
	//
	if( m_pParent!=NULL ){
		bRes = DeleteParent();
		if( bRes==FALSE ){
			return FALSE;
		}
	}

	// -----< ݒ >-----
	//
	m_pParent	= pParent;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CGReason* GetParent()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ȅi[IuWFNgւ̃|C^
//		eݒ肳ĂȂꍇɂ NULL
//
//	[  ]
//		ȅi[IuWFNgւ̃|C^Ԃ܂B
//		eݒ肳ĂȂꍇɂ NULL Ԃ܂B
//--------------------------------------------------------------------
CGReason* CGReason::GetParent()
{
	return m_pParent;
}


//--------------------------------------------------------------------
//	[  ] private
//		BOOL DeleteParent()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɐڑꂽẽIuWFNgċNI
//		܂B
//--------------------------------------------------------------------
BOOL CGReason::DeleteParent()
{
	BOOL bRes;

	// <<< eȂ΂̂܂܏I >>>
	//
	if( m_pParent==NULL ){
		return TRUE;
	}

	// <<< N悪݂ꍇɂ͂ >>>
	//
	bRes = m_pParent->DeleteParent();
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< e >>>
	//
	if( m_pParent!=NULL ){
		delete m_pParent;
	}
	m_pParent = NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetFileName( const char* pFileName )
//
//	[  ]
//		const char* pFileName		t@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@CZbg܂B
//--------------------------------------------------------------------
BOOL CGReason::SetFileName( const char* pFileName )
{
	char* pNewFileName;

	// <<< t@C >>>
	//
	if( pFileName!=NULL ){
		int iLength;
		iLength = strlen( pFileName );

		pNewFileName = (char*)malloc( iLength+1 );
		if( pNewFileName==NULL ){
			return FALSE;
		}

		strcpy( pNewFileName , pFileName );
	} else {
		pNewFileName = NULL;
	}

	// <<< ̂̂ĐVt@CZbg >>>\
	//
	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}
	m_pFileName = pNewFileName;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetFileName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ăt@Cւ̃|C^
//
//	[  ]
//		ݒ肳Ăt@Cւ̃|C^Ԃ܂B
//		Ȃɂݒ肳ĂȂꍇ NULL Ԃ܂B
//--------------------------------------------------------------------
const char* CGReason::GetFileName()
{
	return m_pFileName;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLineNumber( long lLine )
//
//	[  ]
//		long lLine					Cԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		sԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGReason::SetLineNumber( long lLine )
{
	m_lLineNumber = lLine;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetLineNumber()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ăsԍ
//
//	[  ]
//		ݒ肳ĂsԍԂ܂B
//--------------------------------------------------------------------
long CGReason::GetLineNumber()
{
	return m_lLineNumber;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetFuncName( const char* pFuncName )
//
//	[  ]
//		const char* pFuncName		֐
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		֐ݒ肵܂B
//--------------------------------------------------------------------
BOOL CGReason::SetFuncName( const char* pFuncName )
{
	char* pNewFuncName;

	if( pFuncName!=NULL ){
		// <<< ֐ >>>
		//
		int iLength;
		iLength = strlen( pFuncName );

		pNewFuncName = (char*)malloc( iLength+1 );
		if( pNewFuncName==NULL ){
			return FALSE;
		}

		strcpy( pNewFuncName , pFuncName );
	} else {
		pNewFuncName = NULL;
	}

	// <<< ̂̂ĐVt@CZbg >>>\
	//
	if( m_pFuncName!=NULL ){
		free( m_pFuncName );
	}
	m_pFuncName = pNewFuncName;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetFuncName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳Ă֐ւ̃|C^
//
//	[  ]
//		ݒ肳Ă֐ւ̃|C^Ԃ܂B
//		Ȃɂݒ肳ĂȂꍇɂ NULL Ԃ܂B
//--------------------------------------------------------------------
const char* CGReason::GetFuncName()
{
	return m_pFuncName;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddMessage( const char* pMessage )
//
//	[  ]
//		const char* pMessage		ǉ郁bZ[Wւ̃|C^
//
//	[ ߂l ]
//		ǉꂽ̃CfbNXԍ
//		G[̏ꍇ -1
//
//	[  ]
//		IuWFNgɃbZ[Wi{jPsǉ܂B
//		߂lƂāAǉꂽ̍sԍԂ܂B
//		G[̏ꍇɂ -1 Ԃ܂B
//--------------------------------------------------------------------
long CGReason::AddMessage( const char* pMessage )
{
	long lResult;
	lResult	= m_objMessage.Add( pMessage );
	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetMessage( long lLine )
//
//	[  ]
//		long lLine					sԍ
//
//	[ ߂l ]
//		ւ̃|C^
//		񂪐ݒ肳ĂȂ lLine w肵ꍇɂ NULL
//
//	[  ]
//		IuWFNgɐݒ肳Ă郁bZ[WPsԂ܂B
//--------------------------------------------------------------------
const char* CGReason::GetMessage( long lLine )
{
	char* pMessage;

	// <<< ͈͂zĂLZ >>>
	if( lLine>=m_objMessage.Length() ){
		return NULL;
	}

	// <<< Ԃ >>>
	pMessage	= m_objMessage[ lLine ];

	return pMessage;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetMessageCount()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		IuWFNgɐݒ肳Ă郁bZ[W̐
//
//	[  ]
//		IuWFNgɐݒ肳Ă郁bZ[W̍sԂ܂B
//--------------------------------------------------------------------
long CGReason::GetMessageCount()
{
	long lResult;
	lResult	= m_objMessage.Length();
	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetReason()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ꂽbZ[Wւ̃|C^
//		֐sꍇɂ NULL
//
//	[  ]
//		IuWFNgɐݒ肳ĂeƂɁA
//		bZ[W\zĕԂ܂B
//		̓IuWFNgɕۑĂ܂BgpȂȂ
//		 ReleaseReason() sĉƁAʂȃ
//		}܂B
//--------------------------------------------------------------------
const char* CGReason::GetReason()
{
	long i;
	long lMessageStringLength	= 1024;		// 1024eLg[B

	// <<< o >>>
	long lCRLFLength;					// s
	lCRLFLength	= strlen( "\n" );

	long lFileNameLength = 0;			// t@C
	if( GetFileName()!=NULL ){
		lFileNameLength = strlen( GetFileName() );
	}

	long lFuncNameLength = 0;			// ֐
	if( GetFuncName()!=NULL ){
		lFuncNameLength = strlen( GetFuncName() );
	}

	long lMessageLength = 0;			// bZ[W
	long lMessageCount;
	lMessageCount	= GetMessageCount();
	for( i=0;i<lMessageCount;i++ ){
		long  lLength = 0;
		char* pMessage;

		pMessage = m_objMessage[ i ];
		lLength = strlen( pMessage );

		lMessageLength += lLength+lCRLFLength;
	}

	// <<< Zo >>>
	long lTotalLength;
	lTotalLength = lFileNameLength + lFuncNameLength + lMessageLength + lMessageStringLength;


	// <<< pm >>>
	char* pTempReason;
	pTempReason	= (char*)malloc( lTotalLength );
	if( pTempReason==NULL ){
		return NULL;
	}
	memset( pTempReason , 0 , lTotalLength );

	char* pTemp;
	pTemp = (char*)malloc( lTotalLength );
	if( pTemp==NULL ){
		free( pTempReason );
		return NULL;
	}
	memset( pTemp,0,lTotalLength );

	// m
	ReleaseReason();
	m_pReasonString	= pTempReason;

	// <<< wb_ >>>
	BOOL bFirst	= TRUE;
	if( lFileNameLength!=0 ){
		if( bFirst==FALSE ){
			sprintf( pTemp , "  " );
		}
		strcat( m_pReasonString , pTemp );
		sprintf( pTemp , "t@C[%s]" , GetFileName() );
		strcat( m_pReasonString , pTemp );
		bFirst	= FALSE;
	}

	if( GetLineNumber()!=0 ){
		if( bFirst==FALSE ){
			sprintf( pTemp , "  " );
			strcat( m_pReasonString , pTemp );
		}
		sprintf( pTemp , "sԍ[%d]" , GetLineNumber() );
		strcat( m_pReasonString , pTemp );
		bFirst	= FALSE;
	}

	if( lFuncNameLength!=0 ){
		if( bFirst==FALSE ){
			sprintf( pTemp , "  " );
			strcat( m_pReasonString , pTemp );
		}
		sprintf( pTemp , "֐[%s]" , GetFuncName() );
		strcat( m_pReasonString , pTemp );
		bFirst	= FALSE;
	}
	if( strlen( m_pReasonString )!=0 ){
		sprintf( pTemp , "\n" );
		strcat( m_pReasonString , pTemp );
	}

	// <<< 񏑂 >>>
	for( i=0;i<lMessageCount;i++ ){
		sprintf( pTemp , "%s\n" , GetMessage(i) );
		strcat( m_pReasonString , pTemp );
	}

	// <<< ʂԂ >>>
	free( pTemp );
	return m_pReasonString;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseReason()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̃bZ[Wpobt@܂B
//--------------------------------------------------------------------
BOOL CGReason::ReleaseReason()
{
	if( m_pReasonString!=NULL ){
		free( m_pReasonString );
	}
	m_pReasonString	= NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CGReason& operator=( CGReason& rReason )
//
//	[  ]
//		CGReason& rReason			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CGReason& CGReason::operator=( CGReason& rReason )
{
	BOOL bRes;
	bRes	= CopyMembers( rReason );
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		MAKE_REASON( TARGET , FUNC_NAME , MESSAGE , PARENT )
//
//	[  ]
//		TARGET				ʂ̃IuWFNg󂯎|C^
//		FUNC_NAME			֐
//		MESSAGE				bZ[W
//		PARENT				eIuWFNgւ̃|C^iNULLj
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		}N`B
//		FUNC_NAME , MESSAGE , PARENT ݒ肵 CGReason IuWFNg
//		쐬ATARGET Ɍʂݒ肵܂B
//
//		PARENT ɃIuWFNgw肷ƁAPARENT eɎ
//		IuWFNg쐬ATARGET Ɋi[܂B
//		PARENT  NULL w肷ƁAe NULL  CGReason IuWFNg
//		쐬A쐬IuWFNg TARGET ݒ肵܂B
//--------------------------------------------------------------------


//--------------------------------------------------------------------
//	[  ]
//		HANDLE_REASON( TARGET , EXEC_COMMAND )
//
//	[  ]
//		TARGET				CGReason IuWFNgւ̃|C^
//		EXEC_COMMAND		sR}h
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		}N`B
//		TARGET ɂ́A֐ԂĂ CGReason IuWFNgւ
//		|C^w肵܂B
//		̊֐́AEXEC_COMMAND sƂɁATARGET 
//		delete ܂B
//		{IɁACGReason IuWFNg̍폜YƂ
//		q[}G[}邽߂ɑ݂܂B
//--------------------------------------------------------------------


//--------------------------------------------------------------------
//	[  ]
//		PRINT_REASON( TARGET )
//
//	[  ]
//		TARGET				CGReason IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		}N`B
//		TARGET ɂ́A֐ԂĂ CGReason IuWFNgւ
//		|C^w肵܂B
//		̊֐́AWo͂Ƀ|[go͂ƂɁATARGET 
//		delete ܂B
//--------------------------------------------------------------------
