//--------------------------------------------------------------------
//  OIuWFNg
//--------------------------------------------------------------------

#ifndef __NAMED_H__
#define __NAMED_H__

#include "system.h"
#include "Str.h"

// ----------< NX` >----------
//
template < class TTYPE > class CGNamed
{
	// -----< \z >-----
	//
	public:
		CGNamed();										// ftHgRXgN^
		CGNamed( const char*  pName,const TTYPE& rObject );	// RXgN^
		CGNamed( const CGStr& rName,const TTYPE& rObject );	// RXgN^
		CGNamed( CGNamed<TTYPE>& rNamed );				// Rs[RXgN^
		virtual ~CGNamed();								// fXgN^

	private:
		BOOL	SetDefault();							// RXgN^x̏l
		BOOL	CopyMembers( CGNamed<TTYPE>& rNamed );	// IuWFNg̓e𕡐

	// -----< f[^o >-----
	//
	private:
		CGStr	m_objName;								// IuWFNg̖O
		TTYPE	m_objObject;							// IuWFNg

	// -----<  >-----
	//
	public:
		BOOL	Initialize();							// 
		BOOL	Release();								// IuWFNg̓ej

		BOOL	SetName( const char* pName );			// Oݒ肷
		BOOL	SetName( const CGStr& rName );			// Oݒ肷
		CGStr	GetName();								// O擾

		BOOL	SetObject( const TTYPE& rObject );		// IuWFNgݒ肷
		TTYPE& 	GetObject();							// IuWFNg擾

	// -----< Zq >-----
	//
	public:
		CGNamed<TTYPE>&	operator=( CGNamed<TTYPE>& rNamed );	// Zq
};


//--------------------------------------------------------------------
//	[  ]
//		CGNamed()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed< TTYPE >::CGNamed()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CGNamed( const char* pName , const TTYPE& rObject )
//
//	[  ]
//		const char*  pName			Oւ̃|C^
//		const TTYPE& rObject		ݒ肷IuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^B
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed< TTYPE >::CGNamed( const char* pName,const TTYPE& rObject )
{
	// <<<  >>>
	SetDefault();

	// <<< ݒ >>>
	BOOL bRes;
	bRes	= SetName( pName );
	if( bRes==FALSE ){
		return;
	}

	bRes	= SetObject( rObject );
	if( bRes==FALSE ){
		return;
	}

	return;
}


//--------------------------------------------------------------------
//	[  ]
//		CGNamed( const CGStr& rName , const TTYPE& rObject )
//
//	[  ]
//		const CGStr& rName			ݒ肷閼O
//		const TTYPE& rObject		ݒ肷IuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed< TTYPE >::CGNamed( const CGStr& rName,const TTYPE& rObject )
{
	// <<<  >>>
	SetDefault();

	// <<< ݒ >>>
	m_objName	= rName;
	m_objObject	= rObject;
}


//--------------------------------------------------------------------
//	[  ]
//		CGNamed( CGNamed<TTYPE>& rNamed )
//
//	[  ]
//		CGNamed<TTYPE>& rNamed		Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed< TTYPE >::CGNamed( CGNamed<TTYPE>& rNamed )
{
	// <<< lݒ >>>
	SetDefault();

	// <<<  >>>
	BOOL bRes;
	bRes	= CopyMembers( rNamed );
}


//--------------------------------------------------------------------
//	[  ]
//		~CGNamed()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed< TTYPE >::~CGNamed()
{
	// <<< j >>>
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̏lݒs܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::SetDefault()
{
	// <<< IuWFNg쐬 >>>
	TTYPE* pObject;
	pObject	= new TTYPE();
	if( pObject==NULL ){
		return FALSE;
	}

	// <<<  >>>
	m_objName.Initialize();			// 񏉊
	m_objObject	= *pObject;			// ftHgRXgN^
									// IuWFNgŏ
	delete pObject;
	pObject	= NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGNamed<TTYPE>& rNamed )
//
//	[  ]
//		CGNamed<TTYPE>& rNamed		Rs[ƃIuWFNg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::CopyMembers( CGNamed<TTYPE>& rNamed )
{
	// <<<  >>>
	m_objName	= rNamed.m_objName;
	m_objObject	= rNamed.m_objObject;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::Release()
{
	// <<< IuWFNg쐬 >>>
	TTYPE* pObject;
	pObject	= new TTYPE();
	if( pObject==NULL ){
		return FALSE;
	}

	// <<<  >>>
	m_objName.Initialize();			// 񏉊
	m_objObject	= *pObject;			// ftHgRXgN^
									// IuWFNgŏ
	delete pObject;
	pObject	= NULL;

	return TRUE;
}

//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
template< class TTYPE >
BOOL CGNamed<TTYPE>::Initialize()
{
	BOOL bRes;
	bRes = Release();
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetName( const char* pName )
//
//	[  ]
//		const char* pName			IuWFNgɂ閼O
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɖOݒ肵܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::SetName( const char* pName )
{
	BOOL bRes;
	bRes	= m_objName.SetString( pName );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetName( const CGStr& rName )
//
//	[  ]
//		const CGStr& rName			IuWFNgɂ閼O
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɖOݒ肵܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::SetName( const CGStr& rName )
{
	CGStr*	pobjName = (CGStr*)( &(rName) );
	const char* pName = pobjName->GetString();

	BOOL bRes;
	bRes	= SetName( pName );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CGStr GetName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNgɐݒ肳Ă閼OԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
CGStr CGNamed< TTYPE >::GetName()
{
	return m_objName;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetObject( const TTYPE& rObject )
//
//	[  ]
//		const TTYPE& rObject		ݒ肷IuWFNg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		OƈꏏɊǗIuWFNgݒ肵܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGNamed< TTYPE >::SetObject( const TTYPE& rObject )
{
	// <<< const Ŏ󂯎̂AU const ɕϊő >>>
	TTYPE*	pObject;
	pObject	= (TTYPE*)( &rObject );

	m_objObject	= *pObject;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE& GetObject()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ݒ肳ĂIuWFNgւ̎Q
//
//	[  ]
//		OƈꏏɊǗĂIuWFNgւ̎QƂԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
TTYPE& CGNamed< TTYPE >::GetObject()
{
	return m_objObject;
}


//--------------------------------------------------------------------
//	[  ]
//		CGNamed<TTYPE>& operator=( CGNamed<TTYPE>& rNamed )
//
//	[  ]
//		CGNamed<TTYPE>& rNamed		ƃIuWFNg
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template < class TTYPE >
CGNamed<TTYPE>& CGNamed< TTYPE >::operator=( CGNamed<TTYPE>& rNamed )
{
	BOOL bRes;
	bRes	= CopyMembers( rNamed );

	return *this;
}

#endif
