//====================================================================
//  Psǂݍ݃NX
//====================================================================

#ifndef __LINEREAD_H__
#define __LINEREAD_H__

#include "DArray.h"
#include "Utils.h"

#define LINEREAD_TOKEN_TYPE_NORMAL	0					// ʏ̃g[N
#define LINEREAD_TOKEN_TYPE_QUOTED	1					// NI[gꂽ

class CLineRead : public CUtils{
	// -----< \z >-----
	//
	public:
		CLineRead();									// RXgN^
		CLineRead( CLineRead& rLineRead );				// Rs[RXgN^
		virtual ~CLineRead();							// fXgN^

	private:
		void	SetDefault();							// Ԃ̐ݒ
		BOOL	CopyMembers( CLineRead& rLineRead );	// IuWFNg̓e𕡐

	// -----< f[^o >-----
	//
	private:
		BOOL	m_bOpenByThis;							// ̃IuWFNgt@CJۂ
		FILE*	m_pStream;								// t@CXg[
		char*	m_pFileName;							// t@C

		char*	m_pTokenHeader;							// g[N̐擪
		long	m_lBufferSize;							// Ps̃obt@TCY
		char*	m_pString;								// Ps̓eۑ邽߂̃obt@
		CDArray< char* >	m_objTokens;				// g[Nւ̃|C^
		CDArray< long >		m_objTokenTypes;			// g[N^Cvւ̃|C^
		long	m_lLineCount;							// ǂݍݍsJE^

	// -----< ֐ >-----
	//
	private:
		BOOL	AddToken( const char* pString , long lTokenType );	// p[^ǉ
		void	ReleaseTokens();						// ̃p[^j
		BOOL	TokenDivide();							// m_pString ̓eg[N


	// -----< \bh >-----
	//
	public:
		// <<<  >>>
		void	Release();								// ejďԂɖ߂

		BOOL	Open( const char* pFileName );			// t@CJ
		BOOL	Close();								// t@C
		BOOL	Attach( FILE* pStream );				// t@CXg[A^b`
		BOOL	Detach();								// t@CXg[f^b`

		BOOL	SetTokenHeader( const char* pHeader );	// g[N擪o^
		BOOL	SetBufferSize( long lSize );			// Ps̃obt@TCYݒ

		// <<< ǂݍ >>>
		BOOL	Read( BOOL bTokenDivide=TRUE );			// Psǂݍ

		// <<< f[^擾 >>>
		long	GetLine();								// sԍԂ
		BOOL	SetLine( long lLineCount );				// sԍݒ肷
		long	GetTokens();							// g[N擾
		long	GetTokenType( long lIndex );			// g[N^Cv擾
		const char*	GetToken( long lIndex );			// g[N擾
		long	GetTokenLong( long lIndex );			// g[N long Ŏ擾
		double	GetTokenDouble( long lIndex );			// g[N double Ŏ擾

		// <<< 擾 >>>
		BOOL	CheckHead( const char* pString );		// ̐擪Ńp^[}b`O
		const char*	AfterHead( const char* pString );	// wwb_ȍ~̕擾
		const char*	GetString( long lOffset=0 );		// ǂݍ񂾕擾BItZbgB

		// <<< ʒu >>>
		int		Seek( long lOffset, int iOrigin );		// w肳ꂽʒuɃt@C|C^ړ
		long	Tell();									// t@C|C^݈̌ʒu𓾂

		// <<< ̑ >>>
		BOOL	PrintLine( FILE* pStream = stdout );	// ǂݍ񂾍s̓e_v
		BOOL	PrintTokens( FILE* pStream = stdout );	// ǂݍ񂾃g[N̓e_v

	// -----< Zq >-----
	//
	public:
		CLineRead& operator=( CLineRead& rLineRead );	// Zq
};

#endif
