//====================================================================
//  Psǂݍ݃NX
//====================================================================

#include "system.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __SYSTEM_WINDOWS__
#include <mbstring.h>
#endif

#include "LineRead.h"

#define	DEFAULT_BUFFER_SIZE		2048					// Ps̃ftHgobt@TCY
#define	DEFAULT_TOKENHEADER		" \t\n#{}(),=!+-*/<>"	// g[N擪

#define DEFAULT_QUOTE_CHAR		'\''					// 萔ŵ߂̃NI[g
#define DEFAULT_QUOTE_STRING	"'"


//--------------------------------------------------------------------
//	[  ]
//		CLineRead()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CLineRead::CLineRead()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CLineRead( CLineRead& rLineRead )
//
//	[  ]
//		CLineRead& rLineRead		Rs[Ƃւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CLineRead::CLineRead( CLineRead& rLineRead )
{
	BOOL bRes;

	SetDefault();
	bRes = CopyMembers( rLineRead );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::CLineRead : IuWFNg̕Ɏs܂B\n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		~CLineRead()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CLineRead::~CLineRead()
{
	Release();

	if( m_pString ){
		free( m_pString );
	}
	if( m_pTokenHeader ){
		free( m_pTokenHeader );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^xł̃ftHglݒ
//--------------------------------------------------------------------
void CLineRead::SetDefault()
{
	m_bOpenByThis	= FALSE;		// ̃IuWFNgJt@Cł͂ȂB
	m_pStream		= NULL;			// Xg[͊֘AÂĂȂB
	m_pFileName		= NULL;			// t@CȂ
	m_pTokenHeader	= NULL;			// g[N擪̏W
	m_lBufferSize	= 0;			// Ps̃obt@TCY
	m_pString		= NULL;			// Ps̕
	m_objTokens.Release();			// g[N͋
	m_objTokenTypes.Release();		// g[N^Cv͋
	m_lLineCount	= 0;			// Os

	SetTokenHeader( DEFAULT_TOKENHEADER );	// ftHgg[Nwb_̐ݒ
	SetBufferSize( DEFAULT_BUFFER_SIZE );	// ftHg̃obt@TCY
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CLineRead& rLineRead )
//
//	[  ]
//		CLineRead& rLineRead		Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CLineRead::CopyMembers( CLineRead& rLineRead )
{
	BOOL bRes;
	long i;

	// -----< ܂ >-----
	//
	Release();

	// -----< t@CXg[ >-----
	//
	if( rLineRead.m_pStream!=NULL ){	// Xg[֘AÂĂ

		if( rLineRead.m_bOpenByThis ){	// ڃI[vꂽt@CȂAVKɊJB
			// Vt@CI[v
			//
			bRes = Open( rLineRead.m_pFileName );
			if( bRes==FALSE ){
				ErrorLog( "CLineRead::CopyMembers : t@CJ܂łB\n" );
				return FALSE;
			}

			// ItZbg
			//
			long lOffset;
			lOffset = ftell( rLineRead.m_pStream );
			if( lOffset==-1 ){
				ErrorLog( "CLineRead::CopyMembers : ItZbg擾ł܂łB\n" );
				return FALSE;
			}

			int iRes;
			iRes = fseek( m_pStream , lOffset , SEEK_SET );
			if( iRes!=0 ){
				ErrorLog( "CLineRead::CopyMembers : ItZbg܂łB\n" );
				return FALSE;
			}
		} else {
			// ֘AÂRs[
			//
			bRes = Attach( rLineRead.m_pStream );
			if( bRes==FALSE ){
				ErrorLog( "CLineRead::CopyMembers : t@C̊֘AÂɎs܂B\n" );
				return FALSE;
			}
		}
	}

	// -----< g[Nwb_ >-----
	//
	bRes = SetTokenHeader( rLineRead.m_pTokenHeader );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::CopyMembers : g[Nwb_𕡐ł܂łB\n" );
		return FALSE;
	}

	// -----< Psobt@ >-----
	//
	bRes = SetBufferSize( rLineRead.m_lBufferSize );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::CopyMembers : obt@TCYݒł܂łB\n" );
		return FALSE;
	}
	memcpy( m_pString , rLineRead.m_pString , m_lBufferSize );

	// -----< g[N >-----
	//
	for( i=0;i<rLineRead.GetTokens();i++ ){
		bRes = AddToken( rLineRead.m_objTokens[i] , rLineRead.m_objTokenTypes[i] );
		if( bRes==FALSE ){
			ErrorLog( "CLineRead::CopyMembers : g[N𕡐ł܂łB\n" );
			return FALSE;
		}
	}

	// g[N^Cv
	m_objTokenTypes	= rLineRead.m_objTokenTypes;

	// -----< CJE^ >-----
	//
	m_lLineCount = rLineRead.m_lLineCount;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AddToken( const char* pString , long lTokenType )
//
//	[  ]
//		const char* pString			g[N
//		long lTokenType				g[N^CvR[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̃g[Nobt@Ƀg[Nǉ܂B
//--------------------------------------------------------------------
BOOL CLineRead::AddToken( const char* pString , long lTokenType )
{
	// -----< mF >-----
	//
	long lSize;
	lSize	= strlen( pString );

	// -----< m >-----
	//
	char* pBuffer;
	pBuffer = (char*)malloc( lSize+1 );
	if( pBuffer==NULL ){
		ErrorLog( "CLineRead::AddToken : mۂł܂łB\n" );
		return FALSE;
	}

	// -----< 񕡐 >-----
	//
	strcpy( pBuffer , pString );

	// -----< ǉ >-----
	//
	long lIndex;
	lIndex = m_objTokens.Add( pBuffer );
	if( lIndex==-1 ){
		ErrorLog( "CLineRead::AddToken : g[Nzɒǉł܂łB\n" );
		free( pBuffer );
		return FALSE;
	}

	// -----< ^Cvǉ >-----
	//
	long lTypeIndex;
	lTypeIndex	= m_objTokenTypes.Add( lTokenType );
	if( lTypeIndex==-1 ){
		ErrorLog( "CLineRead::AddToken : g[N^Cvǉł܂łB\n" );
		return FALSE;
	}
	if( lTypeIndex!=lIndex ){
		ErrorLog( "CLineRead::AddToken : WbNG[Bƃ^CṽCfbNXv܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void ReleaseTokens()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		̃g[Nobt@ɂ܂B
//--------------------------------------------------------------------
void CLineRead::ReleaseTokens()
{
	// -----< g[N擾 >-----
	//
	long lTokens;
	lTokens = GetTokens();

	// -----< g[N̉ >-----
	//
	long i;
	for( i=0;i<lTokens;i++ ){
		if( m_objTokens[i]!=NULL ){
			free( m_objTokens[i] );
		}
		m_objTokens[i] = NULL;
	}

	// -----< g[Nz̉ >-----
	//
	m_objTokens.Release();
	m_objTokenTypes.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL TokenDivide()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		m_pString ̓eg[NAm_objTokens Ɋi[܂B
//--------------------------------------------------------------------
BOOL CLineRead::TokenDivide()
{
	BOOL bRes;

	// -----< G[`FbN >-----
	//
	if( m_pString==NULL ){
		ErrorLog( "CLineRead::TokenDivide : obt@̃TCYw肳Ă܂B\n" );
		return FALSE;
	}

	// -----< Ɨpobt@m >-----
	//
	char* pBuffer;
	pBuffer = (char*)malloc( m_lBufferSize );
	if( pBuffer==NULL ){
		ErrorLog( "CLineRead::TokenDivice : Ɨpobt@mۂł܂łB\n" );
		return FALSE;
	}

	// -----< g[N >-----
	//
	char* pWork;
	pWork = m_pString;

	// PsI܂Ń[v
	long lLength;				// ƗpBi[B
	while( 1 ){
		memset( pBuffer , 0 , m_lBufferSize );

		// <<< GhR[ho >>>
		if( *pWork==0 ){
			break;
		}

		// <<< Xy[XTABƂ΂ >>>
		lLength = strspn( pWork , " \t\r\n" );
		pWork += lLength;

		// <<< Ƃ΂ʍs̍ŌȂA܂ >>>
		if( *pWork==0 ){
			break;
		}

		// <<< # ȂRgȂ̂ŁAȍ~ >>>
		if( *pWork=='#' ){
			break;
		}

		// <<< pȂA܂łg[N >>>
		if( *pWork==DEFAULT_QUOTE_CHAR ){
			// p̓܂ňړ
			pWork++;

			// ܂ł̒o
			lLength = strcspn( pWork , DEFAULT_QUOTE_STRING );
			if( *(pWork+lLength)!=DEFAULT_QUOTE_CHAR ){
				ErrorLog( "CLineRead::TokenDivide : 񂪂PsŕĂ܂B\n" );
				free( pBuffer );
				return FALSE;
			}

			// ܂łg[NƂēo^
			strncpy( pBuffer , pWork , lLength );
			bRes = AddToken( pBuffer , LINEREAD_TOKEN_TYPE_QUOTED );
			if( bRes==FALSE ){
				ErrorLog( "CLineRead::TokenDivide : g[Nǉł܂łB\n" );
				free( pBuffer );
				return FALSE;
			}

			// g[N̎܂ňړĎ
			pWork += lLength+1;
			continue;
		}

		// <<< lꍇ >>>
		//
		if( strcspn( pWork , "0123456789." )==0 ){
			// 16i\ۂ𔻒f
			BOOL bHex = FALSE;
			if( strncmp( pWork , "0x" , 2 )==0 )bHex = TRUE;

			// l̒o
			if( bHex==FALSE ){
				lLength = strspn( pWork , "0123456789." );
			} else {
				lLength	= 2 + ( strspn( pWork+2 , "0123456789ABCDEFabcdef" ) );
			}

			// l擾
			strncpy( pBuffer , pWork , lLength );

			// g[Nǉ
			bRes = AddToken( pBuffer , LINEREAD_TOKEN_TYPE_NORMAL );
			if( bRes==FALSE ){
				ErrorLog( "CLineRead::TokenDivide : g[Nǉł܂łB\n" );
				free( pBuffer );
				return FALSE;
			}

			// g[N̎܂ňړĎ
			pWork += lLength;
			continue;
		}

		// <<< ̑̃g[N >>>
		#ifdef __SYSTEM_WINDOWS__
		lLength = _mbscspn( (unsigned char*)pWork , (unsigned char*)m_pTokenHeader );
		#else
		lLength = strcspn( pWork , m_pTokenHeader );	// }`oCgΉEEE
		#endif
		if( lLength==0 ){
			pBuffer[ 0 ] = *pWork;
			lLength = 1;
		} else {
			strncpy( pBuffer , pWork , lLength );
		}

		// g[Nǉ
		bRes = AddToken( pBuffer , LINEREAD_TOKEN_TYPE_NORMAL );
		if( bRes==FALSE ){
			ErrorLog( "CLineRead::TokenDivide : g[Nǉł܂łB\n" );
			free( pBuffer );
			return FALSE;
		}

		// g[N̎܂ňړĎ
		pWork += lLength;
		continue;
	}

	free( pBuffer );
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejAԂɖ߂܂B
//--------------------------------------------------------------------
void CLineRead::Release()
{
	// -----< t@CB >-----
	//
	if( m_bOpenByThis ){
		Close();
	} else {
		Detach();
	}

	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}
	m_pFileName	= NULL;

	// -----< g[Nwb_ >-----
	//
	SetTokenHeader( NULL );

	// -----< obt@ >-----
	//
	if( m_pString ){
		free( m_pString );
	}
	m_pString		= NULL;
	m_lBufferSize	= 0;
	m_lLineCount	= 0;

	// -----< g[N >-----
	//
	ReleaseTokens();

	// -----< obt@Đݒ >-----
	//
	BOOL bRes;
	bRes = SetBufferSize( DEFAULT_BUFFER_SIZE );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::Release : obt@̍ĐݒɎs܂B\n" );
	}

	// -----< g[Nwb_Đݒ >-----
	//
	bRes = SetTokenHeader( DEFAULT_TOKENHEADER );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::Release : g[Nwb_̍ĐݒɎs܂B\n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Open( const char* pFileName )
//
//	[  ]
//		const char* pFileName		I[vt@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@CJ܂B
//		̃\bhŊJt@ĆAIuWFNgjƂ
//		܂B
//		łɃt@CJĂ邩AXg[̊֘AÂ
//		Ăꍇɂ́AG[ɂȂ܂B
//--------------------------------------------------------------------
BOOL CLineRead::Open( const char* pFileName )
{
	// -----< ܂͊̃t@CXg[mF >-----
	//
	// t@C
	if( m_pStream!=NULL ){
		ErrorLog( "CLineRead::Open : łɃt@CJĂ܂B\n" );
		return FALSE;
	}

	// t@C
	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}
	m_pFileName = NULL;

	// -----< t@CJ >-----
	//
	// t@Cۑ
	m_pFileName = (char*)malloc( strlen( pFileName )+1 );
	if( m_pFileName==NULL ){
		ErrorLog( "CLineRead::Open : t@Cۑ邽߂̃mۂł܂łB\n" );
		return FALSE;
	}
	strcpy( m_pFileName , pFileName );

	// t@CJ
	m_pStream = fopen( pFileName , "rt" );
	if( m_pStream==NULL ){
		ErrorLog( "CLineRead::Open : t@C[%s]J܂łB\n" , pFileName );
		free( m_pFileName );
		m_pFileName = NULL;
		return FALSE;
	}

	// ̃t@ĆÃIuWFNgJ܂B
	m_bOpenByThis	= TRUE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Close()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C܂B
//		t@CI[vĂȂƂɎsƁAȂ
//		FALSE Ԃ܂BiG[Ȍo͂s܂Bj
//
//		Attach() Ŋ֘AÂꂽt@C͕邱Ƃł܂B
//		Attach() Ŋ֘AÂꂽt@C悤ƂƁA
//		̊֐ FALSE Ԃ܂B
//--------------------------------------------------------------------
BOOL CLineRead::Close()
{
	// -----< G[`FbN >-----
	//
	// t@CJĂȂ΁AȂ
	if( m_pStream==NULL ){
		return FALSE;
	}

	// ̃IuWFNgĴłȂ΃G[
	if( m_bOpenByThis==FALSE ){
		ErrorLog( "CLineRead::Close : ̃t@ĆÃIuWFNgĴł͂܂B\n" );
		return FALSE;
	}

	// -----<  >-----
	//
	fclose( m_pStream );
	m_pStream = NULL;

	if( m_pFileName!=NULL ){
		free( m_pFileName );
	}
	m_pFileName = NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Attach( FILE* pStream )
//
//	[  ]
//		FILE* pStream				t@CXg[ւ̃|C^
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@CXg[֘AÂ܂B
//		̃t@CXg[ꍇ́AG[Ԃ܂B
//
//		̊֐Ŋ֘AÂꂽt@CXg[́AClose() 
//		邱Ƃł܂B̃NX̊OŁAopen  close 
//		ǗKv܂B
//--------------------------------------------------------------------
BOOL CLineRead::Attach( FILE* pStream )
{
	// -----< G[`FbN >-----
	//
	// ̃t@CXg[G[
	if( m_pStream!=NULL ){
		ErrorLog( "CLineRead::Attach : t@CłɊ֘AÂĂ܂B\n" );
		return FALSE;
	}

	// -----< ֘AÂ >-----
	//
	m_pStream = pStream;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Detach()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Attach() Ŋ֘AÂꂽt@C܂B
//		t@CA^b`ĂȂԂŎsƁAȂ
//		FALSE Ԃ܂BiG[Oo͂܂Bj
//		Open() ŊJꂽt@C Detach 邱Ƃ͂ł܂B
//--------------------------------------------------------------------
BOOL CLineRead::Detach()
{
	// -----< G[`FbN >-----
	//
	// ֘AÂȂ΃f^b`łȂ
	if( m_pStream==NULL ){
		return FALSE;
	}

	// ̃t@ĆAŊJ́B
	if( m_bOpenByThis==TRUE ){
		ErrorLog( "CLineRead::Detach : ̃t@C͂̃IuWFNgĴłBCloseKv܂B\n" );
		return FALSE;
	}

	// -----< f^b` >-----
	//
	m_pStream	= NULL;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetTokenHeader( const char* pHeader )
//
//	[  ]
//		const char* pHeader			r镶
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		g[N̐擪ʂ镶Qݒ肵܂B
//--------------------------------------------------------------------
BOOL CLineRead::SetTokenHeader( const char* pHeader )
{
	// -----< NULL w̏ꍇ͏ďI >-----
	//
	if( pHeader==NULL ){
		if( m_pTokenHeader!=NULL ){
			free( m_pTokenHeader );
		}
		m_pTokenHeader = NULL;
		return TRUE;
	}

	// -----< ̐ݒ >-----
	//
	// 𑪂
	long lLength;
	lLength	= strlen( pHeader );

	// ̈mۂ
	char* pBuffer;
	pBuffer = (char*)malloc( lLength+1 );
	if( pBuffer==NULL ){
		ErrorLog( "CLineRead::SetTokenHeader : ̈mۂł܂łB\n" );
		return FALSE;
	}

	// g[Nwb_̕
	strcpy( pBuffer , pHeader );

	// ̂̂
	if( m_pTokenHeader!=NULL ){
		free( m_pTokenHeader );
	}
	m_pTokenHeader	= NULL;

	// Đݒ
	m_pTokenHeader	= pBuffer;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetBufferSize( long lSize )
//
//	[  ]
//		long lSize					Psǂݍݎ̃obt@TCY
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Psǂݍݎ̍őobt@TCYw肵܂B
//--------------------------------------------------------------------
BOOL CLineRead::SetBufferSize( long lSize )
{
	// -----< obt@m >-----
	//
	char* pBuffer;
	pBuffer = (char*)malloc( lSize );
	if( pBuffer==NULL ){
		ErrorLog( "CLineRead::SetBufferSize : obt@mۂł܂łB\n" );
		return FALSE;
	}
	memset( pBuffer , 0 , lSize );

	// -----< ̃obt@ >-----
	//
	if( m_pString!=NULL ){
		free( m_pString );
	}
	m_pString = NULL;

	// -----< Đݒ >-----
	//
	m_pString		= pBuffer;
	m_lBufferSize	= lSize;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Read( BOOL bTokenDivide = TRUE )
//
//	[  ]
//		BOOL bTokenDivide			g[Ns邩ۂ
//
//	[ ߂l ]
//		̏ꍇ TRUE
//		G[A͂dnȅꍇ FALSE
//
//	[  ]
//		Open ܂ Attach Ăt@CPsǂݍ݂܂B
//		bTokenDivide  TRUE ̏ꍇ́AǂݍނƓɃg[N
//		sÃobt@ɕۑ܂B
//		bTokenDivide  FALSE ̏ꍇ̓g[N܂̂
//		g[NɊ֘A@\gp邱Ƃ͂ł܂BA
//--------------------------------------------------------------------
BOOL CLineRead::Read( BOOL bTokenDivide )
{
	// -----< G[`FbN >-----
	//
	if( m_pStream==NULL ){
		ErrorLog( "CLineRead::Read : t@CXg[֘AÂĂ܂B\n" );
		return FALSE;
	}

	// -----< ܂͉ >-----
	//
	ReleaseTokens();

	// -----< ǂݍ >-----
	//
	char* pResult;
	pResult = fgets( m_pString , m_lBufferSize , m_pStream );
	if( pResult==NULL ){
		return FALSE;
	}

	// -----< g[N >-----
	//
	if( bTokenDivide ){
		BOOL bRes;
		bRes = TokenDivide();
		if( bRes==FALSE ){
			ErrorLog( "CLineRead::Read : g[NɎs܂B\n" );
			ErrorLog( "CLineRead::Read :   %s\n" , m_pString );
			return FALSE;
		}
	}

	// -----< I >-----
	//
	m_lLineCount += 1;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetLine()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ǂݍݍsԍ
//
//	[  ]
//		ǂݍݍsԍԂ܂B
//--------------------------------------------------------------------
long CLineRead::GetLine()
{
	return m_lLineCount;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLine( long lLineCount )
//
//	[  ]
//		long lLineCount				ǂݍݍsԍݒ肵܂B
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ǂݍݍsԍݒ肵܂B
//		t@CA^b`ƂȂǂɁAǂݍݍsԍ
//		ItZbgݒ肵肷ꍇɎgp܂B
//--------------------------------------------------------------------
BOOL CLineRead::SetLine( long lLineCount )
{
	m_lLineCount = lLineCount;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTokens()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		̃obt@Ɋi[Ăg[N̐
//		G[̏ꍇ -1
//
//	[  ]
//		̃obt@Ɋi[Ăg[N̐Ԃ܂B
//--------------------------------------------------------------------
long CLineRead::GetTokens()
{
	long lResult;

	lResult = m_objTokens.Length();

	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTokenType( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		g[N^Cv
//
//	[  ]
//		g[Ñ^Cv擾܂B
//		^Cv̒ĺALineRead.h Œ`Ă܂B
//--------------------------------------------------------------------
long CLineRead::GetTokenType( long lIndex )
{
	return m_objTokenTypes[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetToken( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		g[N
//
//	[  ]
//		̃obt@ɕۑĂg[NԂ܂B
//		g[ÑCfbNXԍOn܂܂B
//--------------------------------------------------------------------
const char* CLineRead::GetToken( long lIndex )
{
	// -----< G[`FbN >-----
	//
	if( lIndex<0 ){
		ErrorLog( "CLineRead::GetToken : CfbNXɕ̒lݒ肳܂B\n" );
		return FALSE;
	}
	if( lIndex>=m_objTokens.Length() ){
		ErrorLog( "CLineRead::GetToken : CfbNX̒l傫܂B\n" );
		return FALSE;
	}

	// -----< g[N̎擾 >-----
	//
	char* pResult;
	pResult = m_objTokens[ lIndex ];
	return pResult;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTokenLong( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		g[N long Ƃĉ߂l
//		G[̏ꍇ 0
//
//	[  ]
//		g[N long ̒lƂĎ擾܂B
//--------------------------------------------------------------------
long CLineRead::GetTokenLong( long lIndex )
{
	// -----< g[N̎擾 >-----
	//
	const char* pToken = GetToken( lIndex );
	if( pToken==NULL ){
		ErrorLog( "CLineRead::GetTokenLong : g[N擾ł܂łB\n" );
		return 0;
	}

	// -----< ϊ >-----
	//
	long lResult;
	lResult = atol( pToken );
	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		double GetTokenDouble( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		g[N double ^Ƃĉ߂l
//		G[̏ꍇ 0.0
//
//	[  ]
//		g[N double ̒lƂĎ擾܂B
//--------------------------------------------------------------------
double CLineRead::GetTokenDouble( long lIndex )
{
	// -----< g[N̎擾 >-----
	//
	const char* pToken = GetToken( lIndex );
	if( pToken==NULL ){
		ErrorLog( "CLineRead::GetTokenDouble : g[N擾ł܂łB\n" );
		return 0.0;
	}

	// -----< ϊ >-----
	//
	double dResult;
	dResult = atof( pToken );
	return dResult;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CheckHead( const char* pString )
//
//	[  ]
//		const char* pString			r镶
//
//	[ ߂l ]
//		@vFTRUE
//		svFFALSE
//
//	[  ]
//		ǂݍ񂾍s pString Ŏn܂邩ۂmF܂B
//		g[N̔rł͂ȂÂ܂܂̕ɑ΂
//		rs܂B
//--------------------------------------------------------------------
BOOL CLineRead::CheckHead( const char* pString )
{
	// -----< G[`FbN >-----
	//
	if( pString==NULL ){
		ErrorLog( "CLineRead::CheckHead :  NULL w肳܂B\n" );
		return FALSE;
	}

	// -----< 𑪂 >-----
	//
	long lLength;
	lLength = strlen( pString );

	// -----< r >-----
	//
	int iRes;
	iRes = strncmp( m_pString , pString , lLength );

	BOOL bResult;
	if( iRes!=0 )bResult = FALSE;
	else         bResult = TRUE;

	return bResult;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* AfterHead( const char* pString )
//
//	[  ]
//		const char* pString			擪
//
//	[ ߂l ]
//		ǂݍ񂾕ŁA擪 pString ɑ̕B
//		G[̏ꍇ NULL
//
//	[  ]
//		ǂݍ񂾕ŁA擪 pString ɑ̕Ԃ܂B
//		ǂݍ񂾕̐擪 pString łȂꍇ̓G[Ԃ܂B
//--------------------------------------------------------------------
const char* CLineRead::AfterHead( const char* pString )
{
	// -----< `FbN >-----
	//
	BOOL bRes;
	bRes = CheckHead( pString );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::AfterHead : ̐擪v܂B\n" );
		return FALSE;
	}

	// -----< 𑪂 >-----
	//
	long lLength;
	lLength = strlen( pString );

	// -----< ʂԂ >-----
	//
	char* pResult;
	pResult = m_pString + lLength;
	return pResult;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetString( long lOffset=0 )
//
//	[  ]
//		long lOffset				ǂݍ񂾕ɑ΂ItZbg
//
//	[ ߂l ]
//		ǂݍ񂾕́A擪 lOffset oCgȍ~̕B
//		G[̏ꍇ NULL
//
//	[  ]
//		ǂݍ񂾕́A擪 lOffset oCgȍ~̕
//		Ԃ܂B
//		ǂݍ񂾕 lOffset Zꍇ̓G[Ԃ܂B
//--------------------------------------------------------------------
const char* CLineRead::GetString( long lOffset )
{
	// -----< G[`FbN >-----
	//
	if( lOffset<0 ){
		ErrorLog( "CLineRead::GetString : ItZbgɕ̒lw肳܂B\n" );
		return NULL;
	}
	if( lOffset > (long)( strlen( m_pString ) ) ){
		ErrorLog( "CLineRead::GetString : 񒷂傫ȃItZbglw肳܂B\n" );
		return NULL;
	}

	// -----< Ԃ >-----
	//
	return m_pString + lOffset;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Seek( long lOffset, int iOrigin)
//
//	[  ]
//		long lOffset				lOrigin ̃oCg
//		int  iOrigin				ʒu
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肳ꂽʒuɃt@C |C^ړ܂B
//		iOrign ́ASTDIO.H ɒ`Ăȉ̒萔łȂ΂Ȃ܂B 
//		SEEK_CUR       t@C |C^̈ʒu
//		SEEK_SET       t@C̐擪
//		SEEK_END       t@C̏I[
//--------------------------------------------------------------------
BOOL CLineRead::Seek( long lOffset, int iOrigin )
{
	// -----< G[`FbN >-----
	//
	if( m_pStream==NULL ){
		ErrorLog( "CLineRead::Seek : t@CXg[֘AÂĂ܂B\n" );
		return FALSE;
	}
	if( (iOrigin != SEEK_CUR) && (iOrigin != SEEK_SET) && (iOrigin != SEEK_END) ){
		ErrorLog( "CLineRead::Seek : ʒu̎w肪܂B\n" );
		return FALSE;
	}

	// -----< ړ >-----
	if( fseek(m_pStream, lOffset, iOrigin) != 0 ){
		ErrorLog( "CLineRead::Seek : t@C|C^̈ʒuړł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long Tell()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		݂̃t@C|C^̈ʒuԂ܂B
//		G[ -1L Ԃ܂B
//
//	[  ]
//		t@C |C^݈̌ʒu𓾂܂B
//--------------------------------------------------------------------
long CLineRead::Tell()
{
	long lPosition;
	
	// -----< G[`FbN >-----
	//
	if( m_pStream==NULL ){
		ErrorLog( "CLineRead::Seek : t@CXg[֘AÂĂ܂B\n" );
		return FALSE;
	}

	// -----< 擾 >-----
	//
	lPosition = ftell(m_pStream);
	if( lPosition == -1L ){
		ErrorLog( "CLineRead::Tell : t@C|C^̈ʒu擾ł܂łB\n" );
		return lPosition;
	}

	return lPosition;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrintLine( FILE* pStream = stdout )
//
//	[  ]
//		FILE* pStream				o͐̃t@CXg[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ǂݍ񂾕Â܂ pStream ɏo͂܂B
//--------------------------------------------------------------------
BOOL CLineRead::PrintLine( FILE* pStream )
{
	// -----< G[`FbN >-----
	//
	if( m_pString==NULL ){
		ErrorLog( "CLineRead::PrintLine : obt@mۂĂ܂B\n" );
		return FALSE;
	}

	// -----< o >-----
	//
	fprintf( pStream , "%s" , m_pString );
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrintTokens( FILE* pStream = stdout )
//
//	[  ]
//		FILE* pStream				o͐̃t@CXg[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ǂݍ񂾃g[Nׂ pStream ɏo͂܂B
//--------------------------------------------------------------------
BOOL CLineRead::PrintTokens( FILE* pStream )
{
	// -----< o >-----
	//
	long i;
	for( i=0;i<GetTokens();i++ ){
		fprintf( pStream , "[%s] " , m_objTokens[i] );
	}
	fprintf( pStream , "\n" );

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CLineRead& operator=( CLineRead& rLineRead )
//
//	[  ]
//		CLineRead& rLineRead		rLineRead
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CLineRead& CLineRead::operator=( CLineRead& rLineRead )
{
	BOOL bRes;
	bRes = CopyMembers( rLineRead );
	if( bRes==FALSE ){
		ErrorLog( "CLineRead::operator= : IuWFNg̓e𕡐ł܂łB\n" );
	}

	return *this;
}
