//====================================================================
//  ʎqǗev[gNX
//====================================================================
#ifndef __IDENT_H__
#define __IDENT_H__

#include "DArray.h"
#include "Utils.h"

//----------------------------------------------------------
//  NX`
//----------------------------------------------------------
template < class T > class CIdent : public CUtils
{
	// -----< \z >-----
	//
	public:
		CIdent( long lUnit=10 );			// RXgN^
		CIdent( CIdent< T >& rIdent );		// Rs[RXgN^
		virtual ~CIdent();					// fXgN^

	private:
		BOOL SetDefault();					// lݒ
		BOOL CopyMembers( CIdent< T >& rIdent );	// IuWFNg̓e𕡐


	// -----< f[^o >-----
	//
	private:
		CDArray< char* >	m_objIdent;		// ʎq̔z
		CDArray< T* >		m_objData;		// f[^̔z


	// -----< \bh >-----
	//
	public:
		// <<<  >>>
		//
		void	Release();					// 
		void	Release( long lRemain );	// lRemaincĉ

		// <<< ǉ >>>
		//
		long	Add();						// vf̒ǉil̐ݒȂj
											// vfǉilݒ肷j
		long	Add( const char* pIdent , T& rElem );

		// <<< 擾 >>>
		//
		long 	GetIndex( const char* pIdent );

		// <<< XV >>>
		//
		BOOL	Set( long lIndex , const char* pIdent , T& rElem );
		BOOL	SetIdent( long lIndex , const char* pIdent );
		BOOL	SetValue( long lIndex        , T& rElem );
		BOOL	SetValue( const char* pIdent , T& rElem );

		// <<< 폜 >>>
		//
		BOOL	Remove( long lIndex );			// vf폜ċl߂
		BOOL	Remove( const char* pIdent );	// vf폜ċl߂

		// <<< u >>>
		//
											// vf̏ւ
		BOOL	Replace( long lIndex1 , long lIndex2 );
		BOOL	Replace( const char* pIdent1 , const char* pIdent2 );

		// <<< Q >>>
		//
		T&		operator[]( long lIndex );		// z̗vfo
		T		GetValue( long lIndex );		// l̃Rs[o
		T		GetValue( const char* pIdent );	// l̃Rs[o
		const char* GetIdent( long lIndex );	// ʎqQƂ
		long	Length();						// o^̎擾

		// <<< ̑ >>>
		//
		CIdent&	operator=( CIdent< T >& rIdent );	// Zq
};


//----------------------------------------------------------
//  ev[g`
//----------------------------------------------------------
//--------------------------------------------------------------------
//	[  ]
//		CIdent( long lUnit=10 )
//
//	[  ]
//		long lUnit					z̊gP
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//		ŊǗźAIɃTCYg܂B
//		gƂ̃TCY lUnit Ɏw肵܂B
//--------------------------------------------------------------------
template<class T>
CIdent< T >::CIdent( long lUnit )
{
	// -----< lݒ肷 >-----
	//
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CIdent( CIdent< T >& rIdent )
//
//	[  ]
//		CIdent& rIdent				Rs[Ƃ̃IuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template<class T>
CIdent< T >::CIdent( CIdent< T >& rIdent )
{
	// -----< Ԃݒ >-----
	//
	SetDefault();

	// -----< IuWFNg̓e𕡐 >-----
	//
	BOOL bRes;
	bRes = CopyMembers( rIdent );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::CIdent : IuWFNg̓e𕡐ł܂łB\n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		~CIdent()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template<class T>
CIdent< T >::~CIdent()
{
	// -----< ej >-----
	//
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgɏlݒ肵܂B
//		RXgN^Ăяo܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::SetDefault()
{
	// -----< lݒ >-----
	//
	m_objIdent.Release();
	m_objData.Release();
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CIdent< T >& rIdent )
//
//	[  ]
//		CIdent& rIdent				Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::CopyMembers( CIdent< T >& rIdent )
{
	// -----< ܂ >-----
	//
	Release();

	// -----< ǉĂ >-----
	//
	long lIndex;
	for( lIndex=0;lIndex<rIdent.Length();lIndex++ ){
		long lRes;

		// <<< o >>>
		const char* pIdent = rIdent.GetIdent( lIndex );
		T&          rValue = rIdent[ lIndex ];

		// <<< ǉ >>>
		lRes = Add( pIdent , rValue );
		if( lRes==-1 ){
			ErrorLog( "CIdent::CopyMembers : [%d]ڂ̒l̕Ɏs܂B\n" , lIndex );
			return FALSE;
		}
	}


	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejAIuWFNg̏Ԃɖ߂܂B
//--------------------------------------------------------------------
template<class T>
void CIdent< T >::Release()
{
	long lIndex;

	// -----< ʎq̉ >-----
	//
	for( lIndex=0;lIndex<m_objIdent.Length();lIndex++ ){
		if( m_objIdent[lIndex]!=NULL ){
			free( m_objIdent[lIndex] );
		}
		m_objIdent[lIndex] = NULL;
	}

	// -----< l̉ >-----
	//
	for( lIndex=0;lIndex<m_objData.Length();lIndex++ ){
		if( m_objData[lIndex]!=NULL ){
			delete m_objData[lIndex];
		}
		m_objData[lIndex] = NULL;
	}

	// -----< zIuWFNg̉ >-----
	//
	m_objIdent.Release();
	m_objData.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void Release( long lRemain )
//
//	[  ]
//		long lRemain				c萔
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		lRemain̗vfcāAo^Ăej܂B
//--------------------------------------------------------------------
template<class T>
void CIdent< T >::Release( long lRemain )
{
	// -----< 폜͈͂ >-----
	//
	long lStartIndex;
	long lEndIndex;
	lStartIndex = lRemain;
	lEndIndex   = Length()-1;

	// -----< e >-----
	//
	long lIndex;
	for( lIndex=lStartIndex;lIndex<=lEndIndex;lIndex++ ){
		// <<< ʎq̉ >>>
		//
		if( m_objIdent[lIndex]!=NULL ){
			free( m_objIdent[lIndex] );
		}
		m_objIdent[lIndex] = NULL;

		// <<< f[^̉ >>>
		//
		if( m_objData[lIndex]!=NULL ){
			delete( m_objData[lIndex] );
		}
		m_objData[lIndex] = NULL;
	}

	// -----< zZ >-----
	//
	m_objIdent.Release( lRemain );
	m_objData.Release( lRemain );
}


//--------------------------------------------------------------------
//	[  ]
//		long Add()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		IuWFNgɗvfǉ܂B
//
//	[  ]
//		f[^ɂ́A̓eݒ肵܂B
//--------------------------------------------------------------------
template<class T>
long CIdent< T >::Add()
{
	// -----< zɒǉ >-----
	//
	long lIndex;

	// <<< ʎqǉ >>>
	lIndex = m_objIdent.Add();
	if( lIndex==-1 ){
		ErrorLog( "CIdent::Add : ʎqzɒǉł܂łB\n" );
		return -1;
	}
	m_objIdent[lIndex] = NULL;

	// <<< f[^ǉ >>>
	lIndex = m_objData.Add();
	if( lIndex==-1 ){
		ErrorLog( "CIdent::Add : f[^zɒǉł܂łB\n" );

		// mۂ]Ă
		long lRemain;
		lRemain = m_objIdent.Length()-1;
		m_objIdent.Release( lRemain );

		return -1;
	}
	m_objData[lIndex] = NULL;

	// -----< ʂԂ >-----
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long Add( const char* pIdent , T& rElem )
//
//	[  ]
//		const char* pIdent			ʎq
//		T&          rElem			vfւ̎Q
//
//	[ ߂l ]
//		ǉꂽvf̃CfbNXԍ
//
//	[  ]
//		ʎqƗvfǉ܂B
//--------------------------------------------------------------------
template<class T>
long CIdent< T >::Add( const char* pIdent , T& rElem )
{
	// -----< G[`FbN >-----
	//
	if( pIdent==NULL ){
		ErrorLog( "CIdent::Add : ʎq NULL w肳܂B\n" );
		return -1;
	}

	// -----< ʎqƃIuWFNg̕쐬 >-----
	//
	// <<< ʎq̕ >>>
	//
	char* pIdentifier;
	pIdentifier = (char*)malloc( strlen( pIdent )+1 );
	if( pIdentifier==NULL ){
		ErrorLog( "CIdent::Add : ʎq𕡐邽߂̃mۂł܂łB\n" );
		return -1;
	}
	strcpy( pIdentifier , pIdent );

	// <<< IuWFNg̕ >>>
	//
	T* pElem;
	pElem = new T;
	if( pElem==NULL ){
		ErrorLog( "CIdent::Add : Vvf쐬ł܂łB\n" );
		free( pIdentifier );
		return -1;
	}
	*pElem = rElem;

	// -----< pӂ >-----
	//
	long lIndex;
	lIndex = Add();
	if( lIndex==-1 ){
		ErrorLog( "CIdent::Add : vfǉ邱Ƃł܂łB\n" );
		free( pIdentifier );
		delete pElem;
		return -1;
	}

	// -----< lݒ肷 >-----
	//
	m_objIdent[lIndex] = pIdentifier;
	m_objData[lIndex]  = pElem;

	// -----< I >-----
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetIndex( const char* pIdent )
//
//	[  ]
//		const char* pIdent			ʎqւ̃|C^
//
//	[ ߂l ]
//		ʎqŔFvf̃CfbNXԍ
//
//	[  ]
//		pIdent Ŏw肳鎯ʎqÃCfbNXԍԂ܂B
//--------------------------------------------------------------------
template<class T>
long CIdent< T >::GetIndex( const char* pIdent )
{
	// -----<  >-----
	//
	long lIndex = -1;
	long i;

	for( i=0;i<m_objIdent.Length();i++ ){
		// <<< ʎq擾 >>>
		//
		const char* pIdentifier = m_objIdent[i];
		if( pIdentifier==NULL ){
			continue;
		}

		// <<< ʎqrBvCfbNXԂ >>>
		//
		if( strcmp( pIdentifier , pIdent )==0 ){
			lIndex = i;
			break;
		}
	}

	// -----< ʂԂ >-----
	//
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Set( long lIndex , const char* pIdent , T& rElem )
//
//	[  ]
//		long        lIndex			vf̃CfbNXԍ
//		const char* pIdent			ݒ肷鎯ʎq
//		T&          rElem			vfւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex Ԗڂ̗vfɁAʎq pIdent  vfl rElem 
//		ݒ肵܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::Set( long lIndex , const char* pIdent , T& rElem )
{
	// -----< `FbN >-----
	//
	if( lIndex>=Length() ){
		ErrorLog( "CIdent::Set : wCfbNX傫܂B\n" );
		return FALSE;
	}

	if( pIdent==NULL ){
		ErrorLog( "CIdent::Set : pIdent  NULL w肳܂B\n" );
		return FALSE;
	}

	// -----< ʎqƃIuWFNg̕쐬 >-----
	//
	// <<< ʎq̕ >>>
	//
	char* pIdentifier;
	pIdentifier = (char*)malloc( strlen( pIdent )+1 );
	if( pIdentifier==NULL ){
		ErrorLog( "CIdent::Set : ʎq𕡐邽߂̃mۂł܂łB\n" );
		return FALSE;
	}
	strcpy( pIdentifier , pIdent );

	// <<< IuWFNg̕ >>>
	//
	T* pElem;
	pElem = new T;
	if( pElem==NULL ){
		ErrorLog( "CIdent::Set : Vvf쐬ł܂łB\n" );
		free( pIdentifier );
		return FALSE;
	}
	*pElem = rElem;

	// -----< ̃f[^ >-----
	//
	if( m_objIdent[lIndex]!=NULL ){
		free( m_objIdent[lIndex] );
	}
	m_objIdent[lIndex] = NULL;

	if( m_objData[lIndex]!=NULL ){
		delete m_objData[lIndex];
	}
	m_objData[lIndex] = NULL;

	// -----< lݒ肷 >-----
	//
	m_objIdent[lIndex] = pIdentifier;
	m_objData[lIndex]  = pElem;

	// -----< ʂԂ >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetIdent( long lIndex , const char* pIdent )
//
//	[  ]
//		long        lIndex			vf̃CfbNXԍ
//		const char* pIdent			ݒ肷鎯ʎq
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex Ԗڂ̗vfɎʎq pIdent ݒ肵܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::SetIdent( long lIndex , const char* pIdent )
{
	// -----< `FbN >-----
	//
	if( lIndex>=Length() ){
		ErrorLog( "CIdent::SetIdent : wCfbNX傫܂B\n" );
		return FALSE;
	}

	if( lIndex<0 ){
		ErrorLog( "CIdent::SetIdent : CfbNXɕ̒lw肳܂B\n" );
		return FALSE;
	}

	if( pIdent==NULL ){
		ErrorLog( "CIdent::SetIdent : ʎq NULL w肳܂B\n" );
		return FALSE;
	}

	// -----< ʎq̕ >-----
	//
	char* pIdentifier;
	pIdentifier = (char*)malloc( strlen( pIdent )+1 );
	if( pIdentifier==NULL ){
		ErrorLog( "CIdent::SetIdent : ʎq𕡐邽߂̃mۂł܂łB\n" );
		return FALSE;
	}
	strcpy( pIdentifier , pIdent );

	// -----< l̐ݒ >-----
	//
	m_objIdent[lIndex] = pIdentifier;

	// -----< ʂԂ >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetValue( long lIndex , T& rElem )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//		T&   rElem					vflւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex Ԗڂ̗vfɁAvfl rElem ݒ肵܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::SetValue( long lIndex , T& rElem )
{
	// -----< G[`FbN >-----
	//
	if( lIndex >= Length() ){
		ErrorLog( "CIdent::SetValue : wCfbNX̒l傫܂B\n" );
		return FALSE;
	}

	if( lIndex < 0 ){
		ErrorLog( "CIndet::SetValue : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}

	// -----< IuWFNg̕ >-----
	//
	T* pElem;
	pElem = new T;
	if( pElem==NULL ){
		ErrorLog( "CIdnet::SetValue : VIuWFNg쐬ł܂łB\n" );
		return FALSE;
	}

	// -----< lݒ >-----
	//
	if( m_objData[lIndex]!=NULL ){
		delete m_objData[lIndex];
	}
	m_objData[lIndex] = pElem;

	// ----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetValue( const char* pIdent , T& rElem )
//
//	[  ]
//		const char* pIdent			ʎqւ̃|C^
//		T&          rElem			vflւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pIdent ŎʂvfɁAvfl rElem ݒ肵܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::SetValue( const char* pIdent , T& rElem )
{
	// -----< CfbNX擾 >-----
	//
	long lIndex;
	lIndex = GetIndex( pIdent );
	if( lIndex==-1 ){
		ErrorLog( "CIdent::SetValue : ʎq܂łB\n" );
		return FALSE;
	}

	// -----< lݒ肷 >-----
	//
	BOOL bRes;
	bRes = SetValue( lIndex , rElem );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::SetValue : l̐ݒɎs܂B\n" );
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Remove( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex Ԗڂ̗vf폜܂B
//		폜vfɂvf́AЂƂOɋl߂܂B
//		̌ʁAvf̃CfbNXԍ_ɒӂĂB
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::Remove( long lIndex )
{
	// -----< G[`FbN >-----
	//
	if( lIndex>=Length() ){
		ErrorLog( "CIdent::Remove : w肳ꂽCfbNX傫܂B\n" );
		return FALSE;
	}

	if( lIndex<0 ){
		ErrorLog( "CIdent::Remove : ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}

	// -----< vf̍폜 >-----
	//
	if( m_objIdent[lIndex]!=NULL ){
		free( m_objIdent[lIndex] );
	}
	m_objIdent[lIndex] = NULL;

	if( m_objData[lIndex]!=NULL ){
		delete m_objData[lIndex];
	}
	m_objData[lIndex] = NULL;

	m_objIdent.Remove( lIndex );
	m_objData.Remove( lIndex );

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Remove( const char* pIdent )
//
//	[  ]
//		const char* pIdent			vf̎ʎq
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pIdent Ŏʂvf폜܂B
//		폜vfɂvf́AЂƂOɋl߂܂B
//		̌ʁAvf̃CfbNXԍ_ɒӂĂB
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::Remove( const char* pIdent )
{
	// -----< CfbNX擾 >-----
	//
	long lIndex;
	lIndex = GetIndex( pIdent );
	if( lIndex==-1 ){
		ErrorLog( "CIdent::Remove : CfbNX擾ł܂łB\n" );
		return FALSE;
	}

	// -----< 폜 >-----
	//
	BOOL bRes;
	bRes = Remove( lIndex );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::Remove : 폜Ɏs܂B\n" );
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Replace( long lIndex1 , long lIndex2 )
//
//	[  ]
//		long lIndex1				vf̃CfbNXԍ
//		long lIndex2				vf̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lIndex1 Ԗڂ̗vf lIndex2 Ԗڂ̗vfւ܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::Replace( long lIndex1 , long lIndex2 )
{
	// -----< G[`FbN >-----
	//
	if( lIndex1>=Length() ){
		ErrorLog( "CIdent::Replace : lIndex1Ŏw肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}
	if( lIndex2>=Length() ){
		ErrorLog( "CIdent::Replace : lIndex2Ŏw肳ꂽCfbNXԍ傫܂B\n" );
		return FALSE;
	}

	if( lIndex1<0 ){
		ErrorLog( "CIdent::Replace : lIndex1ɕ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}
	if( lIndex2<0 ){
		ErrorLog( "CIdent::Replace : lIndexɕ̃CfbNXԍw肳܂B\n" );
		return FALSE;
	}

	// -----< ւ >-----
	//
	BOOL bRes;
//	bRes = m_objIdent.Replace( lIndex1 , lIndex2 );
//	if( bRes==FALSE ){
//		ErrorLog( "CIdent::Replace : ʎq̓ւɎs܂B\n" );
//		return FALSE;
//	}

	bRes = m_objData.Replace( lIndex1 , lIndex2 );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::Replace : f[^̓ւɎs܂B\n" );
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Replace( const char* pIdent1 , const char* pIdent2 )
//
//	[  ]
//		const char* pIdent1			vf̎ʎqP
//		const char* pIdent2			vf̎ʎqQ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		pIdent1  pIdent2 ̎ʎqŎʂvfւ܂B
//--------------------------------------------------------------------
template<class T>
BOOL CIdent< T >::Replace( const char* pIdent1 , const char* pIdent2 )
{
	// -----< CfbNX擾 >-----
	//
	long lIndex1;
	long lIndex2;
	lIndex1 = GetIndex( pIdent1 );
	lIndex2 = GetIndex( pIdent2 );
	if( lIndex1==-1 ){
		ErrorLog( "CIdent::Replace : ЂƂ߂̎ʎqł܂łB\n" );
		return FALSE;
	}
	if( lIndex2==-1 ){
		ErrorLog( "CIdent::Replace : ӂ߂̎ʎqł܂łB\n" );
		return FALSE;
	}

	// -----< u >-----
	//
	BOOL bRes;
	bRes = Replace( lIndex1 , lIndex2 );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::Replace : uɎs܂B\n" );
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		T& operator[]( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		vfւ̎Q
//
//	[  ]
//		zƓľ`ŁAvfɃANZX܂B
//--------------------------------------------------------------------
template<class T>
T& CIdent< T >::operator[]( long lIndex )
{
	return *( m_objData[lIndex] );
}


//--------------------------------------------------------------------
//	[  ]
//		T GetValue( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		vfl̃Rs[
//
//	[  ]
//		lIndex Ԗڂ̗vfl̃Rs[Ԃ܂B
//--------------------------------------------------------------------
template<class T>
T CIdent< T >::GetValue( long lIndex )
{
	return *( m_objData[lIndex] );
}


//--------------------------------------------------------------------
//	[  ]
//		T GetValue( const char* pIdent )
//
//	[  ]
//		const char* pIdent			ʎqւ̃|C^
//
//	[ ߂l ]
//		vfl̃Rs[
//
//	[  ]
//		pIdent Ŏʂvfl̃Rs[Ԃ܂B
//--------------------------------------------------------------------
template<class T>
T CIdent< T >::GetValue( const char* pIdent )
{
	long lIndex;

	// -----< CfbNX擾 >-----
	//
	lIndex = GetIndex( pIdent );
	if( lIndex==-1 ){
		ErrorLog( "CIdent::GetValue : ʎqł܂łB\n" );
		lIndex = 0;
	}

	return GetValue( lIndex );
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetIdent( long lIndex )
//
//	[  ]
//		long lIndex					vf̃CfbNXԍ
//
//	[ ߂l ]
//		ʎwւ̃|C^
//
//	[  ]
//		lIndex Ԗڂ̗vf̎ʎqԂ܂B
//		G[̏ꍇ NULL Ԃ܂B
//--------------------------------------------------------------------
template< class T >
const char* CIdent< T >::GetIdent( long lIndex )
{
	// -----< G[`FbN >-----
	//
	if( lIndex>=Length() ){
		ErrorLog( "CIdent::GetIdent : w肳ꂽCfbNXԍ傫܂B\n" );
		return NULL;
	}

	if( lIndex<0 ){
		ErrorLog( "CIdent::GetIdent : ̃CfbNXԍw肳܂B\n" );
		return NULL;
	}

	// -----< Ԃ >----
	//
	return m_objIdent[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long Length()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		o^Ăvf̐
//
//	[  ]
//		o^Ăvfl̐Ԃ܂B
//--------------------------------------------------------------------
template<class T>
long CIdent< T >::Length()
{
	return m_objIdent.Length();
}


//--------------------------------------------------------------------
//	[  ]
//		CIdent& operator=( CIdent< T >& rIdent )
//
//	[  ]
//		CIdent& rIdent				ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template<class T>
CIdent< T >& CIdent< T >::operator=( CIdent< T >& rIdent )
{
	BOOL bRes;
	bRes = CopyMembers( rIdent );
	if( bRes==FALSE ){
		ErrorLog( "CIdent::operator= : IuWFNg̓e𕡐ł܂łB\n" );
	}

	return *this;
}


#endif
