//------------------------------------------------------------------------------
//	HASH
//------------------------------------------------------------------------------

#ifndef __GHASH_H__
#define __GHASH_H__

#include "Named.h"
#include "DObjArray.h"
#include "DStringArray.h"
#include "Str.h"

#define	DEFAULT_GHASH_SIZE	10							// ftHg̃nbVTCY


// -----< NX` >-----
//
template < class TTYPE > class CGHash
{
	// -----< \z >-----
	//
	public:
		CGHash();										// RXgN^
		CGHash( CGHash<TTYPE>& rHash );					// Rs[RXgN^
		CGHash( long lHashSize );						// nbVTCYwRXgN^
		virtual ~CGHash();								// fXgN^

	private:
		BOOL	SetDefault();
		BOOL	CopyMembers( CGHash<TTYPE>& rHash );

	// -----<  >-----
	//
	private:
		long	m_lHashSize;							// nbVTCY
		CDObjArray< CGNamed<TTYPE> >* m_pHashTable;	// nbVe[u

	// -----< \bh >-----
	//
	public:
		BOOL	Initialize( long lHashSize=DEFAULT_GHASH_SIZE );	// 
		BOOL	Release();									// IuWFNg̓ej

		BOOL	KeyExists( const CGStr& rName );					// L[ۂԂ
		BOOL	KeyExists( const char*  pName );					// L[ۂԂ
		BOOL	AddObject( CGNamed<TTYPE>& rObject );				// IuWFNgǉ
		BOOL	AddObject( const CGStr& strName , const TTYPE& rObject );	// IuWFNgǉ
		BOOL	AddObject( const char*    pName , const TTYPE& rObject );	// IuWFNgǉ
		TTYPE&	GetObject( const CGStr& strName ) const;	// IuWFNg擾
		TTYPE&	GetObject( const char*  pName ) const;		// IuWFNg擾
		BOOL	DeleteObject( CGStr& rName );				// IuWFNg폜
		BOOL	DeleteObject( const char* pName );			// IuWFNg폜
		BOOL	DeleteIfExist( CGStr& rName );				// ݂ꍇ̂݃IuWFNg폜
		BOOL	DeleteIfExist( const char* pName );			// ݂ꍇ̂݃IuWFNg폜

		long	Count();									// o^ĂIuWFNg̐Ԃ
		BOOL	GetKeys( CDStringArray& rResult );			// L[̈ꗗԂ

	// -----< Zq >-----
	//
	public:
		CGHash<TTYPE>&	operator=( const CGHash<TTYPE>& rHash );	// Zq
		TTYPE&			operator[]( const CGStr& rName ) const;		// ɂQ
		TTYPE&			operator[]( const char* pName) const;		// ɂQ

	// -----< static \bh >-----
	//
	public:
		static long GetHash( const CGStr& rString , long lMax );	// 񂩂nbVl擾
		static long GetHash( const char*  pString , long lMax );	// 񂩂nbVl擾
};


// -----<  >-----
//
//--------------------------------------------------------------------
//	[  ]
//		CGHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGHash< TTYPE >::CGHash()
{
	BOOL bRes;

	// <<<  >>>
	bRes = SetDefault();
	if( bRes==FALSE ){
		return;
	}

	bRes = Initialize();
	if( bRes==FALSE ){
		return;
	}

	return;
}


//--------------------------------------------------------------------
//	[  ]
//		CGHash( CGHash<TTYPE>& rHash )
//
//	[  ]
//		CGHash<TTYPE>& rHash		Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGHash< TTYPE >::CGHash( CGHash<TTYPE>& rHash )
{
	BOOL bRes;

	// <<<  >>>
	bRes = SetDefault();
	if( bRes==FALSE ){
		return;
	}

	// <<<  >>>
	bRes	= CopyMembers( rHash );
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		CGHash( long lHashSize )
//
//	[  ]
//		long lHashSize				nbVTCY
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		nbVTCYwRXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGHash< TTYPE >::CGHash( long lHashSize )
{
	BOOL bRes;

	// <<< lݒ >>>
	bRes	= SetDefault();
	if( bRes==FALSE ){
		return;
	}

	// <<<  >>>
	bRes	= Initialize( lHashSize );
	if( bRes==FALSE ){
		return;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~CGHash()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
template < class TTYPE >
CGHash< TTYPE >::~CGHash()
{
	BOOL bRes;

	// <<< j >>>
	bRes	= Release();

	return;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̏֐
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::SetDefault()
{
	m_lHashSize		= 0;
	m_pHashTable	= NULL;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGHash<TTYPE>& rHash )
//
//	[  ]
//		CGHash<TTYPE>& rHash		Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::CopyMembers( CGHash<TTYPE>& rHash )
{
	// <<< nbVe[u >>>
	if( rHash.m_pHashTable!=NULL ){
		CDObjArray< CGNamed<TTYPE> >* pHashTable;
		pHashTable	= new CDObjArray< CGNamed<TTYPE> >[ rHash.m_lHashSize ];
		if( pHashTable==NULL ){
			return FALSE;
		}

		long i;
		for( i=0;i<rHash.m_lHashSize;i++ ){
			pHashTable[i]	= rHash.m_pHashTable[i];
		}

		if( m_pHashTable!=NULL ){
			delete[] m_pHashTable;
		}
		m_pHashTable	= pHashTable;
	} else {
		m_pHashTable	= NULL;
	}

	// <<< nbVTCY >>>
	m_lHashSize		= rHash.m_lHashSize;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize( long lHashSize=DEFAULT_GHASH_SIZE )
//
//	[  ]
//		long lHashSize				nbṼTCY
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::Initialize( long lHashSize )
{
	CDObjArray< CGNamed<TTYPE> >* pHashTable;

	// -----< VnbVe[um >-----
	//
	pHashTable	= new CDObjArray< CGNamed<TTYPE> >[ lHashSize ];
	if( pHashTable==NULL ){
		return FALSE;
	}

	// -----< nbVTCYύX >-----
	//
	m_lHashSize		= lHashSize;

	// -----< nbVe[u >-----
	//
	if( m_pHashTable!=NULL ){
		delete[] m_pHashTable;
	}
	m_pHashTable	= pHashTable;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::Release()
{
	long i;

	if( m_pHashTable!=NULL ){
		for( i=0;i<m_lHashSize;i++ ){
			m_pHashTable[i].Release();
		}
		delete[] m_pHashTable;
		m_pHashTable	= NULL;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL KeyExists( const CGStr& rName )
//
//	[  ]
//		const CGStr& rName			L[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		nbVɎw肵L[ɑ݂邩ۂԂ܂
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::KeyExists( const CGStr& rName )
{
	long i;

	// -----< mF >-----
	//
	if( m_pHashTable==NULL ){
		// OɌĂяoꂽG[
		return FALSE;
	}

	// -----< nbVR[h擾 >-----
	//
	long lHash;
	lHash	= CGHash< TTYPE >::GetHash( rName , m_lHashSize-1 );

	// -----< mF >-----
	//
	long lCount;
	lCount	= m_pHashTable[lHash].Length();

	for( i=0;i<lCount;i++ ){
		CGNamed<TTYPE>& rNamed	= m_pHashTable[lHash][i];

		if( rName==rNamed.GetName() ){
			// 
			return TRUE;
		}
	}

	// Ȃ
	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL KeyExists( const char* pName )
//
//	[  ]
//		const char* pName			L[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		nbVɎw肵L[ɑ݂邩ۂԂ܂
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::KeyExists( const char* pName )
{
	// <<< NULL w肳ꂽꍇFALSE >>>
	if( pName==NULL ){
		return FALSE;
	}

	// <<< ubW >>>
	CGStr strName	= CGStr( pName );
	return KeyExists( strName );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AddObject( CGNamed<TTYPE>& rObject )
//
//	[  ]
//		CGNamed<TTYPE>& rObject		ǉIuWFNg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		nbVɃm[hǉ܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::AddObject( CGNamed<TTYPE>& rObject )
{
	// -----< nbVl̎擾 >-----
	//
	CGStr	objName;
	objName	= rObject.GetName();

	long lHash;
	lHash	= CGHash< TTYPE >::GetHash( objName , m_lHashSize-1 );

	// ----< L[݂̑mFA݂ΑďI >-----
	//
	long i;
	for( i=0;i<m_pHashTable[lHash].Length();i++ ){
		CGNamed< TTYPE >& rNamed = m_pHashTable[lHash][i];
		if( objName==rNamed.GetName() ){
			m_pHashTable[lHash][i]	= rObject;
			return TRUE;
		}
	}
	// ݂Ȃ̂Œǉ

	// -----< nbVɒǉ >-----
	//
	long lIndex;
	lIndex	= m_pHashTable[lHash].Add( rObject );
	if( lIndex==-1 ){
		return FALSE;
	}

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AddObject( const CGStr& rName , const TTYPE& rObject )
//
//	[  ]
//		const CGStr& rName			L[
//		const TTYPE& rObject				IuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		nbVɃm[hǉ܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::AddObject( const CGStr& rName , const TTYPE& rObject )
{
	BOOL bRes;
	bRes	= AddObject( (const char*)(rName.GetString()) , rObject );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL AddObject( const char* pName , const TTYPE& rObject )
//
//	[  ]
//		const char* pName			L[
//		const TTYPE& rObject				IuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		nbVɃm[hǉ܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::AddObject( const char* pName , const TTYPE& rObject )
{
	BOOL bRes;
	CGNamed< TTYPE >	objNamed;

	// -----< Named 쐬 >-----
	//
	bRes	= objNamed.SetName( pName );
	if( bRes==FALSE ){
		return FALSE;
	}

	bRes	= objNamed.SetObject( rObject );
	if( bRes==FALSE ){
		return FALSE;
	}

	// -----< ǉ >-----
	//
	bRes	= AddObject( objNamed );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE& GetObject( const CGStr& rName ) const
//
//	[  ]
//		const CGStr& rStr			IuWFNg̖O
//
//	[ ߂l ]
//		FIuWFNgւ̎Q
//		sFNULL
//
//	[  ]
//		IuWFNg擾܂B
//--------------------------------------------------------------------
template < class TTYPE >
TTYPE& CGHash< TTYPE >::GetObject( const CGStr& rName ) const
{
	static TTYPE	objError;
	memset( &objError , 0 , sizeof( TTYPE ) );

	// -----< 擾 >-----
	//
	long lHash;
	long lCount;
	lHash	= CGHash< TTYPE >::GetHash( rName,m_lHashSize-1 );
	lCount	= m_pHashTable[ lHash ].Length();

	// -----< o^擾 >-----
	//
	long i;
	CGNamed<TTYPE>* pResult = NULL;

	for( i=0;i<lCount;i++ ){
		if( rName==m_pHashTable[ lHash ][ i ].GetName() ){
			pResult	= &(m_pHashTable[ lHash ][ i ]);
			break;
		}
	}

	// -----< ʕԂ >-----
	//
	if( pResult==NULL ){
		return objError;
	}
	return pResult->GetObject();
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE& CGHash< TTYPE >::GetObject( const char* pName ) const
//
//	[  ]
//		const char* pName			IuWFNg̖
//
//	[ ߂l ]
//		FIuWFNgւ̎Q
//		sFNULL
//
//	[  ]
//		IuWFNg擾܂B
//--------------------------------------------------------------------
template < class TTYPE >
TTYPE& CGHash< TTYPE >::GetObject( const char* pName ) const
{
	return GetObject( CGStr( pName ) );
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteObject( CGStr& strName )
//
//	[  ]
//		CGStr& strName				IuWFNĝ̖ւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg폜܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::DeleteObject( CGStr& strName )
{
	BOOL bRes;

	// -----< nbVl擾 >-----
	//
	long lHash;
	lHash	= CGHash<TTYPE>::GetHash( strName,m_lHashSize-1 );

	// -----< z擾 >-----
	//
	CDObjArray< CGNamed<TTYPE> >* pArray;
	pArray	= &(m_pHashTable[lHash]);

	// -----< ACe >-----
	//
	long lLength;
	lLength	= pArray->Length();

	long i;
	long lIndex	= -1;
	for( i=0;i<lLength;i++ ){
		CGStr	objName;
		objName	= (*pArray)[i].GetName();
		if( objName==strName ){
			lIndex	= i;
			break;
		}
	}

	// ACełȂG[
	if( lIndex==-1 ){
		return FALSE;
	}

	// -----< ACe폜 >-----
	//
	bRes	= pArray->Remove( lIndex );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteObject( const char* pName )
//
//	[  ]
//		const char* pName			IuWFNg̖
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg폜܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::DeleteObject( const char* pName )
{
	CGStr	objName;
	objName	= pName;

	BOOL bRes;
	bRes	= DeleteObject( objName );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL DeleteIfExist( const char* pName )
//		BOOL DeleteIfExist( CGStr& rName )
//
//	[  ]
//		const char* pName			L[
//		CGStr& rName				L[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵L[݂ꍇ̂݁AIuWFNg폜܂B
//		w肵L[݂ȂꍇA TRUE 
//		Ԃ܂B
//
//		KeyExists()  DeleteObject() gݍ킹֐łB
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::DeleteIfExist( const char* pName )
{
	BOOL bRes;

	// NULL wȂAɐIŕ]
	if( pName==NULL ){ return TRUE; }

	// -----< ݊mF >-----
	//
	BOOL bIsExist;
	bIsExist = KeyExists( pName );
	if( bIsExist==FALSE ){
		// ݂Ȃ΁AȂ TRUE ŕԂ
		return TRUE;
	}

	// -----< 폜 >-----
	//
	bRes	= DeleteObject( pName );
	if( bRes==FALSE ){
		return FALSE;
	}

	// -----< I >------
	//
	return TRUE;
}

template < class TTYPE >
BOOL CGHash< TTYPE >::DeleteIfExist( CGStr& rName )
{
	BOOL bRes;

	// -----< ubW >-----
	//
	const char* pName = rName.GetString();
	bRes	= DeleteIfExist( pName );

	// -----< ʂԂ >-----
	//
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		long Count()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		o^ĂIuWFNg̐
//
//	[  ]
//		o^ĂIuWFNg̐JEgĕԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
long CGHash< TTYPE >::Count()
{
	long i;
	long lCount;

	lCount	= 0;
	for( i=0;i<m_lHashSize;i++ ){
		lCount += m_pHashTable[i].Length();
	}
	return lCount;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GetKeys( CDStringArray& rResult )
//
//	[  ]
//		CDStringArray& rResult		ʂ󂯎邽߂̕zւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		L[̈ꗗԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
BOOL CGHash< TTYPE >::GetKeys( CDStringArray& rResult )
{
	// -----< ܂ >-----
	//
	rResult.Release();

	// -----< XgAbv >-----
	//
	long i;
	for( i=0;i<m_lHashSize;i++ ){
		long lCount;
		lCount	= m_pHashTable[i].Length();

		long c;
		for( c=0;c<lCount;c++ ){
			// O擾
			CGStr	objName;
			objName	= m_pHashTable[i][c].GetName();

			// ǉ
			long lIndex;
			lIndex = rResult.Add( objName.GetString() );
			if( lIndex==-1 ){
				return FALSE;
			}
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CGHash<TTYPE>& operator=( const CGHash<TTYPE>& rHash )
//
//	[  ]
//		const CGHash<TTYPE>& rHash	ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
template < class TTYPE >
CGHash<TTYPE>& CGHash< TTYPE >::operator=( const CGHash<TTYPE>& rHash )
{
	BOOL bRes;
	bRes	= CopyMembers( (CGHash<TTYPE>&)rHash );
	if( bRes==FALSE ){
		return *this;
	}

	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE& operatort[]( const CGStr& rName ) const
//
//	[  ]
//		CGStr& rName				IuWFNg̖
//
//	[ ߂l ]
//		rName Ŏw肳IuWFNgւ̎Q
//
//	[  ]
//		QƉZq
//--------------------------------------------------------------------
template < class TTYPE >
TTYPE& CGHash< TTYPE >::operator[]( const CGStr& rName ) const
{
	return GetObject( rName );
}


//--------------------------------------------------------------------
//	[  ]
//		TTYPE& operator[]( const char* pName ) const
//
//	[  ]
//		const char* pName			IuWFNg̖
//
//	[ ߂l ]
//		pName œ肳IuWFNgւ̎Q
//
//	[  ]
//		QƉZq
//--------------------------------------------------------------------
template < class TTYPE >
TTYPE& CGHash< TTYPE >::operator[]( const char* pName) const
{
	return GetObject( pName );
}


//--------------------------------------------------------------------
//	[  ] static
//		static long GetHash( const CGStr& rString , long lMax )
//
//	[  ]
//		CGStr& rString				nbṼL[Ƃ镶
//		long   lMax					nbVlől
//
//	[ ߂l ]
//		0`lMax ܂ł̃nbVl
//
//	[  ]
//		nbVlvZĕԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
long CGHash< TTYPE >::GetHash( const CGStr& rString , long lMax )
{
	const char* pString	= rString.GetString();

	long lResult;
	lResult	= CGHash<TTYPE>::GetHash( pString , lMax );
	return lResult;
}


//--------------------------------------------------------------------
//	[  ] static
//		static long GetHash( const char* pString , long lMax )
//
//	[  ]
//		const char* pString			nbṼL[Ƃ镶
//		long        lMax			nbVlől
//
//	[ ߂l ]
//		0`lMax ܂ł̃nbVl
//
//	[  ]
//		nbVlvZĕԂ܂B
//--------------------------------------------------------------------
template < class TTYPE >
long CGHash< TTYPE >::GetHash( const char* pString , long lMax )
{
	// <<< 񒷌m >>>
	long lLength;
	lLength	= strlen( pString );

	// <<< aƂ >>>
	long i;
	long lValue;

	lValue	= 0;
	for( i=0;i<lLength;i++ ){
		lValue	= lValue + ((const unsigned char*)pString)[i];
	}

	// <<< mod Ƃ >>>
	lValue	= lValue % (lMax+1);

	// <<< ʂԂ >>>
	return lValue;
}


#endif
