//------------------------------------------------------------------------------
//  - g`qtm` - the second
//
//  XNvgt@CǂݍŃg[NAzɊi[肷B
//------------------------------------------------------------------------------
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "HToken.h"
#include "HARUNA2.h"

//--------------------------------------------------------------------
//	[  ]
//		CHARUNA2()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CHARUNA2::CHARUNA2()
{
	// <<<  >>>
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CHARUNA2( CHARUNA2& rHARUNA2 )
//
//	[  ]
//		CHARUNA2& rHARUNA2			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CHARUNA2::CHARUNA2( CHARUNA2& rHARUNA2 )
{
	BOOL bRes;

	// <<<  >>>
	bRes = SetDefault();
	if( bRes==FALSE ){
		return;
	}

	// <<< e >>>
	CopyMembers( rHARUNA2 );
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~CHARUNA2()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CHARUNA2::~CHARUNA2()
{
	// <<< j >>>
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RXgN^xł̏lݒs܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::SetDefault()
{
	m_strFilename		= "";			// t@C
	m_strTokenHeader	= "";			// g[Nwb_
	m_objToken.Release();				// g[Nz

	m_hashBlockTop.Initialize();		// ubN擪CfbNX

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CHARUNA2& rHARUNA2 )
//
//	[  ]
//		CHARUNA2& rHARUNA2			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::CopyMembers( CHARUNA2& rHARUNA2 )
{
	// <<< ܂͔j >>>
	BOOL bRes;
	bRes	= Release();
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<<  >>>
	m_strFilename		= rHARUNA2.m_strFilename;
	m_strTokenHeader	= rHARUNA2.m_strTokenHeader;
	m_objToken			= rHARUNA2.m_objToken;
	m_hashBlockTop		= rHARUNA2.m_hashBlockTop;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::Initialize()
{
	// <<< ܂j >>>
	BOOL bRes;
	bRes	= Release();
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< g[Nwb_ >>>
	bRes	= SetTokenHeader( HARUNA2_DEFAULT_TOKENHEADER );
	if( bRes==FALSE ){
		return FALSE;
	}

	// <<< ubN擪CfbNX >>>
	m_hashBlockTop.Initialize();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓ej܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::Release()
{
	// <<< IuWFNg̓ej >>>
	m_strFilename		= "";
	m_strTokenHeader	= "";
	m_objToken.Release();
	m_hashBlockTop.Release();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetTokenHeader( const char*  pHeader )
//
//	[  ]
//		const char* pHeader			g[Nwb_
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		g[Nwb_ݒ肵܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::SetTokenHeader( const char*  pHeader )
{
	m_strTokenHeader	= pHeader;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetTokenHeader( const CGStr& rHeader )
//
//	[  ]
//		const CGStr& rHeader		g[Nwb_
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		g[Nwb_ݒ肵܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::SetTokenHeader( const CGStr& rHeader )
{
	m_strTokenHeader	= rHeader;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReadFile( const CGStr& rFilename )
//
//	[  ]
//		const CGStr& rFilename		t@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@Cǂݍ݁Ag[N܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::ReadFile( const CGStr& rFilename )
{
	long		i;
	BOOL		bRes;
	CLineRead	objLineRead;
	CHToken		objToken;
	long		lLine;

	// -----< t@CI[v >-----
	//
	bRes = objLineRead.SetTokenHeader( m_strTokenHeader.GetString() );
	if( bRes==FALSE ){
		return FALSE;
	}

	bRes = objLineRead.Open( rFilename.GetString() );
	if( bRes==FALSE ){
		return FALSE;
	}
	m_strFilename	= rFilename;

	// -----< ǂݍ >-----
	//
	lLine	= 0;
	while( 1 ){
		// <<< Psǂݍ >>>
		bRes	= objLineRead.Read();
		if( bRes==FALSE ){
			// ǂݍݏIŔ
			break;
		}
		lLine += 1;

		// <<< g[N쐬o^ >>>
		for( i=0;i<objLineRead.GetTokens();i++ ){
			CGStr	strToken;
			long	lTokenType;
			strToken	= objLineRead.GetToken( i );
			lTokenType	= objLineRead.GetTokenType( i );
			lTokenType	= CHARUNA2::ConvertTokenTypeFromLineRead( lTokenType );

			// g[NAsԍݒ
			bRes = objToken.SetToken( strToken , lLine , lTokenType );
			if( bRes==FALSE ){
				objLineRead.Close();
				return FALSE;
			}

			// g[Nǉ
			long lRes;
			lRes = m_objToken.Add( objToken );
			if( lRes==-1 ){
				objLineRead.Close();
				return FALSE;
			}
		}
	}

	// -----< t@CN[Y >-----
	//
	bRes = objLineRead.Close();
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReadFile( const char*  pFilename )
//
//	[  ]
//		const char* pFilename		t@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@Cǂݍ݁Ag[N܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::ReadFile( const char*  pFilename )
{
	CGStr	strFilename;
	strFilename	= pFilename;

	BOOL bRes;
	bRes	= ReadFile( strFilename );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetToken(  long lIndex , CGStr&  rStr   )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		CGStr&  rStr					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetToken( long lIndex , CGStr& rStr )
{
	// ʏ
	rStr	= CGStr( "" );

	// <<< G[`FbN >>>
	long lCount;
	lCount	= m_objToken.Length();

	if( lIndex>=lCount ){
		ErrorLog( "CHARUNA2::GetToken : w肳ꂽCfbNXԍ傫܂B\n" );
		return -1;
	}
	if( lIndex<0 ){
		ErrorLog( "CHARUNA2::GetToken : w肳ꂽCfbNXłB\n" );
		return -1;
	}

	// <<< 擾 >>>
	CHToken*	pToken;
	pToken	= &( m_objToken[ lIndex ] );
	rStr	= CGStr( pToken->GetToken() );

	// <<< ̈ʒu >>>
	lIndex++;
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetInt(    long lIndex , int&    rInt   )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		int&    rInt					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Aint^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetInt( long lIndex , int& rInt )
{
	CGStr	strToken;
	int		iSign	= 1;				// + Ƃ - Ƃ

	// -----< l荞 >-----
	//
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// u-vꍇ́AȂ̂ŁAǂō
	if( strToken=="-" ){
		iSign	= -1;
		lIndex	= GetToken( lIndex , strToken );
		if( lIndex==-1 )return -1;
	}

	// l𔽉f
	if( strToken.IsHead( "0x" )==TRUE ){
		// PUȉꍇ
		int iValue;
		sscanf( strToken.GetString() , "%x" , &iValue );
		rInt	= iSign * iValue;
	} else {
		// PUiłȂꍇ
		rInt	= iSign * atoi( strToken.GetString() );
	}

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetLong(   long lIndex , long&   rLong  )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		long&   rLong					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Along^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetLong( long lIndex , long& rLong )
{
	CGStr	strToken;
	long	lSign	= 1;

	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// u-vꍇ́AȂ̂ŁAǂō
	if( strToken=="-" ){
		lSign	= -1;
		lIndex	= GetToken( lIndex , strToken );
		if( lIndex==-1 )return -1;
	}

	// l𔽉f
	if( strToken.IsHead( "0x" )==TRUE ){
		// PUȉꍇ
		int  iValue;
		long lValue;
		sscanf( strToken.GetString() , "%x" , &iValue );
		lValue	= (long)iValue;
		rLong	= lSign * lValue;
	} else {
		// PUiłȂꍇ
		rLong	= lSign * atol( strToken.GetString() );
	}

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetFloat(  long lIndex , float&  rFloat )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		float&  rFloat					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Afloat^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetFloat(  long lIndex , float&  rFloat )
{
	CGStr	strToken;
	float	fSign	= 1.0f;

	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// u-vꍇ́AȂ̂ŁAǂō
	if( strToken=="-" ){
		fSign	= -1.0f;
		lIndex	= GetToken( lIndex , strToken );
		if( lIndex==-1 )return -1;
	}

	rFloat	= fSign * (float)( atof( strToken.GetString() ) );

	// <<< _荞 >>>
//	lIndex	= 

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetDouble( long lIndex , double& rDouble )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		double& rDouble					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Adouble^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetDouble( long lIndex , double& rDouble )
{
	CGStr	strToken;
	double	dSign	= 1.0;
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// u-vꍇ́AȂ̂ŁAǂō
	if( strToken=="-" ){
		dSign	= -1.0;
		lIndex	= GetToken( lIndex , strToken );
		if( lIndex==-1 )return -1;
	}

	rDouble	= dSign * atof( strToken.GetString() );

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetBool(   long lIndex , BOOL&   rBool  )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		BOOL&   rBool					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾ABOOL^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetBool( long lIndex , BOOL& rBool )
{
	CGStr	strToken;
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// mF
	if( (strToken!="TRUE")&&(strToken!="FALSE") ){
		ErrorLog( "CHARUNA2::GetBool : [%d]s TRUE/FALSE \z鏊[%s]LqĂ܂B\n"
					, GetLine( lIndex ) , strToken.GetString() );
		return -1;
	}

	// ݒ
	if( strToken=="TRUE"  )rBool	= TRUE;
	if( strToken=="FALSE" )rBool	= FALSE;

	// <<< ̈ʒu >>>
	return lIndex;
}



//--------------------------------------------------------------------
//	[  ]
//		long GetDWORD( long lIndex , DWORD& rDWORD )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		DWORD&  rDWORD					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾ADWORD^ňɔf܂B
//		ǂݍ݂16iōs܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetDWORD( long lIndex , DWORD& rDWORD )
{
	CGStr	strToken;

	// g[N擾
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;

	// l]
	DWORD dwValue;
	if( strToken.IsHead( "0x" )==TRUE ){
		// 16ȉꍇ
		int iValue;
		sscanf( strToken.GetString() , "%x" , &iValue );
		dwValue	= (DWORD)iValue;
	} else {
		// 16iłȂꍇ
		dwValue	= (DWORD)atof( strToken.GetString() );
	}

	rDWORD	= dwValue;
	return lIndex;
}



//--------------------------------------------------------------------
//	[  ]
//		long GetRndInt(    long lIndex , CGRndInt&    rInt   )
//
//	[  ]
//		long      lIndex				g[ÑCfbNXԍ
//		CGRndInt& rInt					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Aint^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndInt( long lIndex , CGRndInt& rInt )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		int iValue;
		lIndex	= GetInt( lIndex , iValue );
		if( lIndex==-1 ){ return -1; }

		rInt.Initialize( iValue , 0 , 0 );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	int iValue, iAmplitude, iOffset;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetInt( lIndex , iValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetInt( lIndex , iAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetInt( lIndex , iOffset );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rInt.Initialize( iValue , iAmplitude , iOffset );

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetRndLong(   long lIndex , CGRndLong&   rLong  )
//
//	[  ]
//		long       lIndex					g[ÑCfbNXԍ
//		CGRndLong& rLong					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Along^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndLong( long lIndex , CGRndLong& rLong )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		long lValue;
		lIndex	= GetLong( lIndex , lValue );
		if( lIndex==-1 ){ return -1; }

		rLong.Initialize( lValue , 0 , 0 );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	long lValue, lAmplitude, lOffset;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetLong( lIndex , lValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetLong( lIndex , lAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetLong( lIndex , lOffset );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rLong.Initialize( lValue , lAmplitude , lOffset );

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetRndFloat(  long lIndex , CGRndFloat&  rFloat )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		CGRndFloat&  rFloat					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Afloat^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndFloat(  long lIndex , CGRndFloat&  rFloat )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		float fValue;
		lIndex	= GetFloat( lIndex , fValue );
		if( lIndex==-1 ){ return -1; }

		rFloat.Initialize( fValue , 0.0f , 0.0f );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	float fValue, fAmplitude, fOffset;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetFloat( lIndex , fValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetFloat( lIndex , fAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetFloat( lIndex , fOffset );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rFloat.Initialize( fValue , fAmplitude , fOffset );

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetRndDouble( long lIndex , CGRndDouble& rDouble )
//
//	[  ]
//		long    lIndex					g[ÑCfbNXԍ
//		CGRndDouble& rDouble			i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾Adouble^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndDouble( long lIndex , CGRndDouble& rDouble )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		double dValue;
		lIndex	= GetDouble( lIndex , dValue );
		if( lIndex==-1 ){ return -1; }

		rDouble.Initialize( dValue , 0.0 , 0.0 );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	double dValue, dAmplitude, dOffset;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDouble( lIndex , dValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDouble( lIndex , dAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDouble( lIndex , dOffset );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rDouble.Initialize( dValue , dAmplitude , dOffset );

	// <<< ̈ʒu >>>
	return lIndex;
}

//--------------------------------------------------------------------
//	[  ]
//		long GetRndBool(   long lIndex , CGRndBOOL&   rBool  )
//
//	[  ]
//		long       lIndex					g[ÑCfbNXԍ
//		CGRndBOOL& rBool					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾ABOOL^ňɔf܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndBool( long lIndex , CGRndBOOL& rBool )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		BOOL bValue;
		lIndex	= GetBool( lIndex , bValue );
		if( lIndex==-1 ){ return -1; }

		rBool.Initialize( bValue , FALSE , FALSE );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	BOOL bValue, bAmplitude;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetBool( lIndex , bValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetBool( lIndex , bAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rBool.Initialize( bValue , bAmplitude , FALSE );

	// <<< ̈ʒu >>>
	return lIndex;
}



//--------------------------------------------------------------------
//	[  ]
//		long GetRndDWORD( long lIndex , CGRndDWORD& rDWORD )
//
//	[  ]
//		long        lIndex					g[ÑCfbNXԍ
//		CGRndDWORD& rDWORD					i[ւ̎Q
//
//	[ ߂l ]
//		F̃g[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		g[N擾ADWORD^ňɔf܂B
//		ǂݍ݂16iōs܂B
//		擾̎̃g[ÑCfbNXԍԂ܂B
//		G[̏ꍇ́A-1 Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetRndDWORD( long lIndex , CGRndDWORD& rDWORD )
{
	// -----< l >-----
	//
	if( CheckToken( lIndex , "rnd" )==-1 ){
		// <<< lȂ̂ŁAʂɓǂݍ >>>
		DWORD dwValue;
		lIndex	= GetDWORD( lIndex , dwValue );
		if( lIndex==-1 ){ return -1; }

		rDWORD.Initialize( dwValue , 0 , 0 );
		return lIndex;
	}

	// -----< _荞 >-----
	//
	DWORD dwValue, dwAmplitude, dwOffset;
	lIndex	= JudgeToken( lIndex , "rnd" );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "(" );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDWORD( lIndex , dwValue );		if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDWORD( lIndex , dwAmplitude );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , "," );		if( lIndex==-1 ){ return -1; }
	lIndex	= GetDWORD( lIndex , dwOffset );	if( lIndex==-1 ){ return -1; }
	lIndex	= JudgeToken( lIndex , ")" );		if( lIndex==-1 ){ return -1; }
	rDWORD.Initialize( dwValue , dwAmplitude , dwOffset );

	// <<< ̈ʒu >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTokenType( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		g[Ñ^Cv
//
//	[  ]
//		w肵CfbNXʒũg[Ñ^Cv擾܂B
//		^Cv́ACHToken.h Œ`Ă܂B
//--------------------------------------------------------------------
long CHARUNA2::GetTokenType( long lIndex )
{
	// <<< G[`FbN >>>
	long lCount;
	lCount	= m_objToken.Length();

	if( lIndex>=lCount ){
		return CHTOKEN_TYPE_ERROR;
	}

	if( lIndex<0 ){
		return CHTOKEN_TYPE_ERROR;
	}

	// <<< 擾 >>>
	CHToken	objToken;
	objToken	= m_objToken[ lIndex ];

	return objToken.GetType();
}


//--------------------------------------------------------------------
//	[  ]
//		long GetLine( long lIndex )
//
//	[  ]
//		long lIndex					g[ÑCfbNXԍ
//
//	[ ߂l ]
//		Fsԍ
//		sF-1
//
//	[  ]
//		lIndex Ԗڂ̃g[NAt@Csڂɂ邩
//		Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetLine( long lIndex )
{
	// <<< G[`FbN >>>
	long lCount;
	lCount	= m_objToken.Length();

	if( lIndex>=lCount ){
		return -1;
	}

	if( lIndex<0 ){
		return -1;
	}

	// <<< 擾 >>>
	CHToken	objToken;
	objToken	= m_objToken[ lIndex ];

	long lLine;
	lLine	= objToken.GetLine();
	return lLine;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetTokenCount()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ǂݍ܂Ăg[N̐
//
//	[  ]
//		ǂݍ܂Ăg[N̐Ԃ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetTokenCount()
{
	long lCount;
	lCount	= m_objToken.Length();

	return lCount;
}


//--------------------------------------------------------------------
//	[  ]
//		long CheckToken( long lIndex , const char* pKeyword )
//		long CheckToken( long lIndex , const char* rKeyword )
//
//	[  ]
//		long lIndex					g[NCfbNX
//		const char* pKeyword		r镶
//		CGStr&      rKeyword		r镶
//
//	[ ߂l ]
//		v@F̃g[ÑCfbNX
//		vȂF-1
//
//	[  ]
//		w肵CfbNX̃g[NAw肵ƓȂ
//		-1 ȊOԂ܂B
//--------------------------------------------------------------------
long CHARUNA2::CheckToken( long lIndex , const char* pKeyword )
{
	CGStr strKeyword;
	long  lRes;

	strKeyword	= CGStr( pKeyword );
	lRes		= CheckToken( lIndex , strKeyword );
	return lRes;
}

long CHARUNA2::CheckToken( long lIndex , const CGStr& rKeyword )
{
	// g[N擾
	CGStr strToken;
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 )return -1;	// g[N擾G[ȂAvȂƂĕԂ

	// mF
	if( rKeyword!=strToken ){
		// v
		return -1;
	}

	// v
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long JudgeToken( long lIndex , const char*  pKeyword )
//		long JudgeToken( long lIndex , const CGStr& rKeyword )
//
//	[  ]
//		long lIndex					g[NCfbNX
//		const char* pKeyword		r镶
//		CGStr&      rKeyword		r镶
//
//	[ ߂l ]
//		v@F̃g[ÑCfbNX
//		vȂFFALSE
//
//	[  ]
//		w肵CfbNX̃g[NAw肵ƓȂ
//		TRUE Ԃ܂B
//		vȂꍇ́AErrorLog ɃObZ[Wc܂B
//--------------------------------------------------------------------
long CHARUNA2::JudgeToken( long lIndex , const char* pKeyword )
{
	CGStr strKeyword;
	strKeyword	= CGStr( pKeyword );

	long lRes;
	lRes	= JudgeToken( lIndex , strKeyword );
	return lRes;
}

long CHARUNA2::JudgeToken( long lIndex , const CGStr& rKeyword )
{
	long  lSpecIndex = lIndex;
	CGStr strToken;

	// <<< g[N擾 >>>
	//
	lIndex	= GetToken( lIndex , strToken );
	if( lIndex==-1 ){
		ErrorLog( "CHARUNA2::JudgeToken : g[N̎擾Ɏs܂B\n" );
		return -1;
	}

	// <<< mF >>>
	//
	if( rKeyword!=strToken ){
		// vȂꍇ
		ErrorLog( "CHARUNA2::JudgeToken : %s(%d):[%s]\z鏊[%s]LqĂ܂B\n"
			, m_strFilename.GetString()
			, GetLine( lSpecIndex )
			, rKeyword.GetString()
			, strToken.GetString()
		);
		return -1;
	}

	// vꍇ
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL TakeInBlockTop( CDObjArray< CGStr >& rBlockNames )
//
//	[  ]
//		CDObjArray< CGStr >& rBlockNames	舵ubNi[zIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		舵ubN̖Oi[zɎw肷ƁA
//		Ήg[NCfbNXԍoAm_hashBlockTop 
//		ǉ܂B
//		ReadFile() ̌ɎsȂƁAȌʂ͓܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::TakeInBlockTop( CDObjArray< CGStr >& rBlockNames , BOOL bMustExists )
{
	long lRes;
	long i;
	long lIndex;
	long lTokenCount;
	CGStr	strToken;

	// -----< ubN񏉊 >-----
	//
	m_hashBlockTop.Initialize();

	// -----< ubN\z >-----
	//
	lIndex	= 0;
	lTokenCount	= GetTokenCount();

	while( 1 ){
		// <<< I >>>
		if( lIndex>=lTokenCount ){
			break;
		}

		// <<< g[N擾 >>>
		lRes = GetToken( lIndex , strToken );
		if( lRes==-1 ){
			ErrorLog( "CHARUNA2::TakeInBlockTop : g[N̎擾Ɏs܂B\n" );
			return FALSE;
		}

		// <<< oƓo^ >>>
		BOOL bHit = FALSE;
		for( i=0;i<rBlockNames.Length();i++ ){
			if( strToken!=rBlockNames[i] )continue;			// vȂΎ

			// ubN擪o
			bHit	= TRUE;
			lIndex++;
			m_hashBlockTop.AddObject( strToken , lIndex );	// gbvZbg

			// Iu[Xʒu
			lIndex	= GetCloseBraceIndex( lIndex );			// Iu[Xʒu擾
			if( lIndex==-1 )return FALSE;
			lIndex++;
			break;
		}
		if( bHit==TRUE )continue;							// ôŁAs

		// ܂łAΏۂ̃ubNȊO̕񂾂Ƃ
		//
		long lTokenType;
		lTokenType	= GetTokenType( lIndex );

		// NI[gꂽ̏ꍇ́AⓚpŎ
		if( lTokenType==CHTOKEN_TYPE_QUOTED ){
			lIndex++;
			continue;
		}

		// u[XȂAu[XoāAȍ~
		if( strToken=="{" ){
			lIndex	= GetCloseBraceIndex( lIndex );
			if( lIndex==-1 ){
				ErrorLog( "CHARUNA2::TakeInBlockTop : u[Xoł܂łB\n" );
				return -1;
			}
			lIndex++;
			continue;
		}

		// ֌WȂʂ̕ȂÂ܂܎
		lIndex++;
	}

	// -----< ubNSđĂ邩H >-----
	//
	// <<< bMustExists  TRUE ̏ꍇ̂݊mFB >>>
	//
	if( bMustExists==TRUE ){
		for( i=0;i<rBlockNames.Length();i++ ){
			BOOL bRes;
			bRes	= IsBlockExists( rBlockNames[i] );
			if( bRes==FALSE ){
				// ubN݂Ȃꍇ̓G[Ԃ
				ErrorLog( "CHARUNA2::TakeInBlockTop : ubN[%s]݂܂B\n" , rBlockNames[i].GetString() );
				return FALSE;
			}
		}
	}

	// -----< oI >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsBlockExists( CGStr& rBlockName )
//
//	[  ]
//		CGStr& rBlockName			ubN
//
//	[ ߂l ]
//		݂@FTRUE
//		݂ȂFFALSE
//
//	[  ]
//		w肵ÕubN݂邩ۂԂ܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::IsBlockExists( CGStr& rBlockName )
{
	BOOL bRes;
	bRes	= m_hashBlockTop.KeyExists( rBlockName );
	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetBlockTopIndex( CGStr& rBlockName )
//
//	[  ]
//		CGStr& rBlockName			擾ubÑubN
//
//	[ ߂l ]
//		Fg[ÑCfbNXԍ
//		sF-1
//
//	[  ]
//		w肵ÕubN̐擪CfbNXԂ܂B
//--------------------------------------------------------------------
long CHARUNA2::GetBlockTopIndex( CGStr& rBlockName )
{
	long lIndex;
	BOOL bRes;

	// <<< ݂H >>>
	bRes	= m_hashBlockTop.KeyExists( rBlockName );
	if( bRes==FALSE ){
		ErrorLog( "CHARUNA2::GetBlockTopIndex : ubN[%s]݂͑܂B\n" , rBlockName.GetString() );
		return -1;
	}

	// <<< 擾 >>>
	lIndex	= m_hashBlockTop.GetObject( rBlockName );
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		virtual BOOL Exec()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		p̃NXŁAXNvgsR[h܂B
//--------------------------------------------------------------------
BOOL CHARUNA2::Exec()
{
	long i;
	for( i=0;i<m_objToken.Length();i++ ){
		CGStr strToken;
		GetToken( i , strToken );
		printf( "%8d : [%s]\n" , GetLine( i ) , strToken.GetString() );
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetCloseBraceIndex( long lIndex )
//
//	[  ]
//		long lIndex					Jnu[Xi{j̃CfbNXԍ
//
//	[ ߂l ]
//		u[X̃CfbNXԍ
//
//	[  ]
//		Jnu[XɑΉu[X̃CfbNXԍԂ܂
//--------------------------------------------------------------------
long CHARUNA2::GetCloseBraceIndex( long lIndex )
{
	long lRes;
	CGStr strToken;

	// -----< mF >-----
	//
	lRes	= GetToken( lIndex , strToken );
	if( lRes==-1 )return -1;
	if( strToken!="{" ){
		// Jnu[XłȂCfbNXw肳ꂽ
		return -1;
	}
	lIndex++;

	// -----<  >-----
	//
	long lBraceCount = 1;

	while( 1 ){
		lRes	= GetToken( lIndex , strToken );
		if( lRes==-1 ){
			ErrorLog( "HARUNA2::GetCloseBraceIndex : g[N擾Ɏs܂B\n" );
			return -1;
		}

		// NI[gꂽ񂾂AⓚpŎ
		if( GetTokenType( lIndex )==CHTOKEN_TYPE_QUOTED ){
			lIndex++;
			continue;
		}

		// Jnu[X
		if( strToken=="{" ){
			lBraceCount	+= 1;
			lIndex++;
			continue;
		}

		// u[X
		if( strToken=="}" ){
			lBraceCount	-= 1;
			if( lBraceCount==0 )break;
		}

		lIndex++;
		continue;
	}

	return lIndex;
}


//--------------------------------------------------------------------
//	[  ] static
//		long ConvertTokenTypeFromLineRead( long lLineReadTokenType )
//
//	[  ]
//		long lLineReadTokenType		CLineRead ̃g[N^Cv
//
//	[ ߂l ]
//		ϊꂽg[N^Cvl
//
//	[  ]
//		CLineRead ̃g[N^CvAHARUNA2 ̃g[N^Cv
//		ϊ܂B
//--------------------------------------------------------------------
long CHARUNA2::ConvertTokenTypeFromLineRead( long lLineReadTokenType )
{
	long lResult = CHTOKEN_TYPE_NORMAL;

	switch( lLineReadTokenType ){
		case LINEREAD_TOKEN_TYPE_NORMAL:
			lResult	= CHTOKEN_TYPE_NORMAL;
			break;

		case LINEREAD_TOKEN_TYPE_QUOTED:
			lResult	= CHTOKEN_TYPE_QUOTED;
			break;

		default:
			lResult	= CHTOKEN_TYPE_ERROR;
			break;
	}

	return lResult;
}


//--------------------------------------------------------------------
//	[  ]
//		CHARUNA2& operator=( CHARUNA2& rHARUNA2 )
//
//	[  ]
//		CHARUNA2& rHARUNA2			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CHARUNA2& CHARUNA2::operator=( CHARUNA2& rHARUNA2 )
{
	CopyMembers( rHARUNA2 );
	return *this;
}
