//==============================================================================
//    DrawInfo.h			`pbP[W
//==============================================================================

#ifndef __G_DRAWINFO_H__
#define __G_DRAWINFO_H__

#include "Utils.h"
#include "DArray.h"

// -----< 萔` >-----
//
enum EDRAWINFOMETHODTYPE{
	  DRAWINFO_METHOD_NOP 		= 0						// l
	, DRAWINFO_METHOD_SPRITE							// XvCg̕`
	, DRAWINFO_METHOD_GRP								// fqo̕`
	, DRAWINFO_METHOD_OBJ3D								// RcIuWFNg̕`
	, DRAWINFO_METHOD_CAMERA							// Jݒ
	, DRAWINFO_METHOD_TW								// eLXgEBhE
};

#define DRAWINFO_SPRITE_BMPINDEX		0				//  long : aloCfbNX
#define	DRAWINFO_SPRITE_SPCODE			1				//  long : XvCgCfbNX
#define DRAWINFO_SPRITE_X				2				//  long : `wW
#define DRAWINFO_SPRITE_Y				3				//  long : `xW
#define DRAWINFO_SPRITE_DIFFUSE			4				//  long : fBt[YF
#define DRAWINFO_SPRITE_RZ				0				// float : ]px

#define DRAWINFO_GRAPHIC_BMPINDEX		0				//  long : rbg}bṽCfbNXԍ
#define DRAWINFO_GRAPHIC_GRPINDEX		1				//  long : OtBbNʂ̃CfbNXԍ
#define DRAWINFO_GRAPHIC_X				2				//  long : r[|CgwW
#define DRAWINFO_GRAPHIC_Y				3				//  long : r[|CgxW
#define DRAWINFO_GRAPHIC_Z				4				//	long : `ʒuyW
#define DRAWINFO_GRAPHIC_DIFFUSE		5				//  long : fBt[YF
#define DRAWINFO_GRAPHIC_LOOP_X			6				//  long : LOOP X
#define DRAWINFO_GRAPHIC_LOOP_Y			7				//  long : LOOP Y

#define DRAWINFO_OBJ3D_INDEX			0				//  long : RcIuWFNg̃CfbNXԍ
#define DRAWINFO_OBJ3D_X				0				// float : wW
#define DRAWINFO_OBJ3D_Y				1				// float : xW
#define DRAWINFO_OBJ3D_Z				2				// float : yW
#define DRAWINFO_OBJ3D_RX				3				// float : w܂]
#define DRAWINFO_OBJ3D_RY				4				// float : x܂]
#define DRAWINFO_OBJ3D_RZ				5				// float : y܂]

#define DRAWINFO_CAMERA_CULL			0				//  long : Aʏݒ
#define DRAWINFO_CAMERA_ZBUFFER			1				//  long : yobt@gpݒ
#define DRAWINFO_CAMERA_EYE_X			0				// float : JwW
#define DRAWINFO_CAMERA_EYE_Y			1				// float : JxW
#define DRAWINFO_CAMERA_EYE_Z			2				// float : JyW
#define DRAWINFO_CAMERA_AT_X			3				// float : ړ_wW
#define DRAWINFO_CAMERA_AT_Y			4				// float : ړ_xW
#define DRAWINFO_CAMERA_AT_Z			5				// float : ړ_yW
#define DRAWINFO_CAMERA_UP_X			6				// float : wW
#define DRAWINFO_CAMERA_UP_Y			7				// float : xW
#define DRAWINFO_CAMERA_UP_Z			8				// float : yW
#define DRAWINFO_CAMERA_FOVY			9				// float : p
#define DRAWINFO_CAMERA_ASPECT			10				// float : AXyNg
#define DRAWINFO_CAMERA_NEAR			11				// float : ŋ
#define DRAWINFO_CAMERA_FAR				12				// float : ŉ

#define DRAWINFO_TW_INDEX				0				//  long : eLXgEBhẼCfbNXԍ


// -----< NX` >-----
//
class CGDrawInfo : public CUtils {
	// -----< \z >-----
	//
	public:
		CGDrawInfo();									// RXgN^
		CGDrawInfo( CGDrawInfo& rDrawInfo );			// Rs[RXgN^
		virtual ~CGDrawInfo();							// fXgN^

	protected:
		virtual BOOL CopyMembers( CGDrawInfo& rDrawInfo );	// ̕


	// -----< f[^o >-----
	//
	protected:
		long				m_lMethod;					// `@̃R[hԍ
		long				m_lLayer;					// `惌C[
		CDArray< long >		m_objLongValue;				// `֘A̕KvȐ
		CDArray< double >	m_objDoubleValue;			// `֘A̕KvȎ
		CDArray< float >	m_objFloatValue;			// `֘A̕Kvfloat^


	// -----< \bh >-----
	//
	public:
		BOOL	Initialize();							// IuWFNg
		void	Release();								// ̈̊J

	public:
		void	SetLayer( long lLayer );				// `惌C[ݒ
		long	GetLayer();								// `惌C[擾

	private:
		long	AddLongValue( long lValue );			// l̒ǉ
		long	AddDoubleValue( double dValue );		// l̒ǉ
		long	AddFloatValue( float fValue );			// float^l̒ǉ
		long	GetLongValue( long lIndex );			// l̎擾
		double	GetDoubleValue( long lIndex );			// l̎擾
		float	GetFloatValue( long lIndex );			// float^l̎擾

	public:
		long	GetMethod();							// `@擾

		BOOL	SPSetBMP( long lPage );					// XvCg̃rbg}bvy[Wݒ
		BOOL	SPSetSprite( long lSprite );			// XvCg̃XvCgԍ
		BOOL	SPSetX( long lX );						// XvCĝwW
		BOOL	SPSetY( long lY );						// XvCĝxW
		BOOL	SPSetRotation( float fZ );				// XvCg̉]px
		BOOL	SPSetDiffuse( long dwDiffuse );			// XvCg̃fBt[YF

		long	SPGetBMP();								// XvCg̃rbg}bvy[W
		long	SPGetSprite();							// XvCg̃CfbNXԍ
		long	SPGetX();								// XvCĝwW
		long	SPGetY();								// XvCĝxW
		float	SPGetRotation();						// XvCg̉]px
		long	SPGetDiffuse();							// XvCg̃fBt[YF

		BOOL	GRPSetBMP( long lBMPIndex );			// rbg}bv摜̃CfbNXԍݒ
		BOOL	GRPSetGRP( long lGRPIndex );			// OtBbÑCfbNXԍݒ
		BOOL	GRPSetViewX( long lX );					// OtBbÑr[|Cgwݒ
		BOOL	GRPSetViewY( long lY );					// OtBbÑr[|Cgxݒ
		BOOL	GRPSetViewZ( long lZ );					// OtBbÑr[|Cgyݒ
		BOOL	GRPSetDiffuse( long dwDiffuse );		// OtBbÑfBt[YFݒ
		BOOL	GRPSetLoopX( long lLoopX );				// [v[hw
		BOOL	GRPSetLoopY( long lLoopY );				// [v[hx

		long	GRPGetBMP();							// rbg}bṽCfbNXԍ擾
		long	GRPGetGRP();							// OtBbÑCfbNXԍ擾
		long	GRPGetViewX();							// OtBbÑr[|Cgw擾
		long	GRPGetViewY();							// OtBbÑr[|Cgx擾
		long	GRPGetViewZ();							// OtBbÑr[|Cgy擾
		long	GRPGetDiffuse();						// OtBbÑfBt[YF擾
		long	GRPGetLoopX();							// [v[hw
		long	GRPGetLoopY();							// [v[hx

		BOOL	Obj3DSetIndex( long lIndex );			// RcIuWFNg̃CfbNXԍ
		BOOL	Obj3DSetX( float fValue );				// RcIuWFNĝwW
		BOOL	Obj3DSetY( float fValue );				// RcIuWFNĝxW
		BOOL	Obj3DSetZ( float fValue );				// RcIuWFNĝyW
		BOOL	Obj3DSetRX( float fValue );				// RcIuWFNĝw܂]p
		BOOL	Obj3DSetRY( float fValue );				// RcIuWFNĝx܂]p
		BOOL	Obj3DSetRZ( float fValue );				// RcIuWFNĝy܂]p

		long	Obj3DGetIndex();						// RcIuWFNg̃CfbNXԍ
		float	Obj3DGetX();							// RcIuWFNĝwW
		float	Obj3DGetY();							// RcIuWFNĝxW
		float	Obj3DGetZ();							// RcIuWFNĝyW
		float	Obj3DGetRX();							// RcIuWFNĝw܂]p
		float	Obj3DGetRY();							// RcIuWFNĝx܂]p
		float	Obj3DGetRZ();							// RcIuWFNĝy܂]p

		BOOL	CameraSetCull( long lCull );			// Bʏw
		BOOL	CameraSetZBuffer( long lZBuffer );		// yobt@gpw
		BOOL	CameraSetEyeX( float fX );				// Jʒu
		BOOL	CameraSetEyeY( float fY );				// Jʒu
		BOOL	CameraSetEyeZ( float fZ );				// Jʒu
		BOOL	CameraSetAtX(  float fX );				// ړ_
		BOOL	CameraSetAtY(  float fY );				// ړ_
		BOOL	CameraSetAtZ(  float fZ );				// ړ_
		BOOL	CameraSetUpX(  float fX );				// xNg
		BOOL	CameraSetUpY(  float fY );				// xNg
		BOOL	CameraSetUpZ(  float fZ );				// xNg
		BOOL	CameraSetFovy( float fFovy );			// p
		BOOL	CameraSetAspect( float fAspect );		// AXyNg
		BOOL	CameraSetNear( float fNear );			// ŋ
		BOOL	CameraSetFar( float fFar );				// ŉ

		long	CameraGetCull();						// Bʏw
		long	CameraGetZBuffer();						// yobt@gpw
		float	CameraGetEyeX();						// Jʒu
		float	CameraGetEyeY();						// Jʒu
		float	CameraGetEyeZ();						// Jʒu
		float	CameraGetAtX();							// ړ_
		float	CameraGetAtY();							// ړ_
		float	CameraGetAtZ();							// ړ_
		float	CameraGetUpX();							// xNg
		float	CameraGetUpY();							// xNg
		float	CameraGetUpZ();							// xNg
		float	CameraGetFovy();						// p
		float	CameraGetAspect();						// AXyNg
		float	CameraGetNear();						// ŋ
		float	CameraGetFar();							// ŉ

		BOOL	TWSetIndex( long lIndex );				// CfbNXԍ

		long	TWGetIndex();							// CfbNXԍ

	// -----< Zq >-----
	//
	public:
		CGDrawInfo& operator=( CGDrawInfo& rDrawInfo );


	// -----< IuWFNg\zpÓIϐ >-----
	//
	static CGDrawInfo*	CreateSprite(					// XvCg`̃pbP[W\z
					  long lLayer , long lBMPPage , long lSPCode , long lX , long lY
					, float fZ=0.0 , long dwDiffuse=0xFFFFFFFF );

	static CGDrawInfo*	CreateGRP(						// fqo`̃pbP[W\z
					  long lLayer , long lBMPIndex , long lGRPIndex , long lViewX , long lViewY , long lViewZ
					, long dwDiffuse = 0xFFFFFFFF );

	static CGDrawInfo*	CreateObj3D(					// RcIuWFNg`̃pbP[W\z
					  long lLayer
					, long lIndex
					, float fX  , float fY  , float fZ
					, float fRX , float fRY , float fRZ
					);

	static CGDrawInfo*	CreateObj3D(					// RcIuWFNg`̃pbP[W\z
					  long lIndex
					, float fX  , float fY  , float fZ
					, float fRX , float fRY , float fRZ
					);

	static CGDrawInfo*	CreateCamera(					// J
					  long lLayer
					, long lCullMode , long lZBuffer
					, float fEyeX , float fEyeY , float fEyeZ
					, float fAtX  , float fAtY  , float fAtZ
					, float fUpX  , float fUpY  , float fUpZ
					, float fFovy
					, float fAspect
					, float fNear , float fFar
					);

	static CGDrawInfo*	CreateTW(						// eLXgEBhE
					  long lLayer
					, long lIndex 
					);
};

#endif
