//==============================================================================
//    DrawInfo.cpp			`pbP[W
//==============================================================================
#include "system.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "DrawInfo.h"

//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CGDrawInfo::CGDrawInfo()
{
	m_lMethod	= DRAWINFO_METHOD_NOP;
	m_lLayer	= 0;
	m_objLongValue.Release();
	m_objDoubleValue.Release();
	m_objFloatValue.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo( CGDrawInfo& rDrawInfo )
//
//	[  ]
//		CGDrawInfo& rDrawInfo			Rs[IuWFNgւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CGDrawInfo::CGDrawInfo( CGDrawInfo& rDrawInfo )
{
	CopyMembers( rDrawInfo );
}


//--------------------------------------------------------------------
//	[  ]
//		~CGDrawInfo()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGDrawInfo::~CGDrawInfo()
{
	// ̈̊J
	//
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGDrawInfo& rDrawInfo )
//
//	[  ]
//		CGDrawInfo& rDrawInfo			Rs[ƃIuWFNg
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::CopyMembers( CGDrawInfo& rDrawInfo )
{
	m_objLongValue.Release();
	m_objDoubleValue.Release();
	m_objFloatValue.Release();

	// `悷̂̎
	m_lMethod	= rDrawInfo.m_lMethod;

	// `惌C[
	m_lLayer	= rDrawInfo.m_lLayer;

	// ϐ
	m_objLongValue		= rDrawInfo.m_objLongValue;
	m_objDoubleValue	= rDrawInfo.m_objDoubleValue;
	m_objFloatValue		= rDrawInfo.m_objFloatValue;

	// I
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNgԂɖ߂܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Initialize()
{
	m_lMethod	= DRAWINFO_METHOD_NOP;
	m_lLayer	= 0;
	m_objLongValue.Release();
	m_objDoubleValue.Release();
	m_objFloatValue.Release();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNĝ߂ɊmۂĂ郊\[XSĉ܂B
//--------------------------------------------------------------------
void CGDrawInfo::Release()
{
	m_lMethod		= DRAWINFO_METHOD_NOP;
	m_lLayer		= 0;
	m_objLongValue.Release();
	m_objDoubleValue.Release();
	m_objFloatValue.Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void	SetLayer( long lLayer )
//
//	[  ]
//		long lLayer
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		`惌C[ݒ肷
//--------------------------------------------------------------------
void CGDrawInfo::SetLayer( long lLayer )
{
	m_lLayer = lLayer;
}


//--------------------------------------------------------------------
//	[  ]
//		long GetLayer()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		`惌C[
//
//	[  ]
//		`惌C[擾܂B
//--------------------------------------------------------------------
long CGDrawInfo::GetLayer()
{
	return m_lLayer;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddLongValue( long lValue )
//
//	[  ]
//		long lValue					ǉl
//
//	[ ߂l ]
//		ǉCfbNXԍ
//
//	[  ]
//		zɒlǉ܂B
//		IuWFNg̊O璼ڌĂ΂邱Ƃ͂܂B
//--------------------------------------------------------------------
long CGDrawInfo::AddLongValue( long lValue )
{
	return m_objLongValue.Add( lValue );
}


//--------------------------------------------------------------------
//	[  ]
//		long AddDoubleValue( double dValue )
//
//	[  ]
//		double dValue					ǉl
//
//	[ ߂l ]
//		ǉCfbNXԍ
//
//	[  ]
//		zɒlǉ܂B
//		IuWFNg̊O璼ڌĂ΂邱Ƃ͂܂B
//--------------------------------------------------------------------
long CGDrawInfo::AddDoubleValue( double dValue )
{
	return m_objDoubleValue.Add( dValue );
}


//--------------------------------------------------------------------
//	[  ]
//		long AddFloatValue( float dValue )
//
//	[  ]
//		float fValue					ǉl
//
//	[ ߂l ]
//		ǉCfbNXԍ
//
//	[  ]
//		float^zɒlǉ܂B
//		IuWFNg̊O璼ڌĂ΂邱Ƃ͂܂B
//--------------------------------------------------------------------
long CGDrawInfo::AddFloatValue( float fValue )
{
	return m_objFloatValue.Add( fValue );
}


//--------------------------------------------------------------------
//	[  ]
//		long GetLongValue( long lIndex )
//
//	[  ]
//		long lIndex					擾l̃CfbNXԍ
//
//	[ ߂l ]
//		wCfbNXԍ̐l
//
//	[  ]
//		ݒ肳Ă鐮lԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GetLongValue( long lIndex )
{
	return m_objLongValue[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		double GetDoubleValue( long lIndex )
//
//	[  ]
//		long lIndex					擾l̃CfbNXԍ
//
//	[ ߂l ]
//		wCfbNXԍɐݒ肳ꂽl
//
//	[  ]
//		ݒ肳ĂlԂ܂B
//--------------------------------------------------------------------
double CGDrawInfo::GetDoubleValue( long lIndex )
{
	return m_objDoubleValue[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		float GetFloatValue( long lIndex )
//
//	[  ]
//		long lIndex					擾l̃CfbNXԍ
//
//	[ ߂l ]
//		wCfbNXԍɐݒ肳ꂽfloat^l
//
//	[  ]
//		ݒ肳Ăfloat^lԂ܂B
//--------------------------------------------------------------------
float CGDrawInfo::GetFloatValue( long lIndex )
{
	return m_objFloatValue[ lIndex ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GetMethod()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		`@R[h
//
//	[  ]
//		`@擾܂B
//--------------------------------------------------------------------
long CGDrawInfo::GetMethod()
{
	return m_lMethod;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetBMP( long lPage )
//
//	[  ]
//		long lPage					alõy[Wԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		alõy[Wԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetBMP( long lPage )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetBMP : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_SPRITE_BMPINDEX] = lPage;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetSprite( long lSprite )
//
//	[  ]
//		long lSprite				XvCgԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCg̃CfbNXԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetSprite( long lSprite )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetSprite : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_SPRITE_SPCODE] = lSprite;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetX( long lX )
//
//	[  ]
//		long lX						XvCĝwW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCĝwWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetX( long lX )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetX : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_SPRITE_X] = lX;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetY( long lY )
//
//	[  ]
//		long lY						XvCĝxW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCĝxWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetY( long lY )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_SPRITE_Y] = lY;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetRotation( float fZ )
//
//	[  ]
//		float fZ					]pxiWAj
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCg̉]pxݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetRotation( float fZ )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetRotation : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_SPRITE_RZ] = fZ;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SPSetDiffuse( long dwDiffuse )
//
//	[  ]
//		long dwDiffuse				XvCg̃fBt[YFiARGBj
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		XvCg̃fBt[YFݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::SPSetDiffuse( long dwDiffuse )
{
	if( m_lMethod!=DRAWINFO_METHOD_SPRITE ){
		ErrorLog( "CGDrawInfo::SPSetDiffuse : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_SPRITE_DIFFUSE] = dwDiffuse;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long SPGetBMP()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCĝaloy[Wԍ
//
//	[  ]
//		IuWFNgɐݒ肳ĂAro`̏ƌȂA
//		aloy[WԍԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::SPGetBMP()
{
	return m_objLongValue[ DRAWINFO_SPRITE_BMPINDEX ];
}


//--------------------------------------------------------------------
//	[  ]
//		long SPGetSprite()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̃R[hԍ
//
//	[  ]
//		IuWFNgɐݒ肳ĂAro`̏ƌȂA
//		roR[hԍԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::SPGetSprite()
{
	return m_objLongValue[ DRAWINFO_SPRITE_SPCODE ];
}


//--------------------------------------------------------------------
//	[  ]
//		long SPGetX()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̕`wW
//
//	[  ]
//		IuWFNgɐݒ肳Ăro`ƌȂA
//		ro̕`wWԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::SPGetX()
{
	return m_objLongValue[ DRAWINFO_SPRITE_X ];
}


//--------------------------------------------------------------------
//	[  ]
//		long SPGetY()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̕`xW
//
//	[  ]
//		IuWFNgɐݒ肳Ăro`ƌȂA
//		ro`xWԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::SPGetY()
{
	return m_objLongValue[ DRAWINFO_SPRITE_Y ];
}


//--------------------------------------------------------------------
//	[  ]
//		float SPGetRotation()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̉]px
//
//	[  ]
//		IuWFNgɐݒ肳Ăro`ƌȂA
//		`]pxԂ܂B
//--------------------------------------------------------------------
float CGDrawInfo::SPGetRotation()
{
	return m_objFloatValue[ DRAWINFO_SPRITE_RZ ];
}


//--------------------------------------------------------------------
//	[  ]
//		long SPGetDiffuse()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		XvCg̃fBt[YF
//
//	[  ]
//		IuWFNgɐݒ肳Ăro`ƌȂA
//		fBt[YFԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::SPGetDiffuse()
{
	return m_objLongValue[ DRAWINFO_SPRITE_DIFFUSE ];
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetBMP( long lBMPIndex )
//
//	[  ]
//		long lBMPIndex					rbg}bṽCfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		rbg}bṽCfbNXԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetBMP( long lPage )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetBMP : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_BMPINDEX] = lPage;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetGRP( long lGRPIndex )
//
//	[  ]
//		long lGRPIndex					zOtBbNʂ̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		zOtBbNʂ̃CfbNXԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetGRP( long lPage )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetGRP : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_GRPINDEX] = lPage;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetViewX( long lX )
//
//	[  ]
//		long lX						r[|CĝwW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fqôwWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetViewX( long lViewX )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetViewX : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_X] = lViewX;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetViewY( long lY )
//
//	[  ]
//		long lY						OtBbÑr[|CgxW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fqõr[|CĝxWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetViewY( long lY )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetViewY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_Y] = lY;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetViewZ( long lZ )
//
//	[  ]
//		long lZ						OtBbNZW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fqoZWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetViewZ( long lZ )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetViewY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_Z] = lZ;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetLoopX( long lX )
//
//	[  ]
//		long lX						[v[hw
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fqõ[v[hݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetLoopX( long lX )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetLoopX : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_LOOP_X] = lX;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL GRPSetLoopY( long lY )
//
//	[  ]
//		long lY						[v[hx
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		fqôx[v[hݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::GRPSetLoopY( long lY )
{
	if( m_lMethod!=DRAWINFO_METHOD_GRP ){
		ErrorLog( "CGDrawInfo::GRPSetLoopY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_GRAPHIC_LOOP_Y] = lY;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetBMP()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		rbg}bṽCfbNXԍ
//
//	[  ]
//		IuWFNgɐݒ肳Ăfqo`ƌȂA
//		rbg}bṽCfbNXԍԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetBMP()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_BMPINDEX ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetGRP()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		zOtBbNʂ̃CfbNXԍ
//
//	[  ]
//		IuWFNgɐݒ肳Ăfqo`ƌȂA
//		zOtBbNʂ̃CfbNXԍԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetGRP()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_GRPINDEX ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetViewX()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqõr[|Cgw
//
//	[  ]
//		IuWFNgɐݒ肳Ăfqo`ƌȂA
//		fqo`wWԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetViewX()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_X ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetViewY()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqõr[|CgxW
//
//	[  ]
//		IuWFNgɐݒ肳Ăfqo`ƌȂA
//		fqo`xWԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetViewY()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_Y ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetViewZ()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqoZW
//
//	[  ]
//		IuWFNgɐݒ肳Ăfqo`ƌȂA
//		fqo`ZWԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetViewZ()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_Z ];
}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetDiffuse()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqõfBt[YF
//
//	[  ]
//		fqõfBt[YF擾܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetDiffuse()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_DIFFUSE ];

}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetLoopX()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqôw[v[h
//
//	[  ]
//		fqôw[v[hԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetLoopX()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_LOOP_X ];

}


//--------------------------------------------------------------------
//	[  ]
//		long GRPGetLoopY()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		fqôx[v[h
//
//	[  ]
//		fqôx[v[hԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::GRPGetLoopY()
{
	return m_objLongValue[ DRAWINFO_GRAPHIC_LOOP_Y ];

}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetIndex( long lIndex )
//
//	[  ]
//		long lIndex					RcIuWFNg̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNg̃CfbNXԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetIndex( long lIndex )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetIndex : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objLongValue[DRAWINFO_OBJ3D_INDEX] = lIndex;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetX( float fValue )
//
//	[  ]
//		float fValue				wW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝwWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetX( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetX : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_X] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetY( float fValue )
//
//	[  ]
//		float fValue				xW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝxWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetY( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_Y] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetZ( float fValue )
//
//	[  ]
//		float fValue				yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝyWݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetZ( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetZ : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_Z] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetRX( float fValue )
//
//	[  ]
//		float fValue				w܂̉]px
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝw܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetRX( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetRX : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_RX] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetRY( float fValue )
//
//	[  ]
//		float fValue				x܂̉]px
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝx܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetRY( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetRY : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_RY] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Obj3DSetRZ( float fValue )
//
//	[  ]
//		float fValue				y܂̉]px
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝy܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::Obj3DSetRZ( float fValue )
{
	if( m_lMethod!=DRAWINFO_METHOD_OBJ3D ){
		ErrorLog( "CGDrawInfo::Obj3DSetRZ : sȃ[hŌĂ΂܂B\n" );
		return FALSE;
	}

	m_objFloatValue[DRAWINFO_OBJ3D_RZ] = fValue;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long Obj3DGetIndex()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNg̃CfbNXԍݒ肵܂B
//--------------------------------------------------------------------
long CGDrawInfo::Obj3DGetIndex()
{
	return m_objLongValue[DRAWINFO_OBJ3D_INDEX];
}


//--------------------------------------------------------------------
//	[  ]
//		float Obj3DGetX()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝwWݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetX()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_X];
}


//--------------------------------------------------------------------
//	[  ]
//		float Obj3DGetY()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝxWݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetY()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_Y];
}


//--------------------------------------------------------------------
//	[  ]
//		floatObj3DGetZ()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝyWݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetZ()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_Z];
}


//--------------------------------------------------------------------
//	[  ]
//		float Obj3DGetRX()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝw܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetRX()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_RX];
}


//--------------------------------------------------------------------
//	[  ]
//		float Obj3DGetRY()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝx܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetRY()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_RY];
}


//--------------------------------------------------------------------
//	[  ]
//		float Obj3DGetRZ()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		RcIuWFNĝy܂̉]pxݒ肵܂B
//--------------------------------------------------------------------
float CGDrawInfo::Obj3DGetRZ()
{
	return m_objFloatValue[DRAWINFO_OBJ3D_RZ];
}


//--------------------------------------------------------------------
//	[  ]
//		long	CameraSetCull();						// Bʏw
//		long	CameraSetZBuffer();						// yobt@gpw
//		float	CameraSetEyeX();						// Jʒu
//		float	CameraSetEyeY();						// Jʒu
//		float	CameraSetEyeZ();						// Jʒu
//		float	CameraSetAtX();							// ړ_
//		float	CameraSetAtY();							// ړ_
//		float	CameraSetAtZ();							// ړ_
//		float	CameraSetUpX();							// xNg
//		float	CameraSetUpY();							// xNg
//		float	CameraSetUpZ();							// xNg
//		float	CameraSetFovy();						// p
//		float	CameraSetAspect();						// AXyNg
//		float	CameraSetNear();						// ŋ
//		float	CameraSetFar();							// ŉ
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		J֌W̃p[^擾܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::CameraSetCull( long lValue )
{
	m_objLongValue[DRAWINFO_CAMERA_CULL]	= lValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetZBuffer( long lValue )
{
	m_objLongValue[DRAWINFO_CAMERA_ZBUFFER]	= lValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetEyeX( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_EYE_X]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetEyeY( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_EYE_Y]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetEyeZ( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_EYE_Z]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetAtX( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_AT_X]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetAtY( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_AT_Y]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetAtZ( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_AT_Z]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetUpX( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_UP_X]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetUpY( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_UP_Y]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetUpZ( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_UP_Z]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetFovy( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_ASPECT]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetAspect( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_ASPECT]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetNear( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_NEAR]	= fValue;
	return TRUE;
}

BOOL CGDrawInfo::CameraSetFar( float fValue )
{
	m_objFloatValue[DRAWINFO_CAMERA_FAR]	= fValue;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long	CameraGetCull();						// Bʏw
//		long	CameraGetZBuffer();						// yobt@gpw
//		float	CameraGetEyeX();						// Jʒu
//		float	CameraGetEyeY();						// Jʒu
//		float	CameraGetEyeZ();						// Jʒu
//		float	CameraGetAtX();							// ړ_
//		float	CameraGetAtY();							// ړ_
//		float	CameraGetAtZ();							// ړ_
//		float	CameraGetUpX();							// xNg
//		float	CameraGetUpY();							// xNg
//		float	CameraGetUpZ();							// xNg
//		float	CameraGetFovy();						// p
//		float	CameraGetAspect();						// AXyNg
//		float	CameraGetNear();						// ŋ
//		float	CameraGetFar();							// ŉ
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		J֌W̃p[^擾܂B
//--------------------------------------------------------------------
long CGDrawInfo::CameraGetCull()
{
	return m_objLongValue[DRAWINFO_CAMERA_CULL];
}

long CGDrawInfo::CameraGetZBuffer()
{
	return m_objLongValue[DRAWINFO_CAMERA_ZBUFFER];
}

float CGDrawInfo::CameraGetEyeX()
{
	return m_objFloatValue[DRAWINFO_CAMERA_EYE_X];
}

float CGDrawInfo::CameraGetEyeY()
{
	return m_objFloatValue[DRAWINFO_CAMERA_EYE_Y];
}

float CGDrawInfo::CameraGetEyeZ()
{
	return m_objFloatValue[DRAWINFO_CAMERA_EYE_Z];
}

float CGDrawInfo::CameraGetAtX()
{
	return m_objFloatValue[DRAWINFO_CAMERA_AT_X];
}

float CGDrawInfo::CameraGetAtY()
{
	return m_objFloatValue[DRAWINFO_CAMERA_AT_Y];
}

float CGDrawInfo::CameraGetAtZ()
{
	return m_objFloatValue[DRAWINFO_CAMERA_AT_Z];
}

float CGDrawInfo::CameraGetUpX()
{
	return m_objFloatValue[DRAWINFO_CAMERA_UP_X];
}

float CGDrawInfo::CameraGetUpY()
{
	return m_objFloatValue[DRAWINFO_CAMERA_UP_Y];
}

float CGDrawInfo::CameraGetUpZ()
{
	return m_objFloatValue[DRAWINFO_CAMERA_UP_Z];
}

float CGDrawInfo::CameraGetFovy()
{
	return m_objFloatValue[DRAWINFO_CAMERA_FOVY];
}

float CGDrawInfo::CameraGetAspect()
{
	return m_objFloatValue[DRAWINFO_CAMERA_ASPECT];
}

float CGDrawInfo::CameraGetNear()
{
	return m_objFloatValue[DRAWINFO_CAMERA_NEAR];
}

float CGDrawInfo::CameraGetFar()
{
	return m_objFloatValue[DRAWINFO_CAMERA_FAR];
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL TWSetIndex( long lIndex )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		eLXgEBhẼCfbNXԍݒ肵܂B
//--------------------------------------------------------------------
BOOL CGDrawInfo::TWSetIndex( long lIndex )
{
	m_objLongValue[ DRAWINFO_TW_INDEX ]	= lIndex;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		long TWGetIndex()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		CfbNXԍ
//
//	[  ]
//		eLXgEBhẼCfbNXԍԂ܂B
//--------------------------------------------------------------------
long CGDrawInfo::TWGetIndex()
{
	return m_objLongValue[ DRAWINFO_TW_INDEX ];
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo& operator=( CGDrawInfo& rDrawInfo )
//
//	[  ]
//		CGDrawInfo& rDrawInfo			Rs[IuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CGDrawInfo& CGDrawInfo::operator=( CGDrawInfo& rDrawInfo )
{
	CopyMembers( rDrawInfo );
	return *this;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateSprite(
//				  long lLayer , long lBMPPage , long lSPCode , long lX , long lY
//				, float fZ=0.0 , DWORD dwDiffuse=0xFFFFFFFF )
//
//	[  ]
//		long  lLayer				`惌C[ԍ
//		long  lBMPPage				alõy[Wԍ
//		long  lSPCode				rõR[hԍ
//		long  lX					XvCĝwW
//		long  lY					XvCĝxW
//		float fZ					]px
//		long dwDiffuse				fBt[YFiARGBj
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		ro`̃pbP[W\zĕԂ܂B
//		lBMPPage-1w肳ꂽꍇAlSPCode ̓XvCg̒ʂԍ
//		Ӗ邱ƂɂȂ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateSprite(
				  long lLayer , long lBMPPage , long lSPCode , long lX , long lY
				, float fZ , long dwDiffuse )
{
	// IuWFNg̍쐬
	//
	CGDrawInfo* pDrawInfo;
	pDrawInfo = new CGDrawInfo();
	if( pDrawInfo==NULL ){
		ErrorLog( "CSDrawInfo::CreateSprite : IuWFNg̍쐬Ɏs܂B\n" );
		return NULL;
	}

	// IuWFNgɒlݒ肷
	//
	long lIndex;

	// ^Cvݒ
	pDrawInfo->m_lMethod = DRAWINFO_METHOD_SPRITE;

	// C[ݒ
	pDrawInfo->SetLayer( lLayer );

	// aloy[Wԍݒ
	lIndex = pDrawInfo->AddLongValue( lBMPPage );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// roR[hݒ
	lIndex = pDrawInfo->AddLongValue( lSPCode );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// wWݒ
	lIndex = pDrawInfo->AddLongValue( lX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// xWݒ
	lIndex = pDrawInfo->AddLongValue( lY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// ]pxݒ
	lIndex = pDrawInfo->AddFloatValue( fZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// fBt[YFݒ
	lIndex = pDrawInfo->AddLongValue( dwDiffuse );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateSprite : fBt[YF̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// I
	//
	return pDrawInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateGRP(
//			  long lLayer , long lBMPIndex , long lGRPIndex , long lViewX , long lViewY , long lViewZ
//			, DWORD dwDiffuse=0xFFFFFFFF )
//
//	[  ]
//		long  lLayer				C[ԍ
//		long  lBMPIndex				rbg}bv摜̃CfbNXԍ
//		long  lGRPIndex				zOtBbNʂ̃CfbNXԍ
//		long  lViewX				fqõr[|CgwW
//		long  lViewY				fqõr[|CgxW
//		long  lViewZ				`yWiʏ 1.0j
//		long  dwDiffuse				fBt[YFiARGBj
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		fqo`̃pbP[W\zĕԂ܂B
//		lBMPIndex  -1 w肷ƁAlBMPIndex ͖AlGRPIndex 
//		zOtBbNʂ̒ʂCfbNXԍ̂Ƃ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateGRP(
				  long lLayer , long lBMPIndex , long lGRPIndex , long lViewX , long lViewY , long lViewZ
				, long dwDiffuse )
{
	// IuWFNg̍쐬
	//
	CGDrawInfo* pDrawInfo;
	pDrawInfo = new CGDrawInfo();
	if( pDrawInfo==NULL ){
		ErrorLog( "CSDrawInfo::CreateGRP : IuWFNg̍쐬Ɏs܂B\n" );
		return NULL;
	}

	// IuWFNgɒlݒ肷
	//
	long lIndex;

	// ^Cvݒ
	pDrawInfo->m_lMethod = DRAWINFO_METHOD_GRP;

	// C[ݒ
	pDrawInfo->SetLayer( lLayer );

	// aloy[Wԍݒ
	lIndex = pDrawInfo->AddLongValue( lBMPIndex );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// fqoy[Wԍݒ
	lIndex = pDrawInfo->AddLongValue( lGRPIndex );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// r[|CgwWݒ
	lIndex = pDrawInfo->AddLongValue( lViewX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// r[|CgxWݒ
	lIndex = pDrawInfo->AddLongValue( lViewY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// `yWݒ
	lIndex = pDrawInfo->AddLongValue( lViewZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// fBt[YFݒ
	lIndex = pDrawInfo->AddLongValue( dwDiffuse );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : fBt[Y̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// [v[hw
	lIndex = pDrawInfo->AddLongValue( 0 );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : LOOP X̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// [v[hx
	lIndex = pDrawInfo->AddLongValue( 0 );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateGRP : LOOP Y̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// I
	//
	return pDrawInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateObj3D(
//			, long lObjIndex
//			, float fX  , float fY  , float fZ
//			, float fRX , float fRY , float fRZ
//			)
//
//	[  ]
//		long  lObjIndex				RcIuWFNg̃CfbNXԍ
//		float fX					wW
//		float fY					xW
//		float fZ					yW
//		float fRX					w܂̉]px
//		float fRY					x܂̉]px
//		float fRZ					y܂̉]px
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		RcIuWFNg`̃pbP[W\zĕԂ܂B
//		`惌C[ 0 ɂȂ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateObj3D(
				  long lObjIndex
				, float fX  , float fY  , float fZ
				, float fRX , float fRY , float fRZ )
{
	CGDrawInfo* pDrawInfo;
	pDrawInfo	= CreateObj3D(
					  0 , lObjIndex
					, fX  , fY  , fZ
					, fRX , fRY , fRZ
	);

	return pDrawInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateObj3D(
//			  long lLayer
//			, long lObjIndex
//			, float fX  , float fY  , float fZ
//			, float fRX , float fRY , float fRZ
//			)
//
//	[  ]
//		long  lLayer				C[
//		long  lObjIndex				RcIuWFNg̃CfbNXԍ
//		float fX					wW
//		float fY					xW
//		float fZ					yW
//		float fRX					w܂̉]px
//		float fRY					x܂̉]px
//		float fRZ					y܂̉]px
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		RcIuWFNg`̃pbP[W\zĕԂ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateObj3D(
				  long lLayer
				, long lObjIndex
				, float fX  , float fY  , float fZ
				, float fRX , float fRY , float fRZ )
{
	// IuWFNg̍쐬
	//
	CGDrawInfo* pDrawInfo;
	pDrawInfo = new CGDrawInfo();
	if( pDrawInfo==NULL ){
		ErrorLog( "CSDrawInfo::CreateObj3D : IuWFNg̍쐬Ɏs܂B\n" );
		return NULL;
	}

	// IuWFNgɒlݒ肷
	//
	long lIndex;

	// ^Cvݒ
	pDrawInfo->m_lMethod = DRAWINFO_METHOD_OBJ3D;

	// C[ݒ
	pDrawInfo->SetLayer( lLayer );

	// aloy[Wԍݒ
	lIndex = pDrawInfo->AddLongValue( lObjIndex );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// wWݒ
	lIndex = pDrawInfo->AddFloatValue( fX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// xWݒ
	lIndex = pDrawInfo->AddFloatValue( fY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// yWݒ
	lIndex = pDrawInfo->AddFloatValue( fZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// w܂̉]p
	lIndex = pDrawInfo->AddFloatValue( fRX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// x܂̉]p
	lIndex = pDrawInfo->AddFloatValue( fRY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// y܂̉]p
	lIndex = pDrawInfo->AddFloatValue( fRZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateObj3D : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// I
	//
	return pDrawInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateCamera(
//			  long lLayer
//			, long lCullMode , long lZBuffer
//			, float fX  , float fY  , float fZ
//			, float fRX , float fRY , float fRZ
//			)
//
//	[  ]
//		
//		float fX					wW
//		float fY					xW
//		float fZ					yW
//		float fRX					w܂̉]px
//		float fRY					x܂̉]px
//		float fRZ					y܂̉]px
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		RcIuWFNg`̃pbP[W\zĕԂ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateCamera(
					  long lLayer
					, long lCullMode , long lZBuffer
					, float fEyeX , float fEyeY , float fEyeZ
					, float fAtX  , float fAtY  , float fAtZ
					, float fUpX  , float fUpY  , float fUpZ
					, float fFovy
					, float fAspect
					, float fNear , float fFar
					)
{
	// IuWFNg̍쐬
	//
	CGDrawInfo* pDrawInfo;
	pDrawInfo = new CGDrawInfo();
	if( pDrawInfo==NULL ){
		ErrorLog( "CSDrawInfo::CreateObj3D : IuWFNg̍쐬Ɏs܂B\n" );
		return NULL;
	}

	// IuWFNgɒlݒ肷
	//
	long lIndex;

	// ^Cvݒ
	pDrawInfo->m_lMethod = DRAWINFO_METHOD_CAMERA;

	// C[ݒ
	pDrawInfo->SetLayer( lLayer );

	// Bʏwݒ
	lIndex = pDrawInfo->AddLongValue( lCullMode );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// Zobt@gpwݒ
	lIndex = pDrawInfo->AddLongValue( lZBuffer );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// wWݒ
	lIndex = pDrawInfo->AddFloatValue( fEyeX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// xWݒ
	lIndex = pDrawInfo->AddFloatValue( fEyeY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// yWݒ
	lIndex = pDrawInfo->AddFloatValue( fEyeZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// wWݒ
	lIndex = pDrawInfo->AddFloatValue( fAtX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// xWݒ
	lIndex = pDrawInfo->AddFloatValue( fAtY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// yWݒ
	lIndex = pDrawInfo->AddFloatValue( fAtZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// wWݒ
	lIndex = pDrawInfo->AddFloatValue( fUpX );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// xWݒ
	lIndex = pDrawInfo->AddFloatValue( fUpY );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// yWݒ
	lIndex = pDrawInfo->AddFloatValue( fUpZ );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// pݒ
	lIndex = pDrawInfo->AddFloatValue( fFovy );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// AXyNgݒ
	lIndex = pDrawInfo->AddFloatValue( fAspect );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// Nearݒ
	lIndex = pDrawInfo->AddFloatValue( fNear );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// Farݒ
	lIndex = pDrawInfo->AddFloatValue( fFar );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateCamera : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// I
	//
	return pDrawInfo;
}


//--------------------------------------------------------------------
//	[  ]
//		CGDrawInfo* CreateTW(
//			  long lLayer
//			, long lObjIndex
//			)
//
//	[  ]
//		long  lLayer				`惌C[ԍ
//		long  lObjIndex				eLXgEBhẼCfbNXԍ
//
//	[ ߂l ]
//		\zꂽ`pbP[WIuWFNg
//		G[̏ꍇ NULL
//
//	[  ]
//		eLXgEBhE`̃pbP[W\zĕԂ܂B
//--------------------------------------------------------------------
CGDrawInfo* CGDrawInfo::CreateTW(
					  long lLayer
					, long lObjIndex
					)
{
	// IuWFNg̍쐬
	//
	CGDrawInfo* pDrawInfo;
	pDrawInfo = new CGDrawInfo();
	if( pDrawInfo==NULL ){
		ErrorLog( "CSDrawInfo::CreateTW : IuWFNg̍쐬Ɏs܂B\n" );
		return NULL;
	}

	// IuWFNgɒlݒ肷
	//
	long lIndex;

	// ^Cvݒ
	pDrawInfo->m_lMethod = DRAWINFO_METHOD_TW;

	// C[ݒ
	pDrawInfo->SetLayer( lLayer );

	// CfbNXԍ
	lIndex = pDrawInfo->AddLongValue( lObjIndex );
	if( lIndex==-1 ){
		ErrorLog( "CGDrawInfo::CreateTW : p[^̐ݒɎs܂B\n" );
		delete pDrawInfo;
		return NULL;
	}

	// I
	//
	return pDrawInfo;
}
