//====================================================================
//  DirectShow Control unit Interface class.
//====================================================================

#ifndef __DSHOWINTERFACE_H__
#define __DSHOWINTERFACE_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __SYSTEM_WINDOWS__
#include <mbstring.h>
#endif

#include "Utils.h"

#define DSHOWCONTROL_CONTENTSTYPE_MOVIE			0					// [r[̃Recw
#define DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE	1					// [r[eNX`̃Recw
#define DSHOWCONTROL_CONTENTSTYPE_AUDIO			2					// I[fBĨRecw

class CDShowInterface : public CUtils{
	// -----< \z >-----
	//
	public:
		CDShowInterface();									// RXgN^
		virtual ~CDShowInterface();							// fXgN^
		BOOL SetDefault();									// ݒ

	// -----< f[^o >-----
	//
	private:
		int				m_iSHandle;							// TEhnh

		CHAR			m_strFilename[ MAX_PATH ];			// t@C
		WCHAR			m_wFilename[ MAX_PATH ];			// t@CiChj]
		long			m_lContentsType;					// Rec̎
		long			m_lContentsIndex;					// Rec̃CfbNXԍ

		LONGLONG		m_llCurrent;						// ŏ̎
		LONGLONG		m_llStop;							// Ō̎

		BOOL			m_bLoop;							// JԂĐ邩ۂ
		long			m_volume;							// {[

	// -----<  >-----
	//
	public:
		BOOL Release();																// ̔j
		BOOL Initialize();												// 

	public:
		BOOL SetContentsIndex( long lIndex=-1 );									// Rec̃CfbNXԍ
		BOOL SetLoop( BOOL bLoop=FALSE );											// JԂĐ邩ۂ

		BOOL ReadyMovie( const char* pFilename, long volume );						// [r[Đ
		BOOL ReadyAudio( const char* pFilename, long volume );						// I[fBIĐ
		BOOL Play();																// RecĐ
		BOOL Stop();																// Rec~
		BOOL Pause();																// Recꎞ~
		BOOL FinishMovie();															// ĐI

		BOOL IsStop();																// Ot~Ă邩ۂmF
		BOOL IsPause();																// Ot Pause ۂmF
		BOOL IsPlay();																// OtĐۂmF

	private:
		BOOL PrepareMovie(const char* pFilename, long volume);					// Rec̍ĐRA
		BOOL PrepareAudio(const char* pFilename, long volume);					// Rec̍ĐRA
		BOOL PlayMovie();															// [r[Đ
		BOOL PlayAudio();															// I[fBIĐ
		BOOL StopMovie();															// [r[~
		BOOL StopAudio();															// I[fBI~
		BOOL PauseMovie();															// [r[ꎞ~
		BOOL PauseAudio();															// I[fBIꎞ~
};

#endif
