//====================================================================
//  DirectShow Control unit Interface class.
//====================================================================
#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tchar.h>
#ifdef __SYSTEM_WINDOWS__
#include <mbstring.h>
#endif

#include "DGDXInclude.h"
#include "DShowInterface.h"


//--------------------------------------------------------------------
//	[  ]
//		CDShowInterface()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CDShowInterface::CDShowInterface()
{
	BOOL bRes;
	bRes	= SetDefault();
	if( bRes==FALSE ){
		ErrorLog( "CDShowInterface::CDShowInterface : ݒɎs܂B\n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~CDShowInterface()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDShowInterface::~CDShowInterface()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lݒ
//--------------------------------------------------------------------
BOOL CDShowInterface::SetDefault()
{
	m_iSHandle = DGDX_EMPTY;

	memset( m_strFilename , 0 , sizeof( m_strFilename ) );
	memset( m_wFilename   , 0 , sizeof( m_wFilename   ) );
	m_lContentsType		= DSHOWCONTROL_CONTENTSTYPE_MOVIE;
	m_lContentsIndex	= -1;
	m_bLoop				= FALSE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̉
//--------------------------------------------------------------------
BOOL CDShowInterface::Release()
{
	if (m_iSHandle != DGDX_EMPTY) {
		switch (m_lContentsType) {
		case DSHOWCONTROL_CONTENTSTYPE_MOVIE:
		case DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE:
			DeleteGraph(m_iSHandle);
			break;

		case DSHOWCONTROL_CONTENTSTYPE_AUDIO:
			DeleteSoundMem(m_iSHandle);
			break;

		default:
			ErrorLog("CDShowInterface::Play : OɌĂяo܂B\n");
			return FALSE;
			break;
		}
	}
	m_iSHandle = DGDX_EMPTY;

	memset( m_strFilename , 0 , sizeof( m_strFilename ) );
	memset( m_wFilename   , 0 , sizeof( m_wFilename   ) );
	m_lContentsType		= DSHOWCONTROL_CONTENTSTYPE_MOVIE;
	m_lContentsIndex	= -1;
	m_bLoop				= FALSE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::Initialize()
{
	BOOL    bRes;
	bRes	= Release();
	if( bRes==FALSE ){
		ErrorLog( "CDShowInterface::Initialize : IuWFNg̓ejł܂łB\n" );
		return FALSE;
	}

	// -----<  >-----
	//
	m_iSHandle = DGDX_EMPTY;

	// <<< t@C >>>
	memset( m_strFilename , 0 , sizeof( m_strFilename ) );
	memset( m_wFilename   , 0 , sizeof( m_wFilename   ) );
	m_lContentsType		= DSHOWCONTROL_CONTENTSTYPE_MOVIE;
	m_lContentsIndex	= -1;

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetContentsIndex( long lIndex=-1 )
//
//	[  ]
//		long lIndex					CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Rec̃CfbNXԍݒ肵܂B
//		̊֐́A{I CDShowControl::Add`() Ăяo܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::SetContentsIndex( long lIndex )
{
	m_lContentsIndex	= lIndex;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLoop( BOOL bLoop=FALSE )
//
//	[  ]
//		BOOL bLoop					JԂĐ邩ۂ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		JԂĐ̐ݒ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::SetLoop( BOOL bLoop )
{
	m_bLoop	= bLoop;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReadyMovie( const char* pFilename )
//
//	[  ]
//		const char* pFilename		ĐRec̃t@C
//		long volume					{[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Movie̍Đ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::ReadyMovie( const char* pFilename, long volume )
{
	//HRESULT hRes;
	BOOL    bRes;

	// <<< t@C̍Đ >>>
	//
	bRes	= PrepareMovie( pFilename, volume );
	if( bRes==FALSE ){
		ErrorLog( "CDShowInterface::ReadyMovie : t@C pFilename ̍ĐɎs܂B\n" );
		return FALSE;
	}

	// <<< Rec^Cvݒ >>>
	//
	m_lContentsType		= DSHOWCONTROL_CONTENTSTYPE_MOVIE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReadyAudio( const char* pFilename, long volume )
//
//	[  ]
//		const char* pFilename		ĐRec̃t@C
//		long volume					{[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Audio̍Đ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::ReadyAudio( const char* pFilename, long volume )
{
	BOOL    bRes;

	// <<< t@C̍Đ >>>
	//
	bRes	= PrepareAudio( pFilename, volume );
	if( bRes==FALSE ){
		ErrorLog( "CDShowInterface::ReadyAudio : t@C pFilename ̍ĐɎs܂B\n" );
		return FALSE;
	}

	// <<< Rec^Cvݒ >>>
	//
	m_lContentsType		= DSHOWCONTROL_CONTENTSTYPE_AUDIO;

	// <<< I >>>
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Play()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Rec̍ĐJn܂B
//--------------------------------------------------------------------]
BOOL CDShowInterface::Play()
{
	BOOL bRes;
	bRes	= FALSE;

	switch( m_lContentsType ){
		case DSHOWCONTROL_CONTENTSTYPE_MOVIE:
		case DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE:
			bRes	= PlayMovie();
			break;

		case DSHOWCONTROL_CONTENTSTYPE_AUDIO:
			bRes	= PlayAudio();
			break;

		default:
			ErrorLog( "CDShowInterface::Play : OɌĂяo܂B\n" );
			return FALSE;
			break;
	}

	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Stop()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Rec̍Đ~܂B
//--------------------------------------------------------------------]
BOOL CDShowInterface::Stop()
{
	int iRes;
	BOOL bRes;
	bRes	= FALSE;

	switch( m_lContentsType ){
		case DSHOWCONTROL_CONTENTSTYPE_MOVIE:
		case DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE:
			bRes	= StopMovie();
			break;

		case DSHOWCONTROL_CONTENTSTYPE_AUDIO:
			bRes	= StopAudio();
			break;

		default:
			ErrorLog( "CDShowInterface::Stop : OɌĂяo܂B\n" );
			return FALSE;
			break;
	}


	// -----< Rec擪܂Ŋ߂ >-----
	//
	switch (m_lContentsType) {
	case DSHOWCONTROL_CONTENTSTYPE_MOVIE:
	case DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE:
		iRes = SeekMovieToGraph(m_iSHandle, 0);
		if (iRes != 0) {
			ErrorLog("CDShowInterface::Stop : V[NɎs܂B\n");
			return FALSE;
		}
		break;

	case DSHOWCONTROL_CONTENTSTYPE_AUDIO:
		// Nothing to do.
		break;

	default:
		ErrorLog("CDShowInterface::Stop : OɌĂяo܂B\n");
		return FALSE;
		break;
	}

	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Pause()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Rec̍Đꎞ~܂B
//--------------------------------------------------------------------]
BOOL CDShowInterface::Pause()
{
	BOOL bRes;
	bRes	= FALSE;

	switch( m_lContentsType ){
		case DSHOWCONTROL_CONTENTSTYPE_MOVIE:
		case DSHOWCONTROL_CONTENTSTYPE_MOVIETEXTURE:
			bRes	= PauseMovie();
			break;

		case DSHOWCONTROL_CONTENTSTYPE_AUDIO:
			bRes	= PauseAudio();
			break;

		default:
			ErrorLog( "CDShowInterface::Pause : OɌĂяo܂B\n" );
			return FALSE;
			break;
	}

	return bRes;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL FinishMovie()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Đ̏Is܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::FinishMovie()
{
	int iRes;
	iRes = DeleteGraph(m_iSHandle);
	if (iRes != 0) {
		ErrorLog("CDShowInterface::FinishMovie : nh̉Ɏs܂B\n");
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsStop()
//		BOOL IsPause()
//		BOOL IsPlay()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ꂼA~Eꎞ~EĐ̏ꍇTRUE
//
//	[  ]
//		tB^Ot̏ԂԂ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::IsStop()
{
	int iRes;
	//HRESULT hRes;

	// <<< G[`FbN >>>
	if(m_iSHandle==DGDX_EMPTY) {
		ErrorLog( "CDShowInterface::IsStop : OɌĂ΂܂B\n" );
		return FALSE;
	}

	// <<< 擾 >>>
	iRes = CheckSoundMem(m_iSHandle);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::IsStop : Ԃ擾ł܂łB\n");
		return FALSE;
	}

	// <<< Ԃ >>>
	if (iRes == 0)return TRUE;
	return FALSE;
}

BOOL CDShowInterface::IsPause()
{
	return IsStop();
}

BOOL CDShowInterface::IsPlay()
{
	BOOL bStopped;
	bStopped = IsStop();
	if (bStopped) { return FALSE; }
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrepareMovie( const char* pFilename, long volume )
//
//	[  ]
//		const char* pFilename		ĐRec̃t@C
//		long volume					{[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C̍Đ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::PrepareMovie( const char* pFilename, long volume )
{
	int iRes;

	// t@C𕡐
	_mbscpy( (unsigned char*)m_strFilename , (const unsigned char*)pFilename );

	// Chɕϊ
	MultiByteToWideChar( CP_ACP , 0 , m_strFilename , -1 , m_wFilename , MAX_PATH );

	// RecI[v
	iRes = LoadGraph(pFilename);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::ReadyMovie : ǂݍ݂Ɏs܂B\n");
		return FALSE;
	}
	m_iSHandle = iRes;
	this->m_volume = volume;


	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PrepareAudio( const char* pFilename, long volume )
//
//	[  ]
//		const char* pFilename		ĐRec̃t@C
//		long volume					{[
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C̍Đ܂B
//--------------------------------------------------------------------
BOOL CDShowInterface::PrepareAudio(const char* pFilename, long volume)
{
	int iRes;

	// t@C𕡐
	_mbscpy((unsigned char*)m_strFilename, (const unsigned char*)pFilename);

	// Chɕϊ
	MultiByteToWideChar(CP_ACP, 0, m_strFilename, -1, m_wFilename, MAX_PATH);

	// {[ݒ
	this->m_volume = volume;
	iRes = LoadSoundMem(pFilename);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::PrepareAudio : ǂݍ݂Ɏs܂B[%s]\n", pFilename);
		return FALSE;
	}
	m_iSHandle = iRes;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PlayMovie()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ĐJn܂
//--------------------------------------------------------------------
BOOL CDShowInterface::PlayMovie()
{
	// 

	// <<< I >>>
	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PlayAudio()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ĐJn܂
//--------------------------------------------------------------------
BOOL CDShowInterface::PlayAudio()
{
	int iRes;

	// {[ݒ
	iRes = ChangeVolumeSoundMem(m_volume, m_iSHandle);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::PlayAudio : ʕύXɎs܂Bvolume = %d\n", this->m_volume);
		return FALSE;
	}

	// Đ
	iRes = PlaySoundMem(m_iSHandle, (m_bLoop?DX_PLAYTYPE_LOOP:DX_PLAYTYPE_BACK), TRUE);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::PlayAudio : ĐɎs܂B\n");
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StopMovie()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Đ~܂
//--------------------------------------------------------------------
BOOL CDShowInterface::StopMovie()
{
	// 

	// <<< I >>>
	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StopAudio()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Đ~܂
//--------------------------------------------------------------------
BOOL CDShowInterface::StopAudio()
{
	int iRes;

	// <<< mF >>>
	if( m_iSHandle==DGDX_EMPTY ){
		ErrorLog( "CDShowInterface::StopAudio : OɌĂ΂܂B\n" );
		return FALSE;
	}

	// <<< Đ~ >>>
	iRes = StopSoundMem(m_iSHandle);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::PlayAudio : Đ~Ɏs܂B\n");
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PauseMovie()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Đꎞ~܂
//--------------------------------------------------------------------
BOOL CDShowInterface::PauseMovie()
{
	// 

	// <<< I >>>
	return FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PauseAudio()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		Đ~܂
//--------------------------------------------------------------------
BOOL CDShowInterface::PauseAudio()
{
	int iRes;

	// <<< mF >>>
	if( m_iSHandle==DGDX_EMPTY ){
		ErrorLog( "CDShowInterface::PauseAudio : OɌĂ΂܂B\n" );
		return FALSE;
	}

	// <<< Đ~ >>>
	iRes = StopSoundMem(m_iSHandle);
	if (iRes == -1) {
		ErrorLog("CDShowInterface::PauseAudio : Đ~Ɏs܂B\n");
		return FALSE;
	}

	// <<< I >>>
	return TRUE;
}
