//====================================================================
//  DirectShow Control unit.
//====================================================================

#ifndef __DSHOWCONTROL_H__
#define __DSHOWCONTROL_H__

#include "system.h"

#include "LogFile.h"
#include "Utils.h"
#include "DArray.h"

#include "DShowInterface.h"

class CDShowControl : public CUtils{
	// -----< \z >-----
	//
	private:
		static CDShowControl s_objDShowControl;								// IuWFNg

		CDShowControl();													// RXgN^
		BOOL SetDefault();													// lݒ

	public:
		virtual ~CDShowControl();											// fXgN^

	// -----< f[^o >-----
	//
	private:
		CDArray< CDShowInterface* >	m_aryMediaInterfaces;					// MediãC^[tFCXNX
		CDArray< CDShowInterface* >	m_arySEInterfaces;						// SẼC^[tFCXNX

	// -----<  >-----
	//
	public:
		BOOL Release();														// ̔j
		BOOL ReleaseMedia(int index);										// Media̔j
		BOOL ReleaseSE(int index);											// SE̔j
		BOOL ReleaseMedias();												// ׂĂMedia̔j
		BOOL ReleaseSEs();													// ׂĂSE̔j
		BOOL Initialize(DWORD dwMessage=NULL );				// 

		static CDShowControl* GetInstance();								// CX^X擾

		long AddMovie( const char* pFilename, long volume, BOOL bLoop=FALSE );			// [r[̃Recǉ
		long AddAudio( const char* pFilename, long volume, BOOL bLoop=FALSE );			// I[fBIRecǉ
		long AddSE(const char* pFilename, long volume, BOOL bLoop = FALSE);			// SEǉ
		BOOL PlayMedia(long lIndex);										// MediaĐ
		BOOL PlaySE(long lIndex);											// SEĐ
		BOOL StopMedia(long lIndex);										// Media~
		BOOL StopSE(long lIndex);											// SE~
		BOOL PauseMedia(long lIndex);										// ꎞ~
		BOOL PauseSE(long lIndex);											// ꎞ~
		BOOL FinishMovie( long lIndex );									// ĐI

		BOOL StopAllMedia();												// SMedia~
		BOOL StopAllSE();													// SSE~

		BOOL IsStopMedia(long lIndex);										// Ot~Ă邩ۂmF
		BOOL IsStopSE(long lIndex);											// Ot~Ă邩ۂmF
		BOOL IsPauseMedia(long lIndex);										// Ot Pause ۂmF
		BOOL IsPauseSE(long lIndex);										// Ot Pause ۂmF
		BOOL IsPlayMedia(long lIndex);										// OtĐۂmF
		BOOL IsPlaySE(long lIndex);											// OtĐۂmF
};

#endif
