//====================================================================
//  DirectShow Control unit.
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#include "LogFile.h"
#include "Utils.h"

#include "DShowControl.h"
#include "DShowInterface.h"
#include "DGControl.h"

CDShowControl CDShowControl::s_objDShowControl;

//--------------------------------------------------------------------
//	[  ]
//		CDShowControl()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgN^
//--------------------------------------------------------------------
CDShowControl::CDShowControl()
{
	BOOL bRes;
	bRes	= SetDefault();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::CDShowControl : ݒɎs܂B\n" );
	}
}


//--------------------------------------------------------------------
//	[  ]
//		virtual ~CDShowControl()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CDShowControl::~CDShowControl()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		lݒ
//--------------------------------------------------------------------
BOOL CDShowControl::SetDefault()
{
	m_aryMediaInterfaces.Release();
	m_arySEInterfaces.Release();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̉
//--------------------------------------------------------------------
BOOL CDShowControl::Release()
{
	BOOL bRes;
	bRes = ReleaseMedias();
	if (bRes == FALSE)return FALSE;

	bRes = ReleaseSEs();
	if (bRes == FALSE)return FALSE;

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseMedia(int index)
//
//	[  ]
//		int index	index
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ЂƂ̃fBA
//--------------------------------------------------------------------
BOOL CDShowControl::ReleaseMedia(int index)
{
	BOOL bRes;

	// ~
	bRes = StopMedia(index);
	if (bRes == FALSE)return FALSE;

	// C^[tFCX
	if (m_aryMediaInterfaces[index] != NULL) {
		m_aryMediaInterfaces[index]->Release();
		delete m_aryMediaInterfaces[index];
		m_aryMediaInterfaces[index] = NULL;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseSE(int index)
//
//	[  ]
//		int index	index
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ЂƂSE
//--------------------------------------------------------------------
BOOL CDShowControl::ReleaseSE(int index)
{
	BOOL bRes;

	// ~
	bRes = StopSE(index);
	if (bRes == FALSE)return FALSE;

	// C^[tFCX
	if (m_arySEInterfaces[index] != NULL) {
		m_arySEInterfaces[index]->Release();
		delete m_arySEInterfaces[index];
		m_arySEInterfaces[index] = NULL;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseMedias()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		SRec
//--------------------------------------------------------------------
BOOL CDShowControl::ReleaseMedias()
{
	BOOL bRes;
	long i;
	long lCount;

	// ~
	bRes	= StopAllMedia();
	if( bRes==FALSE )return FALSE;

	// C^[tFCXǂ
	lCount	= m_aryMediaInterfaces.Length();
	for( i=0;i<lCount;i++ ){
		if( m_aryMediaInterfaces[ i ]!=NULL ){
			m_aryMediaInterfaces[ i ]->Release();
			delete m_aryMediaInterfaces[ i ];
		}
	}

	// z
	m_aryMediaInterfaces.Release();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ReleaseSEs()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		SRec
//--------------------------------------------------------------------
BOOL CDShowControl::ReleaseSEs()
{
	BOOL bRes;
	long i;
	long lCount;

	// ~
	bRes = StopAllSE();
	if (bRes == FALSE)return FALSE;

	// C^[tFCXǂ
	lCount = m_arySEInterfaces.Length();
	for (i = 0; i < lCount; i++) {
		if (m_arySEInterfaces[i] != NULL) {
			m_arySEInterfaces[i]->Release();
			delete m_arySEInterfaces[i];
		}
	}

	// z
	m_arySEInterfaces.Release();

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Initialize(DWORD dwMessage=NULL )
//
//	[  ]
//		DWORD dwMessage			EBhEbZ[W
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e܂B
//		dwMessage  NULL ȊO̒lݒ肷ƁAEBhE
//		̃bZ[W𑗂邱Ƃł悤ɂȂ܂B
//		ʏ WM_APP+ w肵܂B
//--------------------------------------------------------------------
BOOL CDShowControl::Initialize( DWORD dwMessage )
{
	// -----< ܂͉ >-----
	//
	Release();

	// -----< I >-----
	//
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		static CDShowControl* GetInstance()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		CX^Xւ̃|C^
//
//	[  ]
//		CX^Xւ̃|C^擾
//--------------------------------------------------------------------
CDShowControl* CDShowControl::GetInstance()
{
	return &s_objDShowControl;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddMovie( const char* pFilename , BOOL bLoop=FALSE )
//
//	[  ]
//		const char* pFilename		Rec̃t@C
//		long volume					{[
//		BOOL bLoop					JԂĐ邩ۂ
//
//	[ ߂l ]
//		FǉRec̃CfbNXԍ
//		sF-1
//
//	[  ]
//		C^[tFCXǉB
//--------------------------------------------------------------------
long CDShowControl::AddMovie( const char* pFilename, long volume, BOOL bLoop )
{
	BOOL bRes;

	// <<< IuWFNg쐬 >>>
	CDShowInterface* pInterface;
	pInterface	= new CDShowInterface();
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::AddMovie : C^[tFCXǗ̃IuWFNg쐬ł܂łB\n" );
		return -1;
	}

	// <<<  >>>
	bRes	= pInterface->Initialize();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddMovie : C^[tFCX̏Ɏs܂B\n" );
		delete pInterface;
		return FALSE;
	}

	// <<< t@Cݒ肷 >>>
	bRes	= pInterface->ReadyMovie( pFilename, volume );
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddMovie : t@CĐ̏Ɏs܂B\n" );
		delete pInterface;
		return -1;
	}

	// <<< JԂ[hݒ >>>
	bRes	= pInterface->SetLoop( bLoop );
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddMovie : JԂĐ̐ݒɎs܂B\n" );
		delete pInterface;
		return -1;
	}

	// <<< ǉ >>>
	long lIndex;
	lIndex	= m_aryMediaInterfaces.Add( pInterface );
	if( lIndex==-1 ){
		ErrorLog( "CDShowControl::AddMovie : IuWFNgǉł܂łB\n" );
		delete pInterface;
		return -1;
	}

	// <<< CfbNXݒ >>>
	bRes	= pInterface->SetContentsIndex( lIndex );
	// G[͖

	// <<< Ԃ >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddAudio( const char* pFilename , long volume, BOOL bLoop )
//
//	[  ]
//		const char* pFilename		Rec̃t@C
//		long volume					{[
//		BOOL bLoop					[v[hiTRUE:JԂ  FALSE:JԂȂj
//
//	[ ߂l ]
//		FǉRec̃CfbNXԍ
//		sF-1
//
//	[  ]
//		C^[tFCXǉB
//--------------------------------------------------------------------
long CDShowControl::AddAudio( const char* pFilename , long volume, BOOL bLoop )
{
	BOOL bRes;

	// <<< IuWFNg쐬 >>>
	CDShowInterface* pInterface;
	pInterface	= new CDShowInterface();
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::AddAudio : C^[tFCXǗ̃IuWFNg쐬ł܂łB\n" );
		return -1;
	}

	// <<<  >>>
	bRes	= pInterface->Initialize();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddAudio : C^[tFCX̏Ɏs܂B\n" );
		delete pInterface;
		return FALSE;
	}

	// <<< t@Cݒ肷 >>>
	bRes	= pInterface->ReadyAudio( pFilename, volume );
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddAudio : t@CĐ̏Ɏs܂B\n" );
		delete pInterface;
		return -1;
	}

	// <<< JԂ[hݒ >>>
	bRes	= pInterface->SetLoop( bLoop );
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::AddAudio : JԂĐ̐ݒɎs܂B\n" );
		delete pInterface;
		return -1;
	}

	// <<< ǉ >>>
	long lIndex = -1;
	for (int i = 0; i < m_aryMediaInterfaces.Length(); i++) {
		if (m_aryMediaInterfaces[i] == NULL) {
			lIndex = i;
			break;
		}
	}
	if (lIndex >= 0) {
		// Xbgꍇ͐ݒ肷
		m_aryMediaInterfaces[lIndex] = pInterface;
	}
	else {
		// XbgȂΒǉ
		lIndex = m_aryMediaInterfaces.Add(pInterface);
	}
	if( lIndex==-1 ){
		ErrorLog( "CDShowControl::AddAudio : IuWFNgǉł܂łB\n" );
		delete pInterface;
		return -1;
	}

	// <<< CfbNXݒ >>>
	bRes	= pInterface->SetContentsIndex( lIndex );
	// G[͖

	// <<< Ԃ >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		long AddSE( const char* pFilename , long volume, BOOL bLoop )
//
//	[  ]
//		const char* pFilename		Rec̃t@C
//		long volume					{[
//		BOOL bLoop					[v[hiTRUE:JԂ  FALSE:JԂȂj
//
//	[ ߂l ]
//		FǉRec̃CfbNXԍ
//		sF-1
//
//	[  ]
//		C^[tFCXǉB
//--------------------------------------------------------------------
long CDShowControl::AddSE(const char* pFilename, long volume, BOOL bLoop)
{
	BOOL bRes;

	// <<< IuWFNg쐬 >>>
	CDShowInterface* pInterface;
	pInterface = new CDShowInterface();
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::AddAudio : C^[tFCXǗ̃IuWFNg쐬ł܂łB\n");
		return -1;
	}

	// <<<  >>>
	bRes = pInterface->Initialize();
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::AddAudio : C^[tFCX̏Ɏs܂B\n");
		delete pInterface;
		return FALSE;
	}

	// <<< t@Cݒ肷 >>>
	bRes = pInterface->ReadyAudio(pFilename, volume);
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::AddAudio : t@CĐ̏Ɏs܂B\n");
		delete pInterface;
		return -1;
	}

	// <<< JԂ[hݒ >>>
	bRes = pInterface->SetLoop(bLoop);
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::AddAudio : JԂĐ̐ݒɎs܂B\n");
		delete pInterface;
		return -1;
	}

	// <<< ǉ >>>
	long lIndex;
	lIndex = m_arySEInterfaces.Add(pInterface);
	if (lIndex == -1) {
		ErrorLog("CDShowControl::AddAudio : IuWFNgǉł܂łB\n");
		delete pInterface;
		return -1;
	}

	// <<< CfbNXݒ >>>
	bRes = pInterface->SetContentsIndex(lIndex);
	// G[͖

	// <<< Ԃ >>>
	return lIndex;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PlayMedia( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃RecĐ܂B
//--------------------------------------------------------------------
BOOL CDShowControl::PlayMedia( long lIndex )
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::PlayMedia : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::PlayMedia : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n" );
		return FALSE;
	}

	// <<< Đ >>>
	bRes	= pInterface->Play();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::PlayMedia : ĐJnł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PlaySE( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃RecĐ܂B
//--------------------------------------------------------------------
BOOL CDShowControl::PlaySE(long lIndex)
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::PlaySE : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::PlaySE : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n");
		return FALSE;
	}

	// <<< Đ >>>
	bRes = pInterface->Play();
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::PlaySE : ĐJnł܂łB\n");
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Stop( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃Rec~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::StopMedia( long lIndex )
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::Stop : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::Stop : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n" );
		return FALSE;
	}

	// <<< ~ >>>
	bRes	= pInterface->Stop();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::Stop : ~ł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StopSE( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃Rec~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::StopSE(long lIndex)
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::Stop : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::Stop : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n");
		return FALSE;
	}

	// <<< ~ >>>
	bRes = pInterface->Stop();
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::Stop : ~ł܂łB\n");
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PauseMedia( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃Recꎞ~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::PauseMedia( long lIndex )
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::Pause : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::Pause : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n" );
		return FALSE;
	}

	// <<< ~ >>>
	bRes	= pInterface->Pause();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::Pause : ꎞ~ł܂łB\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL PauseSE( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃Recꎞ~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::PauseSE(long lIndex)
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::Pause : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::Pause : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n");
		return FALSE;
	}

	// <<< ~ >>>
	bRes = pInterface->Pause();
	if (bRes == FALSE) {
		ErrorLog("CDShowControl::Pause : ꎞ~ł܂łB\n");
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL FinishMovie( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		w肵CfbNX̃RecĐIs܂B
//--------------------------------------------------------------------
BOOL CDShowControl::FinishMovie( long lIndex )
{
	BOOL bRes;

	// <<< G[`FbN >>>
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::FinishMovie : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// <<< C^[tFCX擾 >>>
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::FinishMovie : IuWFNgւ̃|C^Ƃ NULL Ԃ܂B\n" );
		return FALSE;
	}

	// <<< Đ >>>
	bRes	= pInterface->FinishMovie();
	if( bRes==FALSE ){
		ErrorLog( "CDShowControl::FinishMovie : ĐIŃG[܂B\n" );
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StopAllMedia()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		SRec~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::StopAllMedia()
{
	long i;
	BOOL bRes;
	for (i = 0; i < m_aryMediaInterfaces.Length(); i++) {
		// NULL͖
		if (m_aryMediaInterfaces[i] == NULL) {
			continue;
		}

		// P~߂
		bRes = StopMedia(i);
		if (bRes == FALSE)return FALSE;

		// ~mF
		int c;
		for (c = 0; c < 100; c++) {
			bRes = IsStopMedia(i);			// ~mF
			if (bRes == TRUE)break;		// 甲
			Sleep(4);					// ~܂ĂȂꂦ΁A4ms 炢҂čĎs
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------
//	[  ]
//		BOOL StopAllSE()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		SRec~܂B
//--------------------------------------------------------------------
BOOL CDShowControl::StopAllSE()
{
	long i;
	BOOL bRes;
	for (i = 0; i < m_arySEInterfaces.Length(); i++) {
		// P~߂
		bRes = StopSE(i);
		if (bRes == FALSE)return FALSE;

		// ~mF
		int c;
		for (c = 0; c < 100; c++) {
			bRes = IsStopSE(i);			// ~mF
			if (bRes == TRUE)break;		// 甲
			Sleep(4);					// ~܂ĂȂꂦ΁A4ms 炢҂čĎs
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsStop( long lIndex )
//		BOOL IsPause( long lIndex )
//		BOOL IsPlay( long lIndex )
//
//	[  ]
//		long lIndex					Rec̃CfbNXԍ
//
//	[ ߂l ]
//		ꂼA~Eꎞ~EĐ̏ꍇTRUE
//
//	[  ]
//		tB^Ot̏ԂԂ܂B
//--------------------------------------------------------------------
BOOL CDShowControl::IsStopMedia( long lIndex )
{
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::IsStop : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::IsStop : 擾|C^ NULL łB\n" );
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes	= pInterface->IsStop();

	// Ԃ
	return bRes;
}

BOOL CDShowControl::IsStopSE(long lIndex)
{
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::IsStop : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::IsStop : 擾|C^ NULL łB\n");
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes = pInterface->IsStop();

	// Ԃ
	return bRes;
}

BOOL CDShowControl::IsPauseMedia(long lIndex)
{
	if (lIndex >= m_aryMediaInterfaces.Length()) {
		ErrorLog("CDShowControl::IsPause : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface = m_aryMediaInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::IsPause : 擾|C^ NULL łB\n");
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes = pInterface->IsPause();

	// Ԃ
	return bRes;
}

BOOL CDShowControl::IsPauseSE(long lIndex)
{
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::IsPause : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::IsPause : 擾|C^ NULL łB\n");
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes = pInterface->IsPause();

	// Ԃ
	return bRes;
}

BOOL CDShowControl::IsPlayMedia( long lIndex )
{
	if( lIndex>=m_aryMediaInterfaces.Length() ){
		ErrorLog( "CDShowControl::IsPlay : w肳ꂽCfbNXԍsłB\n" );
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface	= m_aryMediaInterfaces[ lIndex ];
	if( pInterface==NULL ){
		ErrorLog( "CDShowControl::IsPlay : 擾|C^ NULL łB\n" );
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes	= pInterface->IsPlay();

	// Ԃ
	return bRes;
}

BOOL CDShowControl::IsPlaySE(long lIndex)
{
	if (lIndex >= m_arySEInterfaces.Length()) {
		ErrorLog("CDShowControl::IsPlay : w肳ꂽCfbNXԍsłB\n");
		return FALSE;
	}

	// 擾
	CDShowInterface* pInterface;
	pInterface = m_arySEInterfaces[lIndex];
	if (pInterface == NULL) {
		ErrorLog("CDShowControl::IsPlay : 擾|C^ NULL łB\n");
		return FALSE;
	}

	// 擾
	BOOL bRes;
	bRes = pInterface->IsPlay();

	// Ԃ
	return bRes;
}
