//
// Direct Input Control     CPP File
//
#include <windows.h>
#include <MMSYSTEM.h>

#include "SArray.h"
//#include "../LogMes/LogMes.h"

#include "DICONTROL.h"
//#include <dinput.h>

#include "DISemantics.h"

			// fobOł݂̂̒`
#ifdef DEBUG
#include <stdio.h>
#define DPRINT if(DebugFileStream)fprintf
#endif


static DWORD BtnFlags[]={		// {^tbO
	 JOY_BUTTON1 ,JOY_BUTTON2 ,JOY_BUTTON3 ,JOY_BUTTON4 ,JOY_BUTTON5
	,JOY_BUTTON6 ,JOY_BUTTON7 ,JOY_BUTTON8 ,JOY_BUTTON9 ,JOY_BUTTON10
	,JOY_BUTTON11,JOY_BUTTON12,JOY_BUTTON13,JOY_BUTTON14,JOY_BUTTON15
	,JOY_BUTTON16,JOY_BUTTON17,JOY_BUTTON18,JOY_BUTTON19,JOY_BUTTON20
	,JOY_BUTTON21,JOY_BUTTON22,JOY_BUTTON23,JOY_BUTTON24,JOY_BUTTON25
	,JOY_BUTTON26,JOY_BUTTON27,JOY_BUTTON28,JOY_BUTTON29,JOY_BUTTON30
	,JOY_BUTTON31,JOY_BUTTON32
};

#ifndef DEBUG
//-------------------------------------------------------------<RXgN^i[Xj>
DICONTROL::DICONTROL( long lInitBuffer )
{
	m_bOnLoad		= FALSE;									// [hł͂Ȃ
	m_bOnSave		= FALSE;									// Z[uł͂Ȃ
	m_iReadPoint	= 0;										// ǂݍ݈ʒȕ
	m_pInputData	= new SVALARRAY< SINPUTFORMAT >( lInitBuffer );	// ̓f[^ziQt[炢Tj
	if( m_pInputData==NULL ){
		ErrorLog( "DICONTROL::DICONTROL : ͏IuWFNg̍\zɎs܂B\n" );
		return;
	}
	m_pInputData->Release();
	memset( m_strInputFileName , 0 , sizeof( m_strInputFileName ) );

	isReady = FALSE;				// łĂȂ
							// ftH̃L[RtBOZbg
	CanUseStick = FALSE;				// WCXeBbNgpsɐݒ
	NumOfButtons = 0;				// gp{^̐O

	SetKeyConfig( VK_UP,VK_DOWN,VK_LEFT,VK_RIGHT );	// ftHg̃L[ݒ
	SetNotFree();
	for( int i=0;i<32;i++ ){
		data.trg[i] = FALSE;
		data.trg_norapid[i] = FALSE;
	}
}
#else
//-------------------------------------------------------------<RXgN^ifobOj>
DICONTROL::DICONTROL( long lInitBuffer , FILE* pStream )
{
	m_bOnLoad		= FALSE;				// [hł͂Ȃ
	m_bOnSave		= FALSE;				// Z[uł͂Ȃ
	m_iReadPoint	= 0;					// ǂݍ݈ʒȕ
	m_pInputData	= new SVALARRAY< SINPUTFORMAT >( lInitBuffer );	// ̓f[^z
	if( m_pInputData==NULL ){
		ErrorLog( "DICONTROL::DICONTROL : ͏IuWFNg̍\zɎs܂B\n" );
		return;
	}
	m_pInputData->Release();
	memset( m_strInputFileName , 0 , sizeof( m_strInputFileName ) );


	DebugFileStream=pStream;			// fobOt@C̃t@CXg[
	isReady = FALSE;				// łĂȂ
							// ftH̃L[RtBOZbg
	CanUseStick = FALSE;				// WCXeBbNgpsɐݒ
	NumOfButtons = 0;				// gp{^̐O

	SetKeyConfig( VK_UP,VK_DOWN,VK_LEFT,VK_RIGHT );	// ftHg̃L[ݒ
	SetNotFree();
	for( int i=0;i<32;i++ ){
		data.trg[i] = FALSE;
		data.trg_norapid[i] = FALSE;
	}
}
#endif


//-------------------------------------------------------------<fXgN^>
DICONTROL::~DICONTROL()
{
	// [h^Z[ȕꍇ͕
	CloseFile();

	// IuWFNg̔j
	if( m_pInputData ){
		delete m_pInputData;
	}
	m_pInputData = NULL;
}


//-------------------------------------------------------------<>
void DICONTROL::SetKeyConfig(
			 BYTE KeyUp,BYTE KeyDown,BYTE KeyLeft,BYTE KeyRight
			,BYTE pTrg00,BYTE pTrg01,BYTE pTrg02,BYTE pTrg03
			,BYTE pTrg04,BYTE pTrg05,BYTE pTrg06,BYTE pTrg07
			,BYTE pTrg08,BYTE pTrg09,BYTE pTrg10,BYTE pTrg11
			,BYTE pTrg12,BYTE pTrg13,BYTE pTrg14,BYTE pTrg15
			,BYTE pTrg16,BYTE pTrg17,BYTE pTrg18,BYTE pTrg19
			,BYTE pTrg20,BYTE pTrg21,BYTE pTrg22,BYTE pTrg23
			,BYTE pTrg24,BYTE pTrg25,BYTE pTrg26,BYTE pTrg27
			,BYTE pTrg28,BYTE pTrg29,BYTE pTrg30,BYTE pTrg31)
{
	KeyConfig.up    = KeyUp;			// Zbg
	KeyConfig.down  = KeyDown;			// Zbg
	KeyConfig.left  = KeyLeft;			// Zbg
	KeyConfig.right = KeyRight;			// EZbg

	KeyConfig.trg[ 0]  = pTrg00;				// gK
	KeyConfig.trg[ 1]  = pTrg01;
	KeyConfig.trg[ 2]  = pTrg02;
	KeyConfig.trg[ 3]  = pTrg03;
	KeyConfig.trg[ 4]  = pTrg04;
	KeyConfig.trg[ 5]  = pTrg05;
	KeyConfig.trg[ 6]  = pTrg06;
	KeyConfig.trg[ 7]  = pTrg07;
	KeyConfig.trg[ 8]  = pTrg08;
	KeyConfig.trg[ 9]  = pTrg09;
	KeyConfig.trg[10]  = pTrg10;
	KeyConfig.trg[11]  = pTrg11;
	KeyConfig.trg[12]  = pTrg12;
	KeyConfig.trg[13]  = pTrg13;
	KeyConfig.trg[14]  = pTrg14;
	KeyConfig.trg[15]  = pTrg15;
	KeyConfig.trg[16]  = pTrg16;
	KeyConfig.trg[17]  = pTrg17;
	KeyConfig.trg[18]  = pTrg18;
	KeyConfig.trg[19]  = pTrg19;
	KeyConfig.trg[20]  = pTrg20;
	KeyConfig.trg[21]  = pTrg21;
	KeyConfig.trg[22]  = pTrg22;
	KeyConfig.trg[23]  = pTrg23;
	KeyConfig.trg[24]  = pTrg24;
	KeyConfig.trg[25]  = pTrg25;
	KeyConfig.trg[26]  = pTrg26;
	KeyConfig.trg[27]  = pTrg27;
	KeyConfig.trg[28]  = pTrg28;
	KeyConfig.trg[29]  = pTrg29;
	KeyConfig.trg[30]  = pTrg30;
	KeyConfig.trg[31]  = pTrg31;

	NumOfButtons = 0;
	for( int i=0;i<32;i++ ){			// gp{^擾
		//if( KeyConfig.trg[i] )NumOfButtons=i+1;
		if( KeyConfig.trg[i] ){
			NumOfButtons += 1;
		}
	}

	#ifdef DEBUG
	{DPRINT( DebugFileStream,"DICONTROL::SetKeyConfig  gp{^:%d\n",NumOfButtons );}
	for( i=0;i<(int)NumOfButtons;i++ ){
		{DPRINT( DebugFileStream,"DICONTROL::SetKeyConfig  gK[%d+1]:%d\n",i,KeyConfig.trg[i] );}
	}
	#endif
}


//-------------------------------------------------------------<gKݒύX>
void DICONTROL::SetTrrigerConfig( int iTrrigerID , BYTE iVirtualKeyCode )
{
	// gKIDȂAȂ̑Ή
	if (iTrrigerID == DISEM_EMPTY_TRIGGER_ID) {
		NumOfButtons += 1;
		return;
	}

	// L[RtBOݒ
	KeyConfig.trg[ iTrrigerID ]  = iVirtualKeyCode;

	// Đݒ
	NumOfButtons = 0;
	for( int i=0;i<32;i++ ){			// gp{^擾
		if( KeyConfig.trg[i] ){
			//NumOfButtons=i+1;
			NumOfButtons += 1;
		}
	}
}


//-------------------------------------------------------------<gKݒύX>
void DICONTROL::SetDISemantics( DISemantics sSemantics )
{
	long i;

	m_sSemantics	= sSemantics;
	for( i=0;i<32;i++ ){
		long lTrrigerID	= m_sSemantics.m_sTrrigerInfo[ i ].m_lTrrigerID;
		BYTE iVKey		= m_sSemantics.m_sTrrigerInfo[ i ].m_iVirtualKeyCode;

		if( lTrrigerID==-1 )continue;
		SetTrrigerConfig( lTrrigerID , iVKey );
	}
}


//-------------------------------------------------------------<>
void DICONTROL::Initialize( UINT ParamStickID )
{
	// t@CJĂ
	CloseFile();

	isReady = FALSE;				// ܂́AłĂȂԂɂ
	CanUseStick = FALSE;

#ifdef DEBUG
	{DPRINT( DebugFileStream,"DICONTROL::Initialize  gp\ȃXeBbNő吔F%d\n",joyGetNumDevs() );}
	if( joyGetNumDevs() ){DPRINT( DebugFileStream,"DICONTROL::Initialize  XeBbNpfoCX݂͑܂\n" );}
	else {DPRINT( DebugFileStream,"DICONTROL::Initialize  XeBbNpfoCX݂͑܂\n" );}
#endif

	memset( &JoyInfoEx,0,sizeof(JOYINFOEX) );	// JOYINFOEX\̂̏
	JoyInfoEx.dwSize = sizeof(JOYINFOEX);		// \̂̃TCYZbg
	JoyInfoEx.dwFlags= JOY_RETURNBUTTONS | JOY_RETURNX | JOY_RETURNY ;	// g@\Zbg

	diresult = joyGetPosEx( ParamStickID,&JoyInfoEx );	// ԂĂ݂
	if( diresult!=JOYERR_NOERROR )CanUseStick = FALSE;	// WCXeBbNg邩ǂZbg
	else CanUseStick = TRUE;

	if( CanUseStick ){					// XeBbNgꍇ̂݁EEE
		StickID = ParamStickID;				// XeBbN̂hcZbg

		joyGetDevCaps(StickID,&JoyCaps,sizeof(JOYCAPS));	// XeBbN̋@\𒲂ׂ
		Mid_X   = (JoyCaps.wXmax + JoyCaps.wXmin)/2;	// Sl̐ݒ
		Mid_Y   = (JoyCaps.wYmax + JoyCaps.wYmin)/2;
		Threshould_X = abs((int)(JoyCaps.wXmax - Mid_X))/2;
		Threshould_Y = abs((int)(JoyCaps.wYmax - Mid_Y))/2;
		if( Threshould_X==0 )Threshould_X=1;		// O̓_
		if( Threshould_Y==0 )Threshould_Y=1;
#ifdef DEBUG
	DPRINT( DebugFileStream,"DICONTROL::Initialize  XeBbN͎gp\ł\n" );
#endif
	} else {
		StickID = NULL;					// gȂꍇ͉zIɐݒ
		Mid_X = 127;
		Mid_Y = 127;
		Threshould_X = 63;
		Threshould_Y = 63;
		JoyCaps.wXmin = 0;
		JoyCaps.wXmax = 255;
		JoyCaps.wYmin = 0;
		JoyCaps.wYmax = 255;
#ifdef DEBUG
	DPRINT( DebugFileStream,"DICONTROL::Initialize  XeBbN͎gpł܂\n" );
#endif
	}

	isReady = TRUE;					// 

	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void InitializeState()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ԂNA܂B
//--------------------------------------------------------------------
void DICONTROL::InitializeState()
{
	data.a_y				= 0;				// AiO㉺
	data.a_x				= 0;				// AiOE
	data.d_up				= FALSE;			// fW^
	data.d_down				= FALSE;			// fW^
	data.d_left				= FALSE;			// fW^
	data.d_right			= FALSE;			// fW^E

	for( int i=0;i<32;i++ ){
		data.trg[i]			= FALSE;			// gKiRQ܂ŃT|[gj
		data.trg_norapid[i]	= FALSE;			// gKiAˁj
		data.bIsFree[i]		= FALSE;			// AːtO
	}
}


//------------------------------------------------<< AːtOSč~낷 >>
void DICONTROL::SetNotFree()
{
	for( int i=0;i<32;i++ ){
		data.bIsFree[i] = FALSE;
	}
}


//---------------------------------------------------------------<Ԃ𓾂>
void DICONTROL::GetState()
{
	UINT i;

	if (CanUseStick) {				// XeBbNgȂ
		joyGetPosEx(StickID, &JoyInfoEx);		// XeBbN̏Ԃ

		data.a_x = (WORD)JoyInfoEx.dwXpos;			// f[^ۑ
		data.a_y = (WORD)JoyInfoEx.dwYpos;
		data.d_pov = JoyInfoEx.dwPOV;
		for (i = 0; i < NumOfButtons; i++) {
			int iID;
			iID = m_sSemantics.m_sTrrigerInfo[i].m_lTrrigerID;
			if (iID == DISEM_EMPTY_TRIGGER_ID) {
				continue;
			}

			data.trg[i] = ((JoyInfoEx.dwButtons & BtnFlags[iID]) != 0);
		}
	}
	else {					// gȂȂ
		data.a_x = Mid_X;					// Ԃ̃NA
		data.a_y = Mid_Y;
		for (i = 0; i < NumOfButtons; i++) {
			data.trg[i] = FALSE;
		}
	}

	// L[{[h̏Ԃ
	if (GetAsyncKeyState(KeyConfig.up))data.a_y = JoyCaps.wYmin;
	if (GetAsyncKeyState(KeyConfig.down))data.a_y = JoyCaps.wYmax;
	if (GetAsyncKeyState(KeyConfig.left))data.a_x = JoyCaps.wXmin;
	if (GetAsyncKeyState(KeyConfig.right))data.a_x = JoyCaps.wXmax;
	for (i = 0; i < NumOfButtons; i++) {
		int iID;
		iID = m_sSemantics.m_sTrrigerInfo[i].m_lTrrigerID;
		if (iID == DISEM_EMPTY_TRIGGER_ID) {
			continue;
		}

		if (GetAsyncKeyState(KeyConfig.trg[iID]))data.trg[i] = TRUE;
	}

	// L[̂`^cϊ
	if (data.a_x > Mid_X + Threshould_X)data.d_right = TRUE;
	else data.d_right = FALSE;
	if (data.a_x < Mid_X - Threshould_X)data.d_left = TRUE;
	else data.d_left = FALSE;
	if (data.a_y > Mid_Y + Threshould_Y)data.d_down = TRUE;
	else data.d_down = FALSE;
	if (data.a_y < Mid_Y - Threshould_Y)data.d_up = TRUE;
	else data.d_up = FALSE;

	// POV̕lϊ
	BOOL POVCentered = (LOWORD(data.d_pov) == 0xFFFF);
	if ((!POVCentered) && (CanUseStick)) {
		DWORD rgdwPOV = data.d_pov;
		// 
		if (+33750 <= rgdwPOV || rgdwPOV < +2250) {
			data.d_up = TRUE;
		}
		// E
		if (+2250 <= rgdwPOV && rgdwPOV < +6750) {
			data.d_up = TRUE;
			data.d_right = TRUE;
		}
		// E
		if (+6750 <= rgdwPOV && rgdwPOV < +11250) {
			data.d_right = TRUE;
		}
		// E
		if (+11250 <= rgdwPOV && rgdwPOV < +15750) {
			data.d_right = TRUE;
			data.d_down = TRUE;
		}
		// 
		if (+15750 <= rgdwPOV && rgdwPOV < +20250) {
			data.d_down = TRUE;
		}
		// 
		if (+20250 <= rgdwPOV && rgdwPOV < +24750) {
			data.d_left = TRUE;
			data.d_down = TRUE;
		}
		// 
		if (+24750 <= rgdwPOV && rgdwPOV < +29250) {
			data.d_left = TRUE;
		}
		// 
		if (+29250 <= rgdwPOV && rgdwPOV < +33750) {
			data.d_left = TRUE;
			data.d_up = TRUE;
		}
	}

	// A{^
	for (i = 0; i < NumOfButtons; i++) {
		int iID;
		iID = i;

		if (data.bIsFree[iID] == FALSE)data.trg_norapid[iID] = FALSE;	// t[łȂΊO
		else data.trg_norapid[iID] = data.trg[iID];						// t[ȂAdata.trg[] ƓɁB

		if (data.trg[iID] == FALSE) {						// ꂽȂ
			data.bIsFree[iID] = TRUE;						// t[tOĂ
		}
		else {
			data.bIsFree[iID] = FALSE;						// ĂȂAt[ɂ
		}
	}

	// [hɁA[h邩ۂ𔻒
	BOOL bFinishToLoad = FALSE;
	for (i = 0; i < NumOfButtons; i++) {
		int iID;
		iID = i;

		// L[ꂽ
		if (data.trg[iID]) {
			bFinishToLoad = TRUE;
		}
	}

	// [h̏ꍇ́Af[^ǂŏ㏑܂B
	if (m_bOnLoad) {
		BOOL bRes;
		bRes = LoadInputData();

		// ǂݍ݃G[ȂAt@C
		if (bRes == FALSE) {
			CloseFile();
		}

		// ǂݍݒfȂt@C
		if (bFinishToLoad == TRUE) {
			CloseFile();
		}
	}

	// Z[ȕꍇ́Af[^
	if (m_bOnSave) {
		BOOL bRes;
		bRes = SaveInputData();
		if (bRes == FALSE) {
			CloseFile();
		}
	}

	// <<< 󋵃g[X >>>
	TraceLog("DIControl : E:%d :%d :%d :%d `:%d a:%d b:%d :%d :%d :%d\n"
		, data.d_right, data.d_left, data.d_up, data.d_down
		, data.trg[0], data.trg[1], data.trg[2]
		, data.trg_norapid[0], data.trg_norapid[1], data.trg_norapid[2]
	);
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsLeft()
//		BOOL IsRight()
//		BOOL IsUp()
//		BOOL IsDown()
//		BOOl IsButton( int iNumber )
//
//	[  ]
//		int iNumber				{^ԍ
//
//	[ ߂l ]
//		  ĂFTRUE
//		ĂȂFFALSE
//
//	[  ]
//		XeBbN|Ă邩^{^Ă邩
//		ۂ̔܂B
//--------------------------------------------------------------------
BOOL DICONTROL::IsLeft()
{
	if( data.d_left )return TRUE;
	else return FALSE;
}

BOOL DICONTROL::IsRight()
{
	if( data.d_right )return TRUE;
	else return FALSE;
}

BOOL DICONTROL::IsUp()
{
	if( data.d_up )return TRUE;
	else return FALSE;
}

BOOL DICONTROL::IsDown()
{
	if( data.d_down )return TRUE;
	else return FALSE;
}

BOOL DICONTROL::IsButton( int iNumber )
{
	int iTrrigerID;
	iTrrigerID	= iNumber;

	if( data.trg[iTrrigerID] )return TRUE;
	else return FALSE;
}

BOOL DICONTROL::IsButtonPressed( int iNumber )
{
	int iTrrigerID;
	iTrrigerID	= iNumber;

	if( data.trg_norapid[iTrrigerID] )return TRUE;
	else return FALSE;
}


BOOL DICONTROL::AllFreeInputData()
{
	memset( &data , 0 , sizeof(data) );
	return TRUE;
}


BOOL DICONTROL::FreeDirectionData()
{
	data.a_y		= 0;				// AiO㉺
	data.a_x		= 0;				// AiOE
	data.d_up		= FALSE;				// fW^
	data.d_down		= FALSE;				// fW^
	data.d_left		= FALSE;				// fW^
	data.d_right	= FALSE;				// fW^E
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void CloseFile(char* header_data, int size)
//
//	[  ]
//		char* data	wb_Ƃčރf[^
//		int size	wb_̃TCY
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Z[ut@C̃t@CXg[܂B
//		ۑɂāA擪 header_data ł
//		̓f[^L^܂B
//		t@CJĂȂԂœǂłSłB
//--------------------------------------------------------------------
void DICONTROL::CloseFile(char* header_data, int size)
{
	// Z[uł΁Ãf[^
	if( m_bOnSave ){
		FILE* pFileStream;
		pFileStream = fopen( m_strInputFileName , "wb" );
		if( pFileStream!=NULL ){
			// wb_ۑ
			if (header_data != NULL) {
				fwrite(header_data, size, 1, pFileStream);
			}
			// ̓f[^ۑ
			SINPUTFORMAT sInputFormat;
			for( int i=0;i<m_pInputData->GetRegistedNum();i++ ){
				sInputFormat = (*m_pInputData)[i];
				fwrite( &sInputFormat , sizeof( sInputFormat ) , 1 , pFileStream );
			}
			// t@C
			fclose( pFileStream );
		}
	}

	// ێĂ̓f[^̔j
	m_pInputData->Release();
	memset( m_strInputFileName , 0 , sizeof( m_strInputFileName ) );

	// Xe[g̕ύX
	m_bOnSave		= FALSE;
	m_bOnLoad		= FALSE;
	m_iReadPoint	= 0;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StartToSave( const char* pFileName )
//
//	[  ]
//		const char* pFileName	Z[ut@C
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		͏́ADISK ւ̃Z[uJn܂B
//--------------------------------------------------------------------
BOOL DICONTROL::StartToSave( const char* pFileName )
{
	// ܂́AZ[u^[h
	CloseFile();

	// t@C̕
	strcpy( m_strInputFileName , pFileName );

	// Xe[^Xݒ
	//
	m_bOnSave = TRUE;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL StartToLoad( const char* pFileName , long lOffset )
//
//	[  ]
//		const char* pFileName	Z[ut@C̖O
//		long lOffset			f[^t@C̐擪ŁAvCf[^ƂĎgȂTCY
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		t@C̓ǂݍ݂Jn܂B
//		t@C̏̓ǂݍ݂́A炩̃{^
//		ꂽ_ŎIɏI܂B
//--------------------------------------------------------------------
BOOL DICONTROL::StartToLoad( const char* pFileName , long lOffset )
{
	long i;

	// ܂́At@C
	CloseFile();

	// t@CI[v
	FILE* pFileStream;
	pFileStream = fopen( pFileName , "rb" );
	if( pFileStream==NULL ){
		return FALSE;
	}

	// 擪̂Ȃj
	for( i=0;i<lOffset;i++ ){
		fgetc( pFileStream );
	}

	// f[^ǂݍ
	SINPUTFORMAT sInputFormat;
	while( 1 ){
		int iRes;
		iRes = fread( &sInputFormat , sizeof( SINPUTFORMAT ) , 1 , pFileStream );
		if( iRes==0 ){
			// ǂݍݏI
			break;
		}

		// zɒǉ
		m_pInputData->Add( sInputFormat );
	}

	// ǂݏIt@C
	if( pFileStream ){
		fclose( pFileStream );
	}

	// ݒ
	//
	m_bOnLoad = TRUE;

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL LoadInputData()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		̓f[^z񂩂ǂݍ݂܂B
//		̓f[^IAIɃXe[gʏԂ
//		߂܂B
//--------------------------------------------------------------------
BOOL DICONTROL::LoadInputData()
{
	// ǂݍ݈ʒus̏ꍇ̓G[Ԃ
	//
	if( m_iReadPoint >= m_pInputData->GetRegistedNum() ){
		return FALSE;
	}

	// ǂݍ
	SINPUTFORMAT sInputFormat;
	memset( &sInputFormat , 0 , sizeof( sInputFormat ) );
	sInputFormat = (*m_pInputData)[m_iReadPoint];
	m_iReadPoint++;

	// ǂݍ񂾓e𗬂
	data.a_y		= sInputFormat.a_y;
	data.a_x		= sInputFormat.a_x;
	data.d_up		= (sInputFormat.direction & 0x00000001)!=0;
	data.d_down		= (sInputFormat.direction & 0x00000002)!=0;
	data.d_left		= (sInputFormat.direction & 0x00000004)!=0;
	data.d_right	= (sInputFormat.direction & 0x00000008)!=0;

	for( UINT i=0;i<NumOfButtons;i++ ){
		int iID;
		iID = i;

		data.trg[iID]			= (sInputFormat.trg         & ( 0x01<<iID) )!=0;
		data.trg_norapid[iID]	= (sInputFormat.trg_norapid & ( 0x01<<iID) )!=0;
		data.bIsFree[iID]		= (sInputFormat.bIsFree     & ( 0x01<<iID) )!=0;
	}

	// ǂݍݏȈꍇ́AXe[g߂
	if( m_iReadPoint>=m_pInputData->GetRegistedNum() ){
		CloseFile();
	}

	// I
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SaveInputData()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		݂̏Ԃ̓f[^zɕۑ܂B
//		ۑf[^́ACloseFile() Ă΂ꂽƂɃZ[u܂B
//--------------------------------------------------------------------
BOOL DICONTROL::SaveInputData()
{
	SINPUTFORMAT sInputFormat;
	memset( &sInputFormat , 0 , sizeof( sInputFormat ) );

	// ݂̏Ԃ𗬂
	sInputFormat.a_y		= data.a_y;
	sInputFormat.a_x		= data.a_x;
	if( data.d_up    )sInputFormat.direction |= 0x00000001;
	if( data.d_down  )sInputFormat.direction |= 0x00000002;
	if( data.d_left  )sInputFormat.direction |= 0x00000004;
	if( data.d_right )sInputFormat.direction |= 0x00000008;

	for( UINT i=0;i<NumOfButtons;i++ ){
		int iID;
		iID = i;

		long lMask;
		lMask = (0x01<<iID);
		if( data.trg[iID]         )sInputFormat.trg			|= lMask;
		if( data.trg_norapid[iID] )sInputFormat.trg_norapid	|= lMask;
		if( data.bIsFree[iID]     )sInputFormat.bIsFree		|= lMask;
	}

	// ǉ
	int iRes;
	iRes = m_pInputData->Add( sInputFormat );
	if( iRes==-1 ){
		// G[̏ꍇ FALSE ŕԂ
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsOnLoad()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		  [hFTRUE
//		񃍁[hFFALSE
//
//	[  ]
//		t@CǂݏoĂrۂԂ܂B
//--------------------------------------------------------------------
BOOL DICONTROL::IsOnLoad()
{
	return m_bOnLoad;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL IsOnSave()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		  Z[uFTRUE
//		Z[uFFALSE
//
//	[  ]
//		t@CɏłrۂԂ܂B
//--------------------------------------------------------------------
BOOL DICONTROL::IsOnSave()
{
	return m_bOnSave;
}
