//====================================================================
//  OtBbNʃNX
//====================================================================

#include "system.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Graphic.h"


//--------------------------------------------------------------------
//	[  ]
//		CGraphic()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ftHgRXgN^
//--------------------------------------------------------------------
CGraphic::CGraphic()
: C2DObject()
{
	SetDefault();
}


//--------------------------------------------------------------------
//	[  ]
//		CGraphic( CGraphic& rGraphic )
//
//	[  ]
//		CGraphic& rGraphic			Rs[Ƃւ̎Q
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Rs[RXgN^
//--------------------------------------------------------------------
CGraphic::CGraphic( CGraphic& rGraphic )
: C2DObject( rGraphic )
{
	SetDefault();
	CopyMembers( rGraphic );
}


//--------------------------------------------------------------------
//	[  ]
//		~CGraphic()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		fXgN^
//--------------------------------------------------------------------
CGraphic::~CGraphic()
{
	Release();
}


//--------------------------------------------------------------------
//	[  ]
//		void SetDefault()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		RXgNg̃ftHgݒ
//--------------------------------------------------------------------
void CGraphic::SetDefault()
{
	m_strIDName	= "";

	m_bLoopX	= FALSE;
	m_bLoopY	= FALSE;

	m_bLoopX	= TRUE;
	m_bLoopY	= TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL CopyMembers( CGraphic& rGraphic )
//
//	[  ]
//		CGraphic& rGraphic			Rs[ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		IuWFNg̓e𕡐܂B
//--------------------------------------------------------------------
BOOL CGraphic::CopyMembers( CGraphic& rGraphic )
{
	Release();

	m_strIDName	= rGraphic.m_strIDName;
	C2DObject::CopyMembers( rGraphic );
	m_bLoopX	= rGraphic.m_bLoopX;
	m_bLoopY	= rGraphic.m_bLoopY;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		void Release()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg̓ejAԂɖ߂܂B
//--------------------------------------------------------------------
void CGraphic::Release()
{
	m_strIDName	= "";
	C2DObject::Release();
	m_bLoopX	= FALSE;
	m_bLoopY	= FALSE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetIDName( const char* pName )
//
//	[  ]
//		const char* pName			ݒ肷閼
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		ʖ̂ݒ肵܂
//--------------------------------------------------------------------
BOOL CGraphic::SetIDName( const char* pName )
{
	m_strIDName	= pName;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		const char* GetIDName()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		ʖ
//
//	[  ]
//		ʖ̂Ԃ܂
//--------------------------------------------------------------------
const char* CGraphic::GetIDName()
{
	return m_strIDName.GetString();
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLoopMode( BOOL bSwX , BOOL bSwY )
//
//	[  ]
//		BOOL bSwX					w[v[h
//		BOOL bSwY					x[v[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		[v[hݒ
//--------------------------------------------------------------------
BOOL CGraphic::SetLoopMode( BOOL bSwX , BOOL bSwY )
{
	BOOL bRes;
	bRes = SetLoopModeX( bSwX );
	if( bRes==FALSE ){
		return FALSE;
	}

	bRes = SetLoopModeY( bSwY );
	if( bRes==FALSE ){
		return FALSE;
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLoopModeX( BOOL bSwitch )
//
//	[  ]
//		BOOL bSwitch				[v[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		[v[hݒ
//--------------------------------------------------------------------
BOOL CGraphic::SetLoopModeX( BOOL bSwitch )
{
	m_bLoopX	= bSwitch;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL SetLoopModeY( BOOL bSwitch )
//
//	[  ]
//		BOOL bSwitch				[v[h
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		[v[hݒ
//--------------------------------------------------------------------
BOOL CGraphic::SetLoopModeY( BOOL bSwitch )
{
	m_bLoopY	= bSwitch;
	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL Draw( SDeviceInfo* pDeviceInfo , long lViewX , long lViewY , DWORD dwDiffuse , float fZ = 0.0f )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCXւ̃|C^
//		long lViewX					r[|CgwW
//		long lViewY					r[|CgxW
//		DWORD dwDiffuse= 0xFFFFFFFF	fBt[YF
//		float fZ = 0.0f				`yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`悵܂B
//--------------------------------------------------------------------
BOOL CGraphic::Draw( SDeviceInfo* pDeviceInfo , long lViewX , long lViewY , DWORD dwDiffuse , float fZ )
{
	long	lX1,lY1;					// ڗ̈捶̈ʒu
	long	lX2,lY2;					// ڗ̈Ëʒu
	long	lTgtX,lTgtY;				// `W

	UINT	uiSizeX,uiSizeY;				// rbg}bṽTCY
	long	lBmpStartX,lBmpStartY;		// `Jnʒu
	long	lTgtStartX,lTgtStartY;		// ^[QbgJnʒu

	long	lWindowSizeX;				// zEBhẼTCY
	long	lWindowSizeY;

	// ---< ̎擾 >---
	//
	uiSizeX		= m_pTexture->Width();			// rbg}bṽTCY擾
	uiSizeY		= m_pTexture->Height();

	lWindowSizeX	= m_sRect.right - m_sRect.left +1;	// zEBhẼTCYZo
	lWindowSizeY	= m_sRect.bottom - m_sRect.top +1;

	// ---< `JnʒuZo >---
	//
	if( lViewX<0 ){								// r[|Cg̏ꍇ
		lBmpStartX	= lViewX;
		if( m_bLoopX ){
			lBmpStartX	= (lBmpStartX % (long)uiSizeX) + uiSizeX;
			lBmpStartX %= (long)uiSizeX;
		}
	} else {									// r[|Cg̏ꍇ
		lBmpStartX	= lViewX;
		if( m_bLoopX ){
			lBmpStartX  = (lBmpStartX % (long)uiSizeX );
			lBmpStartX %= (long)uiSizeX;
		}
	}
	if( lViewY<0 ){			// r[|Cg̏ꍇ
		lBmpStartY	= lViewY;
		if( m_bLoopY ){
			lBmpStartY  = (lBmpStartY % (long)uiSizeY) + uiSizeY;
			lBmpStartY %= (long)uiSizeY;
		}
	} else {										// r[|Cg̏ꍇ
		lBmpStartY	= lViewY;
		if( m_bLoopY ){
			lBmpStartY  = lBmpStartY % (long)uiSizeY;
			lBmpStartY %= (long)uiSizeY;
		}
	}


	// ---< `^[Qbgʒu̐ݒ >---
	//
	lTgtStartX	= m_sRect.left;						// `^[Qbgݒ
	lTgtStartY	= m_sRect.top;


	// ---< rbgubN](BltFast) >---
	//
	long lMappedX;									// ʂɃ}bvÏ̑傫
	long lMappedY;


	// ---< xA`Jnʒu̐ݒ >---
	//
	lMappedY = 0;									// xɃ}bv傫
	lY1		= lBmpStartY;
	lTgtY	= lTgtStartY;
	while( lMappedY<lWindowSizeY ){					// x}bsO

		// ---< wA`Jnʒu̐ݒ >---
		lMappedX = 0;
		lX1 = lBmpStartX;
		lTgtX = lTgtStartX;

		while( lMappedX<lWindowSizeX ){				// w}bsO
			if( lX1>=(long)uiSizeX )break;					// NbsO
			if( lY1>=(long)uiSizeY )break;

			lX2		= lX1 + lWindowSizeX -1;		// Eʒu
			lY2		= lY1 + lWindowSizeY -1;
			if( lX2<0 )break;						// NbsO
			if( lY2<0 )break;

			if( lX2>=(long)uiSizeX )lX2 = uiSizeX-1;		// Eʒu␳
			if( lY2>=(long)uiSizeY )lY2 = uiSizeY-1;

			long lDx,lDy;
			lDx = lX2-lX1+1;
			lDy = lY2-lY1+1;
			if( (lMappedX+lDx)>lWindowSizeX )lX2 -= (lMappedX+lDx)-lWindowSizeX;
			if( (lMappedY+lDy)>lWindowSizeY )lY2 -= (lMappedY+lDy)-lWindowSizeY;

			if( lX1<0 ){							// ^[Qbgʒu␳
				lTgtX += -lX1;
				lX1 = 0;
			}
			if( lY1<0 ){							// ^[Qbgʒu␳
				lTgtY += -lY1;
				lY1 = 0;
			}

			C2DObject::DrawRev( pDeviceInfo , lX1,lY1 , lX2,lY2 , lTgtX,lTgtY , FALSE, FALSE, dwDiffuse , fZ );

			lMappedX += uiSizeX-lX1;					// r[|Cg[܂ł̋𑫂
			lTgtX    += uiSizeX-lX1;
			lX1 = 0;								// Xebvł̕`Jnʒu

			if( m_bLoopX==FALSE ){					// [vȂȂ
				break;								// [v؂
			}
		}

		lMappedY += uiSizeY-lY1;						// r[|Cg[܂ł̋𑫂
		lTgtY    += uiSizeY-lY1;
		lY1 = 0;									// Xebvł̕`Jnʒu

		if( m_bLoopY==FALSE ){						// [vȂȂ
			break;									// [v؂
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		BOOL ScaledDraw( SDeviceInfo* pDeviceInfo , long lViewX , long lViewY , FLOAT fScalingX , FLOAT fScalingY , DWORD dwDiffuse , float fZ = 0.0f )
//
//	[  ]
//		SDeviceInfo* pDeviceInfo	foCXւ̃|C^
//		long lViewX					r[|CgwW
//		long lViewY					r[|CgxW
//		FLOAT fScalingX				wXP[O
//		FLOAT fScalingY				xXP[O
//		DWORD dwDiffuse				fBt[YF
//		float fZ					`yW
//
//	[ ߂l ]
//		FTRUE
//		sFFALSE
//
//	[  ]
//		`悵܂B
//--------------------------------------------------------------------
BOOL CGraphic::ScaledDraw(  SDeviceInfo* pDeviceInfo
							, long lViewX , long lViewY
							, FLOAT fScalingX , FLOAT fScalingY
							, DWORD dwDiffuse , float fZ
){
	// XP[OOȂȂɂȂ
	if( (long)fScalingX==0 )return TRUE;
	if( (long)fScalingY==0 )return TRUE;

	// s
	long	lX1,lY1;												// ڗ̈捶̈ʒu
	long	lX2,lY2;												// ڗ̈Ëʒu
	long	lTgtX,lTgtY;											// `W

	UINT	uiSizeX,uiSizeY;										// rbg}bṽTCY
	long	lBmpStartX,lBmpStartY;									// `Jnʒu
	long	lTgtStartX,lTgtStartY;									// ^[QbgJnʒu

	long	lWindowSizeX;											// zEBhẼTCY
	long	lWindowSizeY;

	// ---< ̎擾 >---
	//
	uiSizeX		= m_pTexture->Width();								// rbg}bṽTCY擾
	uiSizeY		= m_pTexture->Height();

	// XP[OTCYɍĐݒ
	uiSizeX		= (UINT)( ((FLOAT)uiSizeX) * fScalingX );
	uiSizeY		= (UINT)( ((FLOAT)uiSizeY) * fScalingY );
	//lViewX		= (long)( ((FLOAT)lViewX) * fScalingX );
	//lViewY		= (long)( ((FLOAT)lViewY) * fScalingY );

	if( uiSizeX==0 )return TRUE;
	if( uiSizeY==0 )return TRUE;

	lWindowSizeX	= m_sRect.right - m_sRect.left +1;				// zEBhẼTCYZo
	lWindowSizeY	= m_sRect.bottom - m_sRect.top +1;

	// ---< `JnʒuZo >---
	//
	if( lViewX<0 ){													// r[|Cg̏ꍇ
		lBmpStartX	= lViewX;
		if( m_bLoopX ){
			lBmpStartX	= (lBmpStartX % (long)uiSizeX) + uiSizeX;
			lBmpStartX %= (long)uiSizeX;
		}
	} else {														// r[|Cg̏ꍇ
		lBmpStartX	= lViewX;
		if( m_bLoopX ){
			lBmpStartX  = (lBmpStartX % (long)uiSizeX );
			lBmpStartX %= (long)uiSizeX;
		}
	}
	if( lViewY<0 ){													// r[|Cg̏ꍇ
		lBmpStartY	= lViewY;
		if( m_bLoopY ){
			lBmpStartY  = (lBmpStartY % (long)uiSizeY) + uiSizeY;
			lBmpStartY %= (long)uiSizeY;
		}
	} else {														// r[|Cg̏ꍇ
		lBmpStartY	= lViewY;
		if( m_bLoopY ){
			lBmpStartY  = lBmpStartY % (long)uiSizeY;
			lBmpStartY %= (long)uiSizeY;
		}
	}


	// ---< `^[Qbgʒu̐ݒ >---
	//
	lTgtStartX	= m_sRect.left;										// `^[Qbgݒ
	lTgtStartY	= m_sRect.top;


	// ---< rbgubN](BltFast) >---
	//
	long lMappedX;													// ʂɃ}bvÏ̑傫
	long lMappedY;


	// ---< xA`Jnʒu̐ݒ >---
	//
	long lOffsetX , lOffsetY;
	lOffsetX	= 0;				// ŏ͂OBŏ̃[vŒlZoB
	lOffsetY	= 0;
	lMappedY = 0;													// xɃ}bv傫
	lY1		= lBmpStartY;
	lTgtY	= lTgtStartY;
	while( lMappedY<(lWindowSizeY+lOffsetY) ){						// x}bsO

		// ---< wA`Jnʒu̐ݒ >---
		lMappedX = 0;
		lX1 = lBmpStartX;
		lTgtX = lTgtStartX;

		while( lMappedX<(lWindowSizeX+lOffsetX) ){					// w}bsO
			if( lX1>=(long)uiSizeX )break;							// NbsO
			if( lY1>=(long)uiSizeY )break;

			lX2		= lX1 + lWindowSizeX -1;						// Eʒu
			lY2		= lY1 + lWindowSizeY -1;
			if( lX2<0 )break;										// NbsO
			if( lY2<0 )break;

			if( lX2>=(long)uiSizeX )lX2 = uiSizeX-1;				// Eʒu␳
			if( lY2>=(long)uiSizeY )lY2 = uiSizeY-1;

			long lDx,lDy;
			lDx = lX2-lX1+1;
			lDy = lY2-lY1+1;
			if( (lMappedX+lDx)>lWindowSizeX )lX2 -= (lMappedX+lDx)-lWindowSizeX;
			if( (lMappedY+lDy)>lWindowSizeY )lY2 -= (lMappedY+lDy)-lWindowSizeY;

			if( lX1<0 ){											// ^[Qbgʒu␳
				lTgtX += -lX1;
				lX1 = 0;
			}
			if( lY1<0 ){											// ^[Qbgʒu␳
				lTgtY += -lY1;
				lY1 = 0;
			}

			lOffsetX	= (long)( ((FLOAT)(lX1 % ((long)fScalingX)))  );
			lOffsetY	= (long)( ((FLOAT)(lY1 % ((long)fScalingY)))  );
			C2DObject::DrawRev(  pDeviceInfo
							, (long)( ((FLOAT)lX1)/fScalingX )		// ]Ɨ̈捶
							, (long)( ((FLOAT)lY1)/fScalingY )
							, (long)( ((FLOAT)lX2)/fScalingX )		// E
							, (long)( ((FLOAT)lY2)/fScalingY )
							, -lOffsetX + lTgtX,-lOffsetY + lTgtY							// `
							, FALSE, FALSE
							, dwDiffuse , fZ );

			lMappedX += uiSizeX-lX1;								// r[|Cg[܂ł̋𑫂
			lTgtX    += uiSizeX-lX1;
			lX1 = 0;												// Xebvł̕`Jnʒu

			if( m_bLoopX==FALSE ){									// [vȂȂ
				break;												// [v؂
			}
		}

		lMappedY += uiSizeY-lY1;									// r[|Cg[܂ł̋𑫂
		lTgtY    += uiSizeY-lY1;
		lY1 = 0;													// Xebvł̕`Jnʒu

		if( m_bLoopY==FALSE ){										// [vȂȂ
			break;													// [v؂
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------
//	[  ]
//		CGraphic& operator=( CGraphic& rGraphic )
//
//	[  ]
//		CGraphic& rGraphic			ƃIuWFNgւ̎Q
//
//	[ ߂l ]
//		ւ̎Q
//
//	[  ]
//		Zq
//--------------------------------------------------------------------
CGraphic& CGraphic::operator=( CGraphic& rGraphic )
{
	BOOL bRes;
	bRes = CopyMembers( rGraphic );
	if( bRes==FALSE ){
		ErrorLog( "CGraphic::operator= : e̕Ɏs܂B\n" );
	}

	return *this;
}
